//                                               -*- C++ -*-
/**
 *  @file  FunctionalChaosRandomVector.hxx
 *  @brief An implementation class for functionalChaos random vectors
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-04-09 00:01:15 +0200 (mer. 09 avril 2008) $
 *  Id:      $Id: FunctionalChaosRandomVector.hxx 786 2008-04-08 22:01:15Z lebrun $
 */
#ifndef OPENTURNS_FUNCTIONALCHAOSRANDOMVECTOR_HXX
#define OPENTURNS_FUNCTIONALCHAOSRANDOMVECTOR_HXX

#include "CompositeRandomVector.hxx"
#include "FunctionalChaosResult.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {



      /**
       * @class FunctionalChaosRandomVector
       *
       * An implementation class for functionalChaos random vectors
       */
      class FunctionalChaosRandomVector
        : public CompositeRandomVector
      {
        CLASSNAME;

      public:

        /** Some typedefs to ease reading */
        typedef Algorithm::FunctionalChaosResult FunctionalChaosResult;

        /** Default constructor */
        FunctionalChaosRandomVector(const FunctionalChaosResult & functionalChaosResult);


        /** Virtual constructor */
        FunctionalChaosRandomVector * clone() const;


        /** String converter */
        String __repr__() const;




        /* Here is the interface that all derived class must implement */

        /** Mean accessor */
        NumericalPoint getMean() const;

        /** Covariance accessor */
        CovarianceMatrix getCovariance() const;

        /** Sobol index accessor */
        NumericalScalar getSobolIndex(const Indices & variableIndices) const;
        NumericalScalar getSobolIndex(const UnsignedLong variableIndex) const;

        /** Sobol total index accessor */
        NumericalScalar getSobolTotalIndex(const Indices & variableIndices) const;
        NumericalScalar getSobolTotalIndex(const UnsignedLong variableIndex) const;

        /** Functional chaos result accessor */
        FunctionalChaosResult getFunctionalChaoResult() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

        friend class Base::Common::Factory<FunctionalChaosRandomVector>;

        /** Default constructor */
        FunctionalChaosRandomVector() : CompositeRandomVector() {};

      private:
        /** Compute the covariance */
        void computeCovariance() const;

        /** Scalar value of the covariance */
        mutable NumericalScalar covariance_;

        /** Flag to tell if the covariance has already been computed */
        mutable Bool isAlreadyComputedCovariance_;

        /** The functional chaos result tht allows to build the random vector */
        FunctionalChaosResult functionalChaosResult_;

      }; /* class FunctionalChaosRandomVector */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FUNCTIONALCHAOSRANDOMVECTOR_HXX */
