//                                               -*- C++ -*-
/**
 *  @file  InverseNatafEllipticalCopulaGradient.hxx
 *  @brief Class for the InverseNataf transformation evaluation for elliptical
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: InverseNatafEllipticalCopulaGradient.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_INVERSENATAFELLIPTICALCOPULAGRADIENT_HXX
#define OPENTURNS_INVERSENATAFELLIPTICALCOPULAGRADIENT_HXX

#include "OTprivate.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "Matrix.hxx"
#include "SquareMatrix.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class InverseNatafEllipticalCopulaGradient
       *
       * This class offers an interface for the InverseNataf function for elliptical distributions
       */
      class InverseNatafEllipticalCopulaGradient
	: public Base::Func::NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathGradientImplementation NumericalMathGradientImplementation;
	typedef Base::Type::Matrix                              Matrix;
	typedef Base::Type::SquareMatrix                        SquareMatrix;
	typedef Base::Type::NumericalPoint                      NumericalPoint;
	typedef Model::Distribution                             Distribution;
	typedef Base::Common::InternalException                 InternalException;
	typedef Base::Common::InvalidArgumentException          InvalidArgumentException;

	/** Parameter constructor */
	InverseNatafEllipticalCopulaGradient(const Distribution & standardDistribution,
					     const SquareMatrix & cholesky);


	/** Virtual constructor */
	virtual InverseNatafEllipticalCopulaGradient * clone() const;

	/** Gradient */
	Matrix gradient(const NumericalPoint & in) const
	  /* throw(InvalidArgumentException, InternalException) */;

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:
	Distribution standardDistribution_;
	Matrix cholesky_;

      }; /* InverseNatafEllipticalCopulaGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INVERSENATAFELLIPTICALCOPULAGRADIENT_HXX */
