//                                               -*- C++ -*-
/**
 *  @file  NumericalMathGradientImplementation.cxx
 *  @brief Abstract top-level class for all distributions
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: NumericalMathGradientImplementation.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "NumericalMathGradientImplementation.hxx"
#include "PersistentObjectFactory.hxx"


namespace OpenTURNS {

  namespace Base {

    namespace Func {

      typedef Common::NotYetImplementedException NotYetImplementedException;

      CLASSNAMEINIT(NumericalMathGradientImplementation);

      static Common::Factory<NumericalMathGradientImplementation> RegisteredFactory("NumericalMathGradientImplementation");

      /* Default constructor */
      NumericalMathGradientImplementation::NumericalMathGradientImplementation()
	: PersistentObject(),
	  callsNumber_(0),
	  description_()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NumericalMathGradientImplementation * NumericalMathGradientImplementation::clone() const
      {
	return new NumericalMathGradientImplementation(*this);
      }

      /* Comparison operator */
      Bool NumericalMathGradientImplementation::operator ==(const NumericalMathGradientImplementation & other) const
      {
	return true;
      }
  
      /* String converter */
      String NumericalMathGradientImplementation::__repr__() const {
	OSS oss;
	oss << "class=" << NumericalMathGradientImplementation::GetClassName()
	    << " name=" << getName()
	    << " description=" << description_;
	return oss;
      }
  

      /* Description Accessor */
      void NumericalMathGradientImplementation::setDescription(const Description & description)
      {
	description_ = description;
      }


      /* Description Accessor */
      NumericalMathGradientImplementation::Description NumericalMathGradientImplementation::getDescription() const
      {
	return description_;
      }

      /* Test for actual implementation */
      Bool NumericalMathGradientImplementation::isActualImplementation() const
      {
	return true;
      }

      /* Here is the interface that all derived class must implement */

      /* Gradient method */
      NumericalMathGradientImplementation::Matrix NumericalMathGradientImplementation::gradient(const NumericalPoint & in) const
	/* throw(InvalidArgumentException, InternalException) */
      {
	throw NotYetImplementedException(HERE);
      }

      /* Accessor for input point dimension */
      UnsignedLong NumericalMathGradientImplementation::getInputDimension() const
	/* throw(InternalException) */
      {
	throw NotYetImplementedException(HERE);
      }

      /* Accessor for output point dimension */
      UnsignedLong NumericalMathGradientImplementation::getOutputDimension() const
	/* throw(InternalException) */
      {
	throw NotYetImplementedException(HERE);
      }

      /* Get the number of calls to operator() */
      UnsignedLong NumericalMathGradientImplementation::getCallsNumber() const
      {
	return callsNumber_;
      }

      /* Method save() stores the object through the StorageManager */
      void NumericalMathGradientImplementation::save(StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.saveAttribute( "callsNumber_", callsNumber_ );
	adv.saveAttribute( "description_", description_ );
      }

      /* Method load() reloads the object from the StorageManager */
      void NumericalMathGradientImplementation::load(StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	adv.loadAttribute( "callsNumber_", callsNumber_ );
	adv.loadAttribute( "description_", description_ );
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
