//                                               -*- C++ -*-
/**
 *  @file  LinearCombinationGradientImplementation.cxx
 *  @brief The gradient part of linear combination of polynomials
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "LinearCombinationGradientImplementation.hxx"
#include "OSS.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      CLASSNAMEINIT(LinearCombinationGradientImplementation);

      static Base::Common::Factory<LinearCombinationGradientImplementation> RegisteredFactory("LinearCombinationGradientImplementation");


      /* Default constructor */
      LinearCombinationGradientImplementation::LinearCombinationGradientImplementation()
	: NumericalMathGradientImplementation(),
	  evaluation_()
      {
	// Nothing to do
      }

      
      /* Parameters constructor */
      LinearCombinationGradientImplementation::LinearCombinationGradientImplementation(const LinearCombinationEvaluationImplementation & evaluation)
	: NumericalMathGradientImplementation(),
	  evaluation_(evaluation)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      LinearCombinationGradientImplementation * LinearCombinationGradientImplementation::clone() const
      {
	return new LinearCombinationGradientImplementation(*this);
      }


      /* Gradient method */
      LinearCombinationGradientImplementation::Matrix LinearCombinationGradientImplementation::gradient(const NumericalPoint & in) const
	/* throw(InvalidArgumentException, InternalException) */
      {
	const UnsignedLong size(evaluation_.functionsCollection_.getSize());
        Matrix result(evaluation_.getInputDimension(), evaluation_.getOutputDimension());
	for (UnsignedLong i = 0; i < size; ++i) result = result + evaluation_.coefficients_[i] * evaluation_.functionsCollection_[i].gradient(in);
	return result;
      }

      /* Accessor for input point dimension */
      UnsignedLong LinearCombinationGradientImplementation::getInputDimension() const
	/* throw(InternalException) */
      {
	return evaluation_.getInputDimension();
      }

      /* Accessor for output point dimension */
      UnsignedLong LinearCombinationGradientImplementation::getOutputDimension() const
	/* throw(InternalException) */
      {
	return evaluation_.getOutputDimension();
      }

      /* String converter */
      String LinearCombinationGradientImplementation::__repr__() const
      {
	return OSS() << "class=" << GetClassName()
                     << " evaluation=" << evaluation_;
      }


      /* Method save() stores the object through the StorageManager */
      void LinearCombinationGradientImplementation::save(StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.saveAttribute( "evaluation_", evaluation_ );
      }


      /* Method load() reloads the object from the StorageManager */
      void LinearCombinationGradientImplementation::load(StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	adv.loadAttribute( "evaluation_", evaluation_ );
      }



    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
