//                                               -*- C++ -*-
/**
 *  @file  Less.hxx
 *  @brief Implementation of strict less comparison
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: Less.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_LESS_HXX
#define OPENTURNS_LESS_HXX

#include "ComparisonOperatorImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {


      /**
       * @class Less
       *
       * @brief The class implements the strict less comparison
       *
       * This class is derived from ComparisonOperatorImplementation. It performs the comparison
       * of two NumericalScalar and is mainly used in threshold exceedence algorithms.
       */
      class Less 
	: public ComparisonOperatorImplementation
      {
	CLASSNAME;
      public:

	/** Default constructor */
	explicit Less();

	/* String converter */
	String __repr__() const;


	/* Here is the interface that all derived class must implement */

	/* Virtual constructor */
	virtual Less * clone() const;

	/** @copydoc ComparisonOperator::operator()(NumericalScalar,NumericalScalar) const
	 * Return true if a < b
	 */
	virtual Bool operator() (NumericalScalar a, NumericalScalar b) const;

	/* Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/* Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);

      }; /* class Less */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LESS_HXX */
