name="SaveWindow"#
author="mDuo13"
help="""Saves the size and position of your OpenRPG window, as well as
whether or not it is maximized. You must set the plugin to load on startup
in order for this to work."""
#These give the patch some information about your plugin.
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os

chat=None
session=None
tree=None
openrpg=None

#This is a new feature, the plugin database. You can store settings in it, and
#it will keep things in a single XML file for all plugins, instead of having to
#create and read text files for each plugin.
#Experiment with the following functions, or look at examples from other
#plugins, to see how to use them:
#These must be called in one of the functions.
#plugindb.SetString(plugin_filename, variable_name, variable_value)
#plugindb.GetString(plugin_filename, variable_name, default_value)
#plugindb.SetList(plugin_filename, variable_name, list_value)
#plugindb.GetList(plugin_filename, variable_name, default_list)
#plugindb.SetDict(plugin_filename, variable_name, dictionary_value)
#plugindb.GetDict(plugin_filename, variable_name, default_dictionary)

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def load(self):
    if name in self.startplugs:
        win_xpos = plugindb.GetString(name,"win_xpos","-1")
        win_ypos = plugindb.GetString(name,"win_ypos","-1")
        maximized = plugindb.GetString(name,"maximized","0")
        win_xsize = plugindb.GetString(name,"win_xsize","-1")
        win_ysize = plugindb.GetString(name,"win_ysize","-1")
        x = int(win_xpos)
        y = int(win_ypos)
        is_maxed = int(maximized)
        width = int(win_xsize)
        height = int(win_ysize)
        if not is_maxed:
            openrpg.SetDimensions(x,y,width,height)
        openrpg.Maximize(is_maxed)

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message from anyone is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    #Be careful; system and info messages trigger this too.
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    def bool2int(x):
        if x:
            return 1
        else:
            return 0
    #This is called when OpenRPG shuts down
    (x_size,y_size) = openrpg.GetSizeTuple()
    (x_pos,y_pos) = openrpg.GetPositionTuple()
    is_maximized = bool2int(openrpg.IsMaximized())
    plugindb.SetString(name,"win_xsize",str(x_size))
    plugindb.SetString(name,"win_ysize",str(y_size))
    plugindb.SetString(name,"win_xpos",str(x_pos))
    plugindb.SetString(name,"win_ypos",str(y_pos))
    plugindb.SetString(name,"maximized",str(is_maximized))
