/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: escherex.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:23:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_ESCHEREX_HXX
#define _SVX_ESCHEREX_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
// auto strip #ifndef _SV_GEN_HXX
// auto strip #include <tools/gen.hxx>
// auto strip #endif
// auto strip #ifndef _LIST_HXX
// auto strip #include <tools/list.hxx>
// auto strip #endif
// auto strip #ifndef _STREAM_HXX //autogen wg. SvStream
// auto strip #include <tools/stream.hxx>
// auto strip #endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _GRFMGR_HXX
// auto strip #include <goodies/grfmgr.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_SIZE_HPP_
// auto strip #include <com/sun/star/awt/Size.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_POINT_HPP_
// auto strip #include <com/sun/star/awt/Point.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
// auto strip #include <com/sun/star/awt/Rectangle.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATE_HPP_
// auto strip #include <com/sun/star/beans/XPropertyState.hpp>
// auto strip #endif
//STRIP001 class SvStream;

namespace binfilter {

		/*Record Name       FBT-Value   Instance                  Contents                                                          Wrd Exl PPt Ver*/
// In der Mickysoft-Doku heissen die msofbt... statt ESCHER_...
//STRIP001 #define ESCHER_DggContainer      0xF000 /*                           per-document data                                                  X   X   X     */
//STRIP001 #define   ESCHER_Dgg             0xF006 /*                           an FDGG and several FIDCLs                                         X   X   X   0 */
//STRIP001 #define   ESCHER_CLSID           0xF016 /*                           the CLSID of the application that put the data on the clipboard    C   C   C   0 */
//STRIP001 #define   ESCHER_OPT             0xF00B /* count of properties       the document-wide default shape properties                         X   X   X   3 */
//STRIP001 #define   ESCHER_ColorMRU        0xF11A /* count of colors           the colors in the MRU swatch                                       X   X   X   0 */
//STRIP001 #define   ESCHER_SplitMenuColors 0xF11E /* count of colors           the colors in the top-level split menus                            X   X   X   0 */
//STRIP001 #define   ESCHER_BstoreContainer 0xF001 /* count of BLIPs            all images in the document (JPEGs, metafiles, etc.)                X   X   X     */
//STRIP001 #define     ESCHER_BSE           0xF007 /* BLIP type                 an FBSE (one per BLIP)                                             X   X   X   2 */
//STRIP001 #define     ESCHER_BlipFirst     0xF018 /*                           range of fbts reserved for various kinds of BLIPs                  X   X   X     */
//STRIP001 #define     ESCHER_BlipLast      0xF117 /*                           range of fbts reserved for various kinds of BLIPs                  X   X   X     */
//STRIP001 
//STRIP001 #define ESCHER_DgContainer       0xF002 /*                           per-sheet/page/slide data                                          X   X   X     */
//STRIP001 #define   ESCHER_Dg              0xF008 /* drawing ID                an FDG                                                             X   X   X   0 */
//STRIP001 #define   ESCHER_RegroupItems    0xF118 /* count of regroup entries  several FRITs                                                      X   X   X   0 */
//STRIP001 #define   ESCHER_ColorScheme     0xF120 /* count of colors           the colors of the source host's color scheme                           C   C   0 */
//STRIP001 #define   ESCHER_SpgrContainer   0xF003 /*                           several SpContainers, the first of which is the group shape itself X   X   X     */
//STRIP001 #define   ESCHER_SpContainer     0xF004 /*                           a shape                                                            X   X   X     */
//STRIP001 #define     ESCHER_Spgr          0xF009 /*                           an FSPGR; only present if the shape is a group shape               X   X   X   1 */
//STRIP001 #define     ESCHER_Sp            0xF00A /* shape type                an FSP                                                             X   X   X   2 */
//STRIP001 //#define     ESCHER_OPT           0xF00B /* count of properties       a shape property table                                             X   X   X   3 */
//STRIP001 #define     ESCHER_Textbox       0xF00C /*                           RTF text                                                           C   C   C   0 */
//STRIP001 #define     ESCHER_ClientTextbox 0xF00D /* host-defined              the text in the textbox, in host-defined format                    X   X   X     */
//STRIP001 #define     ESCHER_Anchor        0xF00E /*                           a RECT, in 100000ths of an inch                                    C   C   C   0 */
//STRIP001 #define     ESCHER_ChildAnchor   0xF00F /*                           a RECT, in units relative to the parent group                      X   X   X   0 */
//STRIP001 #define     ESCHER_ClientAnchor  0xF010 /* host-defined              the location of the shape, in a host-defined format                X   X   X     */
//STRIP001 #define     ESCHER_ClientData    0xF011 /* host-defined              host-specific data                                                 X   X   X     */
//STRIP001 #define     ESCHER_OleObject     0xF11F /*                           a serialized IStorage for an OLE object                            C   C   C   0 */
//STRIP001 #define     ESCHER_DeletedPspl   0xF11D /*                           an FPSPL; only present in top-level deleted shapes                 X           0 */
//STRIP001 #define   ESCHER_SolverContainer 0xF005 /* count of rules            the rules governing shapes                                         X   X   X     */
//STRIP001 #define     ESCHER_ConnectorRule 0xF012 /*                           an FConnectorRule                                                      X   X   1 */
//STRIP001 #define     ESCHER_AlignRule     0xF013 /*                           an FAlignRule                                                      X   X   X   0 */
//STRIP001 #define     ESCHER_ArcRule       0xF014 /*                           an FARCRU                                                          X   X   X   0 */
//STRIP001 #define     ESCHER_ClientRule    0xF015 /* host-defined              host-defined                                                                     */
//STRIP001 #define     ESCHER_CalloutRule   0xF017 /*                           an FCORU                                                           X   X   X   0 */
//STRIP001 #define ESCHER_Selection         0xF119 /*                           an FDGSL followed by the SPIDs of the shapes in the selection              X   0 */
//STRIP001 
//STRIP001 #define SHAPEFLAG_GROUP			0x001	// This shape is a group shape
//STRIP001 #define SHAPEFLAG_CHILD			0x002	// Not a top-level shape
//STRIP001 #define SHAPEFLAG_PATRIARCH		0x004	// This is the topmost group shape. Exactly one of these per drawing.
//STRIP001 #define SHAPEFLAG_DELETED		0x008	// The shape has been deleted
//STRIP001 #define SHAPEFLAG_OLESHAPE		0x010	// The shape is an OLE object
//STRIP001 #define SHAPEFLAG_HAVEMASTER	0x020	// Shape has a hspMaster property
//STRIP001 #define SHAPEFLAG_FLIPH			0x040	// Shape is flipped horizontally
//STRIP001 #define SHAPEFLAG_FLIPV			0x080	// Shape is flipped vertically
//STRIP001 #define SHAPEFLAG_CONNECTOR		0x100	// Connector type of shape
//STRIP001 #define SHAPEFLAG_HAVEANCHOR	0x200	// Shape has an anchor of some kind
//STRIP001 #define SHAPEFLAG_BACKGROUND	0x400	// Background shape
//STRIP001 #define SHAPEFLAG_HAVESPT		0x800	// Shape has a shape type property
//STRIP001 
//STRIP001 #define ESCHER_ShpInst_Min				0
//STRIP001 #define ESCHER_ShpInst_NotPrimitive		ESCHER_ShpInst_Min
//STRIP001 #define ESCHER_ShpInst_Rectangle		1
//STRIP001 #define ESCHER_ShpInst_RoundRectangle	2
//STRIP001 #define ESCHER_ShpInst_Ellipse			3
//STRIP001 #define ESCHER_ShpInst_Diamond			4
//STRIP001 #define ESCHER_ShpInst_IsocelesTriangle	5
//STRIP001 #define ESCHER_ShpInst_RightTriangle	6
//STRIP001 #define ESCHER_ShpInst_Parallelogram	7
//STRIP001 #define ESCHER_ShpInst_Trapezoid		8
//STRIP001 #define ESCHER_ShpInst_Hexagon			9
//STRIP001 #define ESCHER_ShpInst_Octagon			10
//STRIP001 #define ESCHER_ShpInst_Plus				11
//STRIP001 #define ESCHER_ShpInst_Star				12
//STRIP001 #define ESCHER_ShpInst_Arrow			13
//STRIP001 #define ESCHER_ShpInst_ThickArrow		14
//STRIP001 #define ESCHER_ShpInst_HomePlate		15
//STRIP001 #define ESCHER_ShpInst_Cube				16
//STRIP001 #define ESCHER_ShpInst_Balloon			17
//STRIP001 #define ESCHER_ShpInst_Seal				18
//STRIP001 #define ESCHER_ShpInst_Arc				19
//STRIP001 #define ESCHER_ShpInst_Line				20
//STRIP001 #define ESCHER_ShpInst_Plaque			21
//STRIP001 #define ESCHER_ShpInst_Can				22
//STRIP001 #define ESCHER_ShpInst_Donut			23
//STRIP001 #define ESCHER_ShpInst_TextSimple		24
//STRIP001 #define ESCHER_ShpInst_TextOctagon		25
//STRIP001 #define ESCHER_ShpInst_TextHexagon		26
//STRIP001 #define ESCHER_ShpInst_TextCurve		27
//STRIP001 #define ESCHER_ShpInst_TextWave			28
//STRIP001 #define ESCHER_ShpInst_TextRing			29
//STRIP001 #define ESCHER_ShpInst_TextOnCurve		30
//STRIP001 #define ESCHER_ShpInst_TextOnRing		31
//STRIP001 #define ESCHER_ShpInst_StraightConnector1 32
//STRIP001 #define ESCHER_ShpInst_BentConnector2	33
//STRIP001 #define ESCHER_ShpInst_BentConnector3	34
//STRIP001 #define ESCHER_ShpInst_BentConnector4	35
//STRIP001 #define ESCHER_ShpInst_BentConnector5	36
//STRIP001 #define ESCHER_ShpInst_CurvedConnector2	37
//STRIP001 #define ESCHER_ShpInst_CurvedConnector3	38
//STRIP001 #define ESCHER_ShpInst_CurvedConnector4	39
//STRIP001 #define ESCHER_ShpInst_CurvedConnector5	40
//STRIP001 #define ESCHER_ShpInst_Callout1			41
//STRIP001 #define ESCHER_ShpInst_Callout2			42
//STRIP001 #define ESCHER_ShpInst_Callout3			43
//STRIP001 #define ESCHER_ShpInst_AccentCallout1	44
//STRIP001 #define ESCHER_ShpInst_AccentCallout2	45
//STRIP001 #define ESCHER_ShpInst_AccentCallout3	46
//STRIP001 #define ESCHER_ShpInst_BorderCallout1	47
//STRIP001 #define ESCHER_ShpInst_BorderCallout2	48
//STRIP001 #define ESCHER_ShpInst_BorderCallout3	49
//STRIP001 #define ESCHER_ShpInst_AccentBorderCallout1	50
//STRIP001 #define ESCHER_ShpInst_AccentBorderCallout2	51
//STRIP001 #define ESCHER_ShpInst_AccentBorderCallout3	52
//STRIP001 #define ESCHER_ShpInst_Ribbon			53
//STRIP001 #define ESCHER_ShpInst_Ribbon2			54
//STRIP001 #define ESCHER_ShpInst_Chevron			55
//STRIP001 #define ESCHER_ShpInst_Pentagon			56
//STRIP001 #define ESCHER_ShpInst_NoSmoking		57
//STRIP001 #define ESCHER_ShpInst_Seal8			58
//STRIP001 #define ESCHER_ShpInst_Seal16			59
//STRIP001 #define ESCHER_ShpInst_Seal32			60
//STRIP001 #define ESCHER_ShpInst_WedgeRectCallout	61
//STRIP001 #define ESCHER_ShpInst_WedgeRRectCallout	62
//STRIP001 #define ESCHER_ShpInst_WedgeEllipseCallout	63
//STRIP001 #define ESCHER_ShpInst_Wave				64
//STRIP001 #define ESCHER_ShpInst_FoldedCorner		65
//STRIP001 #define ESCHER_ShpInst_LeftArrow		66
//STRIP001 #define ESCHER_ShpInst_DownArrow		67
//STRIP001 #define ESCHER_ShpInst_UpArrow			68
//STRIP001 #define ESCHER_ShpInst_LeftRightArrow	69
//STRIP001 #define ESCHER_ShpInst_UpDownArrow		70
//STRIP001 #define ESCHER_ShpInst_IrregularSeal1	71
//STRIP001 #define ESCHER_ShpInst_IrregularSeal2	72
//STRIP001 #define ESCHER_ShpInst_LightningBolt	73
//STRIP001 #define ESCHER_ShpInst_Heart			74
//STRIP001 #define ESCHER_ShpInst_PictureFrame		75
//STRIP001 #define ESCHER_ShpInst_QuadArrow		76
//STRIP001 #define ESCHER_ShpInst_LeftArrowCallout	77
//STRIP001 #define ESCHER_ShpInst_RightArrowCallout	78
//STRIP001 #define ESCHER_ShpInst_UpArrowCallout	79
//STRIP001 #define ESCHER_ShpInst_DownArrowCallout	80
//STRIP001 #define ESCHER_ShpInst_LeftRightArrowCallout	81
//STRIP001 #define ESCHER_ShpInst_UpDownArrowCallout	82
//STRIP001 #define ESCHER_ShpInst_QuadArrowCallout	83
//STRIP001 #define ESCHER_ShpInst_Bevel			84
//STRIP001 #define ESCHER_ShpInst_LeftBracket		85
//STRIP001 #define ESCHER_ShpInst_RightBracket		86
//STRIP001 #define ESCHER_ShpInst_LeftBrace		87
//STRIP001 #define ESCHER_ShpInst_RightBrace		88
//STRIP001 #define ESCHER_ShpInst_LeftUpArrow		89
//STRIP001 #define ESCHER_ShpInst_BentUpArrow		90
//STRIP001 #define ESCHER_ShpInst_BentArrow		91
//STRIP001 #define ESCHER_ShpInst_Seal24			92
//STRIP001 #define ESCHER_ShpInst_StripedRightArrow	93
//STRIP001 #define ESCHER_ShpInst_NotchedRightArrow	94
//STRIP001 #define ESCHER_ShpInst_BlockArc			95
//STRIP001 #define ESCHER_ShpInst_SmileyFace		96
//STRIP001 #define ESCHER_ShpInst_VerticalScroll	97
//STRIP001 #define ESCHER_ShpInst_HorizontalScroll	98
//STRIP001 #define ESCHER_ShpInst_CircularArrow	99
//STRIP001 #define ESCHER_ShpInst_NotchedCircularArrow	100
//STRIP001 #define ESCHER_ShpInst_UturnArrow		101
//STRIP001 #define ESCHER_ShpInst_CurvedRightArrow	102
//STRIP001 #define ESCHER_ShpInst_CurvedLeftArrow	103
//STRIP001 #define ESCHER_ShpInst_CurvedUpArrow	104
//STRIP001 #define ESCHER_ShpInst_CurvedDownArrow	105
//STRIP001 #define ESCHER_ShpInst_CloudCallout		106
//STRIP001 #define ESCHER_ShpInst_EllipseRibbon	107
//STRIP001 #define ESCHER_ShpInst_EllipseRibbon2	108
//STRIP001 #define ESCHER_ShpInst_FlowChartProcess	109
//STRIP001 #define ESCHER_ShpInst_FlowChartDecision	110
//STRIP001 #define ESCHER_ShpInst_FlowChartInputOutput	111
//STRIP001 #define ESCHER_ShpInst_FlowChartPredefinedProcess	112
//STRIP001 #define ESCHER_ShpInst_FlowChartInternalStorage	113
//STRIP001 #define ESCHER_ShpInst_FlowChartDocument	114
//STRIP001 #define ESCHER_ShpInst_FlowChartMultidocument	115
//STRIP001 #define ESCHER_ShpInst_FlowChartTerminator	116
//STRIP001 #define ESCHER_ShpInst_FlowChartPreparation	117
//STRIP001 #define ESCHER_ShpInst_FlowChartManualInput	118
//STRIP001 #define ESCHER_ShpInst_FlowChartManualOperation	119
//STRIP001 #define ESCHER_ShpInst_FlowChartConnector	120
//STRIP001 #define ESCHER_ShpInst_FlowChartPunchedCard	121
//STRIP001 #define ESCHER_ShpInst_FlowChartPunchedTape	122
//STRIP001 #define ESCHER_ShpInst_FlowChartSummingJunction	123
//STRIP001 #define ESCHER_ShpInst_FlowChartOr		124
//STRIP001 #define ESCHER_ShpInst_FlowChartCollate	125
//STRIP001 #define ESCHER_ShpInst_FlowChartSort	126
//STRIP001 #define ESCHER_ShpInst_FlowChartExtract	127
//STRIP001 #define ESCHER_ShpInst_FlowChartMerge	128
//STRIP001 #define ESCHER_ShpInst_FlowChartOfflineStorage	129
//STRIP001 #define ESCHER_ShpInst_FlowChartOnlineStorage	130
//STRIP001 #define ESCHER_ShpInst_FlowChartMagneticTape	131
//STRIP001 #define ESCHER_ShpInst_FlowChartMagneticDisk	132
//STRIP001 #define ESCHER_ShpInst_FlowChartMagneticDrum	133
//STRIP001 #define ESCHER_ShpInst_FlowChartDisplay	134
//STRIP001 #define ESCHER_ShpInst_FlowChartDelay	135
//STRIP001 #define ESCHER_ShpInst_TextPlainText	136
//STRIP001 #define ESCHER_ShpInst_TextStop			137
//STRIP001 #define ESCHER_ShpInst_TextTriangle		138
//STRIP001 #define ESCHER_ShpInst_TextTriangleInverted	139
//STRIP001 #define ESCHER_ShpInst_TextChevron		140
//STRIP001 #define ESCHER_ShpInst_TextChevronInverted	141
//STRIP001 #define ESCHER_ShpInst_TextRingInside	142
//STRIP001 #define ESCHER_ShpInst_TextRingOutside	143
//STRIP001 #define ESCHER_ShpInst_TextArchUpCurve	144
//STRIP001 #define ESCHER_ShpInst_TextArchDownCurve	145
//STRIP001 #define ESCHER_ShpInst_TextCircleCurve	146
//STRIP001 #define ESCHER_ShpInst_TextButtonCurve	147
//STRIP001 #define ESCHER_ShpInst_TextArchUpPour	148
//STRIP001 #define ESCHER_ShpInst_TextArchDownPour	149
//STRIP001 #define ESCHER_ShpInst_TextCirclePour	150
//STRIP001 #define ESCHER_ShpInst_TextButtonPour	151
//STRIP001 #define ESCHER_ShpInst_TextCurveUp		152
//STRIP001 #define ESCHER_ShpInst_TextCurveDown	153
//STRIP001 #define ESCHER_ShpInst_TextCascadeUp	154
//STRIP001 #define ESCHER_ShpInst_TextCascadeDown	155
//STRIP001 #define ESCHER_ShpInst_TextWave1		156
//STRIP001 #define ESCHER_ShpInst_TextWave2		157
//STRIP001 #define ESCHER_ShpInst_TextWave3		158
//STRIP001 #define ESCHER_ShpInst_TextWave4		159
//STRIP001 #define ESCHER_ShpInst_TextInflate		160
//STRIP001 #define ESCHER_ShpInst_TextDeflate		161
//STRIP001 #define ESCHER_ShpInst_TextInflateBottom	162
//STRIP001 #define ESCHER_ShpInst_TextDeflateBottom	163
//STRIP001 #define ESCHER_ShpInst_TextInflateTop		164
//STRIP001 #define ESCHER_ShpInst_TextDeflateTop		165
//STRIP001 #define ESCHER_ShpInst_TextDeflateInflate	166
//STRIP001 #define ESCHER_ShpInst_TextDeflateInflateDeflate	167
//STRIP001 #define ESCHER_ShpInst_TextFadeRight	168
//STRIP001 #define ESCHER_ShpInst_TextFadeLeft		169
//STRIP001 #define ESCHER_ShpInst_TextFadeUp		170
//STRIP001 #define ESCHER_ShpInst_TextFadeDown		171
//STRIP001 #define ESCHER_ShpInst_TextSlantUp		172
//STRIP001 #define ESCHER_ShpInst_TextSlantDown	173
//STRIP001 #define ESCHER_ShpInst_TextCanUp		174
//STRIP001 #define ESCHER_ShpInst_TextCanDown		175
//STRIP001 #define ESCHER_ShpInst_FlowChartAlternateProcess	176
//STRIP001 #define ESCHER_ShpInst_FlowChartOffpageConnector	177
//STRIP001 #define ESCHER_ShpInst_Callout90		178
//STRIP001 #define ESCHER_ShpInst_AccentCallout90	179
//STRIP001 #define ESCHER_ShpInst_BorderCallout90	180
//STRIP001 #define ESCHER_ShpInst_AccentBorderCallout90	181
//STRIP001 #define ESCHER_ShpInst_LeftRightUpArrow	182
//STRIP001 #define ESCHER_ShpInst_Sun				183
//STRIP001 #define ESCHER_ShpInst_Moon				184
//STRIP001 #define ESCHER_ShpInst_BracketPair		185
//STRIP001 #define ESCHER_ShpInst_BracePair		186
//STRIP001 #define ESCHER_ShpInst_Seal4			187
//STRIP001 #define ESCHER_ShpInst_DoubleWave		188
//STRIP001 #define ESCHER_ShpInst_ActionButtonBlank	189
//STRIP001 #define ESCHER_ShpInst_ActionButtonHome		190
//STRIP001 #define ESCHER_ShpInst_ActionButtonHelp		191
//STRIP001 #define ESCHER_ShpInst_ActionButtonInformation	192
//STRIP001 #define ESCHER_ShpInst_ActionButtonForwardNext	193
//STRIP001 #define ESCHER_ShpInst_ActionButtonBackPrevious	194
//STRIP001 #define ESCHER_ShpInst_ActionButtonEnd		195
//STRIP001 #define ESCHER_ShpInst_ActionButtonBeginning	196
//STRIP001 #define ESCHER_ShpInst_ActionButtonReturn	197
//STRIP001 #define ESCHER_ShpInst_ActionButtonDocument	198
//STRIP001 #define ESCHER_ShpInst_ActionButtonSound	199
//STRIP001 #define ESCHER_ShpInst_ActionButtonMovie	200
//STRIP001 #define ESCHER_ShpInst_HostControl			201
//STRIP001 #define ESCHER_ShpInst_TextBox				202
//STRIP001 #define ESCHER_ShpInst_Max					0x0FFF
//STRIP001 #define ESCHER_ShpInst_Nil					ESCHER_ShpInst_Max

//STRIP001 enum ESCHER_BlibType
//STRIP001 {							// GEL provided types...
//STRIP001    ERROR = 0,				// An error occured during loading
//STRIP001    UNKNOWN,					// An unknown blip type
//STRIP001    EMF,						// Windows Enhanced Metafile
//STRIP001    WMF,						// Windows Metafile
//STRIP001    PICT,					// Macintosh PICT
//STRIP001    PEG,						// JFIF
//STRIP001    PNG,						// PNG
//STRIP001    DIB,						// Windows DIB
//STRIP001    FirstClient = 32,		// First client defined blip type
//STRIP001    LastClient  = 255		// Last client defined blip type
//STRIP001 };

//STRIP001 enum ESCHER_FillStyle
//STRIP001 {
//STRIP001 	ESCHER_FillSolid,		// Fill with a solid color
//STRIP001 	ESCHER_FillPattern,     // Fill with a pattern (bitmap)
//STRIP001 	ESCHER_FillTexture,     // A texture (pattern with its own color map)
//STRIP001 	ESCHER_FillPicture,     // Center a picture in the shape
//STRIP001 	ESCHER_FillShade,       // Shade from start to end points
//STRIP001 	ESCHER_FillShadeCenter, // Shade from bounding rectangle to end point
//STRIP001 	ESCHER_FillShadeShape,  // Shade from shape outline to end point
//STRIP001 	ESCHER_FillShadeScale,
//STRIP001 	ESCHER_FillShadeTitle,
//STRIP001 	ESCHER_FillBackground
//STRIP001 };

//STRIP001 enum ESCHER_wMode
//STRIP001 {
//STRIP001 	ESCHER_wColor,          // only used for predefined shades
//STRIP001 	ESCHER_wAutomatic,      // depends on object type
//STRIP001 	ESCHER_wGrayScale,      // shades of gray only
//STRIP001 	ESCHER_wLightGrayScale, // shades of light gray only
//STRIP001 	ESCHER_wInverseGray,    // dark gray mapped to light gray, etc.
//STRIP001 	ESCHER_wGrayOutline,    // pure gray and white
//STRIP001 	ESCHER_wBlackTextLine,  // black text and lines, all else grayscale
//STRIP001 	ESCHER_wHighContrast,   // pure black and white mode (no grays)
//STRIP001 	ESCHER_wBlack,          // solid black   msobwWhite,          // solid white
//STRIP001 	ESCHER_wDontShow,       // object not drawn
//STRIP001 	ESCHER_wNumModes        // number of Black and white modes
//STRIP001 };

//
//STRIP001 enum ESCHER_ShapePath
//STRIP001 {
//STRIP001 	ESCHER_ShapeLines,        // A line of straight segments
//STRIP001 	ESCHER_ShapeLinesClosed,  // A closed polygonal object
//STRIP001 	ESCHER_ShapeCurves,       // A line of Bezier curve segments
//STRIP001 	ESCHER_ShapeCurvesClosed, // A closed shape with curved edges
//STRIP001 	ESCHER_ShapeComplex      // pSegmentInfo must be non-empty
//STRIP001 };

//STRIP001 enum ESCHER_WrapMode
//STRIP001 {
//STRIP001 	ESCHER_WrapSquare,
//STRIP001 	ESCHER_WrapByPoints,
//STRIP001 	ESCHER_WrapNone,
//STRIP001 	ESCHER_WrapTopBottom,
//STRIP001 	ESCHER_WrapThrough
//STRIP001 };

//
//STRIP001 enum ESCHER_bwMode
//STRIP001 {
//STRIP001 	ESCHER_bwColor,          // only used for predefined shades
//STRIP001 	ESCHER_bwAutomatic,      // depends on object type
//STRIP001 	ESCHER_bwGrayScale,      // shades of gray only
//STRIP001 	ESCHER_bwLightGrayScale, // shades of light gray only
//STRIP001 	ESCHER_bwInverseGray,    // dark gray mapped to light gray, etc.
//STRIP001 	ESCHER_bwGrayOutline,    // pure gray and white
//STRIP001 	ESCHER_bwBlackTextLine,  // black text and lines, all else grayscale
//STRIP001 	ESCHER_bwHighContrast,   // pure black and white mode (no grays)
//STRIP001 	ESCHER_bwBlack,          // solid black
//STRIP001 	ESCHER_bwWhite,          // solid white
//STRIP001 	ESCHER_bwDontShow,       // object not drawn
//STRIP001 	ESCHER_bwNumModes        // number of Black and white modes
//STRIP001 };

//STRIP001 enum ESCHER_AnchorText
//STRIP001 {
//STRIP001 	ESCHER_AnchorTop,
//STRIP001 	ESCHER_AnchorMiddle,
//STRIP001 	ESCHER_AnchorBottom,
//STRIP001 	ESCHER_AnchorTopCentered,
//STRIP001 	ESCHER_AnchorMiddleCentered,
//STRIP001 	ESCHER_AnchorBottomCentered,
//STRIP001 	ESCHER_AnchorTopBaseline,
//STRIP001 	ESCHER_AnchorBottomBaseline,
//STRIP001 	ESCHER_AnchorTopCenteredBaseline,
//STRIP001 	ESCHER_AnchorBottomCenteredBaseline
//STRIP001 };

//STRIP001 enum ESCHER_cDir
//STRIP001 {
//STRIP001 	ESCHER_cDir0,       // Right
//STRIP001 	ESCHER_cDir90,      // Down
//STRIP001 	ESCHER_cDir180,     // Left
//STRIP001 	ESCHER_cDir270      // Up
//STRIP001 };

//  connector style
//STRIP001 enum ESCHER_cxSTYLE
//STRIP001 {
//STRIP001 	ESCHER_cxstyleStraight = 0,
//STRIP001 	ESCHER_cxstyleBent,
//STRIP001 	ESCHER_cxstyleCurved,
//STRIP001 	ESCHER_cxstyleNone
//STRIP001 };

//  text flow
//STRIP001 enum ESCHER_txfl
//STRIP001 {
//STRIP001 	ESCHER_txflHorzN,           // Horizontal non-@
//STRIP001 	ESCHER_txflTtoBA,           // Top to Bottom @-font
//STRIP001 	ESCHER_txflBtoT,            // Bottom to Top non-@
//STRIP001 	ESCHER_txflTtoBN,           // Top to Bottom non-@
//STRIP001 	ESCHER_txflHorzA,           // Horizontal @-font
//STRIP001 	ESCHER_txflVertN			// Vertical, non-@
//STRIP001 };

//  text direction (needed for Bi-Di support)
//STRIP001 enum ESCHER_txDir
//STRIP001 {
//STRIP001 	ESCHER_txdirLTR,			// left-to-right text direction
//STRIP001 	ESCHER_txdirRTL,			// right-to-left text direction
//STRIP001 	ESCHER_txdirContext			// context text direction
//STRIP001 };

// Callout Type
//STRIP001 enum ESCHER_spcot
//STRIP001 {
//STRIP001 	ESCHER_spcotRightAngle = 1,
//STRIP001 	ESCHER_spcotOneSegment = 2,
//STRIP001 	ESCHER_spcotTwoSegment = 3,
//STRIP001 	ESCHER_spcotThreeSegment = 4
//STRIP001 };

// Callout Angle
//STRIP001 enum ESCHER_spcoa
//STRIP001 {
//STRIP001 	ESCHER_spcoaAny,
//STRIP001 	ESCHER_spcoa30,
//STRIP001 	ESCHER_spcoa45,
//STRIP001 	ESCHER_spcoa60,
//STRIP001 	ESCHER_spcoa90,
//STRIP001 	ESCHER_spcoa0
//STRIP001 };

//  Callout Drop
//STRIP001 enum ESCHER_spcod
//STRIP001 {
//STRIP001 	ESCHER_spcodTop,
//STRIP001 	ESCHER_spcodCenter,
//STRIP001 	ESCHER_spcodBottom,
//STRIP001 	ESCHER_spcodSpecified
//STRIP001 };

// WordArt alignment
//STRIP001 enum ESCHER_GeoTextAlign
//STRIP001 {
//STRIP001 	ESCHER_AlignTextStretch,      /* Stretch each line of text to fit width. */
//STRIP001 	ESCHER_AlignTextCenter,       /* Center text on width. */
//STRIP001 	ESCHER_AlignTextLeft,         /* Left justify. */
//STRIP001 	ESCHER_AlignTextRight,        /* Right justify. */
//STRIP001 	ESCHER_AlignTextLetterJust,   /* Spread letters out to fit width. */
//STRIP001 	ESCHER_AlignTextWordJust,     /* Spread words out to fit width. */
//STRIP001 	ESCHER_AlignTextInvalid       /* Invalid */
//STRIP001 };

//  flags for pictures
//STRIP001 enum ESCHER_BlipFlags
//STRIP001 {
//STRIP001 	ESCHER_BlipFlagDefault = 0,
//STRIP001 	ESCHER_BlipFlagComment = 0,   // Blip name is a comment
//STRIP001 	ESCHER_BlipFlagFile,          // Blip name is a file name
//STRIP001 	ESCHER_BlipFlagURL,           // Blip name is a full URL
//STRIP001 	ESCHER_BlipFlagType = 3,      // Mask to extract type
//STRIP001    /* Or the following flags with any of the above. */
//STRIP001 	ESCHER_BlipFlagDontSave = 4,  // A "dont" is the depression in the metal
//STRIP001 							 // body work of an automobile caused when a
//STRIP001 							 // cyclist violently thrusts his or her nose
//STRIP001 							 // at it, thus a DontSave is another name for
//STRIP001 							 // a cycle lane.
//STRIP001 	ESCHER_BlipFlagDoNotSave = 4, // For those who prefer English
//STRIP001 	ESCHER_BlipFlagLinkToFile = 8
//STRIP001 };

//
//STRIP001 enum ESCHER_3DRenderMode
//STRIP001 {
//STRIP001 	ESCHER_FullRender,      // Generate a full rendering
//STRIP001 	ESCHER_Wireframe,       // Generate a wireframe
//STRIP001 	ESCHER_BoundingCube		// Generate a bounding cube
//STRIP001 };

//
//STRIP001 enum ESCHER_xFormType
//STRIP001 {
//STRIP001 	ESCHER_xFormAbsolute,   // Apply transform in absolute space centered on shape
//STRIP001 	ESCHER_xFormShape,      // Apply transform to shape geometry
//STRIP001 	ESCHER_xFormDrawing     // Apply transform in drawing space
//STRIP001 };

//
//STRIP001 enum ESCHER_ShadowType
//STRIP001 {
//STRIP001 	ESCHER_ShadowOffset,    // N pixel offset shadow
//STRIP001 	ESCHER_ShadowDouble,    // Use second offset too
//STRIP001 	ESCHER_ShadowRich,      // Rich perspective shadow (cast relative to shape)
//STRIP001 	ESCHER_ShadowShape,     // Rich perspective shadow (cast in shape space)
//STRIP001 	ESCHER_ShadowDrawing,   // Perspective shadow cast in drawing space
//STRIP001 	ESCHER_ShadowEmbossOrEngrave
//STRIP001 };

//  - the type of a (length) measurement
//STRIP001 enum ESCHER_dzType
//STRIP001    {
//STRIP001    ESCHER_dzTypeMin          = 0,
//STRIP001    ESCHER_dzTypeDefault      = 0,  // Default size, ignore the values
//STRIP001    ESCHER_dzTypeA            = 1,  // Values are in EMUs
//STRIP001    ESCHER_dzTypeV            = 2,  // Values are in pixels
//STRIP001    ESCHER_dzTypeShape        = 3,  // Values are 16.16 fractions of shape size
//STRIP001    ESCHER_dzTypeFixedAspect  = 4,  // Aspect ratio is fixed
//STRIP001    ESCHER_dzTypeAFixed       = 5,  // EMUs, fixed aspect ratio
//STRIP001    ESCHER_dzTypeVFixed       = 6,  // Pixels, fixed aspect ratio
//STRIP001    ESCHER_dzTypeShapeFixed   = 7,  // Proportion of shape, fixed aspect ratio
//STRIP001    ESCHER_dzTypeFixedAspectEnlarge= 8,  // Aspect ratio is fixed, favor larger size
//STRIP001    ESCHER_dzTypeAFixedBig    = 9,  // EMUs, fixed aspect ratio
//STRIP001    ESCHER_dzTypeVFixedBig    = 10, // Pixels, fixed aspect ratio
//STRIP001    ESCHER_dzTypeShapeFixedBig= 11, // Proportion of shape, fixed aspect ratio
//STRIP001    ESCHER_dzTypeMax         = 11
//STRIP001 };

// how to interpret the colors in a shaded fill.
//STRIP001 enum ESCHER_ShadeType
//STRIP001 {
//STRIP001 	ESCHER_ShadeNone  = 0,        // Interpolate without correction between RGBs
//STRIP001 	ESCHER_ShadeGamma = 1,        // Apply gamma correction to colors
//STRIP001 	ESCHER_ShadeSigma = 2,        // Apply a sigma transfer function to position
//STRIP001 	ESCHER_ShadeBand  = 4,        // Add a flat band at the start of the shade
//STRIP001 	ESCHER_ShadeOneColor = 8,     // This is a one color shade
//STRIP001 
//STRIP001    /* A parameter for the band or sigma function can be stored in the top
//STRIP001 	  16 bits of the value - this is a proportion of *each* band of the
//STRIP001 	  shade to make flat (or the approximate equal value for a sigma
//STRIP001 	  function).  NOTE: the parameter is not used for the sigma function,
//STRIP001 	  instead a built in value is used.  This value should not be changed
//STRIP001 	  from the default! */
//STRIP001 	ESCHER_ShadeParameterShift = 16,
//STRIP001 	ESCHER_ShadeParameterMask  = 0xffff0000,
//STRIP001 
//STRIP001 	ESCHER_ShadeDefault = (ESCHER_ShadeGamma|ESCHER_ShadeSigma|
//STRIP001 					 (16384<<ESCHER_ShadeParameterShift))
//STRIP001 };

// compound line style
//STRIP001 enum ESCHER_LineStyle
//STRIP001 {
//STRIP001 	ESCHER_LineSimple,            // Single line (of width lineWidth)
//STRIP001 	ESCHER_LineDouble,            // Double lines of equal width
//STRIP001 	ESCHER_LineThickThin,         // Double lines, one thick, one thin
//STRIP001 	ESCHER_LineThinThick,         // Double lines, reverse order
//STRIP001 	ESCHER_LineTriple             // Three lines, thin, thick, thin
//STRIP001 };

//  how to "fill" the line contour
//STRIP001 enum ESCHER_LineType
//STRIP001 {
//STRIP001    ESCHER_lineSolidType,         // Fill with a solid color
//STRIP001    ESCHER_linePattern,           // Fill with a pattern (bitmap)
//STRIP001    ESCHER_lineTexture,           // A texture (pattern with its own color map)
//STRIP001    ESCHER_linePicture            // Center a picture in the shape
//STRIP001 };

// dashed line style
//STRIP001 enum ESCHER_LineDashing
//STRIP001 {
//STRIP001 	ESCHER_LineSolid,              // Solid (continuous) pen
//STRIP001 	ESCHER_LineDashSys,            // PS_DASH system   dash style
//STRIP001 	ESCHER_LineDotSys,             // PS_DOT system   dash style
//STRIP001 	ESCHER_LineDashDotSys,         // PS_DASHDOT system dash style
//STRIP001 	ESCHER_LineDashDotDotSys,      // PS_DASHDOTDOT system dash style
//STRIP001 	ESCHER_LineDotGEL,             // square dot style
//STRIP001 	ESCHER_LineDashGEL,            // dash style
//STRIP001 	ESCHER_LineLongDashGEL,        // long dash style
//STRIP001 	ESCHER_LineDashDotGEL,         // dash short dash
//STRIP001 	ESCHER_LineLongDashDotGEL,     // long dash short dash
//STRIP001 	ESCHER_LineLongDashDotDotGEL   // long dash short dash short dash
//STRIP001 };

// line end effect
//STRIP001 enum ESCHER_LineEnd
//STRIP001 {
//STRIP001 	ESCHER_LineNoEnd,
//STRIP001 	ESCHER_LineArrowEnd,
//STRIP001 	ESCHER_LineArrowStealthEnd,
//STRIP001 	ESCHER_LineArrowDiamondEnd,
//STRIP001 	ESCHER_LineArrowOvalEnd,
//STRIP001 	ESCHER_LineArrowOpenEnd
//STRIP001 };

// size of arrowhead
//STRIP001 enum ESCHER_LineWidth
//STRIP001 {
//STRIP001 	ESCHER_LineNarrowArrow,
//STRIP001 	ESCHER_LineMediumWidthArrow,
//STRIP001 	ESCHER_LineWideArrow
//STRIP001 };

// size of arrowhead
//STRIP001 enum ESCHER_LineEndLenght
//STRIP001 {
//STRIP001 	ESCHER_LineShortArrow,
//STRIP001 	ESCHER_LineMediumLenArrow,
//STRIP001 	ESCHER_LineLongArrow
//STRIP001 };

// line join style.
//STRIP001 enum ESCHER_LineJoin
//STRIP001 {
//STRIP001 	ESCHER_LineJoinBevel,     // Join edges by a straight line
//STRIP001 	ESCHER_LineJoinMiter,     // Extend edges until they join
//STRIP001 	ESCHER_LineJoinRound      // Draw an arc between the two edges
//STRIP001 };

// line cap style (applies to ends of dash segments too).
//STRIP001 enum ESCHER_LineCap
//STRIP001 {
//STRIP001 	ESCHER_LineEndCapRound,   // Rounded ends - the default
//STRIP001 	ESCHER_LineEndCapSquare,  // Square protrudes by half line width
//STRIP001 	ESCHER_LineEndCapFlat     // Line ends at end point
//STRIP001 };
// Shape Properties
// 1pt = 12700 EMU (English Metric Units)
// 1pt = 20 Twip = 20/1440" = 1/72"
// 1twip=635 EMU
// 1" = 12700*72 = 914400 EMU
// 1" = 25.4mm
// 1mm = 36000 EMU
// Transform
//STRIP001 #define ESCHER_Prop_Rotation                      4  /*  Fixed Point 16.16 degrees                  */
// Protection
//STRIP001 #define ESCHER_Prop_LockRotation                119  /*  BOOL              No rotation                         */
//STRIP001 #define ESCHER_Prop_LockAspectRatio             120  /*  BOOL              Don't allow changes in aspect ratio */
//STRIP001 #define ESCHER_Prop_LockPosition                121  /*  BOOL              Don't allow the shape to be moved   */
//STRIP001 #define ESCHER_Prop_LockAgainstSelect           122  /*  BOOL              Shape may not be selected           */
//STRIP001 #define ESCHER_Prop_LockCropping                123  /*  BOOL              No cropping this shape              */
//STRIP001 #define ESCHER_Prop_LockVertices                124  /*  BOOL              Edit Points not allowed             */
//STRIP001 #define ESCHER_Prop_LockText                    125  /*  BOOL              Do not edit text                    */
//STRIP001 #define ESCHER_Prop_LockAdjustHandles           126  /*  BOOL              Do not adjust                       */
//STRIP001 #define ESCHER_Prop_LockAgainstGrouping         127  /*  BOOL              Do not group this shape             */
//STRIP001 // Text
//STRIP001 #define ESCHER_Prop_lTxid                       128  /*  LONG              id for the text, value determined by the host            */
//STRIP001 #define ESCHER_Prop_dxTextLeft                  129  /*  LONG              margins relative to shape's inscribed                    */
//STRIP001 #define ESCHER_Prop_dyTextTop                   130  /*  LONG                text rectangle (in EMUs)                               */
//STRIP001 #define ESCHER_Prop_dxTextRight                 131  /*  LONG                                                                       */
//STRIP001 #define ESCHER_Prop_dyTextBottom                132  /*  LONG                                                                       */
//STRIP001 #define ESCHER_Prop_WrapText                    133  /*  MSOWRAPMODE       Wrap text at shape margins                               */
//STRIP001 #define ESCHER_Prop_scaleText                   134  /*  LONG              Text zoom/scale (used if fFitTextToShape)                */
//STRIP001 #define ESCHER_Prop_AnchorText                  135  /*  ESCHER_AnchorText How to anchor the text                                   */
//STRIP001 #define ESCHER_Prop_txflTextFlow                136  /*  MSOTXFL           Text flow                                                */
//STRIP001 #define ESCHER_Prop_cdirFont                    137  /*  MSOCDIR           Font rotation                                            */
//STRIP001 #define ESCHER_Prop_hspNext                     138  /*  MSOHSP            ID of the next shape (used by Word for linked textboxes) */
//STRIP001 #define ESCHER_Prop_txdir                       139  /*  MSOTXDIR          Bi-Di Text direction                                     */
//STRIP001 #define ESCHER_Prop_SelectText                  187  /*  BOOL              TRUE if single click selects text, FALSE if two clicks   */
//STRIP001 #define ESCHER_Prop_AutoTextMargin              188  /*  BOOL              use host's margin calculations                           */
//STRIP001 #define ESCHER_Prop_RotateText                  189  /*  BOOL              Rotate text with shape                                   */
//STRIP001 #define ESCHER_Prop_FitShapeToText              190  /*  BOOL              Size shape to fit text size                              */
//STRIP001 #define ESCHER_Prop_FitTextToShape              191  /*  BOOL              Size text to fit shape size                              */
//STRIP001 // GeoText
//STRIP001 #define ESCHER_Prop_gtextUNICODE                192  /*  WCHAR*            UNICODE text string       */
//STRIP001 #define ESCHER_Prop_gtextRTF                    193  /*  char*             RTF text string           */
//STRIP001 #define ESCHER_Prop_gtextAlign                  194  /*  MSOGEOTEXTALIGN   alignment on curve        */
//STRIP001 #define ESCHER_Prop_gtextSize                   195  /*  LONG              default point size        */
//STRIP001 #define ESCHER_Prop_gtextSpacing                196  /*  LONG              fixed point 16.16         */
//STRIP001 #define ESCHER_Prop_gtextFont                   197  /*  WCHAR*            font family name          */
//STRIP001 #define ESCHER_Prop_gtextFReverseRows           240  /*  BOOL              Reverse row order         */
//STRIP001 #define ESCHER_Prop_fGtext                      241  /*  BOOL              Has text effect           */
//STRIP001 #define ESCHER_Prop_gtextFVertical              242  /*  BOOL              Rotate characters         */
//STRIP001 #define ESCHER_Prop_gtextFKern                  243  /*  BOOL              Kern characters           */
//STRIP001 #define ESCHER_Prop_gtextFTight                 244  /*  BOOL              Tightening or tracking    */
//STRIP001 #define ESCHER_Prop_gtextFStretch               245  /*  BOOL              Stretch to fit shape      */
//STRIP001 #define ESCHER_Prop_gtextFShrinkFit             246  /*  BOOL              Char bounding box         */
//STRIP001 #define ESCHER_Prop_gtextFBestFit               247  /*  BOOL              Scale text-on-path        */
//STRIP001 #define ESCHER_Prop_gtextFNormalize             248  /*  BOOL              Stretch char height       */
//STRIP001 #define ESCHER_Prop_gtextFDxMeasure             249  /*  BOOL              Do not measure along path */
//STRIP001 #define ESCHER_Prop_gtextFBold                  250  /*  BOOL              Bold font                 */
//STRIP001 #define ESCHER_Prop_gtextFItalic                251  /*  BOOL              Italic font               */
//STRIP001 #define ESCHER_Prop_gtextFUnderline             252  /*  BOOL              Underline font            */
//STRIP001 #define ESCHER_Prop_gtextFShadow                253  /*  BOOL              Shadow font               */
//STRIP001 #define ESCHER_Prop_gtextFSmallcaps             254  /*  BOOL              Small caps font           */
//STRIP001 #define ESCHER_Prop_gtextFStrikethrough         255  /*  BOOL              Strike through font       */
//STRIP001 // Blip
//STRIP001 #define ESCHER_Prop_cropFromTop                 256  /*  LONG              16.16 fraction times total                          */
//STRIP001 #define ESCHER_Prop_cropFromBottom				257  /*  LONG                image width or height,                            */
//STRIP001 #define ESCHER_Prop_cropFromLeft                258  /*  LONG                as appropriate.                                   */
//STRIP001 #define ESCHER_Prop_cropFromRight               259  /*  LONG                                                                  */
//STRIP001 #define ESCHER_Prop_pib                         260  /*  IMsoBlip*         Blip to display                                     */
//STRIP001 #define ESCHER_Prop_pibName                     261  /*  WCHAR*            Blip file name                                      */
//STRIP001 #define ESCHER_Prop_pibFlags                    262  /*  MSOBLIPFLAGS      Blip flags                                          */
//STRIP001 #define ESCHER_Prop_pictureTransparent          263  /*  LONG              transparent color (none if ~0UL)                    */
//STRIP001 #define ESCHER_Prop_pictureContrast             264  /*  LONG              contrast setting                                    */
//STRIP001 #define ESCHER_Prop_pictureBrightness           265  /*  LONG              brightness setting                                  */
//STRIP001 #define ESCHER_Prop_pictureGamma                266  /*  LONG              16.16 gamma                                         */
//STRIP001 #define ESCHER_Prop_pictureId                   267  /*  LONG              Host-defined ID for OLE objects (usually a pointer) */
//STRIP001 #define ESCHER_Prop_pictureDblCrMod             268  /*  MSOCLR            Modification used if shape has double shadow        */
//STRIP001 #define ESCHER_Prop_pictureFillCrMod            269  /*  MSOCLR                                                                */
//STRIP001 #define ESCHER_Prop_pictureLineCrMod            270  /*  MSOCLR                                                                */
//STRIP001 #define ESCHER_Prop_pibPrint                    271  /*  IMsoBlip*         Blip to display when printing                       */
//STRIP001 #define ESCHER_Prop_pibPrintName                272  /*  WCHAR*            Blip file name                                      */
//STRIP001 #define ESCHER_Prop_pibPrintFlags               273  /*  MSOBLIPFLAGS      Blip flags                                          */
//STRIP001 #define ESCHER_Prop_fNoHitTestPicture           316  /*  BOOL              Do not hit test the picture                         */
//STRIP001 #define ESCHER_Prop_pictureGray                 317  /*  BOOL              grayscale display                                   */
//STRIP001 #define ESCHER_Prop_pictureBiLevel              318  /*  BOOL              bi-level display                                    */
//STRIP001 #define ESCHER_Prop_pictureActive               319  /*  BOOL              Server is active (OLE objects only)                 */
//STRIP001 // Geometry
//STRIP001 #define ESCHER_Prop_geoLeft                     320  /*  LONG              Defines the G (geometry) coordinate space.  */
//STRIP001 #define ESCHER_Prop_geoTop                      321  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_geoRight                    322  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_geoBottom                   323  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_shapePath                   324  /*  MSOSHAPEPATH                                                  */
//STRIP001 #define ESCHER_Prop_pVertices                   325  /*  IMsoArray         An array of points, in G units.             */
//STRIP001 #define ESCHER_Prop_pSegmentInfo                326  /*  IMsoArray                                                     */
//STRIP001 #define ESCHER_Prop_adjustValue                 327  /*  LONG              Adjustment values corresponding to          */
//STRIP001 #define ESCHER_Prop_adjust2Value                328  /*  LONG                the positions of the adjust handles       */
//STRIP001 #define ESCHER_Prop_adjust3Value                329  /*  LONG                of the shape. The number of values        */
//STRIP001 #define ESCHER_Prop_adjust4Value                330  /*  LONG                used and their allowable ranges vary      */
//STRIP001 #define ESCHER_Prop_adjust5Value                331  /*  LONG                from shape type to shape type.            */
//STRIP001 #define ESCHER_Prop_adjust6Value                332  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_adjust7Value                333  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_adjust8Value                334  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_adjust9Value                335  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_adjust10Value               336  /*  LONG                                                          */
//STRIP001 #define ESCHER_Prop_fShadowOK                   378  /*  BOOL              Shadow may be set                           */
//STRIP001 #define ESCHER_Prop_f3DOK                       379  /*  BOOL              3D may be set                               */
//STRIP001 #define ESCHER_Prop_fLineOK                     380  /*  BOOL              Line style may be set                       */
//STRIP001 #define ESCHER_Prop_fGtextOK                    381  /*  BOOL              Text effect (WordArt) supported             */
//STRIP001 #define ESCHER_Prop_fFillShadeShapeOK           382  /*  BOOL                                                          */
//STRIP001 #define ESCHER_Prop_fFillOK                     383  /*  BOOL              OK to fill the shape through the UI or VBA? */
//STRIP001 // FillStyle
//STRIP001 #define ESCHER_Prop_fillType                    384  /*  ESCHER_FillStyle  Type of fill                                  */
//STRIP001 #define ESCHER_Prop_fillColor                   385  /*  MSOCLR            Foreground color                              */
//STRIP001 #define ESCHER_Prop_fillOpacity                 386  /*  LONG              Fixed 16.16                                   */
//STRIP001 #define ESCHER_Prop_fillBackColor               387  /*  MSOCLR            Background color                              */
//STRIP001 #define ESCHER_Prop_fillBackOpacity             388  /*  LONG              Shades only                                   */
//STRIP001 #define ESCHER_Prop_fillCrMod                   389  /*  MSOCLR            Modification for BW views                     */
//STRIP001 #define ESCHER_Prop_fillBlip                    390  /*  IMsoBlip*         Pattern/texture                               */
//STRIP001 #define ESCHER_Prop_fillBlipName                391  /*  WCHAR*            Blip file name                                */
//STRIP001 #define ESCHER_Prop_fillBlipFlags               392  /*  MSOBLIPFLAGS      Blip flags                                    */
//STRIP001 #define ESCHER_Prop_fillWidth                   393  /*  LONG              How big (A units) to make a metafile texture. */
//STRIP001 #define ESCHER_Prop_fillHeight                  394  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillAngle                   395  /*  LONG              Fade angle - degrees in 16.16                 */
//STRIP001 #define ESCHER_Prop_fillFocus                   396  /*  LONG              Linear shaded fill focus percent              */
//STRIP001 #define ESCHER_Prop_fillToLeft                  397  /*  LONG              Fraction 16.16                                */
//STRIP001 #define ESCHER_Prop_fillToTop                   398  /*  LONG              Fraction 16.16                                */
//STRIP001 #define ESCHER_Prop_fillToRight                 399  /*  LONG              Fraction 16.16                                */
//STRIP001 #define ESCHER_Prop_fillToBottom                400  /*  LONG              Fraction 16.16                                */
//STRIP001 #define ESCHER_Prop_fillRectLeft                401  /*  LONG              For shaded fills, use the specified rectangle */
//STRIP001 #define ESCHER_Prop_fillRectTop                 402  /*  LONG                instead of the shape's bounding rect to     */
//STRIP001 #define ESCHER_Prop_fillRectRight               403  /*  LONG                define how large the fade is going to be.   */
//STRIP001 #define ESCHER_Prop_fillRectBottom              404  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillDztype                  405  /*  MSODZTYPE                                                       */
//STRIP001 #define ESCHER_Prop_fillShadePreset             406  /*  LONG              Special shades                                */
//STRIP001 #define ESCHER_Prop_fillShadeColors             407  /*  IMsoArray         a preset array of colors                      */
//STRIP001 #define ESCHER_Prop_fillOriginX                 408  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillOriginY                 409  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillShapeOriginX            410  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillShapeOriginY            411  /*  LONG                                                            */
//STRIP001 #define ESCHER_Prop_fillShadeType               412  /*  MSOSHADETYPE      Type of shading, if a shaded (gradient) fill. */
//STRIP001 #define ESCHER_Prop_fFilled                     443  /*  BOOL              Is shape filled?                              */
//STRIP001 #define ESCHER_Prop_fHitTestFill                444  /*  BOOL              Should we hit test fill?                      */
//STRIP001 #define ESCHER_Prop_fillShape                   445  /*  BOOL              Register pattern on shape                     */
//STRIP001 #define ESCHER_Prop_fillUseRect                 446  /*  BOOL              Use the large rect?                           */
//STRIP001 #define ESCHER_Prop_fNoFillHitTest              447  /*  BOOL              Hit test a shape as though filled             */
//STRIP001 // LineStyle
//STRIP001 #define ESCHER_Prop_lineColor                   448  /*  MSOCLR            Color of line                              */
//STRIP001 #define ESCHER_Prop_lineOpacity                 449  /*  LONG              Not implemented                            */
//STRIP001 #define ESCHER_Prop_lineBackColor               450  /*  MSOCLR            Background color                           */
//STRIP001 #define ESCHER_Prop_lineCrMod                   451  /*  MSOCLR            Modification for BW views                  */
//STRIP001 #define ESCHER_Prop_lineType                    452  /*  MSOLINETYPE       Type of line                               */
//STRIP001 #define ESCHER_Prop_lineFillBlip                453  /*  IMsoBlip*         Pattern/texture                            */
//STRIP001 #define ESCHER_Prop_lineFillBlipName            454  /*  WCHAR*            Blip file name                             */
//STRIP001 #define ESCHER_Prop_lineFillBlipFlags           455  /*  MSOBLIPFLAGS      Blip flags                                 */
//STRIP001 #define ESCHER_Prop_lineFillWidth               456  /*  LONG              How big (A units) to make                  */
//STRIP001 #define ESCHER_Prop_lineFillHeight              457  /*  LONG                a metafile texture.                      */
//STRIP001 #define ESCHER_Prop_lineFillDztype              458  /*  MSODZTYPE         How to interpret fillWidth/Height numbers. */
//STRIP001 #define ESCHER_Prop_lineWidth                   459  /*  LONG              A units; 1pt == 12700 EMUs                 */
//STRIP001 #define ESCHER_Prop_lineMiterLimit              460  /*  LONG              ratio (16.16) of width                     */
//STRIP001 #define ESCHER_Prop_lineStyle                   461  /*  MSOLINESTYLE      Draw parallel lines?                       */
//STRIP001 #define ESCHER_Prop_lineDashing                 462  /*  MSOLINEDASHING    Can be overridden by:                      */
//STRIP001 #define ESCHER_Prop_lineDashStyle               463  /*  IMsoArray         As Win32 ExtCreatePen                      */
//STRIP001 #define ESCHER_Prop_lineStartArrowhead          464  /*  MSOLINEEND        Arrow at start                             */
//STRIP001 #define ESCHER_Prop_lineEndArrowhead            465  /*  MSOLINEEND        Arrow at end                               */
//STRIP001 #define ESCHER_Prop_lineStartArrowWidth         466  /*  MSOLINEENDWIDTH   Arrow at start                             */
//STRIP001 #define ESCHER_Prop_lineStartArrowLength        467  /*  MSOLINEENDLENGTH  Arrow at end                               */
//STRIP001 #define ESCHER_Prop_lineEndArrowWidth           468  /*  MSOLINEENDWIDTH   Arrow at start                             */
//STRIP001 #define ESCHER_Prop_lineEndArrowLength          469  /*  MSOLINEENDLENGTH  Arrow at end                               */
//STRIP001 #define ESCHER_Prop_lineJoinStyle               470  /*  MSOLINEJOIN       How to join lines                          */
//STRIP001 #define ESCHER_Prop_lineEndCapStyle             471  /*  MSOLINECAP        How to end lines                           */
//STRIP001 #define ESCHER_Prop_fArrowheadsOK               507  /*  BOOL              Allow arrowheads if prop. is set           */
//STRIP001 #define ESCHER_Prop_fLine                       508  /*  BOOL              Any line?                                  */
//STRIP001 #define ESCHER_Prop_fHitTestLine                509  /*  BOOL              Should we hit test lines?                  */
//STRIP001 #define ESCHER_Prop_lineFillShape               510  /*  BOOL              Register pattern on shape                  */
//STRIP001 #define ESCHER_Prop_fNoLineDrawDash             511  /*  BOOL              Draw a dashed line if no line              */
//STRIP001 // ShadowStyle
//STRIP001 #define ESCHER_Prop_shadowType                  512  /*  MSOSHADOWTYPE     Type of effect            */
//STRIP001 #define ESCHER_Prop_shadowColor                 513  /*  MSOCLR            Foreground color          */
//STRIP001 #define ESCHER_Prop_shadowHighlight             514  /*  MSOCLR            Embossed color            */
//STRIP001 #define ESCHER_Prop_shadowCrMod                 515  /*  MSOCLR            Modification for BW views */
//STRIP001 #define ESCHER_Prop_shadowOpacity               516  /*  LONG              Fixed 16.16               */
//STRIP001 #define ESCHER_Prop_shadowOffsetX               517  /*  LONG              Offset shadow             */
//STRIP001 #define ESCHER_Prop_shadowOffsetY               518  /*  LONG              Offset shadow             */
//STRIP001 #define ESCHER_Prop_shadowSecondOffsetX         519  /*  LONG              Double offset shadow      */
//STRIP001 #define ESCHER_Prop_shadowSecondOffsetY         520  /*  LONG              Double offset shadow      */
//STRIP001 #define ESCHER_Prop_shadowScaleXToX             521  /*  LONG              16.16                     */
//STRIP001 #define ESCHER_Prop_shadowScaleYToX             522  /*  LONG              16.16                     */
//STRIP001 #define ESCHER_Prop_shadowScaleXToY             523  /*  LONG              16.16                     */
//STRIP001 #define ESCHER_Prop_shadowScaleYToY             524  /*  LONG              16.16                     */
//STRIP001 #define ESCHER_Prop_shadowPerspectiveX          525  /*  LONG              16.16 / weight            */
//STRIP001 #define ESCHER_Prop_shadowPerspectiveY          526  /*  LONG              16.16 / weight            */
//STRIP001 #define ESCHER_Prop_shadowWeight                527  /*  LONG              scaling factor            */
//STRIP001 #define ESCHER_Prop_shadowOriginX               528  /*  LONG                                        */
//STRIP001 #define ESCHER_Prop_shadowOriginY               529  /*  LONG                                        */
//STRIP001 #define ESCHER_Prop_fShadow                     574  /*  BOOL              Any shadow?               */
//STRIP001 #define ESCHER_Prop_fshadowObscured             575  /*  BOOL              Excel5-style shadow       */
//STRIP001 // PerspectiveStyle
//STRIP001 #define ESCHER_Prop_perspectiveType             576  /*  MSOXFORMTYPE      Where transform applies        */
//STRIP001 #define ESCHER_Prop_perspectiveOffsetX          577  /*  LONG              The LONG values define a       */
//STRIP001 #define ESCHER_Prop_perspectiveOffsetY          578  /*  LONG                transformation matrix,       */
//STRIP001 #define ESCHER_Prop_perspectiveScaleXToX        579  /*  LONG                effectively, each value      */
//STRIP001 #define ESCHER_Prop_perspectiveScaleYToX        580  /*  LONG                is scaled by the             */
//STRIP001 #define ESCHER_Prop_perspectiveScaleXToY        581  /*  LONG                perspectiveWeight parameter. */
//STRIP001 #define ESCHER_Prop_perspectiveScaleYToY        582  /*  LONG                                             */
//STRIP001 #define ESCHER_Prop_perspectivePerspectiveX     583  /*  LONG                                             */
//STRIP001 #define ESCHER_Prop_perspectivePerspectiveY     584  /*  LONG                                             */
//STRIP001 #define ESCHER_Prop_perspectiveWeight           585  /*  LONG              Scaling factor                 */
//STRIP001 #define ESCHER_Prop_perspectiveOriginX          586  /*  LONG                                             */
//STRIP001 #define ESCHER_Prop_perspectiveOriginY          587  /*  LONG                                             */
//STRIP001 #define ESCHER_Prop_fPerspective                639  /*  BOOL              On/off                         */
//STRIP001 // 3D Object
//STRIP001 #define ESCHER_Prop_c3DSpecularAmt              640  /*  LONG         Fixed-point 16.16                                                                                                   */
//STRIP001 #define ESCHER_Prop_c3DDiffuseAmt               641  /*  LONG         Fixed-point 16.16                                                                                                   */
//STRIP001 #define ESCHER_Prop_c3DShininess                642  /*  LONG         Default gives OK results                                                                                            */
//STRIP001 #define ESCHER_Prop_c3DEdgeThickness            643  /*  LONG         Specular edge thickness                                                                                             */
//STRIP001 #define ESCHER_Prop_c3DExtrudeForward           644  /*  LONG         Distance of extrusion in EMUs                                                                                       */
//STRIP001 #define ESCHER_Prop_c3DExtrudeBackward          645  /*  LONG                                                                                                                             */
//STRIP001 #define ESCHER_Prop_c3DExtrudePlane             646  /*  LONG         Extrusion direction                                                                                                 */
//STRIP001 #define ESCHER_Prop_c3DExtrusionColor           647  /*  MSOCLR       Basic color of extruded part of shape; the lighting model used will determine the exact shades used when rendering. */
//STRIP001 #define ESCHER_Prop_c3DCrMod                    648  /*  MSOCLR       Modification for BW views                                                                                           */
//STRIP001 #define ESCHER_Prop_f3D                         700  /*  BOOL         Does this shape have a 3D effect?                                                                                   */
//STRIP001 #define ESCHER_Prop_fc3DMetallic                701  /*  BOOL         Use metallic specularity?                                                                                           */
//STRIP001 #define ESCHER_Prop_fc3DUseExtrusionColor       702  /*  BOOL                                                                                                                             */
//STRIP001 #define ESCHER_Prop_fc3DLightFace               703  /*  BOOL                                                                                                                             */
//STRIP001 // 3D Style
//STRIP001 #define ESCHER_Prop_c3DYRotationAngle           704  /*  LONG            degrees (16.16) about y axis         */
//STRIP001 #define ESCHER_Prop_c3DXRotationAngle           705  /*  LONG            degrees (16.16) about x axis         */
//STRIP001 #define ESCHER_Prop_c3DRotationAxisX            706  /*  LONG            These specify the rotation axis;     */
//STRIP001 #define ESCHER_Prop_c3DRotationAxisY            707  /*  LONG              only their relative magnitudes     */
//STRIP001 #define ESCHER_Prop_c3DRotationAxisZ            708  /*  LONG              matter.                            */
//STRIP001 #define ESCHER_Prop_c3DRotationAngle            709  /*  LONG            degrees (16.16) about axis           */
//STRIP001 #define ESCHER_Prop_c3DRotationCenterX          710  /*  LONG            rotation center x (16.16 or g-units) */
//STRIP001 #define ESCHER_Prop_c3DRotationCenterY          711  /*  LONG            rotation center y (16.16 or g-units) */
//STRIP001 #define ESCHER_Prop_c3DRotationCenterZ          712  /*  LONG            rotation center z (absolute (emus))  */
//STRIP001 #define ESCHER_Prop_c3DRenderMode               713  /*  MSO3DRENDERMODE Full,wireframe, or bcube             */
//STRIP001 #define ESCHER_Prop_c3DTolerance                714  /*  LONG            pixels (16.16)                       */
//STRIP001 #define ESCHER_Prop_c3DXViewpoint               715  /*  LONG            X view point (emus)                  */
//STRIP001 #define ESCHER_Prop_c3DYViewpoint               716  /*  LONG            Y view point (emus)                  */
//STRIP001 #define ESCHER_Prop_c3DZViewpoint               717  /*  LONG            Z view distance (emus)               */
//STRIP001 #define ESCHER_Prop_c3DOriginX                  718  /*  LONG                                                 */
//STRIP001 #define ESCHER_Prop_c3DOriginY                  719  /*  LONG                                                 */
//STRIP001 #define ESCHER_Prop_c3DSkewAngle                720  /*  LONG            degree (16.16) skew angle            */
//STRIP001 #define ESCHER_Prop_c3DSkewAmount               721  /*  LONG            Percentage skew amount               */
//STRIP001 #define ESCHER_Prop_c3DAmbientIntensity         722  /*  LONG            Fixed point intensity                */
//STRIP001 #define ESCHER_Prop_c3DKeyX                     723  /*  LONG            Key light source direc-              */
//STRIP001 #define ESCHER_Prop_c3DKeyY                     724  /*  LONG            tion; only their relative            */
//STRIP001 #define ESCHER_Prop_c3DKeyZ                     725  /*  LONG            magnitudes matter                    */
//STRIP001 #define ESCHER_Prop_c3DKeyIntensity             726  /*  LONG            Fixed point intensity                */
//STRIP001 #define ESCHER_Prop_c3DFillX                    727  /*  LONG            Fill light source direc-             */
//STRIP001 #define ESCHER_Prop_c3DFillY                    728  /*  LONG            tion; only their relative            */
//STRIP001 #define ESCHER_Prop_c3DFillZ                    729  /*  LONG            magnitudes matter                    */
//STRIP001 #define ESCHER_Prop_c3DFillIntensity            730  /*  LONG            Fixed point intensity                */
//STRIP001 #define ESCHER_Prop_fc3DConstrainRotation       763  /*  BOOL                                                 */
//STRIP001 #define ESCHER_Prop_fc3DRotationCenterAuto      764  /*  BOOL                                                 */
//STRIP001 #define ESCHER_Prop_fc3DParallel                765  /*  BOOL            Parallel projection?                 */
//STRIP001 #define ESCHER_Prop_fc3DKeyHarsh                766  /*  BOOL            Is key lighting harsh?               */
//STRIP001 #define ESCHER_Prop_fc3DFillHarsh               767  /*  BOOL            Is fill lighting harsh?              */
//STRIP001 // Shape
//STRIP001 #define ESCHER_Prop_hspMaster                   769  /*  MSOHSP          master shape                                        */
//STRIP001 #define ESCHER_Prop_cxstyle                     771  /*  MSOCXSTYLE      Type of connector                                   */
//STRIP001 #define ESCHER_Prop_bWMode                      772  /*  ESCHERwMode     Settings for modifications to                       */
//STRIP001 #define ESCHER_Prop_bWModePureBW                773  /*  ESCHERwMode	 be made when in different                         */
//STRIP001 #define ESCHER_Prop_bWModeBW                    774  /*  ESCHERwMode	 forms of black-and-white mode.                    */
//STRIP001 #define ESCHER_Prop_fOleIcon                    826  /*  BOOL            For OLE objects, whether the object is in icon form */
//STRIP001 #define ESCHER_Prop_fPreferRelativeResize       827  /*  BOOL            For UI only. Prefer relative resizing.              */
//STRIP001 #define ESCHER_Prop_fLockShapeType              828  /*  BOOL            Lock the shape type (don't allow Change Shape)      */
//STRIP001 #define ESCHER_Prop_fDeleteAttachedObject       830  /*  BOOL                                                                */
//STRIP001 #define ESCHER_Prop_fBackground                 831  /*  BOOL            If TRUE, this is the background shape.              */
//STRIP001 // Callout
//STRIP001 #define ESCHER_Prop_spcot                       832  /*  MSOSPCOT        Callout type                                           */
//STRIP001 #define ESCHER_Prop_dxyCalloutGap               833  /*  LONG            Distance from box to first point.(EMUs)                */
//STRIP001 #define ESCHER_Prop_spcoa                       834  /*  MSOSPCOA        Callout angle                                          */
//STRIP001 #define ESCHER_Prop_spcod                       835  /*  MSOSPCOD        Callout drop type                                      */
//STRIP001 #define ESCHER_Prop_dxyCalloutDropSpecified     836  /*  LONG            if msospcodSpecified, the actual drop distance         */
//STRIP001 #define ESCHER_Prop_dxyCalloutLengthSpecified   837  /*  LONG            if fCalloutLengthSpecified, the actual distance        */
//STRIP001 #define ESCHER_Prop_fCallout                    889  /*  BOOL            Is the shape a callout?                                */
//STRIP001 #define ESCHER_Prop_fCalloutAccentBar           890  /*  BOOL            does callout have accent bar                           */
//STRIP001 #define ESCHER_Prop_fCalloutTextBorder          891  /*  BOOL            does callout have a text border                        */
//STRIP001 #define ESCHER_Prop_fCalloutMinusX              892  /*  BOOL                                                                   */
//STRIP001 #define ESCHER_Prop_fCalloutMinusY              893  /*  BOOL                                                                   */
//STRIP001 #define ESCHER_Prop_fCalloutDropAuto            894  /*  BOOL            If true, then we occasionally invert the drop distance */
//STRIP001 #define ESCHER_Prop_fCalloutLengthSpecified     895  /*  BOOL            if true, we look at dxyCalloutLengthSpecified          */
//STRIP001 // GroupShape
//STRIP001 #define ESCHER_Prop_wzName                      896  /*  WCHAR*          Shape Name (present only if explicitly set)                                                            */
//STRIP001 #define ESCHER_Prop_wzDescription               897  /*  WCHAR*          alternate text                                                                                         */
//STRIP001 #define ESCHER_Prop_pihlShape                   898  /*  IHlink*         The hyperlink in the shape.                                                                            */
//STRIP001 #define ESCHER_Prop_pWrapPolygonVertices        899  /*  IMsoArray       The polygon that text will be wrapped around (Word)                                                    */
//STRIP001 #define ESCHER_Prop_dxWrapDistLeft              900  /*  LONG            Left wrapping distance from text (Word)                                                                */
//STRIP001 #define ESCHER_Prop_dyWrapDistTop               901  /*  LONG            Top wrapping distance from text (Word)                                                                 */
//STRIP001 #define ESCHER_Prop_dxWrapDistRight             902  /*  LONG            Right wrapping distance from text (Word)                                                               */
//STRIP001 #define ESCHER_Prop_dyWrapDistBottom            903  /*  LONG            Bottom wrapping distance from text (Word)                                                              */
//STRIP001 #define ESCHER_Prop_lidRegroup                  904  /*  LONG            Regroup ID                                                                                             */
//STRIP001 #define ESCHER_Prop_fEditedWrap                 953  /*  BOOL            Has the wrap polygon been edited?                                                                      */
//STRIP001 #define ESCHER_Prop_fBehindDocument             954  /*  BOOL            Word-only (shape is behind text)                                                                       */
//STRIP001 #define ESCHER_Prop_fOnDblClickNotify           955  /*  BOOL            Notify client on a double click                                                                        */
//STRIP001 #define ESCHER_Prop_fIsButton                   956  /*  BOOL            A button shape (i.e., clicking performs an action). Set for shapes with attached hyperlinks or macros. */
//STRIP001 #define ESCHER_Prop_fOneD                       957  /*  BOOL            1D adjustment                                                                                          */
//STRIP001 #define ESCHER_Prop_fHidden                     958  /*  BOOL            Do not display                                                                                         */
//STRIP001 #define ESCHER_Prop_fPrint                      959  /*  BOOL            Print this shape                                                                                       */
//STRIP001 
//STRIP001 #define ESCHER_PERSISTENTRY_PREALLOCATE		64
//STRIP001 
//STRIP001 #define ESCHER_Persist_PrivateEntry			0x80000000
//STRIP001 #define ESCHER_Persist_Dgg					0x00010000
//STRIP001 #define ESCHER_Persist_Dgg_FIDCL			0x00010001
//STRIP001 #define ESCHER_Persist_Dg					0x00020000
//STRIP001 #define ESCHER_Persist_BlibStoreContainer	0x00030000
//STRIP001 #define ESCHER_Persist_CurrentPosition		0x00040000
//STRIP001 #define ESCHER_Persist_Grouping_Snap		0x00050000
//STRIP001 #define ESCHER_Persist_Grouping_Logic		0x00060000

// ---------------------------------------------------------------------------------------------

namespace com { namespace sun { namespace star {
	namespace awt {
		struct Gradient;
	}
	namespace drawing {
		class XShape;
	}
}}}

//STRIP001 struct EscherPropertyValueHelper
//STRIP001 {
//STRIP001 		static sal_Bool GetPropertyValue(
//STRIP001 				::com::sun::star::uno::Any& rAny,
//STRIP001 					const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > &,
//STRIP001 						const String& rPropertyName,
//STRIP001 							sal_Bool bTestPropertyAvailability = sal_False );
//STRIP001 
//STRIP001 		static ::com::sun::star::beans::PropertyState GetPropertyState(
//STRIP001 					const ::com::sun::star::uno::Reference < ::com::sun::star::beans::XPropertySet > &,
//STRIP001 						const String& rPropertyName );
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 struct EscherPersistEntry
//STRIP001 {
//STRIP001 	UINT32	mnID;
//STRIP001 	UINT32	mnOffset;
//STRIP001 			EscherPersistEntry( UINT32 nId, UINT32 nOffset ) { mnID = nId; mnOffset = nOffset; };
//STRIP001 
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 class SvMemoryStream;
//STRIP001 class EscherBlibEntry
//STRIP001 {
//STRIP001 
//STRIP001 		friend class EscherGraphicProvider;
//STRIP001 		friend class EscherEx;
//STRIP001 		friend class _EscherEx;
//STRIP001 
//STRIP001 	protected:
//STRIP001 
//STRIP001 		UINT32			mnIdentifier[ 4 ];
//STRIP001 		UINT32			mnPictureOffset;		// offset auf die grafik im PictureStreams
//STRIP001 		UINT32			mnSize;					// size of real graphic
//STRIP001 
//STRIP001 		UINT32			mnRefCount;				// !! reference count
//STRIP001 		UINT32			mnSizeExtra;			// !! size of preceding header
//STRIP001 
//STRIP001 		ESCHER_BlibType	meBlibType;
//STRIP001 
//STRIP001 		sal_Bool		mbIsEmpty;
//STRIP001 		sal_Bool		mbIsNativeGraphicPossible;
//STRIP001 
//STRIP001 		Size			maPrefSize;
//STRIP001 		MapMode			maPrefMapMode;
//STRIP001 
//STRIP001 	public:
//STRIP001 
//STRIP001 						EscherBlibEntry( sal_uInt32 nPictureOffset, const GraphicObject& rObj,
//STRIP001 												const ByteString& rId, const GraphicAttr* pAttr = NULL );
//STRIP001 
//STRIP001 						~EscherBlibEntry();
//STRIP001 
//STRIP001 		void			WriteBlibEntry( SvStream& rSt, sal_Bool bWritePictureOffset, sal_uInt32 nResize = 0 );
//STRIP001 		sal_Bool		IsEmpty() const { return mbIsEmpty; };
//STRIP001 
//STRIP001 		BOOL			operator==( const EscherBlibEntry& ) const;
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 #define _E_GRAPH_PROV_USE_INSTANCES				1
//STRIP001 #define _E_GRAPH_PROV_DO_NOT_ROTATE_METAFILES	2

//STRIP001 class EscherGraphicProvider
//STRIP001 {
//STRIP001 		sal_uInt32				mnFlags;
//STRIP001 
//STRIP001 		EscherBlibEntry**		mpBlibEntrys;
//STRIP001 		sal_uInt32				mnBlibBufSize;
//STRIP001 		sal_uInt32				mnBlibEntrys;
//STRIP001 
//STRIP001 	protected :
//STRIP001 
//STRIP001 		UINT32					ImplInsertBlib( EscherBlibEntry* p_EscherBlibEntry );
//STRIP001 
//STRIP001 	public :
//STRIP001 
//STRIP001 		sal_uInt32	GetBlibStoreContainerSize( SvStream* pMergePicStreamBSE = NULL ) const;
//STRIP001 		void		WriteBlibStoreContainer( SvStream& rStrm, SvStream* pMergePicStreamBSE = NULL  );
//STRIP001 		sal_Bool WriteBlibStoreEntry(SvStream& rStrm, sal_uInt32 nBlipId,
//STRIP001             sal_Bool bWritePictureOffset, sal_uInt32 nResize = 0);
//STRIP001 		sal_uInt32	GetBlibID( SvStream& rPicOutStream, const ByteString& rGraphicId, const Rectangle& rBoundRect,
//STRIP001 								const GraphicAttr* pGrafikAttr = NULL );
//STRIP001 		sal_Bool	HasGraphics() const { return mnBlibEntrys != 0; };
//STRIP001 
//STRIP001 		void		SetNewBlipStreamOffset( sal_Int32 nOffset );
//STRIP001 
//STRIP001 		sal_Bool	GetPrefSize( const sal_uInt32 nBlibId, Size& rSize, MapMode& rMapMode );
//STRIP001 
//STRIP001 		EscherGraphicProvider( sal_uInt32 nFlags = _E_GRAPH_PROV_DO_NOT_ROTATE_METAFILES );
//STRIP001 		~EscherGraphicProvider();
//STRIP001 
//STRIP001 };

//STRIP001 class EscherSolverContainer
//STRIP001 {
//STRIP001 	List				maShapeList;
//STRIP001 	List				maConnectorList;
//STRIP001 
//STRIP001 	sal_uInt32			ImplGetId( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rShape );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 	void				AddShape( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > &, sal_uInt32 nId );
//STRIP001 	void				AddConnector( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > &,
//STRIP001 										const ::com::sun::star::awt::Point& rA,
//STRIP001 									::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > &,
//STRIP001 										const ::com::sun::star::awt::Point& rB,
//STRIP001 									::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rConB );
//STRIP001 
//STRIP001 	void				WriteSolver( SvStream& );
//STRIP001 
//STRIP001 						EscherSolverContainer(){};
//STRIP001 						~EscherSolverContainer();
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 #define ESCHER_CREATEPOLYGON_LINE			1
//STRIP001 #define ESCHER_CREATEPOLYGON_POLYLINE		2
//STRIP001 #define ESCHER_CREATEPOLYGON_POLYPOLYGON	4

//STRIP001 struct EscherPropSortStruct;
//STRIP001 class GraphicAttr;
//STRIP001 class EscherPropertyContainer
//STRIP001 {
//STRIP001 		sal_uInt32				nSortCount;
//STRIP001 		sal_uInt32				nSortBufSize;
//STRIP001 		EscherPropSortStruct*	pSortStruct;
//STRIP001 		sal_uInt32				nCountCount;
//STRIP001 		sal_uInt32				nCountSize;
//STRIP001 		sal_Bool				bHasComplexData;
//STRIP001 		sal_Bool				bSuppressRotation;
//STRIP001 
//STRIP001 		EscherGraphicProvider*	pGraphicProvider;
//STRIP001 		Rectangle*				pShapeBoundRect;
//STRIP001 		SvStream*				pPicOutStrm;
//STRIP001 
//STRIP001 		sal_uInt32	ImplGetColor( const sal_uInt32 rColor, sal_Bool bSwap = sal_True );
//STRIP001 		void		ImplCreateGraphicAttributes( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 													sal_uInt32 nBlibId, sal_Bool bCreateCroppingAttributes );
//STRIP001 		void		ImplInit();
//STRIP001 
//STRIP001 	public :
//STRIP001 
//STRIP001 		EscherPropertyContainer();
//STRIP001 		EscherPropertyContainer(
//STRIP001 			EscherGraphicProvider& rGraphicProvider,	// the PropertyContainer needs to know
//STRIP001 					SvStream* pPicOutStrm,				// the GraphicProvider to be able to write
//STRIP001 						Rectangle& rShapeBoundRect );	// FillBitmaps or GraphicObjects.
//STRIP001 														// under some cirumstances the ShapeBoundRect is adjusted
//STRIP001 														// this will happen when rotated GraphicObjects
//STRIP001 														// are saved to PowerPoint
//STRIP001 		~EscherPropertyContainer();
//STRIP001 
//STRIP001 		void		AddOpt( sal_uInt16 nPropertyID, sal_uInt32 nPropValue,
//STRIP001 							sal_Bool bBlib = sal_False );
//STRIP001 
//STRIP001 		void		AddOpt( sal_uInt16 nPropertyID, sal_Bool bBlib, sal_uInt32 nPropValue,
//STRIP001 							sal_uInt8* pProp, sal_uInt32 nPropSize );
//STRIP001 
//STRIP001 		sal_Bool	GetOpt( sal_uInt16 nPropertyID, sal_uInt32& rPropValue ) const;
//STRIP001 
//STRIP001 		void		Commit( SvStream& rSt, sal_uInt16 nVersion = 3 );
//STRIP001 
//STRIP001 					// the GraphicProperties will only be created if a GraphicProvider and PicOutStrm is known
//STRIP001                     // DR: #99897# if no GraphicProvider is present, a complex ESCHER_Prop_fillBlip
//STRIP001                     //             will be created, containing the BLIP directly (i.e. for Excel charts).
//STRIP001 		sal_Bool	CreateGraphicProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 						const String& rSource, sal_Bool bFillBitmap, sal_Bool bCreateCroppingAttributes = sal_False );
//STRIP001 
//STRIP001 		sal_Bool	CreatePolygonProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 						sal_uInt32 nFlags, sal_Bool bBezier, ::com::sun::star::awt::Rectangle& rGeoRect, Polygon* pPolygon = NULL );
//STRIP001 
//STRIP001 		static sal_uInt32 GetGradientColor( const ::com::sun::star::awt::Gradient* pGradient, sal_uInt32 nStartColor );
//STRIP001 		void		CreateGradientProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & );
//STRIP001 		void		CreateFillProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > &, sal_Bool bEdge );
//STRIP001 		void		CreateLineProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > &, sal_Bool bEdge );
//STRIP001 
//STRIP001 		sal_Bool	CreateConnectorProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape,
//STRIP001 												EscherSolverContainer& rSolver, ::com::sun::star::awt::Rectangle& rGeoRect,
//STRIP001 													sal_uInt16& rShapeType, sal_uInt16& rShapeFlags );
//STRIP001 
//STRIP001 					// Because shadow properties depends to the line and fillstyle, the CreateShadowProperties method should be called at last.
//STRIP001 					// It activ only when at least a FillStyle or LineStyle is set.
//STRIP001 		sal_Bool	CreateShadowProperties( const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & );
//STRIP001 
//STRIP001 
//STRIP001         // helper functions which are also used by the escher import
//STRIP001         static PolyPolygon GetPolyPolygon( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape > & rXShape );
//STRIP001 		static PolyPolygon GetPolyPolygon( const ::com::sun::star::uno::Any& rSource );
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 class EscherPersistTable
//STRIP001 {
//STRIP001 
//STRIP001 	public:
//STRIP001 		List	maPersistTable;
//STRIP001 
//STRIP001 		BOOL	PtIsID( UINT32 nID );
//STRIP001 		void	PtInsert( UINT32 nID, UINT32 nOfs );
//STRIP001 		UINT32	PtDelete( UINT32 nID );
//STRIP001 		UINT32	PtGetOffsetByID( UINT32 nID );
//STRIP001 		UINT32	PtReplace( UINT32 nID, UINT32 nOfs );
//STRIP001 		UINT32	PtReplaceOrInsert( UINT32 nID, UINT32 nOfs );
//STRIP001 		UINT32	PtGetCount() const { return maPersistTable.Count(); };
//STRIP001 
//STRIP001 				EscherPersistTable();
//STRIP001 		virtual	~EscherPersistTable();
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 class EscherEx;

/// abstract base class for ESCHER_ClientTextbox, ESCHER_ClientData
//STRIP001 class EscherExClientRecord_Base
//STRIP001 {
//STRIP001 public:
//STRIP001 								EscherExClientRecord_Base() {}
//STRIP001 	virtual						~EscherExClientRecord_Base();
//STRIP001 
//STRIP001 								/// Application writes the record header
//STRIP001 								/// using rEx.AddAtom(...) followed by
//STRIP001 								/// record data written to rEx.GetStream()
//STRIP001 	virtual	void				WriteData( EscherEx& rEx ) const = 0;
//STRIP001 };

/// abstract base class for ESCHER_ClientAnchor
//STRIP001 class EscherExClientAnchor_Base
//STRIP001 {
//STRIP001 public:
//STRIP001 								EscherExClientAnchor_Base() {}
//STRIP001 	virtual						~EscherExClientAnchor_Base();
//STRIP001 
//STRIP001 								/// Application writes the record header
//STRIP001 								/// using rEx.AddAtom(...) followed by
//STRIP001 								/// record data written to rEx.GetStream()
//STRIP001 	virtual	void				WriteData( EscherEx& rEx,
//STRIP001 									const Rectangle& rRect ) = 0;
//STRIP001 };

//STRIP001 class EscherExHostAppData
//STRIP001 {
//STRIP001 private:
//STRIP001 		EscherExClientAnchor_Base*	pClientAnchor;
//STRIP001 		EscherExClientRecord_Base*	pClientData;
//STRIP001 		EscherExClientRecord_Base*	pClientTextbox;
//STRIP001 		// ignore single shape if entire pages are written
//STRIP001 		BOOL						bDontWriteShape;
//STRIP001 
//STRIP001 public:
//STRIP001 		EscherExHostAppData() : pClientAnchor(0), pClientData(0),
//STRIP001 								pClientTextbox(0), bDontWriteShape(FALSE)
//STRIP001 		{}
//STRIP001 
//STRIP001 		void SetClientAnchor( EscherExClientAnchor_Base* p )
//STRIP001 			{ pClientAnchor = p; }
//STRIP001 		void SetClientData( EscherExClientRecord_Base* p )
//STRIP001 			{ pClientData = p; }
//STRIP001 		void SetClientTextbox( EscherExClientRecord_Base* p )
//STRIP001 			{ pClientTextbox = p; }
//STRIP001 		void SetDontWriteShape( BOOL b )
//STRIP001 			{ bDontWriteShape = b; }
//STRIP001 		EscherExClientAnchor_Base* GetClientAnchor() const
//STRIP001 			{ return pClientAnchor; }
//STRIP001 		EscherExClientRecord_Base* GetClientData() const
//STRIP001 			{ return pClientData; }
//STRIP001 		EscherExClientRecord_Base* GetClientTextbox() const
//STRIP001 			{ return pClientTextbox; }
//STRIP001 
//STRIP001 		void WriteClientAnchor( EscherEx& rEx, const Rectangle& rRect )
//STRIP001 			{ if( pClientAnchor ) 	pClientAnchor->WriteData( rEx, rRect ); }
//STRIP001 		void WriteClientData( EscherEx& rEx )
//STRIP001 			{ if( pClientData ) 	pClientData->WriteData( rEx ); }
//STRIP001 		void WriteClientTextbox( EscherEx& rEx )
//STRIP001 			{ if( pClientTextbox ) 	pClientTextbox->WriteData( rEx ); }
//STRIP001 
//STRIP001 		BOOL DontWriteShape() const { return bDontWriteShape; }
//STRIP001 };

// ---------------------------------------------------------------------------------------------

//STRIP001 class SdrObject;
//STRIP001 class SdrPage;
//STRIP001 class ImplEscherExSdr;
//STRIP001 class Color;

//STRIP001 class Graphic;
//STRIP001 class SvMemoryStream;

//STRIP001 class EscherEx : public EscherPersistTable, public EscherGraphicProvider
//STRIP001 {
//STRIP001 	protected :
//STRIP001 
//STRIP001 		SvStream*				mpOutStrm;
//STRIP001 		ImplEscherExSdr*		mpImplEscherExSdr;
//STRIP001 		UINT32					mnStrmStartOfs;
//STRIP001 		int						mnLevel;
//STRIP001 		UINT32*					mpOffsets;
//STRIP001 		UINT16*					mpRecTypes;					// nimmt die Container RecTypes auf
//STRIP001 
//STRIP001 		UINT32					mnDrawings;
//STRIP001 		UINT32					mnFIDCLs;					// anzahl der cluster ID's
//STRIP001 
//STRIP001 		UINT32					mnCurrentDg;
//STRIP001 		UINT32					mnCurrentShapeID;			// die naechste freie ID
//STRIP001 		UINT32					mnCurrentShapeMaximumID;	// die hoechste und auch benutzte ID
//STRIP001 		UINT32					mnTotalShapesDg;			// anzahl der shapes im Dg
//STRIP001 		UINT32					mnTotalShapeIdUsedDg;		// anzahl der benutzten shape Id's im Dg
//STRIP001 		UINT32					mnTotalShapesDgg;			// anzahl der shapes im Dgg
//STRIP001 		UINT32					mnCountOfs;
//STRIP001 
//STRIP001 		UINT32					mnGroupLevel;
//STRIP001 		UINT16					mnHellLayerId;
//STRIP001 
//STRIP001 		BOOL					mbEscherSpgr;
//STRIP001 		BOOL					mbEscherDgg;
//STRIP001 		BOOL					mbEscherDg;
//STRIP001 		BOOL					mbOleEmf;					// OLE is EMF instead of WMF
//STRIP001 
//STRIP001 
//STRIP001 		BOOL	DoSeek( UINT32 nKey );
//STRIP001 
//STRIP001 	public:
//STRIP001 
//STRIP001 				EscherEx( SvStream& rOut, UINT32 nDrawings );
//STRIP001 
//STRIP001 				/// Fuegt in den EscherStream interne Daten ein, dieser Vorgang
//STRIP001 				/// darf und muss nur einmal ausgefuehrt werden.
//STRIP001 				/// Wenn pPicStreamMergeBSE angegeben ist, werden die BLIPs
//STRIP001 				/// aus diesem Stream in die MsofbtBSE Records des EscherStream
//STRIP001 				/// gemerged, wie es fuer Excel (und Word?) benoetigt wird.
//STRIP001 		void	Flush( SvStream* pPicStreamMergeBSE = NULL );
//STRIP001 
//STRIP001 	virtual		~EscherEx();
//STRIP001 
//STRIP001 				// Application may overload this function to maintain an offset
//STRIP001 				// table for specific regions but MUST call this function too.
//STRIP001 	virtual void	InsertAtCurrentPos( UINT32 nBytes, BOOL bCont = FALSE );// es werden nBytes an der aktuellen Stream Position eingefuegt,
//STRIP001 																	// die PersistantTable und interne Zeiger angepasst
//STRIP001 
//STRIP001 		void	InsertPersistOffset( UINT32 nKey, UINT32 nOffset );	// Es wird nicht geprueft, ob sich jener schluessel schon in der PersistantTable befindet
//STRIP001 		BOOL	SeekToPersistOffset( UINT32 nKey );
//STRIP001 		BOOL	InsertAtPersistOffset( UINT32 nKey, UINT32 nValue );// nValue wird im Stream an entrsprechender Stelle eingefuegt(overwrite modus), ohne dass sich die
//STRIP001 																	// aktuelle StreamPosition aendert
//STRIP001 
//STRIP001 		SvStream&	GetStream() const	{ return *mpOutStrm; }
//STRIP001 		ULONG	GetStreamPos() const	{ return mpOutStrm->Tell(); }
//STRIP001 
//STRIP001 		BOOL	SeekBehindRecHeader( UINT16 nRecType );				// der stream muss vor einem gueltigen Record Header oder Atom stehen
//STRIP001 
//STRIP001 				// features beim erzeugen folgender Container:
//STRIP001 				//
//STRIP001 				//		ESCHER_DggContainer:	ein EscherDgg Atom wird automatisch erzeugt und verwaltet
//STRIP001 				//		ESCHER_DgContainer:		ein EscherDg Atom wird automatisch erzeugt und verwaltet
//STRIP001 				//		ESCHER_SpgrContainer:
//STRIP001 				//		ESCHER_SpContainer:
//STRIP001 
//STRIP001 		virtual void OpenContainer( UINT16 nEscherContainer, int nRecInstance = 0 );
//STRIP001 		virtual void CloseContainer();
//STRIP001 
//STRIP001 		void	BeginAtom();
//STRIP001 		void	EndAtom( UINT16 nRecType, int nRecVersion = 0, int nRecInstance = 0 );
//STRIP001 		void	AddAtom( UINT32 nAtomSitze, UINT16 nRecType, int nRecVersion = 0, int nRecInstance = 0 );
//STRIP001 		void	AddClientAnchor( const Rectangle& rRectangle );
//STRIP001 
//STRIP001 		UINT32	EnterGroup( const Rectangle* pBoundRect = NULL );
//STRIP001 		UINT32	GetGroupLevel() const { return mnGroupLevel; };
//STRIP001 		BOOL	SetGroupSnapRect( UINT32 nGroupLevel, const Rectangle& rRect );
//STRIP001 		BOOL	SetGroupLogicRect( UINT32 nGroupLevel, const Rectangle& rRect );
//STRIP001 		void	LeaveGroup();
//STRIP001 
//STRIP001 				// ein ESCHER_Sp wird geschrieben ( Ein ESCHER_DgContainer muss dazu geoeffnet sein !!)
//STRIP001 		void	AddShape( UINT32 nShpInstance, UINT32 nFlagIds, UINT32 nShapeID = 0 );
//STRIP001 				// reserviert eine ShapeId
//STRIP001 		UINT32	GetShapeID();
//STRIP001 
//STRIP001 		UINT32	GetColor( const UINT32 nColor, BOOL bSwap = TRUE );
//STRIP001 		UINT32	GetColor( const Color& rColor, BOOL bSwap = TRUE );
//STRIP001 
//STRIP001 				// OLE is written as EMF instead of WMF (default WMF)
//STRIP001 		void	SetOleEmf( BOOL bVal )		{ mbOleEmf = bVal; }
//STRIP001 		BOOL	IsOleEmf() const			{ return mbOleEmf; }
//STRIP001 
//STRIP001 				// ...Sdr... implemented in eschesdo.cxx
//STRIP001 
//STRIP001 		void	AddSdrPage( const SdrPage& rPage );
//STRIP001 
//STRIP001 				/// returns the ShapeID
//STRIP001 		UINT32	AddSdrObject( const SdrObject& rObj );
//STRIP001 
//STRIP001 				/// If objects are written through AddSdrObject the
//STRIP001 				/// SolverContainer has to be written, and maybe some
//STRIP001 				/// maintenance to be done.
//STRIP001 		void	EndSdrObjectPage();
//STRIP001 
//STRIP001 				/// Called before a shape is written, application supplies
//STRIP001 				/// ClientRecords. May set AppData::bDontWriteShape so the
//STRIP001 				/// shape is ignored.
//STRIP001 		virtual	EscherExHostAppData* StartShape( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& rShape );
//STRIP001 
//STRIP001 				/// Called after a shape is written to inform the application
//STRIP001 				/// of the resulted shape type and ID.
//STRIP001 	virtual	void	EndShape( UINT16 nShapeType, UINT32 nShapeID );
//STRIP001 
//STRIP001 				/// Called before an AdditionalText EnterGroup occurs.
//STRIP001 				/// The current shape will be written in three parts:
//STRIP001 				/// a group shape, the shape itself, and an extra textbox shape.
//STRIP001 				/// The complete flow is:
//STRIP001 				/// StartShape sets HostData1.
//STRIP001 				/// EnterAdditionalTextGroup sets HostData2, App may modify
//STRIP001 				///   HostData1 and keep track of the change.
//STRIP001 				/// The group shape is written with HostData2.
//STRIP001 				/// Another StartShape with the same (!) object sets HostData3.
//STRIP001 				/// The current shape is written with HostData3.
//STRIP001 				/// EndShape is called for the current shape.
//STRIP001 				/// Another StartShape with the same (!) object sets HostData4.
//STRIP001 				/// The textbox shape is written with HostData4.
//STRIP001 				/// EndShape is called for the textbox shape.
//STRIP001 				/// EndShape is called for the group shape, this provides
//STRIP001 				///   the same functionality as an ordinary recursive group.
//STRIP001 	virtual	EscherExHostAppData*	EnterAdditionalTextGroup();
//STRIP001 
//STRIP001 				/// Called if a picture shall be written and no PicStream is
//STRIP001 				/// set at ImplEscherExSdr
//STRIP001 	virtual SvStream*	QueryPicStream();
//STRIP001 
//STRIP001 				/// Called if an ESCHER_Prop_lTxid shall be written
//STRIP001 	virtual	UINT32	QueryTextID( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >&, UINT32 nShapeId );
//STRIP001 			// add an dummy rectangle shape into the escher stream
//STRIP001 		UINT32 	AddDummyShape( const SdrObject& rObj );
//STRIP001 
//STRIP001 	static const SdrObject* GetSdrObject( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& rXShape );
//STRIP001 
//STRIP001 	void SetHellLayerId( UINT16 nId )		{ mnHellLayerId = nId; }
//STRIP001 	UINT16 GetHellLayerId() const			{ return mnHellLayerId; }
//STRIP001 };

}//end of namespace binfilter
#endif // _SVX_ESCHEREX_HXX
