/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_rlrcitem.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:01:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifndef _SFXRECTITEM_HXX
#include <svtools/rectitem.hxx>
#endif
#pragma hdrstop

#define ITEMID_LRSPACE	0
#define ITEMID_ULSPACE  0
#define ITEMID_TABSTOP  0
#define ITEMID_PROTECT  0

#include "dialogs.hrc"

#include "ruler.hxx"
#include "lrspitem.hxx"
// auto strip #include "ulspitem.hxx"
#include "tstpitem.hxx"
#include "protitem.hxx"
#include "rlrcitem.hxx"
#include "rulritem.hxx"
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
namespace binfilter {

// class SvxRulerItem ----------------------------------------------------

/*N*/ SvxRulerItem::SvxRulerItem(USHORT nId, SvxRuler &rRul, SfxBindings &rBindings)
/*N*/ : SfxControllerItem(nId, rBindings),
/*N*/   rRuler(rRul)
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SvxRulerItem::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 								 const SfxPoolItem* pState)
/*N*/ {
/*N*/ 	// SFX_ITEM_DONTCARE => pState == -1 => PTR_CAST buff
/*N*/ 	if ( eState != SFX_ITEM_AVAILABLE )
/*N*/ 		pState = 0;
/*N*/ 
/*N*/ 	switch(nSID)
/*N*/ 	{
/*N*/ 		// Linker / rechter Seitenrand
/*N*/ 		case SID_RULER_LR_MIN_MAX:
/*N*/ 		{
/*N*/ 			const SfxRectangleItem *pItem = PTR_CAST(SfxRectangleItem, pState);
/*N*/ 			rRuler.UpdateFrameMinMax(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_LONG_LRSPACE:
/*N*/ 		{
/*N*/ 			const SvxLongLRSpaceItem *pItem = PTR_CAST(SvxLongLRSpaceItem, pState);
/*N*/ 			DBG_ASSERT(pState? 0 != pItem: TRUE, "SvxLRSpaceItem erwartet");
/*N*/ 			rRuler.UpdateFrame(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_LONG_ULSPACE:
/*N*/ 		{
/*N*/ 			const SvxLongULSpaceItem *pItem = PTR_CAST(SvxLongULSpaceItem, pState);
/*N*/ 			DBG_ASSERT(pState? 0 != pItem: TRUE, "SvxULSpaceItem erwartet");
/*N*/ 			rRuler.UpdateFrame(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_TABSTOP_VERTICAL:
/*N*/         case SID_ATTR_TABSTOP:
/*N*/ 		{
/*N*/ 			const SvxTabStopItem *pItem = PTR_CAST(SvxTabStopItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxTabStopItem erwartet");
/*N*/ 			rRuler.Update(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_PARA_LRSPACE_VERTICAL:
/*N*/         case SID_ATTR_PARA_LRSPACE:
/*N*/ 		{
/*N*/ 			const SvxLRSpaceItem *pItem = PTR_CAST(SvxLRSpaceItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxLRSpaceItem erwartet");
/*N*/ 			rRuler.UpdatePara(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_RULER_BORDERS_VERTICAL:
/*N*/         case SID_RULER_BORDERS:
/*N*/ 		{
/*N*/ 			const SvxColumnItem *pItem = PTR_CAST(SvxColumnItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxColumnItem erwartet");
/*N*/ #ifdef DBG_UTIL
/*N*/ 			if(pItem)
/*N*/ 			{
/*N*/ 				if(pItem->IsConsistent())
/*N*/ 					rRuler.Update(pItem);
/*N*/ 				else
/*N*/ 					DBG_ERROR("Spaltenitem corrupted");
/*N*/ 			}
/*N*/ 			else
/*N*/ 				rRuler.Update(pItem);
/*N*/ #else
/*N*/ 			rRuler.Update(pItem);
/*N*/ #endif
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_RULER_PAGE_POS:
/*N*/ 		{	// Position Seite, Seitenbreite
/*N*/ 			const SvxPagePosSizeItem *pItem = PTR_CAST(SvxPagePosSizeItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxPagePosSizeItem erwartet");
/*N*/ 			rRuler.Update(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_RULER_OBJECT:
/*N*/ 		{	// Object-Selektion
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SvxObjectItem *pItem = PTR_CAST(SvxObjectItem, pState);
//STRIP001 /*?*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxObjectItem erwartet");
//STRIP001 /*?*/ 			rRuler.Update(pItem);
/*?*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_RULER_PROTECT:
/*N*/ 		{
/*N*/ 			const SvxProtectItem *pItem = PTR_CAST(SvxProtectItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxProtectItem erwartet");
/*N*/ 			rRuler.Update(pItem);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_RULER_BORDER_DISTANCE:
/*N*/         {
/*N*/             const SvxLRSpaceItem *pItem = PTR_CAST(SvxLRSpaceItem, pState);
/*N*/ 			DBG_ASSERT(pState?  0 != pItem: TRUE, "SvxLRSpaceItem erwartet");
/*N*/             rRuler.UpdateParaBorder(pItem);
/*N*/         }
/*N*/         break;
/*N*/         case SID_RULER_TEXT_RIGHT_TO_LEFT :
/*N*/         {
/*N*/             const SfxBoolItem *pItem = PTR_CAST(SfxBoolItem, pState);
/*N*/             DBG_ASSERT(pState?  0 != pItem: TRUE, "SfxBoolItem erwartet");
/*N*/             rRuler.UpdateTextRTL(pItem);
/*N*/         }
/*N*/         break;
/*N*/ 	}
/*N*/ }


}
