/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_fudraw.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:28:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS
// auto strip #ifndef _SVDOGRP_HXX //autogen
// auto strip #include <bf_svx/svdogrp.hxx>
// auto strip #endif
// auto strip #ifndef _CTRLTOOL_HXX //autogen
// auto strip #include <svtools/ctrltool.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #include <bf_svx/flstitem.hxx>
// auto strip #ifndef _SVDOCIRC_HXX
// auto strip #include <bf_svx/svdocirc.hxx>
// auto strip #endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
// auto strip #include "schresid.hxx"
// auto strip #include "objid.hxx"
#include "fudraw.hxx"
// auto strip #include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
// auto strip #include "schgroup.hxx"
// auto strip #ifndef _CHTMODEL_HXX
// auto strip #include "chtmodel.hxx"
// auto strip #endif
// auto strip #include "datapoin.hxx"
#include <bf_svx/svxids.hrc>
// auto strip #include "undmovsize.hxx"
// auto strip #include "undmovpieseg.hxx"
namespace binfilter {

//STRIP001 TYPEINIT1(SchFuDraw, SchFuPoor);


/*************************************************************************
|*
|* Basisklasse fuer alle Drawmodul-spezifischen Funktionen
|*
\************************************************************************/

/*N*/ SchFuDraw::SchFuDraw(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
/*N*/ 			   ChartModel* pDoc, SfxRequest& rReq) :
/*N*/ 	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq),
/*N*/ 	aNewPointer(POINTER_ARROW),
/*N*/ 	aOldPointer(POINTER_ARROW),
/*N*/ 	bMBDown(FALSE)
/*N*/ {
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SchFuDraw::~SchFuDraw()
/*N*/ {
/*N*/ 	pView->BrkAction();
/*N*/ }

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL SchFuDraw::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001     // guard object to suspend sending broadcasts
//STRIP001     SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );
//STRIP001 
//STRIP001     switch (rKEvt.GetKeyCode().GetCode())
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 			if (!pView->IsTextEdit())
//STRIP001 				if (pView->IsAction())
//STRIP001 				{
//STRIP001 					pView->BrkAction();
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 				else if (pView->HasMarkedObj())
//STRIP001 				{
//STRIP001 					pView->UnmarkAll();
//STRIP001 					pView->SetDragMode( SDRDRAG_MOVE );		// #67766# remove rotation handle
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case KEY_DELETE:
//STRIP001 		case KEY_BACKSPACE:
//STRIP001 			if (!pView->IsAction() && !pView->IsTextEdit())
//STRIP001 			{
//STRIP001 				if (!pView->DeleteMarkedObjects
//STRIP001 								(String(SchResId(STR_UNDO_DELETE))))
//STRIP001 					InfoBox(&pViewShell->GetViewFrame()->GetWindow(),
//STRIP001 							String(SchResId(STR_ACTION_NOTPOSSIBLE))).Execute();
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case KEY_TAB:
//STRIP001             bReturn = MarkChartObject( rKEvt.GetKeyCode().IsShift()
//STRIP001                                        ? lcl_SELECT_PREVIOUS
//STRIP001                                        : lcl_SELECT_NEXT );
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_HOME:
//STRIP001             bReturn = MarkChartObject( lcl_SELECT_FIRST );
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_END:
//STRIP001             bReturn = MarkChartObject( lcl_SELECT_LAST );
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_LEFT:
//STRIP001         case KEY_RIGHT:
//STRIP001         case KEY_UP:
//STRIP001         case KEY_DOWN:
//STRIP001             {
//STRIP001                 lcl_Movement_Direction eDir = lcl_MOVE_LEFT;
//STRIP001                 switch( rKEvt.GetKeyCode().GetCode() )
//STRIP001                 {
//STRIP001                     case KEY_LEFT:  eDir = lcl_MOVE_LEFT;  break;
//STRIP001                     case KEY_RIGHT: eDir = lcl_MOVE_RIGHT; break;
//STRIP001                     case KEY_UP:    eDir = lcl_MOVE_UP;    break;
//STRIP001                     case KEY_DOWN:  eDir = lcl_MOVE_DOWN;  break;
//STRIP001                 }
//STRIP001 
//STRIP001                 // together with 'Alt' move by one pixel
//STRIP001                 // otherwise move by 100 units (unit: 100th mm => 1mm)
//STRIP001                 if( rKEvt.GetKeyCode().IsMod2() )
//STRIP001                     bReturn = MoveMarkedObject( eDir, 1, true );
//STRIP001                 else
//STRIP001                     bReturn = MoveMarkedObject( eDir, 100, false );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_F2:
//STRIP001             {
//STRIP001                 // text edit for titles
//STRIP001                 const SdrMarkList & rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001                 if( rMarkList.GetMarkCount() > 0 )
//STRIP001                 {
//STRIP001                     // in the chart you can only select one object (probably a
//STRIP001                     // group) at once
//STRIP001                     SdrObject *   pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001                     if( pObj->ISA( SdrTextObj ))
//STRIP001                     {
//STRIP001                         SfxUInt16Item aItem( SID_TEXTEDIT, 2 );
//STRIP001                         pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001                             Execute( SID_TEXTEDIT, SFX_CALLMODE_ASYNCHRON |
//STRIP001                                      SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001                         bReturn = TRUE;
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_F3:
//STRIP001             // Ctrl-F3: leave group
//STRIP001             if( rKEvt.GetKeyCode().IsMod1())
//STRIP001             {
//STRIP001                 pView->LeaveOneGroup();
//STRIP001                 AdjustHandles( GetCurrentlyMarkedObject() );
//STRIP001                 bReturn = TRUE;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // F3: enter group
//STRIP001                 if( MayEnterGroup() )
//STRIP001                 {
//STRIP001                     pView->EnterMarkedGroup();
//STRIP001                     bReturn = MarkChartObject( lcl_SELECT_FIRST );
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001         case KEY_ADD:
//STRIP001         case KEY_SUBTRACT:
//STRIP001             // try resizing the current object
//STRIP001             if( rKEvt.GetKeyCode().IsMod2())
//STRIP001                 bReturn = ResizeMarkedObject( KEY_ADD == rKEvt.GetKeyCode().GetCode()
//STRIP001                                               ?  2
//STRIP001                                               : -2,
//STRIP001                                               true );
//STRIP001             else
//STRIP001                 bReturn = ResizeMarkedObject( KEY_ADD == rKEvt.GetKeyCode().GetCode()
//STRIP001                                               ?  200
//STRIP001                                               : -200,
//STRIP001                                               false );
//STRIP001 
//STRIP001             // if this didn't work try moving a pie
//STRIP001             if( ! bReturn )
//STRIP001             {
//STRIP001                 if( rKEvt.GetKeyCode().IsMod2() )
//STRIP001                     bReturn = MovePieSegment( KEY_ADD == rKEvt.GetKeyCode().GetCode(), 1 );
//STRIP001                 else
//STRIP001                     bReturn = MovePieSegment( KEY_ADD == rKEvt.GetKeyCode().GetCode(), 5 );
//STRIP001             }
//STRIP001             break;
//STRIP001     }
//STRIP001 
//STRIP001     if (!bReturn)
//STRIP001 		bReturn = SchFuPoor::KeyInput(rKEvt);
//STRIP001 	else
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuDraw::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	aMDPos = pWindow->PixelToLogic(rMEvt.GetPosPixel());
//STRIP001 
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuDraw::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

//STRIP001 BOOL SchFuDraw::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	ForcePointer(&rMEvt);
//STRIP001 
//STRIP001 	return SchFuPoor::MouseButtonUp (rMEvt);
//STRIP001 }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void SchFuDraw::Activate()
/*N*/ {
/*N*/ 	SchFuPoor::Activate();
/*N*/ 
/*N*/ 	ForcePointer();
/*N*/ }

/*************************************************************************
|*
|* Maus-Pointer umschalten
|* FG: Bisher (8.3.97) gab es nur einen einzigen Mousepointer und den
|*     brauchte man daher auch nie umschalten. Ab jetzt gibt es auch
|*     Mousepointer die ein Resize andeuten.
|*
\************************************************************************/

/*N*/ void SchFuDraw::ForcePointer(const MouseEvent* pMEvt)
/*N*/ {
/*N*/ 	if (pMEvt != NULL)
/*N*/ 	{
/*?*/ 		USHORT nModifier = 0;
/*?*/ 		BOOL bLeftDown = FALSE;
/*?*/ 		BOOL bAllowChange=TRUE;
/*?*/ 		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();
/*?*/ 
/*?*/ 		Point aPnt(pWindow->PixelToLogic(pMEvt->GetPosPixel()));
/*?*/ 		nModifier = pMEvt->GetModifier();
/*?*/ 		bLeftDown = pMEvt->IsLeft();
/*?*/ 
/*?*/ 		Pointer aPointer = pView->GetPreferedPointer(aPnt, pWindow,
/*?*/ 														  nModifier, bLeftDown);
/*?*/ 		if( aPointer.GetStyle() == POINTER_TEXT )
/*?*/ 		{
/*?*/ 			SdrObject*   pObj = NULL;
/*?*/ 			SdrPageView* pPV  = pView->GetPageViewPvNum (0);
/*?*/ 
/*?*/ 			pView->PickObj(aMDPos,nHitLog,pObj,pPV);
/*?*/ 
/*?*/ 			if(pObj)
/*?*/ 			{
/*?*/ 
/*?*/ 				SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 				if (pId)switch(pId->GetObjId())
/*?*/ 				{
/*?*/ 
/*?*/ 					case CHOBJID_TITLE_MAIN:
/*?*/ 					case CHOBJID_TITLE_SUB :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
/*?*/ 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
/*?*/ 						break;
/*?*/ 					default:
/*?*/ 						bAllowChange=FALSE;
/*?*/ 					break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*?*/ 		if( aPointer.GetStyle() == POINTER_MOVE )
/*?*/ 		{
/*?*/ 			SdrObject*   pObj = NULL;
/*?*/ 			SdrPageView* pPV  = pView->GetPageViewPvNum (0);
/*?*/ 
/*?*/ 			pView->PickObj(aMDPos,nHitLog,pObj,pPV);
/*?*/ 
/*?*/ 			if(pObj)
/*?*/ 			{
/*?*/ 				SchObjectId* pId = GetObjectId(*pObj);
/*?*/ 				if (pId)switch(pId->GetObjId())
/*?*/ 				{
/*?*/ 
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_ROW:
/*?*/ 					case CHOBJID_LEGEND_SYMBOL_COL:
/*?*/ 						aPointer=Pointer(POINTER_ARROW);
/*?*/ 						break;
/*?*/ 					default:
/*?*/ 					break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 		}
/*?*/ 
/*?*/         // there is no point-editing in a chart
/*?*/         if( aPointer.GetStyle() == POINTER_MOVEPOINT )
/*?*/         {
/*?*/             aPointer = Pointer( POINTER_ARROW );
/*?*/         }
/*?*/ 
/*?*/ 
/*?*/ 		switch(aPointer.GetStyle())
/*?*/ 		{
/*?*/ 		case POINTER_DRAW_BEZIER:
/*?*/ 		case POINTER_HAND:
/*?*/ 		case POINTER_MOVEBEZIERWEIGHT:
/*?*/ 			 bAllowChange=FALSE;
/*?*/ 		default: break;
/*?*/ 		}
/*?*/ 
/*?*/ 		if(bAllowChange)
/*?*/ 			pWindow->SetPointer(aPointer);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Reaktion auf Doppelklick
|*
\************************************************************************/

//STRIP001 void SchFuDraw::DoubleClick()
//STRIP001 {
//STRIP001 	if (pView->HasMarkedObj())
//STRIP001 	{
//STRIP001 		const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 		if (rMarkList.GetMarkCount() == 1)
//STRIP001 		{
//STRIP001 			SdrObject   *pObj   = rMarkList.GetMark(0)->GetObj();
//STRIP001 			SchObjectId *pObjId = GetObjectId(*pObj);
//STRIP001 
//STRIP001 			if (pObjId)
//STRIP001 			{
//STRIP001 				USHORT nId = 0;
//STRIP001 				switch( pObjId->GetObjId() )
//STRIP001 				{
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_X_AXIS :
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Y_AXIS :
//STRIP001 					case CHOBJID_DIAGRAM_TITLE_Z_AXIS :
//STRIP001 					case CHOBJID_TITLE_MAIN :
//STRIP001 					case CHOBJID_TITLE_SUB :
//STRIP001 						nId = SID_TEXTEDIT;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_FLOOR :
//STRIP001 						nId = SID_DIAGRAM_FLOOR;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_WALL :
//STRIP001 					case CHOBJID_DIAGRAM :
//STRIP001 						if (pChDoc->IsAxisChart () && !pChDoc->IsNetChart ()) nId = SID_DIAGRAM_WALL;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_LEGEND :
//STRIP001 						nId = SID_LEGEND;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_X_GRID_MAIN :
//STRIP001 					case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_X_MAIN;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_X_GRID_HELP :
//STRIP001 					case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_X_HELP;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Y_GRID_MAIN :
//STRIP001 					case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_Y_MAIN;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Y_GRID_HELP :
//STRIP001 					case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_Y_HELP;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Z_GRID_MAIN :
//STRIP001 					case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_Z_MAIN;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Z_GRID_HELP :
//STRIP001 					case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
//STRIP001 						nId = SID_DIAGRAM_GRID_Z_HELP;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_X_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_X;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Y_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_Y;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_Z_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_Z;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_A_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_A;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_B_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_B;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_C_AXIS :
//STRIP001 						nId = SID_DIAGRAM_AXIS_C;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_AREA:
//STRIP001 					case CHOBJID_AREA :
//STRIP001 						nId = SID_DIAGRAM_AREA;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_DATA :
//STRIP001 					case CHOBJID_DIAGRAM_SPECIAL_GROUP :
//STRIP001 					case CHOBJID_DIAGRAM_ROWGROUP :
//STRIP001 					case CHOBJID_DIAGRAM_ROWSLINE :
//STRIP001 					case CHOBJID_LEGEND_SYMBOL_ROW :
//STRIP001 					case CHOBJID_LEGEND_SYMBOL_COL :
//STRIP001 						nId = SID_DATA_ROW_POINT;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_STATISTICS_GROUP :
//STRIP001 						nId = SID_DIAGRAM_ERROR;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
//STRIP001 						nId = SID_DIAGRAM_STOCK_LOSS;
//STRIP001 						break;
//STRIP001 					case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
//STRIP001 						nId = SID_DIAGRAM_STOCK_PLUS;
//STRIP001 						break;
//STRIP001 					//case CHOBJID_DIAGRAM_STOCKLINE:
//STRIP001 					case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
//STRIP001 						nId = SID_DIAGRAM_STOCK_LINE;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_AVERAGEVALUE :
//STRIP001 						nId = SID_DIAGRAM_AVERAGEVALUE;
//STRIP001 						break;
//STRIP001 
//STRIP001 					case CHOBJID_DIAGRAM_REGRESSION :
//STRIP001 						nId = SID_DIAGRAM_REGRESSION;
//STRIP001 						break;
//STRIP001 
//STRIP001 					default :
//STRIP001 						nId = 0;
//STRIP001 						break;
//STRIP001 
//STRIP001 				}
//STRIP001 
//STRIP001 				if( nId > 0 )
//STRIP001 					pViewShell->GetViewFrame()->GetDispatcher()->Execute(nId, SFX_CALLMODE_ASYNCHRON);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// ========================================
// Methods for selecting and moving objects
// with the keyboard
// ========================================

//STRIP001 BOOL SchFuDraw::MarkChartObject( lcl_Selection_Direction eDirection, int nDepth, bool bEnterDiagram )
//STRIP001 {
//STRIP001     BOOL bInvertNavigation = FALSE;
//STRIP001     BOOL bInRange = TRUE;
//STRIP001 
//STRIP001     // avoid infinite loop
//STRIP001     // a depth up to 3 may happen regularly
//STRIP001     // (next => first => validity check: next)
//STRIP001     DBG_ASSERT( nDepth < 3, "There seem to be no valid objects in the current group" );
//STRIP001     if( nDepth >= 3 )
//STRIP001         return FALSE;
//STRIP001 
//STRIP001     pView->SetMarkHdlHidden( TRUE );
//STRIP001 
//STRIP001     switch( eDirection )
//STRIP001     {
//STRIP001         case  lcl_SELECT_NEXT:
//STRIP001             // if diagram is selected then enter it
//STRIP001             if( bEnterDiagram )
//STRIP001             {
//STRIP001                 SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001                 if( pObj )
//STRIP001                 {
//STRIP001                     // enter group rather than selecting next top-level object
//STRIP001                     // when currently the diagram is selected
//STRIP001                     UINT16 nObjId = CHOBJID_ANY;
//STRIP001                     SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001                     if( pObjId &&
//STRIP001                         CHOBJID_DIAGRAM == pObjId->GetObjId())
//STRIP001                     {
//STRIP001                         pView->EnterMarkedGroup();
//STRIP001                         MarkChartObject( lcl_SELECT_FIRST, nDepth + 1, false );
//STRIP001                         break;
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             // select next valid object
//STRIP001             do
//STRIP001             {
//STRIP001                 bInRange = pView->MarkNextObj( bInvertNavigation );
//STRIP001             }
//STRIP001             while( bInRange && ! ValidObjectSelected() );
//STRIP001 
//STRIP001             // if there is no next object go back to the first one
//STRIP001             // except if we are in the diagram, then leave group and
//STRIP001             // select the next object after the diagram
//STRIP001             if( ! bInRange )
//STRIP001             {
//STRIP001                 SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001                 if( pObj )
//STRIP001                 {
//STRIP001                     pObj = pObj->GetUpGroup();
//STRIP001                     if( pObj )
//STRIP001                     {
//STRIP001                         UINT16 nObjId = CHOBJID_ANY;
//STRIP001                         SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001                         if( pObjId &&
//STRIP001                             CHOBJID_DIAGRAM == pObjId->GetObjId())
//STRIP001                         {
//STRIP001                             pView->LeaveOneGroup();
//STRIP001                             // select next element after diagram
//STRIP001                             MarkChartObject( lcl_SELECT_NEXT, nDepth + 1, false );
//STRIP001                             break;
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001                 MarkChartObject( lcl_SELECT_FIRST, nDepth + 1 );
//STRIP001             }
//STRIP001             break;
//STRIP001         case lcl_SELECT_PREVIOUS:
//STRIP001             // select previous valid object
//STRIP001             do
//STRIP001             {
//STRIP001                 bInRange = pView->MarkNextObj( ! bInvertNavigation );
//STRIP001             }
//STRIP001             while( bInRange && ! ValidObjectSelected() );
//STRIP001 
//STRIP001             // if we reach the diagram then enter it and select the
//STRIP001             // last group member
//STRIP001             if( bEnterDiagram )
//STRIP001             {
//STRIP001                 SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001                 if( pObj )
//STRIP001                 {
//STRIP001                     UINT16 nObjId = CHOBJID_ANY;
//STRIP001                     SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001                     if( pObjId &&
//STRIP001                         CHOBJID_DIAGRAM == pObjId->GetObjId())
//STRIP001                     {
//STRIP001                         pView->EnterMarkedGroup();
//STRIP001                         MarkChartObject( lcl_SELECT_LAST, nDepth + 1, false );
//STRIP001                         break;
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             // if there is no previous object go forward to the last
//STRIP001             // one except if we are in the diagram, then leave group
//STRIP001             // so that the diagram gets selected
//STRIP001             if( ! bInRange )
//STRIP001             {
//STRIP001                 SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001                 pObj = pObj->GetUpGroup();
//STRIP001                 if( pObj )
//STRIP001                 {
//STRIP001                     UINT16 nObjId = CHOBJID_ANY;
//STRIP001                     SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001                     if( pObjId &&
//STRIP001                         CHOBJID_DIAGRAM == pObjId->GetObjId())
//STRIP001                     {
//STRIP001                         // select diagram
//STRIP001                         pView->LeaveOneGroup();
//STRIP001                         AdjustHandles( GetCurrentlyMarkedObject() );
//STRIP001                         break;
//STRIP001                     }
//STRIP001                 }
//STRIP001                 MarkChartObject( lcl_SELECT_LAST, nDepth + 1 );
//STRIP001             }
//STRIP001             break;
//STRIP001         case lcl_SELECT_LAST:
//STRIP001             // got to last object
//STRIP001             while( pView->MarkNextObj( bInvertNavigation ));
//STRIP001             // go back to first valid one
//STRIP001             if( ! ValidObjectSelected() )
//STRIP001                 MarkChartObject( lcl_SELECT_PREVIOUS, nDepth + 1 );
//STRIP001             break;
//STRIP001         case lcl_SELECT_FIRST:
//STRIP001             // go to first object
//STRIP001             while( pView->MarkNextObj( ! bInvertNavigation ));
//STRIP001             // advance to first valid one
//STRIP001             if( ! ValidObjectSelected() )
//STRIP001                 MarkChartObject( lcl_SELECT_NEXT, nDepth + 1 );
//STRIP001             break;
//STRIP001     }
//STRIP001 
//STRIP001     pView->SetMarkHdlHidden( FALSE );
//STRIP001     return TRUE;
//STRIP001 }

//STRIP001 bool SchFuDraw::ValidObjectSelected()
//STRIP001 {
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001     
//STRIP001     if( NULL == pObj )
//STRIP001         return false;
//STRIP001 
//STRIP001     UINT16 nObjId = CHOBJID_ANY;
//STRIP001     SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001     if( pObjId )
//STRIP001         nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001     bool bResult = ! ( ( CHOBJID_ANY == nObjId )
//STRIP001                        || ( CHOBJID_DIAGRAM_DESCRGROUP == nObjId )
//STRIP001                        || ( CHOBJID_DIAGRAM_ROWSLINE  == nObjId ) );
//STRIP001 
//STRIP001     if( bResult )
//STRIP001     {
//STRIP001         if( pObj->IsGroupObject() &&
//STRIP001             ! pObj->ISA( E3dCompoundObject ) &&
//STRIP001             0 == pObj->GetSubList()->GetObjCount())
//STRIP001         {
//STRIP001             bResult = false;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             AdjustHandles( pObj );
//STRIP001         }
//STRIP001     }
//STRIP001     return bResult;
//STRIP001 }

//STRIP001 void SchFuDraw::AdjustHandles( SdrObject* pObj )
//STRIP001 {
//STRIP001     if( NULL == pObj )
//STRIP001         return;
//STRIP001 
//STRIP001     if( pObj->ISA( E3dObject ) &&
//STRIP001         pView->GetDragMode() == SDRDRAG_ROTATE )
//STRIP001     {
//STRIP001         pView->SetDragMode( SDRDRAG_MOVE );
//STRIP001     }
//STRIP001 
//STRIP001     UINT16 nObjId = CHOBJID_ANY;
//STRIP001     SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001     if( pObjId )
//STRIP001         nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001     BOOL bMarkGroupMembers =
//STRIP001         ( ( nObjId == CHOBJID_DIAGRAM_ROWGROUP )
//STRIP001           || ( CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP <= nObjId
//STRIP001                && nObjId <= CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP )
//STRIP001           || ( CHOBJID_DIAGRAM_X_AXIS <= nObjId
//STRIP001                && nObjId <= CHOBJID_DIAGRAM_Z_AXIS )
//STRIP001           || ( CHOBJID_DIAGRAM_A_AXIS <= nObjId
//STRIP001                && nObjId <= CHOBJID_DIAGRAM_C_AXIS )
//STRIP001           || pObj->ISA( E3dCompoundObject ));
//STRIP001 
//STRIP001     if( pView->IsFrameHandles() == bMarkGroupMembers )
//STRIP001     {
//STRIP001         pView->SetFrameDragSingles( ! bMarkGroupMembers );
//STRIP001         pView->SetMarkHdlHidden( TRUE );
//STRIP001         pView->SetMarkHdlHidden( FALSE );
//STRIP001     }
//STRIP001 }

//STRIP001 BOOL SchFuDraw::MoveMarkedObject( lcl_Movement_Direction eDirection, long nAmount, bool bPixel  )
//STRIP001 {
//STRIP001     BOOL bResult = FALSE;
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001 
//STRIP001     if( NULL != pObj )
//STRIP001     {
//STRIP001         SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001 
//STRIP001         bool bMayMove = ! pObj->IsMoveProtect();
//STRIP001 
//STRIP001         // dragging of pie segments
//STRIP001         if( bMayMove &&
//STRIP001             pObjId && CHOBJID_DIAGRAM_DATA == pObjId->GetObjId() &&
//STRIP001             pChDoc && pChDoc->IsPieChart() &&
//STRIP001             ! pChDoc->Is3DChart() &&
//STRIP001             pObj->ISA( SdrCircObj ))
//STRIP001         {
//STRIP001             // emulate pie dragging like in drag method
//STRIP001             // one press moves SCH_PIE_DRAG_AMOUNT percent
//STRIP001             SdrCircObj* pPie = static_cast< SdrCircObj* >( pObj );
//STRIP001 
//STRIP001             // determine angle of the bisector of the segment
//STRIP001             long nStartAngle = pPie->GetStartWink(),
//STRIP001                 nEndAngle = pPie->GetEndWink();
//STRIP001             if( nStartAngle > nEndAngle )
//STRIP001                 nEndAngle += 36000;
//STRIP001             long nAngle = (nStartAngle + nEndAngle) / 2;
//STRIP001 
//STRIP001             // direction in which to move
//STRIP001             bool bOut =true;
//STRIP001             switch( eDirection )
//STRIP001             {
//STRIP001                 case lcl_MOVE_LEFT:
//STRIP001                 case lcl_MOVE_RIGHT:
//STRIP001                     if( 9000 <= nAngle && nAngle <= 27000 )
//STRIP001                         bOut = ( lcl_MOVE_LEFT == eDirection );
//STRIP001                     else
//STRIP001                         bOut = ( lcl_MOVE_RIGHT == eDirection );
//STRIP001                     break;
//STRIP001                 case lcl_MOVE_UP:
//STRIP001                 case lcl_MOVE_DOWN:
//STRIP001                     if( 0 <= nAngle && nAngle <= 18000 )
//STRIP001                         bOut = ( lcl_MOVE_UP == eDirection );
//STRIP001                     else
//STRIP001                         bOut = ( lcl_MOVE_DOWN == eDirection );
//STRIP001                     break;
//STRIP001             }
//STRIP001             bResult = MovePieSegment( bOut, ( bPixel ? nAmount : nAmount / 20 ));
//STRIP001         }
//STRIP001         else if( bMayMove )
//STRIP001         {
//STRIP001             long nShiftX = 0;
//STRIP001             long nShiftY = 0;
//STRIP001 
//STRIP001             long nAmountX = nAmount;
//STRIP001             long nAmountY = nAmount;
//STRIP001 
//STRIP001             if( bPixel )
//STRIP001             {
//STRIP001                 Size aPixelSize = pWindow->PixelToLogic( Size( nAmount, nAmount ));
//STRIP001                 nAmountX = aPixelSize.Width();
//STRIP001                 nAmountY = aPixelSize.Height();
//STRIP001             }
//STRIP001 
//STRIP001             switch( eDirection )
//STRIP001             {
//STRIP001                 case lcl_MOVE_LEFT:
//STRIP001                     nShiftX -= nAmountX;
//STRIP001                     break;
//STRIP001                 case lcl_MOVE_RIGHT:
//STRIP001                     nShiftX += nAmountX;
//STRIP001                 break;
//STRIP001                 case lcl_MOVE_UP:
//STRIP001                     nShiftY -= nAmountY;
//STRIP001                     break;
//STRIP001                 case lcl_MOVE_DOWN:
//STRIP001                     nShiftY += nAmountY;
//STRIP001                     break;
//STRIP001             }
//STRIP001             Rectangle aNewBoundRect( pObj->GetBoundRect() );
//STRIP001             aNewBoundRect.Move( nShiftX, nShiftY );
//STRIP001             if( pView->GetWorkArea().IsInside( aNewBoundRect ))
//STRIP001             {
//STRIP001 				//create undo
//STRIP001 				if( pObjId )
//STRIP001 				{
//STRIP001 					UINT16 nUndoObjId(pObjId->GetObjId());
//STRIP001 					Rectangle aOldUndoRect(pObj->GetBoundRect());
//STRIP001 					Rectangle aNewUndoRect(aNewBoundRect);
//STRIP001 
//STRIP001 					SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize(
//STRIP001 							*pChDoc, nUndoObjId, aOldUndoRect, aNewUndoRect );
//STRIP001 					pUndo->SetCommentTemplate(STR_UNDO_MOVE);
//STRIP001 					pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 						GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 				}
//STRIP001 
//STRIP001                 Size aDist( nShiftX, nShiftY );
//STRIP001                 pObj->Move( aDist );
//STRIP001 
//STRIP001                 ApplyMoveResizeChanges();
//STRIP001                 bResult = TRUE;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bResult;
//STRIP001 }

//STRIP001 BOOL SchFuDraw::ResizeMarkedObject( long nAmount, bool bPixel )
//STRIP001 {
//STRIP001     BOOL bResult = FALSE;
//STRIP001 
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001     if( NULL != pObj )
//STRIP001     {
//STRIP001         SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001         if( pObjId && CHOBJID_DIAGRAM == pObjId->GetObjId())
//STRIP001         {
//STRIP001             long nAmountX = nAmount;
//STRIP001             long nAmountY = nAmount;
//STRIP001 
//STRIP001             if( bPixel )
//STRIP001             {
//STRIP001                 Size aPixelSize = pWindow->PixelToLogic( Size( nAmount, nAmount ));
//STRIP001                 nAmountX = aPixelSize.Width();
//STRIP001                 nAmountY = aPixelSize.Height();
//STRIP001             }
//STRIP001 
//STRIP001             Rectangle aRect = pObj->GetSnapRect();
//STRIP001             Size aSize = aRect.GetSize();
//STRIP001             long nWidth = aSize.getWidth();
//STRIP001             long nHeight = aSize.getHeight();
//STRIP001             double fAspect = (double)nWidth / (double)nHeight;
//STRIP001 
//STRIP001             if( fAspect >= 1.0 )
//STRIP001                 nAmountY = (long)((double)nAmountX / fAspect);
//STRIP001             else
//STRIP001                 nAmountX = (long)((double)nAmountY * fAspect);
//STRIP001 
//STRIP001             if( 0 != nAmountX &&
//STRIP001                 0 != nAmountY )
//STRIP001             {
//STRIP001                 aSize.setWidth( nWidth + nAmountX );
//STRIP001                 aSize.setHeight( nHeight + nAmountY );
//STRIP001                 aRect.SetSize( aSize );
//STRIP001 
//STRIP001                 aRect.Move( - nAmountX / 2, - nAmountY / 2 );
//STRIP001 
//STRIP001 				//create undo
//STRIP001 				{
//STRIP001 					UINT16 nUndoObjId(pObjId->GetObjId());
//STRIP001 					Rectangle aOldUndoRect(pObj->GetSnapRect());
//STRIP001 					Rectangle aNewUndoRect(aRect);
//STRIP001 
//STRIP001 					SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize(
//STRIP001 							*pChDoc, CHOBJID_DIAGRAM
//STRIP001 							, aOldUndoRect, aNewUndoRect );
//STRIP001 					pUndo->SetCommentTemplate(STR_UNDO_RESIZE);
//STRIP001 					pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 						GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 				}
//STRIP001 
//STRIP001                 pObj->SetSnapRect( aRect );
//STRIP001                 ApplyMoveResizeChanges();
//STRIP001                 bResult = TRUE;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     return bResult;
//STRIP001 }

//STRIP001 BOOL SchFuDraw::MovePieSegment( bool bOut, long nAmount )
//STRIP001 {
//STRIP001     BOOL bResult = FALSE;
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001 
//STRIP001     if( NULL != pObj )
//STRIP001     {
//STRIP001         SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001 
//STRIP001         // dragging of pie segments
//STRIP001         if( ! pObj->IsMoveProtect() &&
//STRIP001             pObjId && CHOBJID_DIAGRAM_DATA == pObjId->GetObjId() &&
//STRIP001             pChDoc && pChDoc->IsPieChart() &&
//STRIP001             ! pChDoc->Is3DChart())
//STRIP001         {
//STRIP001             SchDataPoint* pPoint = GetDataPoint( *pObj );
//STRIP001             DBG_ASSERT( pPoint, "Pie has no data point user data" );
//STRIP001 
//STRIP001             if( pPoint )
//STRIP001             {
//STRIP001                 long nCol = pPoint->GetCol();
//STRIP001                 long nOldSegOf = pChDoc->PieSegOfs( nCol );
//STRIP001                 long nNewSegOf = nOldSegOf;
//STRIP001 
//STRIP001                 if( bOut )
//STRIP001                     nNewSegOf += nAmount;
//STRIP001                 else
//STRIP001                     nNewSegOf -= nAmount;
//STRIP001 
//STRIP001                 // bound value
//STRIP001                 if( nNewSegOf < 0)
//STRIP001                     nNewSegOf = 0;
//STRIP001                 else if( nNewSegOf > 100 )
//STRIP001                     nNewSegOf = 100;
//STRIP001 
//STRIP001                 // change offset
//STRIP001                 if( nOldSegOf != nNewSegOf )
//STRIP001                 {
//STRIP001                     pChDoc->SetPieSegOfs( nCol, nNewSegOf );
//STRIP001                     pChDoc->BuildChart( FALSE );
//STRIP001 
//STRIP001                     // remark pie object
//STRIP001                     SdrPageView* pPV  = pView->GetPageViewPvNum (0);
//STRIP001                     if( pPV )
//STRIP001                     {
//STRIP001                         pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage( 0 ), 0, IM_DEEPWITHGROUPS ), pPV );
//STRIP001                         pView->EnterMarkedGroup();
//STRIP001                         pView->MarkObj( pChDoc->GetDataPointObj( nCol, 0 ), pPV );
//STRIP001                     }
//STRIP001                     bResult = TRUE;
//STRIP001 
//STRIP001 					//create undo
//STRIP001 					{
//STRIP001 						SfxUndoAction* pUndo = new SchUndoMovePieSeg( *pChDoc, nCol
//STRIP001 									, nOldSegOf, nNewSegOf );
//STRIP001 						pViewShell->GetViewFrame()->GetObjectShell()->
//STRIP001 								GetUndoManager()->AddUndoAction(pUndo);
//STRIP001 					}
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     return bResult;
//STRIP001 }

//STRIP001 bool SchFuDraw::MayEnterGroup()
//STRIP001 {
//STRIP001     bool bResult = false;
//STRIP001 
//STRIP001     // get object and id
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001     
//STRIP001     if( NULL != pObj )
//STRIP001     {
//STRIP001         UINT16 nObjId = CHOBJID_ANY;
//STRIP001         SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001         if( pObjId )
//STRIP001             nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001         if( CHOBJID_ANY != nObjId )
//STRIP001         {
//STRIP001             // now allow entering for certain elements
//STRIP001             switch( nObjId )
//STRIP001             {
//STRIP001                 case CHOBJID_DIAGRAM:
//STRIP001                 case CHOBJID_DIAGRAM_ROWGROUP:
//STRIP001                 case CHOBJID_LEGEND:
//STRIP001                     bResult = true;
//STRIP001                     break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bResult;
//STRIP001 }

//STRIP001 SdrObject* SchFuDraw::GetCurrentlyMarkedObject()
//STRIP001 {
//STRIP001     SdrObject* pObj = NULL;
//STRIP001     if( pView )
//STRIP001     {
//STRIP001         const SdrMarkList & rMarkList = pView->GetMarkList();
//STRIP001         if( rMarkList.GetMarkCount() > 0 )
//STRIP001             pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001     }
//STRIP001 
//STRIP001     return pObj;
//STRIP001 }

//STRIP001 void SchFuDraw::ApplyMoveResizeChanges()
//STRIP001 {
//STRIP001     SdrObject* pObj = GetCurrentlyMarkedObject();
//STRIP001 
//STRIP001     if( pChDoc &&
//STRIP001         pView )
//STRIP001     {
//STRIP001         pChDoc->SetUseRelativePositions( TRUE );
//STRIP001         if( pObj->ISA( SchObjGroup ) )
//STRIP001         {
//STRIP001             SchObjGroup* pGrp = static_cast< SchObjGroup* >( pObj );
//STRIP001             pGrp->SetGroupMoved( TRUE );
//STRIP001             if( SchObjGroup::DIAGRAM == pGrp->GetGroupType())
//STRIP001             {
//STRIP001                 pChDoc->BuildChart( FALSE );
//STRIP001                 // remark diagram object
//STRIP001                 SdrPageView* pPV  = pView->GetPageViewPvNum( 0 );
//STRIP001                 pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage( 0 ), 0, IM_DEEPWITHGROUPS ), pPV );
//STRIP001             }
//STRIP001         }
//STRIP001         else if( pObj->ISA( SdrTextObj ))
//STRIP001         {
//STRIP001             UINT16 nObjId = CHOBJID_ANY;
//STRIP001             SchObjectId * pObjId = GetObjectId( *pObj );
//STRIP001             if( pObjId )
//STRIP001                 nObjId = pObjId->GetObjId();
//STRIP001 
//STRIP001             if( CHOBJID_ANY != nObjId )
//STRIP001                 pChDoc->SetHasBeenMoved( nObjId, TRUE );
//STRIP001         }
//STRIP001     }
//STRIP001 }
}
