/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: new_foil.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:46:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SD_NEW_FOIL_HXX_
#define _SD_NEW_FOIL_HXX_

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif
#ifndef _VALUESET_HXX //autogen
#include <svtools/valueset.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif

#ifndef _PRESENTATION_HXX
#include "pres.hxx"
#endif

class SfxItemSet;

namespace sd {
class DrawDocShell;
}


/*************************************************************************
|*
|* Dialog zur Auswahl eines Folienlayouts
|*
\************************************************************************/
class SdNewFoilDlg : public ModalDialog
{
private:
	PageKind			ePageKind;
	Edit				aEdtName;
	FixedLine			aFlName;
	FixedText			aFtLayout;
	ValueSet			aCtlLayout;
	CheckBox			aCbxBackground;
	CheckBox			aCbxObjects;
	FixedLine			aFlDisplay;
	PushButton			aBtnDelete;
	OKButton			aBtnOK;
	CancelButton		aBtnCancel;
	HelpButton			aBtnHelp;

	const SfxItemSet&	rOutAttrs;
	::sd::DrawDocShell*     pDocSh;

	void				Reset();

	AutoLayout			GetAutoLayout() const;
	BOOL				SetAutoLayout( const AutoLayout eAutoLayout );

	virtual BOOL		Close();

	virtual void		DataChanged( const DataChangedEvent& rDCEvt );
	void				ApplyImages();

public:
						SdNewFoilDlg( Window* pWindow,
									  const SfxItemSet& rInAttrs,
									  PageKind ePgKind,
									  ::sd::DrawDocShell* pDocShell,
									  BOOL bChangeFoil );
						~SdNewFoilDlg();

	void				GetAttr( SfxItemSet& rOutAttrs );

	DECL_LINK( ClickLayoutHdl, void * );
	DECL_LINK( ClickCancelHdl, void * );
};

#endif // _SD_NEW_FOIL_HXX_

