/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: documentproperties.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 10:59:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef	__FRAMEWORK_SERVICES_DOCUMENTPROPERTIES_HXX_
#define	__FRAMEWORK_SERVICES_DOCUMENTPROPERTIES_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XSERVICEINFO_HXX_
#include <macros/xserviceinfo.hxx>
#endif

#ifndef __FRAMEWORK_HELPER_FIXEDDOCUMENTPROPERTIES_HXX_
#include <helper/fixeddocumentproperties.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XPERSIST_HPP_
#include <com/sun/star/io/XPersist.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _CPPUHELPER_PROPSHLP_HXX
#include <cppuhelper/propshlp.hxx>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _TIMESTAMP_HXX
#include <tools/timestamp.hxx>
#endif

#ifndef _SOT_STORAGE_HXX
#include <sot/storage.hxx>
#endif

#include <hash_map>

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	We must save our user optional properties.
	We implement this as a hashtable for strings.
*//*-*************************************************************************************************************/

struct tIMPL_StringHashCode
{
	size_t operator()( const ::rtl::OUString& sString ) const
	{
		return sString.hashCode();
	}
};

typedef ::std::hash_map<	::rtl::OUString					,
							::rtl::OUString					,
							tIMPL_StringHashCode			,
							std::equal_to< ::rtl::OUString >	> tIMPL_PropertyHashTable;

/*-************************************************************************************************************//**
	@short		set and get information about properties of an document
	@descr		You can use this class to set and get properties of an document. Some properties are predefined!
				But you can add and remove user defined properties.

	@implements	XServiceInfo
				XTypeProvider
				XPersist
				XNameContainer
				XNameReplace
				XNameAccess
				XElementAccess
				XPropertySet
				XFastPropertySet
				XMultiPropertySet

	@base		ThreadHelpBase
				OWeakObject
				OBroadcastHelper
				OPropertySetHelper

	@devstatus	ready to use
*//*-*************************************************************************************************************/

class DocumentProperties	:	public css::lang::XTypeProvider			,
								public css::lang::XServiceInfo			,
								public css::io::XPersist				,
								public css::container::XNameContainer	,	// -> XNameReplace -> XNameAccess -> XElementAccess
								public ThreadHelpBase						,	// Struct for right initalization of mutex member! Must be first of baseclasses.
								public ::cppu::OBroadcastHelper			,
								public ::cppu::OPropertySetHelper		,	// -> XPropertySet, XFastPropertySet, XMultiPropertySet
								public ::cppu::OWeakObject
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------

	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		standard constructor to create instance by factory
			@descr		This constructor initialize a new instance of this class by valid factory,
						and set valid values on his member and baseclasses.

			@seealso	-

			@param		"xFactory" is our global service manager, which create this instance.
						The value must be different from NULL!
			@return		-

			@onerror	ASSERT in debug version or nothing in relaese version.
		*//*-*****************************************************************************************************/

	 	DocumentProperties( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory );

		/*-****************************************************************************************************//**
			@short		standard destructor
			@descr		This method destruct an instance of "DocumentProperties" and
						clear some member. (for example: hashtable)

			@seealso	-

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual	~DocumentProperties();

		//---------------------------------------------------------------------------------------------------------
		//	XInterface, XTypeProvider, XServiceInfo
		//---------------------------------------------------------------------------------------------------------

		FWK_DECLARE_XINTERFACE
		FWK_DECLARE_XTYPEPROVIDER
		DECLARE_XSERVICEINFO

		//---------------------------------------------------------------------------------------------------------
		//	XPersist
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		read document properties from URL
			@descr      URL must be a valid storage!

			@seealso	interface XPersist

			@param		"sURL"	name of storage file
			@return		-

			@onerror    URL empty			=>	IOException
						URL not a storage	=> 	IOException
						open stream failed	=> 	IOException
						wrong headertype	=> 	IOException
						DocUserKey's empty	=> 	IOException
						general read error	=> 	IOException
		*//*-*****************************************************************************************************/

    	virtual void SAL_CALL read( const ::rtl::OUString& sURL ) throw(	css::io::IOException		,
																			css::uno::RuntimeException	);

		/*-****************************************************************************************************//**
			@short		read properties from URL
			@descr		URL must be a valid storage!

			@seealso	interface XPersist

			@param		"sURL"	name of storage file
			@return		-

			@onerror    URL empty			=>	IOException
						URL not a storage	=> 	IOException
						open stream failed	=> 	IOException
						general write error	=> 	IOException
		*//*-*****************************************************************************************************/

	    virtual void SAL_CALL write( const ::rtl::OUString& sURL ) throw(	css::io::IOException		,
																			css::uno::RuntimeException	);

		//---------------------------------------------------------------------------------------------------------
		//	XNameContainer
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		insert persistent property
			@descr		This method insert a persistent property. You can set name and value of this.
						But type must be "string" everytime!

			@seealso	interface XNameContainer

			@param      "sName"		Name of new persistent property
			@param      "aValue"	Value of new persistent property
			@return		-

			@onerror	IllegalArgumentException, if you call this with an invalid argument
						ElementExistException	, if element with same name already exist
						WrappedTargetException	, if an unknown exception is catched
						RuntimeException		, if something is wrong (not enough memory ...)
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL insertByName(	const	::rtl::OUString&	sName	,
											const	css::uno::Any&		aValue	) throw(	css::lang::IllegalArgumentException		,
																	 						css::container::ElementExistException	,
																	 						css::lang::WrappedTargetException		,
																	 						css::uno::RuntimeException				);

		/*-****************************************************************************************************//**
			@short		remove persistent property from instance
			@descr		This method remove a persistent property by name.

			@seealso	interface XNameContainer

			@param      "sName" Name of property to remove
			@return		-

			@onerror	NoSuchElementException, if exist no such element with this name
						WrappedTargetException, if an unknown exception is catched
						RuntimeException	  , if something is wrong (not enough memory ...)
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL removeByName( const ::rtl::OUString& sName ) throw(	css::container::NoSuchElementException	,
																					css::lang::WrappedTargetException		,
																					css::uno::RuntimeException				);

		//---------------------------------------------------------------------------------------------------------
		//	XNameReplace
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		replace value of persistent property
			@descr		This change the value of an existing persistent property.

			@seealso	interface XNameReplace

			@param      "sName"		Name of property
			@param      "aValue"	New value of property
			@return		-

			@onerror	IllegalArgumentException, if you call this with an invalid argument
						NoSuchElementException	, if exist no such element with this name
						WrappedTargetException	, if an unknown exception is catched
						RuntimeException	 	, if something is wrong (not enough memory ...)
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL replaceByName(	const	::rtl::OUString&	sName	,
												const	css::uno::Any&		aValue	) throw(	css::lang::IllegalArgumentException		,
																								css::container::NoSuchElementException	,
																								css::lang::WrappedTargetException		,
																								css::uno::RuntimeException				);

		//---------------------------------------------------------------------------------------------------------
		//	XNameAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		get value of persistent property given by name
			@descr		The type of this value is string everytime!

			@seealso	interface XNameAccess

			@param      "sName"	Name of property
			@return		Value of property as string.

			@onerror	NoSuchElementException, if exist no such element with this name
						WrappedTargetException, if an unknown exception is catched
						RuntimeException	  , if something is wrong (not enough memory ...)
		*//*-*****************************************************************************************************/

		virtual css::uno::Any SAL_CALL getByName( const ::rtl::OUString& sName ) throw(	css::container::NoSuchElementException	,
																						css::lang::WrappedTargetException		,
																						css::uno::RuntimeException				);

		/*-****************************************************************************************************//**
			@short		give names of all persistent properties
			@descr		Don't use this names for transient properties (XPropertySet...)!

			@seealso	interface XNameAccess

			@param      -
			@return		List of property names.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual css::uno::Sequence< ::rtl::OUString > SAL_CALL getElementNames() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		search for a property with same name
			@descr		You can test, if a property with this name exist.

			@seealso	interface XNameAccess

			@param      "sName"	Name of searched property
			@return		sal_True - if property exist, sal_False otherway.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual sal_Bool SAL_CALL hasByName( const ::rtl::OUString& sName ) throw( css::uno::RuntimeException );

		//---------------------------------------------------------------------------------------------------------
		//	XElementAccess
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		return type of ALL persistent properties
			@descr		All persistent properties have the same type! [OUString]

			@seealso	interface XElementAccess

			@param      -
			@return		type of persistent properties - [OUString]

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual css::uno::Type SAL_CALL getElementType() throw( css::uno::RuntimeException );

		/*-****************************************************************************************************//**
			@short		return state of namecontainer
			@descr		Use this method to get information, if any properties exist or not.

			@seealso	interface XElementAccess

			@param      -
			@return		sal_True if some properties exist, sal_False otherway

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		virtual sal_Bool SAL_CALL hasElements() throw( css::uno::RuntimeException );

	//-------------------------------------------------------------------------------------------------------------
	//	private methods
	//-------------------------------------------------------------------------------------------------------------

	private:

		//---------------------------------------------------------------------------------------------------------
		//	OPropertySetHelper
		//---------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		try to convert a property value
			@descr		This method is calling from helperclass "OPropertySetHelper".
						Don't use this directly!
						You must try to convert the value of given propertyhandle and
						return results of this operation. This will be use to ask vetoable
						listener. If no listener have a veto, we will change value realy!
						( in method setFastPropertyValue_NoBroadcast(...) )

			@seealso	OPropertySetHelper
			@seealso	setFastPropertyValue_NoBroadcast()

			@param		"aConvertedValue"	new converted value of property
			@param		"aOldValue"			old value of property
			@param		"nHandle"			handle of property
			@param		"aValue"			new value of property
			@return		sal_True if value will be changed, sal_False otherway

			@onerror	IllegalArgumentException, if you call this with an invalid argument
		*//*-*****************************************************************************************************/

		virtual sal_Bool SAL_CALL convertFastPropertyValue(			css::uno::Any&		aConvertedValue	,
																	css::uno::Any&		aOldValue		,
																	sal_Int32			nHandle			,
															const	css::uno::Any&		aValue			) throw( css::lang::IllegalArgumentException );

		/*-****************************************************************************************************//**
			@short		set value of a transient property
			@descr		This method is calling from helperclass "OPropertySetHelper".
						Don't use this directly!
						Handle and value are valid everyway! You must set the new value only.
						After this, baseclass send messages to all listener automaticly.

			@seealso	OPropertySetHelper

			@param      "nHandle"	handle of property to change
			@param      "aValue"	new value of property
			@return		-

			@onerror	An exception is thrown.
		*//*-*****************************************************************************************************/

		virtual void SAL_CALL setFastPropertyValue_NoBroadcast(			sal_Int32		nHandle	,
							  									const	css::uno::Any&	aValue	) throw( css::uno::Exception );

		/*-****************************************************************************************************//**
			@short		get value of a transient property
			@descr		This method is calling from helperclass "OPropertySetHelper".
						Don't use this directly!

			@seealso	OPropertySetHelper

			@param      "nHandle"	handle of property to change
			@param      "aValue"	current value of property
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

        using cppu::OPropertySetHelper::getFastPropertyValue;
		virtual void SAL_CALL getFastPropertyValue(	css::uno::Any&	aValue	,
							  						sal_Int32		nHandle	) const;

		/*-****************************************************************************************************//**
			@short      return structure and information about transient properties
			@descr		This method is calling from helperclass "OPropertySetHelper".
						Don't use this directly!

			@seealso	OPropertySetHelper

			@param		-
			@return		structure with property-informations

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual ::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();

		/*-****************************************************************************************************//**
			@short		return propertysetinfo
			@descr		You can call this method to get information about transient properties
						of this object.

			@seealso	XPropertySet
			@seealso	XMultiPropertySet

			@param		-
			@return		reference to object with information [XPropertySetInfoRef]

			@onerror	-
		*//*-*****************************************************************************************************/

		virtual css::uno::Reference< css::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo() throw (::com::sun::star::uno::RuntimeException);

		/*-****************************************************************************************************//**
			@short		return list of our persistent properties
			@descr		We support transient and persistent properties.
						For our helper we need a list of fixed property names - This method create it as static struct.

			@seealso	helper OPropertySetHelper

			@param		-
			@return		Static list of property names.

			@onerror	No error should occure.
		*//*-*****************************************************************************************************/

		static const css::uno::Sequence< css::beans::Property > impl_getStaticPropertyDescriptor();

		/*-****************************************************************************************************//**
			@short		methods to try to change a value of a property
			@descr		This method is used by "convertFastPropertyValue()". There are different
						methods for different basetypes of properties.

			@seealso	convertFastPropertyValue()

			@param		"...Property"		reference to property
			@param		"aValue"			new value of property
			@param		"aOldValue"			current value of property
			@param		"aConvertedValue"	new converted value of property

			@return		sal_True if value has changed, sal_False otherway

			@onerror	IllegalArgumentException, if you call this with an invalid argument.
		*//*-*****************************************************************************************************/

		sal_Bool impl_tryToChangeProperty( const ::rtl::OUString&  	 				sCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const css::util::DateTime&				aCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const sal_Bool&  						bCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const sal_Int16& 						nCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const sal_uInt16& 						nCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const sal_Int32& 						nCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );
		sal_Bool impl_tryToChangeProperty( const css::uno::Sequence< sal_Int8 >&	lCurrentValue, const css::uno::Any& aNewValue, css::uno::Any& aOldValue, css::uno::Any& aConvertedValue ) throw( css::lang::IllegalArgumentException );

		/*-****************************************************************************************************//**
			@short		impl. method to read properties from opened stream
			@descr		Is used by method "XPersist::read()".

			@seealso    method read()

			@param		"aStream"	reference to opened stream for reading
			@return		-

			@onerror    wrong headertype	=> 	IOException
						DocUserKey's empty	=> 	IOException
						general read error	=> 	IOException
		*//*-*****************************************************************************************************/

		void impl_readProperties( SvStream& aStream ) throw(	css::io::IOException		,
								  								css::uno::RuntimeException	);

		/*-****************************************************************************************************//**
			@short		impl. method to read properties from opened xml stream
			@descr		Is used by method "XPersist::read()".

			@seealso    method read()

			@param		"aStream"	reference to opened stream for reading
			@return		-

			@onerror    wrong headertype	=> 	IOException
						DocUserKey's empty	=> 	IOException
						general read error	=> 	IOException
		*//*-*****************************************************************************************************/


		void impl_readXMLProperties( SvStream& aStream ) throw(	css::io::IOException		,
								  								css::uno::RuntimeException	);

		/*-****************************************************************************************************//**
			@short		impl. method to write properties to opened stream
			@descr		Is used by method "XPersist::write()".

			@seealso	method write()

			@param		"aStream"	reference to opened stream for writing
			@return		-

			@onerror    general write error	=> 	IOException
		*//*-*****************************************************************************************************/

		void impl_writeProperties( SvStream& aStream ) throw(	css::io::IOException		,
								 								css::uno::RuntimeException	);

		/*-****************************************************************************************************//**
			@short		impl. method to write properties to opened stream
			@descr		Is used by method "XPersist::write()".

			@seealso	method write()

			@param		"aStream"	reference to opened stream for writing
			@return		-

			@onerror    general write error	=> 	IOException
		*//*-*****************************************************************************************************/

		void impl_writeXMLProperties( SvStream& aStream ) throw(	css::io::IOException		,
								  								css::uno::RuntimeException	);
		
		/*-****************************************************************************************************//**
			@short		help methods to read variables with different types from stream
			@descr		Sometimes we must convert a readed value or look for somethings else.
						These methods do that.

			@seealso	impl_readStream()

			@param		"aStream"	reference to stream for reading
			@param		"nFixSize"	some strings have a fixed size in file
									(Use this parameter to read all bytes from stream for this string.
									If "nFixSize" == 0, this option is ignored!)
			@return     read value

			@onerror	An IOException is thrown.
		*//*-*****************************************************************************************************/

		void impl_readFromStream( SvStream& aStream, ::rtl::OUString&					sValue, const sal_uInt16& nFixSize = 0	) const;
		void impl_readFromStream( SvStream& aStream, css::uno::Sequence< sal_Int8 >&	lValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_Bool&							bValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_Int8&							nValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_Int16&							nValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_uInt16&						nValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_Int32&							nValue 									) const;
		void impl_readFromStream( SvStream& aStream, sal_uInt32&						nValue 									) const;

		/*-****************************************************************************************************//**
			@short		help methods to write variables with different types to stream
			@descr		Sometimes we must convert a value or look for somethings else.
						These methods do that.

			@seealso	impl_writeStream()

			@param		"aStream"	reference to stream for writing
			@param		"nFixSize"	some strings have a fixed size in file
									(Use this parameter to write all bytes to stream for this string.
									If "nFixSize" == 0, this option is ignored!)
			@return     -

			@onerror	-
		*//*-*****************************************************************************************************/

		void impl_writeToStream( SvStream& aStream,	const	::rtl::OUString&				sValue, const sal_uInt16& nFixSize = 0	);
		void impl_writeToStream( SvStream& aStream,	const	css::uno::Sequence< sal_Int8 >&	lValue									);
		void impl_writeToStream( SvStream& aStream,	const	sal_Bool&						bValue									);
		void impl_writeToStream( SvStream& aStream,	const	sal_Int8&						nValue									);
		void impl_writeToStream( SvStream& aStream,	const	sal_Int16&						nValue									);
		void impl_writeToStream( SvStream& aStream,	const	sal_uInt16&						nValue									);
		void impl_writeToStream( SvStream& aStream,	const	sal_Int32&						nValue  								);
		void impl_writeToStream( SvStream& aStream,	const	sal_uInt32&						nValue  								);

		/*-****************************************************************************************************//**
			@short		convert a format-ID to right MIMEType
			@descr		Use "aStaticConvertTable[]" to do that!

			@seealso	aStaticConvertTable[] in CXX-file

			@param		"nFormatID"		index in aStaticConvertTable[] to get right MIMEType
			@return		MIMEType as string

			@onerror	-
		*//*-*****************************************************************************************************/

		::rtl::OUString impl_FormatID2MIMEType( sal_uInt32 nFormatID ) const;

		/*-****************************************************************************************************//**
			@short		convert a format-ID to right fileversion
			@descr		Use "aStaticConvertTable[]" to do that!

			@seealso	aStaticConvertTable[] in CXX-file

			@param		"nFormatID"		index in aStaticConvertTable[] to get right fileversion
			@return		fileversion as long

			@onerror	-
		*//*-*****************************************************************************************************/

		sal_Int32 impl_FormatID2FileVersion( sal_uInt32 nFormatID ) const;

		/*-****************************************************************************************************//**
			@short		check fileversion for right value
			@descr		There exist 4 right values for this only. This method check it.

			@seealso	SOFFICE_FILEVERSION_31 ... SOFFICE_FILEVERSION_NOW in "tools/solar.h"

			@param		"nFileVersion"		value to check
			@return		sal_True	, if version ok
			@return		sal_False	, if version invalid

			@onerror	-
		*//*-*****************************************************************************************************/

		sal_Bool impl_isFileVersionValid( sal_Int32 nFileVersion ) const;

		/*-****************************************************************************************************//**
			@short		follow methods convert a timestamp->datetime and datetime->timestamp
			@descr		We can't use a DateTime-object directly as UNO-Type! We must use a
						DateTime-structure. But TimeStamp can't use this. We must convert variables.

			@seealso	tools/TimeStamp
			@seealso	tools/DateTime
			@seealso	struct ::com::sun::star::util::DateTime

			@param      "aTimeStamp"	reference to TimeStamp-object
			@param      "aDateTime"		reference to DateTime-structure
			@return		a TimeStamp-object or a DateTime-structure

			@onerror	-
		*//*-*****************************************************************************************************/

		css::util::DateTime	impl_TimeStamp2DateTime(	const	TimeStamp&				aTimeStamp	) const;
		TimeStamp			impl_DateTime2TimeStamp(	const	css::util::DateTime&	aDateTime	) const;

		/*-****************************************************************************************************//**
			@short		set default values on members of this class and free used memory
			@descr		Is used to reset state of object. (for example before read new properties from stream!)

			@seealso	DocumentProperties()
			@seealso	read()

			@param		-
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		void impl_resetObject();

		/*-****************************************************************************************************//**
			@short		reset values of a datetime-structure
			@descr		We can't use DateTime-object from tools directly as property type!
						We must use a DateTime-struct. And this method set default values
						for struct-members.

			@seealso	struct ::com::sun::star::util::DateTime

			@param		"aDateTime"	reference to structure to reset
			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

		void impl_resetDateTime( css::util::DateTime& aDateTime );

	//-------------------------------------------------------------------------------------------------------------
	//	debug methods
	//	(should be private everyway!)
	//-------------------------------------------------------------------------------------------------------------

		/*-****************************************************************************************************//**
			@short		debug-method to check incoming parameter of some other mehods of this class
			@descr		The following methods are used to check parameters for other methods
						of this class. The return value is used directly for an ASSERT(...).

			@seealso	ASSERTs in implementation!

			@param		references to checking variables
			@return		sal_False ,on invalid parameter
			@return		sal_True  ,otherwise

			@onerror	-
		*//*-*****************************************************************************************************/

	#ifdef ENABLE_ASSERTIONS

	private:

		static sal_Bool impldbg_checkParameter_DocumentProperties	(	const	css::uno::Reference< css::lang::XMultiServiceFactory >&	xFactory	);
    	static sal_Bool impldbg_checkParameter_read					(	const	::rtl::OUString&										sURL		);
	    static sal_Bool impldbg_checkParameter_write				(	const	::rtl::OUString&										sURL		);
		static sal_Bool impldbg_checkParameter_insertByName			(	const	::rtl::OUString&										sName		,
																		const	css::uno::Any&											aValue 		);
		static sal_Bool impldbg_checkParameter_removeByName			(	const	::rtl::OUString&										sName		);
		static sal_Bool impldbg_checkParameter_replaceByName		(	const	::rtl::OUString&										sName		,
													   					const	css::uno::Any&											aValue		);
		static sal_Bool impldbg_checkParameter_getByName			(	const	::rtl::OUString&										sName		);
		static sal_Bool impldbg_checkParameter_hasByName			(	const	::rtl::OUString&										sName		);

	#endif // ENABLE_ASSERTIONS

		/*-****************************************************************************************************//**
			@short		debug-method to check state of a SvStream
			@descr		We don't control SvStream everytime ... (Performance!)
						But for debugging and testing, you can activate this by set
						define "SWITCH_ON_CHECK_SVSTREAM". This mechanism is used
						in all "impl_readXXXX()"- and "impl_writeXXXX"-methods.

			@seealso	impl_readXXX() and impl_writeXXX() methods

			@param		"aStream"	reference to stream for checking
			@param		"sCaller"	string with name of method, who is calling this method! (logged in file)

			@return		-

			@onerror	-
		*//*-*****************************************************************************************************/

	#ifdef ENABLE_SVSTREAM_CHECK

	private:

		void impldbg_checkSvStream(			SvStream&	aStream	,
									const	OString&	sCaller	);

	#endif // ENABLE_SVSTREAM_CHECK

	//-------------------------------------------------------------------------------------------------------------
	//	private variables
	//-------------------------------------------------------------------------------------------------------------

	private:
		css::uno::Reference< css::lang::XMultiServiceFactory >		m_xFactory					;	/// Reference to factory, which has create this instance.
		tIMPL_PropertyHashTable										m_aPropertyHash				;	/// hashtable for persistent properties (used by XNameContainer)
		::rtl::OUString												m_sHeaderType				;	/// Typename of header
		sal_uInt16													m_nHeaderVersion			;	/// Version number of header
		rtl_TextEncoding											m_eFileEncoding				;	/// encoding of documentinfo (is sal_uInt16 in file !)
		sal_uInt32													m_nFormatID					;	/// Used to set MIMEType and FileVersion, if not exist in document or has invalid value
		FixedDocumentProperties										m_aFixedProperties			;	/// struct which includes all fixed properties

};		// class DocumentProperties

}		// namespace framework

#endif	// __FRAMEWORK_SERVICES_DOCUMENTPROPERTIES_HXX_
