/*************************************************************************
 *
 *  $RCSfile: rmtpacc.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:28:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTPACC_HXX_
#include <rmtpacc.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_REMOTECONTENTPROVIDERCHANGEACTION_HPP_
#include <com/sun/star/ucb/RemoteContentProviderChangeAction.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_REMOTECONTENTPROVIDERCHANGEEVENT_HPP_
#include <com/sun/star/ucb/RemoteContentProviderChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCHANGELISTENER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCONNECTIONCONTROL_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderConnectionControl.hpp>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _UCBHELPER_CONFIGURATIONKEYS_HXX_
#include <ucbhelper/configurationkeys.hxx>
#endif
#ifndef _UCBHELPER_CONFIGUREUCB_HXX_
#include <ucbhelper/configureucb.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _UCPRMT_RMTPAID_HXX_
#include <rmtpaid.hxx>
#endif

using namespace com::sun;
using namespace com::sun::star;
using namespace ucprmt;

//============================================================================
//
//  ConnectionControlToken
//
//============================================================================

namespace {

class ConnectionControlToken: public cppu::OWeakObject
{
public:
    ConnectionControlToken(
        uno::Reference< star::ucb::XRemoteContentProviderAcceptor > const &
            rAcceptor,
        rtl::OUString const & rIdentifier);

    virtual ~ConnectionControlToken() throw ();

    virtual inline uno::Any SAL_CALL queryInterface(uno::Type const & rType)
        throw (uno::RuntimeException)
    { return OWeakObject::queryInterface(rType); }

    virtual inline void SAL_CALL acquire() throw ()
    { OWeakObject::acquire(); }

    virtual inline void SAL_CALL release() throw ()
    { OWeakObject::release(); }

private:
    uno::Reference< star::ucb::XRemoteContentProviderAcceptor > m_xAcceptor;
    rtl::OUString m_aIdentifier;
};

}

//============================================================================
ConnectionControlToken::ConnectionControlToken(
    uno::Reference< star::ucb::XRemoteContentProviderAcceptor > const &
        rAcceptor,
    rtl::OUString const & rIdentifier):
    m_xAcceptor(rAcceptor),
    m_aIdentifier(rIdentifier)
{
    OSL_ENSURE(rAcceptor.is(), "null rAcceptor");
}

//============================================================================
// virtual
ConnectionControlToken::~ConnectionControlToken() throw ()
{
    try
    {
        m_xAcceptor->removeRemoteContentProvider(m_aIdentifier);
    }
    catch (uno::RuntimeException &)
    {
        OSL_ENSURE(false, "com::sun::star::uno::RuntimeException caught");
    }
}

//============================================================================
//
//  ProviderAcceptor
//
//============================================================================

inline
ProviderAcceptor::Data::Data(
	uno::Reference< lang::XMultiServiceFactory > const & rTheFactory,
	uno::Reference< star::ucb::XRemoteContentProviderDoneListener > const &
	    rTheDoneListener):
	m_xFactory(rTheFactory),
	m_xDoneListener(rTheDoneListener)
{}

//============================================================================
inline void ProviderAcceptor::checkDisposed()
    throw (lang::DisposedException)
{
    if (m_bDisposed)
        throw lang::DisposedException(rtl::OUString(), *this);
}

//============================================================================
ProviderAcceptor::ProviderAcceptor(
	uno::Reference< lang::XMultiServiceFactory > const & rTheFactory):
    m_aEventListeners(m_aMutex),
    m_aChangeListeners(m_aMutex),
	m_xFactory(rTheFactory),
	m_aUcbServiceSpecifier(RTL_CONSTASCII_USTRINGPARAM(
		                       "com.sun.star.ucb.UniversalContentBroker")),
    m_bDisposed(false),
	m_bActivated(false)
{
	OSL_ASSERT(m_xFactory.is());
}

//============================================================================
// static
void
ProviderAcceptor::setExternalUcb(
	uno::Reference< star::ucb::XRemoteContentProviderAcceptor > const &
	    rAcceptor,
	rtl::OUString const & rServiceSpecifier)
{
	OSL_ASSERT(rAcceptor.is());
	ProviderAcceptor * pThis
		= static_cast< ProviderAcceptor * >(rAcceptor.get());

	OSL_ASSERT(!pThis->m_xUcb.is());
	pThis->m_aUcbServiceSpecifier = rServiceSpecifier;
}

//============================================================================
bool ProviderAcceptor::activate(Map::iterator const & rIt)
	throw (uno::RuntimeException)
{
	if (!m_xUcb.is())
		try
		{
			m_xUcb = uno::Reference< star::ucb::XContentProviderManager >(
				         m_xFactory->createInstance(m_aUcbServiceSpecifier),
						 uno::UNO_QUERY);
		}
		catch (uno::RuntimeException const &) { throw; }
		catch (uno::Exception const &) {}

	// Register the remote UCB, using the appropriate data from the
	// configuration database:
	uno::Sequence< uno::Any > aArgs(4);
	aArgs[0] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
		                           UCB_CONFIGURATION_KEY1_SERVER));
	aArgs[1] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
		                           UCB_CONFIGURATION_KEY2_CLIENT_ACCESS));
	aArgs[2] <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("FACTORY"));
	aArgs[3] <<= rIt->first; //@@@ URI-encode
	return ::ucb::configureUcb(m_xUcb,
							   m_xFactory,
							   aArgs,
							   &rIt->second.m_aProviders);
}

//============================================================================
void
ProviderAcceptor::notifyChangeListeners(
    rtl::OUString const & rIdentifier,
    star::ucb::RemoteContentProviderChangeAction eAction)
{
    uno::Sequence< uno::Reference< uno::XInterface > > aElements;
    {
        osl::MutexGuard aGuard(m_aMutex);
        aElements = m_aChangeListeners.getElements();
    }
    if (aElements.getLength() > 0)
    {
        star::ucb::RemoteContentProviderChangeEvent
            aEvent(*this, rIdentifier, eAction);
        for (sal_Int32 i = 0; i < aElements.getLength(); ++i)
        {
            uno::Reference< star::ucb::XRemoteContentProviderChangeListener >
                xListener(aElements[i], uno::UNO_QUERY);
            if (xListener.is())
                xListener->remoteContentProviderChange(aEvent);
        }
    }
}

//============================================================================
// virtual
ProviderAcceptor::~ProviderAcceptor() throw ()
{}

//============================================================================
// virtual
uno::Any SAL_CALL ProviderAcceptor::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any
		aRet(cppu::queryInterface(
			     rType,
				 static_cast< lang::XServiceInfo * >(this),
				 static_cast< lang::XTypeProvider * >(this),
				 static_cast< lang::XComponent * >(this),
				 static_cast< star::ucb::XRemoteContentProviderAcceptor * >(
					 this),
				 static_cast< star::ucb::XRemoteContentProviderActivator * >(
					 this),
				 static_cast< star::ucb::XRemoteContentProviderSupplier * >(
					 this),
				 static_cast<
                         star::ucb::XRemoteContentProviderChangeNotifier * >(
					 this),
				 static_cast<
				         star::ucb::XRemoteContentProviderDoneListener * >(
					 this),
				 static_cast< lang::XUnoTunnel * >(this)));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL ProviderAcceptor::acquire() throw ()
{
	OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL ProviderAcceptor::release() throw ()
{
	OWeakObject::release();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL ProviderAcceptor::getImplementationName()
	throw (uno::RuntimeException)
{
	return rtl::OUString::createFromAscii(getImplementationName_static());
}

//============================================================================
// virtual
sal_Bool SAL_CALL ProviderAcceptor::supportsService(rtl::OUString const &
													    rServiceName)
	throw (uno::RuntimeException)
{
	uno::Sequence< rtl::OUString > aNames(getSupportedServiceNames_static());
	for (sal_Int32 i = 0; i < aNames.getLength(); ++i)
		if (aNames[i] == rServiceName)
			return true;
	return false;
}

//============================================================================
// virtual
uno::Sequence< rtl::OUString > SAL_CALL
ProviderAcceptor::getSupportedServiceNames() throw (uno::RuntimeException)
{
	return getSupportedServiceNames_static();
}

//============================================================================
// virtual
uno::Sequence< uno::Type > SAL_CALL ProviderAcceptor::getTypes()
	throw (uno::RuntimeException)
{
	static cppu::OTypeCollection * pCollection = 0;
	if (!pCollection)
	{
		osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
		if (!pCollection)
		{
			static cppu::OTypeCollection
				aTheCollection(
					getCppuType(
						static_cast< uno::Reference< lang::XServiceInfo >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference< lang::XTypeProvider >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference< lang::XComponent >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						           star::ucb::XRemoteContentProviderAcceptor >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						          star::ucb::XRemoteContentProviderActivator >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						           star::ucb::XRemoteContentProviderSupplier >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						     star::ucb::XRemoteContentProviderChangeNotifier >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						       star::ucb::XRemoteContentProviderDoneListener >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference< lang::XUnoTunnel >
						                 const * >(
							0)));
			pCollection = &aTheCollection;
		}
	}
	return pCollection->getTypes();
}

//============================================================================
// virtual
uno::Sequence< sal_Int8 > SAL_CALL ProviderAcceptor::getImplementationId()
	throw (uno::RuntimeException)
{
	return
		uno::Sequence< sal_Int8 >(aProviderAcceptorImplementationId,
								  sizeof aProviderAcceptorImplementationId);
}

//============================================================================
// virtual
void SAL_CALL ProviderAcceptor::dispose() throw (uno::RuntimeException)
{
    {
        osl::MutexGuard aGuard(m_aMutex);
        checkDisposed();
        m_bDisposed = true;
    }

    lang::EventObject aEvent(*this);
    m_aEventListeners.disposeAndClear(aEvent);
    m_aChangeListeners.disposeAndClear(aEvent);
}

//============================================================================
// virtual
void SAL_CALL
ProviderAcceptor::addEventListener(
    uno::Reference< lang::XEventListener > const & rListener)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bDisposed)
        m_aEventListeners.addInterface(rListener);
}

//============================================================================
// virtual
void SAL_CALL
ProviderAcceptor::removeEventListener(
    uno::Reference< lang::XEventListener > const & rListener)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bDisposed)
        m_aEventListeners.removeInterface(rListener);
}

//============================================================================
// virtual
sal_Bool SAL_CALL
ProviderAcceptor::addRemoteContentProvider(
	rtl::OUString const & rIdentifier,
	uno::Reference< lang::XMultiServiceFactory > const & rFactory,
	uno::Sequence< rtl::OUString > const & rTemplates,
	uno::Reference< star::ucb::XRemoteContentProviderDoneListener > const &
	    rDoneListener)
	throw (uno::RuntimeException)
{
    bool bSuccess;
    {
	    osl::MutexGuard aGuard(m_aMutex);

        checkDisposed();

	    std::pair< Map::iterator, bool >
		    aInsert(m_aMap.insert(Map::value_type(rIdentifier,
                                                  Data(rFactory,
                                                       rDoneListener))));
	    if (!aInsert.second)
		    return false;

        try
        {
            uno::Reference<
                    star::ucb::XRemoteContentProviderConnectionControl >
                m_xConnectionControl(rDoneListener, uno::UNO_QUERY);
            OSL_ENSURE(m_xConnectionControl.is(), "no connection control");
            if (m_xConnectionControl.is())
                m_xConnectionControl->
                    enableConnectionControl(this,
                                            *new ConnectionControlToken(
                                                     this, rIdentifier));
        }
        catch (uno::RuntimeException &)
        {
            m_aMap.erase(aInsert.first);
            return false;
        }

        if (m_bActivated)
            bSuccess = activate(aInsert.first);
        else
        {
            m_aActivations.push_back(aInsert.first);
            bSuccess = true;
        }
    }

    notifyChangeListeners(
        rIdentifier, star::ucb::RemoteContentProviderChangeAction_ADDED);
    return bSuccess;
}

//============================================================================
// virtual
sal_Bool SAL_CALL
ProviderAcceptor::removeRemoteContentProvider(rtl::OUString const &
											      rIdentifier)
	throw (uno::RuntimeException)
{
    {
        osl::MutexGuard aGuard(m_aMutex);

        checkDisposed();

        Map::iterator aIt(m_aMap.find(rIdentifier));
        if (aIt == m_aMap.end())
            return false;

        if (m_bActivated)
		    ::ucb::unconfigureUcb(m_xUcb, aIt->second.m_aProviders);
        else
            m_aActivations.remove(aIt);

        m_aMap.erase(aIt);
        if (m_bActivated && m_aMap.size() == 0)
            m_xUcb = 0;
    }

    notifyChangeListeners(
        rIdentifier, star::ucb::RemoteContentProviderChangeAction_REMOVED);
	return true;
}

//============================================================================
// virtual
uno::Reference< star::ucb::XContentProviderManager > SAL_CALL
ProviderAcceptor::activateRemoteContentProviders()
	throw (uno::RuntimeException)
{
	osl::MutexGuard aGuard(m_aMutex);

    checkDisposed();

	if (!m_bActivated)
	{
		m_bActivated = true;
		List::iterator aEnd(m_aActivations.end());
		for (List::iterator aIt(m_aActivations.begin()); aIt != aEnd; ++aIt)
			activate(*aIt);
        m_aActivations.clear();
	}
	return m_xUcb;
}

//============================================================================
// virtual
uno::Reference< lang::XMultiServiceFactory > SAL_CALL
ProviderAcceptor::queryRemoteContentProvider(rtl::OUString const &
											     rIdentifier)
	throw (uno::RuntimeException)
{
	osl::MutexGuard aGuard(m_aMutex);

    checkDisposed();

	Map::iterator aIt(m_aMap.find(rIdentifier));
	if (aIt == m_aMap.end())
		return 0;
	else
		return aIt->second.m_xFactory;
}

//============================================================================
// virtual
void SAL_CALL
ProviderAcceptor::addRemoteContentProviderChangeListener(
    uno::Reference< star::ucb::XRemoteContentProviderChangeListener > const &
        rListener)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bDisposed)
        m_aChangeListeners.addInterface(rListener);
}

//============================================================================
// virtual
void SAL_CALL
ProviderAcceptor::removeRemoteContentProviderChangeListener(
    uno::Reference< star::ucb::XRemoteContentProviderChangeListener > const &
        rListener)
    throw (uno::RuntimeException)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (!m_bDisposed)
        m_aChangeListeners.removeInterface(rListener);
}

//============================================================================
// virtual
void SAL_CALL
ProviderAcceptor::doneWithRemoteContentProviders(
	uno::Reference< star::ucb::XRemoteContentProviderAcceptor > const &
	    rAcceptor)
	throw (uno::RuntimeException)
{
	OSL_ENSURE(!rAcceptor.is(),
			   "ucprmt::ProviderAcceptor::doneWithRemoteContentProviders():"
			   " Non null acceptor ignored");

	typedef std::vector< uno::Reference<
		                     star::ucb::XRemoteContentProviderDoneListener > >
		Listeners;
	Listeners aListeners;
	{
		osl::MutexGuard aGuard(m_aMutex);

        checkDisposed();

		aListeners.reserve(m_aMap.size());
		for (Map::const_iterator aIt(m_aMap.begin()); aIt != m_aMap.end();
			 ++aIt)
		{
			if (aIt->second.m_xDoneListener.is())
				aListeners.push_back(aIt->second.m_xDoneListener);
		}
	}

	for (Listeners::const_iterator aIt(aListeners.begin());
		 aIt != aListeners.end(); ++aIt)
		(*aIt)->doneWithRemoteContentProviders(this);
}

//============================================================================
// virtual
sal_Int64 SAL_CALL
ProviderAcceptor::getSomething(uno::Sequence< sal_Int8 > const & rIdentifier)
	throw (uno::RuntimeException)
{
	// This method only works if
	//   reinterpret_cast< sal_Int64 >(setExternalUcb) == 0
	// is always false:
    if (rIdentifier.getLength() == sizeof aProviderAcceptorImplementationId
        && rtl_compareMemory(aProviderAcceptorImplementationId,
							 rIdentifier.getConstArray(),
							 sizeof aProviderAcceptorImplementationId)
		       == 0)
    {
		// Some compilers (notably on the MACOSX and LINUX POWERPC platforms)
		// misinterpret the expression
		//   reinterpret_cast< sal_Int64 >(setExternalUcb)
		// and try to reinterpret_cast setExternalUcb's return value (which is
		// void) instead of setExternalUcb's memory address; hence, the
		// expression is rewritten:
		SetExternalUcb * pMethod = setExternalUcb;
		return reinterpret_cast< sal_Int64 >(pMethod);
    }
    else
        return 0;
}

//============================================================================
// static
sal_Char const * ProviderAcceptor::getImplementationName_static()
{
	return "com.sun.star.comp.ucb.ucp.remote.ProviderAcceptor";
}

//============================================================================
// static
uno::Sequence< rtl::OUString >
ProviderAcceptor::getSupportedServiceNames_static()
{
	uno::Sequence< rtl::OUString > aNames(1);
	aNames[0] = rtl::OUString::createFromAscii(
		            "com.sun.star.ucb.RemoteContentProviderAcceptor");
	return aNames;
}

//============================================================================
// static
uno::Reference< uno::XInterface > SAL_CALL
ProviderAcceptor::createInstance(
	uno::Reference< lang::XMultiServiceFactory > const & rTheFactory)
{
	return
		static_cast< uno::XWeak * >(static_cast< cppu::OWeakObject * >(
			                            new ProviderAcceptor(rTheFactory)));
}
