/*************************************************************************
 *
 *  $RCSfile: wpfolder.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <svpm.h>
#include <solar.h>

#ifndef _OSL_DIAGNOSE_H
#include <osl/diagnose.h>
#endif

#ifndef _DEBUG_HXX
#include <debug.hxx>
#endif

#include <folder.hxx>
#include <ExtAttr.hxx>

const char cBackSlash = '\\';

class aTmpClass : public NAMESPACE_VOS(OThread)
{
	WPSBaseImpl * m_pBase;
	Link		* m_pLink;
	String		  m_aLocation;

    BOOL		  m_bIsPopulated;
    BOOL          m_bIsPending;

    NAMESPACE_VOS(OMutex) *m_pMutex;

public:
    aTmpClass(WPSBaseImpl *, String&);
    ~aTmpClass() { delete m_pMutex; };

    sal_Bool create();

    inline BOOL isPopulated() { NAMESPACE_VOS(OGuard) aGuard(m_pMutex); return m_bIsPopulated; };
    inline BOOL isPending() { NAMESPACE_VOS(OGuard) aGuard(m_pMutex); return m_bIsPending; };
    inline void reset() { NAMESPACE_VOS(OGuard) aGuard(m_pMutex); m_bIsPopulated = FALSE; };

	virtual void run();
};

aTmpClass::aTmpClass(WPSBaseImpl *pBase, String& rLocation)
{
	m_pBase		   = pBase;
	m_aLocation	   = rLocation;
    m_bIsPopulated = FALSE;
    m_bIsPending   = FALSE;

    m_pMutex = new OMutex;
}

sal_Bool aTmpClass::create()
{
    NAMESPACE_VOS(OGuard) aGuard(m_pMutex);
    m_bIsPending = TRUE;

    return NAMESPACE_VOS(OThread)::create();
}

void aTmpClass::run()
{
    CHAR szBuffer[10];

	m_pBase->sendRequest((PSZ) m_aLocation.GetStr(), POPULATE_FOLDER, &szBuffer, 10);

    // set isPopulated flag even if request failed
    m_bIsPopulated = TRUE;

    NAMESPACE_VOS(OGuard) aGuard(m_pMutex);
    m_bIsPending = FALSE;
}

/***************************************************************************************
 *
 * WinFolderImpl - Implementation
 *
 ***************************************************************************************
 */

//define static members
WPSBaseImpl *WinFolderImpl::m_pBase = 0;

/*------------------------------------------------------------------------------------
 * Constructor
 *------------------------------------------------------------------------------------
 */

WinFolderImpl::WinFolderImpl(const ItemIDPath& rPath, const FindFlags aFlags) : FolderImpl(rPath)
{
	EnsureBase();

	// a valid folder must have a location
    m_aLocation = rPath.GetHostNotationPath();

    // m_aLocation must not have an '\\' at the end
    USHORT nLen = m_aLocation.Len();
    if(nLen && m_aLocation.GetChar(--nLen) == '\\')
        m_aLocation.Erase(nLen);

	m_aThread	= new aTmpClass(m_pBase, m_aLocation);
}

/*------------------------------------------------------------------------------------
 * Destructor
 *------------------------------------------------------------------------------------
 */

WinFolderImpl::~WinFolderImpl()
{
    CHAR szBuffer[20];

	if(m_aThread)
        delete m_aThread;

    // release wps objects
    m_pBase->sendRequest((PSZ) m_aLocation.GetStr(), RELEASE_LOCK, szBuffer, sizeof(szBuffer));
}

/*------------------------------------------------------------------------------------
 * EnsureBase()
 *------------------------------------------------------------------------------------
 */

void WinFolderImpl::EnsureBase()
{
	if(m_pBase == 0)
	{
		m_pBase = new WPSBaseImpl;

                if(m_pBase)
                {
                    DosExitList(EXLST_ADD | 0x00004200, (PFNEXITLIST) DestroyBase);
                }
        }

}

/*------------------------------------------------------------------------------------
 * DestroyBase()
 *------------------------------------------------------------------------------------
 */

void WinFolderImpl::DestroyBase()
{
	if(m_pBase)
		delete m_pBase;
}

/*------------------------------------------------------------------------------------
 * isAvailable()
 *------------------------------------------------------------------------------------
 */

Boolean WinFolderImpl::isAvailable()
{
	EnsureBase();
	return m_pBase && m_pBase->isAvailable();
}

/*------------------------------------------------------------------------------------
 * queryHandle()
 *------------------------------------------------------------------------------------
 */

Boolean WinFolderImpl::queryHandle(PSZ pszObject, HOBJECT *phObject)
{
	EnsureBase();
	return m_pBase && m_pBase->queryHandle(pszObject, phObject, sizeof(HOBJECT));
}

/*------------------------------------------------------------------------------------
 * queryLocation()
 *------------------------------------------------------------------------------------
 */
#define HINIBBLE( byte )   (((UCHAR)(byte) & 0xF0) >> 4)
#define LONIBBLE( byte )   ((UCHAR)(byte) & 0x0F)
#define MAKEBYTE( lo, hi ) ( ((UCHAR)(lo) & 0x0F) | (((UCHAR)(hi) & 0x0F) << 4) )

String WinFolderImpl::queryLocation(PSZ pszObject)
{
	CHAR szBuffer[CCHMAXPATHCOMP];

	EnsureBase();

	if(m_pBase && m_pBase->sendRequest(pszObject, GET_OBJECT_LOCATION,
									   &szBuffer, sizeof(szBuffer)))
	{
		return String(szBuffer);
	}

	return String();
}

/*------------------------------------------------------------------------------------
 * queryIcon()
 *------------------------------------------------------------------------------------
 */
static inline CHAR NibbleToChar( BYTE nibble )
{
    if( nibble < 0x0A )
        return '0' + nibble;
    else if( nibble < 0x10 )
        return 'A' + ( nibble - 0x0A );
    else
        return '?';
}

String WinFolderImpl::HandleToString(LHANDLE hIcon)
{
    CHAR  szBuffer[12] = ">";
    PSZ   pszString = szBuffer + 1;
    PBYTE pBytes = (PBYTE) &hIcon;
    BYTE  nCRC   = 0;
    BYTE  cbSize = sizeof(LHANDLE);

    while( cbSize-- )
    {
        BYTE b = *(pBytes++);

        *(pszString++) = NibbleToChar( LONIBBLE( b ) );
        *(pszString++) = NibbleToChar( HINIBBLE( b ) );

        nCRC ^= b;
    }

    // write a checksum to validate on reading
    *(pszString++) = NibbleToChar( LONIBBLE( nCRC ) );
    *(pszString++) = NibbleToChar( HINIBBLE( nCRC ) );

    *pszString     = '\0';

    return String(szBuffer);
}

/*------------------------------------------------------------------------------------
 * queryTitle()
 *------------------------------------------------------------------------------------
 */

String WinFolderImpl::queryTitle(PSZ pszObject)
{
	CHAR szBuffer[CCHMAXPATHCOMP];
	String aRet;

	EnsureBase();

	if(m_pBase &&
	   m_pBase->sendRequest((PSZ) pszObject, GET_OBJECT_INFO, &szBuffer, sizeof(szBuffer)))
	{
		wps_objectInfo *pInfo = (wps_objectInfo *) szBuffer;
		aRet = &pInfo->szTitle[pInfo->cbName];
	}

	return aRet;
}

/*------------------------------------------------------------------------------------
 * queryObjectInfo
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::queryObjectInfo(PSZ pszObject, PVOID pBuffer, ULONG ulSize)
{
	EnsureBase();

	return m_pBase && m_pBase->sendRequest((PSZ) pszObject, GET_OBJECT_INFO, pBuffer, ulSize);
}

/*------------------------------------------------------------------------------------
 * queryLinkInfo
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::queryLinkInfo(PSZ pszObject, PVOID pBuffer, ULONG ulSize)
{
	EnsureBase();

	return m_pBase && m_pBase->sendRequest((PSZ) pszObject, GET_LINK_INFO, pBuffer, ulSize);
}


/*------------------------------------------------------------------------------------
 * isValid
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::isValid() const
{
	// invalid folder if location empty
	return m_aLocation.Len() != 0;
}

/*------------------------------------------------------------------------------------
 * extractObject()
 *------------------------------------------------------------------------------------
 */

String WinFolderImpl::extractObject(const ItemIDPath& rIDPath)
{
	String aPath = extractPath(rIDPath);
	String aRet;
	USHORT nPos = aPath.Len();

	// find last special object token
	for(; nPos > 0; nPos--)
	{
		if(aPath.GetChar(nPos - 1) == '<')
			break;
	}

	// nPos == 0 means no special object token found
	if(nPos)
	{
		aRet = aPath.Copy(nPos - 1);

		// if token is not the last one
		if(aRet.GetTokenCount('\\') > 1)
		{
			CHAR   szBuffer[CCHMAXPATHCOMP];

			// query object location
			if(m_pBase->sendRequest((PSZ) aRet.GetToken(0, '\\').GetStr(),
									GET_OBJECT_LOCATION, &szBuffer, sizeof(szBuffer)))
				aRet.SetToken(0, '\\',szBuffer);
			else
				return String();
		}
	}
	else
	{
		aRet = m_aLocation;
		aRet += '\\';
		aRet += aPath;
	}

	return aRet;
}

/*------------------------------------------------------------------------------------
 * ExtractLocation()
 *------------------------------------------------------------------------------------
 */

String WinFolderImpl::extractLocation(const ItemIDPath& rIDPath)
{
	ItemIDPathData *pIDData = (ItemIDPathData *) rIDPath.GetDataPtr();

	String aPath = pIDData->sLocation;
    String aRet;

	if(aPath.Len() == 0)
	{
        aPath = m_aLocation;
		aPath += '\\';
		aPath += extractPath(rIDPath);
	}

	USHORT nPos = aPath.Len();

	// find last special object token
	for(; nPos > 0; nPos--)
	{
		if(aPath.GetChar(nPos - 1) == '<')
			break;
	}

	// nPos == 0 means no special object token found
	if(nPos)
	{
		CHAR   szBuffer[CCHMAXPATHCOMP];

		aRet = aPath.Copy(nPos - 1);

		// query object location
		if(m_pBase->sendRequest((PSZ) aRet.GetToken(0, '\\').GetStr(),
								GET_OBJECT_LOCATION, &szBuffer, sizeof(szBuffer)))
			aRet.SetToken(0, '\\',szBuffer);
		else
			return String();

		// save location information
		pIDData->sLocation = aRet;
	}
    else
        aRet = aPath;

	return aRet;
}

/*------------------------------------------------------------------------------------
 * GetValidObject()
 *------------------------------------------------------------------------------------
 */

String WinFolderImpl::GetValidObject(const String& rPath)
{
	String aTmp;
	USHORT nCount, nTokens = rPath.GetTokenCount(cBackSlash);

	// test if nLast is zero
	if(nTokens == 0)
		return rPath;
	
	// find last special object token
	for(nCount = nTokens; nCount > 0; nCount--)
	{
		aTmp = rPath.GetToken(nCount - 1, cBackSlash);
		if(aTmp.GetChar(0) == '<')
			break;
	}

	// if special object token found and it is not the last
	if(nCount > 0 && nCount < nTokens)
	{
		CHAR   szBuffer[CCHMAXPATHCOMP];

		// query object location 
		if(m_pBase->sendRequest((PSZ) aTmp.GetStr(), GET_OBJECT_LOCATION,
								&szBuffer, sizeof(szBuffer)))
			aTmp = szBuffer;
		else
			return String();

		// append the rest of the path
		aTmp += rPath.Copy(rPath.Search(rPath.GetToken(nCount, cBackSlash)) - 1);
	}

	return aTmp;
}

/*------------------------------------------------------------------------------------
 * isVirtual()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::isVirtual(const String& rUrl)
{
    USHORT nIndex = 0, nIndex2;

    do
    {
        // search the end of actual token
        nIndex2 = rUrl.Search('\\', nIndex);

        if(rUrl.GetChar(nIndex) == '<')
        {
            // set nIndex to the first character behind actual token
            if(nIndex2 == STRING_NOTFOUND)
                nIndex = rUrl.Len();
            else
                nIndex = nIndex2;

            if(rUrl.GetChar(nIndex - 1) == '>')
                return TRUE;

            nIndex++;
        }
        else
            nIndex = nIndex2 + 1;

    } while(nIndex2 != STRING_NOTFOUND);

    return FALSE;
}

/*------------------------------------------------------------------------------------
 * RestartEnum()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::RestartEnum(const FindFlags aFlags)
{
    m_aActual = String();
	return TRUE;
}

/*------------------------------------------------------------------------------------
 * BuildCRC()
 *------------------------------------------------------------------------------------
 */

UINT32 WinFolderImpl::BuildCRC(const FindFlags aFlags, BOOL bBreak)
{
    UINT32 nCRC = 0;
    BOOL   bRet;

	// do nothing if folder is not populated
	if(m_aThread->isPopulated() == FALSE)
		return 0;

    bRet = m_pBase->sendRequest((PSZ) m_aLocation.GetStr(), BUILD_CRC,
                                &nCRC, sizeof(nCRC));

    if(!bRet)
        m_aThread->reset();

	return nCRC;
}

/*------------------------------------------------------------------------------------
 * run()
 *------------------------------------------------------------------------------------
 */

void WinFolderImpl::run()
{
	static TimeValue aSleepTime = {5, 0};
	UINT32 n;

	// sleep while folder is not populated
	while(m_aThread->isPopulated() == FALSE)
		wait(aSleepTime);

	n = BuildCRC(FIND_FLAG_INCLUDE_ALL, TRUE);

	wait(aSleepTime);

	while(schedule())
    {
        if(m_aThread->isPopulated())
        {
            UINT32 nTmp = BuildCRC(FIND_FLAG_INCLUDE_ALL, TRUE);

            if(nTmp != n && m_aThread->isPopulated())
            {
                n = nTmp;
                getLink().Call(NULL);

                // repopulate folder to set lock on new object
                m_aThread->reset();
                m_aThread->create();
            }
		}

		wait(aSleepTime);
	}
}

/*------------------------------------------------------------------------------------
 * GetNextItem()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::GetNextItem(ItemIDPathData& rData)
{
	BOOL bRet;
	ItemIDPathData *pIDData = (ItemIDPathData *) GetItemIDPath().GetDataPtr();

	if(m_aActual.Len() == 0)
	{
		if(m_aThread->isPopulated())
		{
			bRet = m_pBase->sendRequest((PSZ) m_aLocation.GetStr(), FIND_FIRST_OBJECT,
                                        &rData.Cache.wpInfo, sizeof(rData.Cache));
//            m_aThread->reset();
		}
		else
        {
            if(!m_aThread->isPending())
                m_aThread->create();

			return FOLDER_PENDING;
		}
	}
	else
		bRet = m_pBase->sendRequest((PSZ) m_aActual.GetStr(), FIND_NEXT_OBJECT,
									&rData.Cache.wpInfo, sizeof(rData.Cache));

	if(bRet)
	{
		rData.sPath = rData.Cache.wpInfo.szName;
		rData.nImplFlags = ITEM_IMPL_FLAG_OBJ_INFO;

		if(rData.sPath.GetChar(0) == '<')
		{
			m_aActual		= rData.sPath;
			rData.sLocation = rData.sPath;
		}
		else
		{
			m_aActual = m_aLocation;
			m_aActual += '\\';
            m_aActual += rData.sPath;
		}

		return FOLDER_OK;
	}

	return FOLDER_NO_MORE_ITEMS;
}

/*------------------------------------------------------------------------------------
 * GetItemIDInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::GetItemIDInfo(const ItemIDPath& rPath, FastItemInfo& rInfo)
{
	ItemIDPathData *pIDData = (ItemIDPathData *) rPath.GetDataPtr();

	if(pIDData == NULL)
		return FALSE;

	CHAR   szBuffer[CCHMAXPATHCOMP + 10];
	String aObject = extractObject(rPath);

	// quick and dirty hack to filter two OS/2 specific folders
	static const char pszItemName[][25] =
	{
		"<WP_CONNECTIONSFOLDER>",
        "<WP_DRIVESSHADOW>",
        "<WP_NOWHERE>"
	};

	for(BYTE n = 0; n < 3; n++)
	{
		if(aObject == pszItemName[n])
			return FALSE;
	}

    String aFileName = (GetItemIDPath() + rPath).GetHostNotationPath();

    if(aFileName.Len())
        aObject = aFileName;

	// complete the information needed
	if(!(pIDData->nImplFlags & ITEM_IMPL_FLAG_OBJ_INFO))
	{
		if(m_pBase->sendRequest((PSZ) aObject.GetStr(), GET_OBJECT_INFO,
								&pIDData->Cache.wpInfo, sizeof(pIDData->Cache)))
		{
			pIDData->nImplFlags |= ITEM_IMPL_FLAG_OBJ_INFO;
		}
		else
		{
			return FALSE;
		}
	}

	rInfo.aDisplayName = &pIDData->Cache.wpInfo.szTitle[pIDData->Cache.wpInfo.cbName];
	rInfo.aItemKind	   = ITEM_KIND_NAMESPACE;
	rInfo.aAttributes  = 0;

	if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_COPY))
		rInfo.aAttributes |= ITEM_FLAG_COPYABLE;

	if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_MOVE))
		rInfo.aAttributes |= ITEM_FLAG_MOVABLE;

	if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_DELETE))
		rInfo.aAttributes |= ITEM_FLAG_DISCARDABLE;

	if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_LINK))
		rInfo.aAttributes |= ITEM_FLAG_LINKABLE;

	if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_RENAME))
		rInfo.aAttributes |= ITEM_FLAG_RENAMABLE;

	if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_LINK)
		rInfo.aAttributes |= ITEM_FLAG_ISLINK;

	// replace \n with blanks
	USHORT nIndex = 0;
	while(( nIndex = rInfo.aDisplayName.SearchAndReplace( "\n", " ", nIndex +1))
		   != STRING_NOTFOUND )
        ;

    rInfo.aDisplayName.EraseAllChars('\r');

    if(pIDData->Cache.wpInfo.hIcon)
    {
        rInfo.aIconLocation = HandleToString(pIDData->Cache.wpInfo.hIcon);
    }

    /*
     * set folder information and replace icon location
     */

	if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_FILESYSTEM)
	{
		rInfo.aAttributes |= ITEM_FLAG_ISFILESYSTEM;

		if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_FOLDER)
		{
			rInfo.aAttributes |= ITEM_FLAG_ISFOLDER |
				ITEM_FLAG_HASSUBFOLDERS |
                ITEM_FLAG_HASITEMS;

            if(!isVirtual(aObject))
                rInfo.aItemKind = ITEM_KIND_FILESYSTEM;
		}
		else
		{
			// handle files als filesystem kind
			rInfo.aItemKind = ITEM_KIND_FILESYSTEM;

			// do not test for .type EA for directories
            rInfo.aContent = StringEA(aFileName, ".TYPE");

            if(rInfo.aContent.Compare("UniformResourceLocator") == COMPARE_EQUAL)
            {
                rInfo.aAttributes |= ITEM_FLAG_ISLINK;
            }
		}
	}

	return TRUE;
}

/*------------------------------------------------------------------------------------
 * getItemInfo()
 *------------------------------------------------------------------------------------
 */
#if 0
void WinFolderImpl::getItemInfo(const wps_objectInfo *pInfo, FastItemInfo&rInfo)
{
}
#endif

/*------------------------------------------------------------------------------------
 * GetFileInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::GetFileInfo(const ItemIDPath& rPath, FastFileInfo& rInfo)
{
	APIRET rc;
	String aFileName = extractLocation(rPath);

	if(aFileName.Len())
	{
		FILESTATUS3 fStatus;

		if(NO_ERROR == (rc = DosQueryPathInfo(aFileName, FIL_STANDARD, &fStatus, sizeof(FILESTATUS3))))
		{
			DosFolderImpl::getFileInfo(&fStatus, rInfo);
			rInfo.aFileName = aFileName.GetToken(aFileName.GetTokenCount('\\') - 1, '\\');

			return TRUE;
		}
	}

	return FALSE;
}

/*------------------------------------------------------------------------------------
 * GetNameSpaceInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::GetNameSpaceInfo(const ItemIDPath& rPath, NameSpaceInfo& rInfo)
{
	rInfo.aNameSpaceKind = NAMESPACE_KIND_UNKNOWN;
	rInfo.aClassName	 = "";

	return TRUE;
}


/*------------------------------------------------------------------------------------
 * GetLinkFileInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::GetLinkFileInfo(const ItemIDPath& rPath, LinkFileInfo& rInfo)
{
	ItemIDPathData *pIDData = (ItemIDPathData *) rPath.GetDataPtr();
	String			aObject = extractObject(rPath);

	if(pIDData == NULL)
		return FALSE;

	if(pIDData->nImplFlags & ITEM_IMPL_FLAG_OBJ_INFO)
    {
        if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_LINK)
        {
            CHAR szBuffer[3 * CCHMAXPATHCOMP];

            if(m_pBase->sendRequest((PSZ) aObject.GetStr(), GET_LINK_INFO, szBuffer, sizeof(szBuffer)))
            {
                PSZ pszTarget = ((wps_linkInfo *) szBuffer)->szTarget;

                rInfo.aTargetPath = ItemIDPath(pszTarget);

                if(pszTarget[0] == '<')
                    rInfo.aTargetURL = rInfo.aTargetPath.GetBinaryDescription();
                else
                    rInfo.aTargetURL = rInfo.aTargetPath.GetFileDescription();

                if(m_pBase->sendRequest(pszTarget, GET_OBJECT_ICON, szBuffer, sizeof(szBuffer)))
                {
                    rInfo.aIconLocation = szBuffer;
                }

                return TRUE;
            }
        }
        else
        {
            rInfo.aTargetURL = UrlEA(aObject, ".CLASSINFO");
            return TRUE;
        }
	}
	
	return FALSE;
}

/*------------------------------------------------------------------------------------
 * RenameItem()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::RenameItem(const ItemIDPath& rPath, ItemIDPath& rNewPath, const String& rNewName)
{
	String aObject = extractObject(rPath);

	aObject += '\n';
	aObject += rNewName;

	CHAR szBuffer[CCHMAXPATHCOMP];
	if(m_pBase->sendRequest((PSZ) aObject.GetStr(), RENAME_OBJECT, szBuffer, sizeof(szBuffer)))
	{
        ItemIDPath aParent;
        USHORT nIndex = 0;

        aObject = ((wps_objectInfo *) szBuffer)->szName;

        // replace brackets for special objects
        while(( nIndex = aObject.SearchAndReplace( '<', *VIRTUAL_URL_OPENBRACKET, nIndex ))
              != STRING_NOTFOUND )
            ;

        nIndex = 0;
        while(( nIndex = aObject.SearchAndReplace( '>', *VIRTUAL_URL_CLOSEBRACKET, nIndex ))
              != STRING_NOTFOUND )
            ;

		BOOL bRet = ItemIDPath(aObject).Split(aParent, rNewPath);

		// check if split works correctly
		DBG_ASSERT(bRet, "Rename: Split of destination path failed.\n");

		return TRUE;
	}

	return FALSE;
}

/*------------------------------------------------------------------------------------
 * DeleteItem()
 *------------------------------------------------------------------------------------
 */

BOOL WinFolderImpl::DeleteItem(const ItemIDPath& rPath)
{
	CHAR   szBuffer[10];
	String aObject = extractObject(rPath);

	return m_pBase->sendRequest((PSZ) aObject.GetStr(), DELETE_OBJECT,
								szBuffer, sizeof(szBuffer));
}

/*------------------------------------------------------------------------------------
 * GetContextMenu()
 *------------------------------------------------------------------------------------
 */

IfcContextMenu* WinFolderImpl::GetContextMenu(const ItemIDPath& rPath)
{
    ItemIDPathData *pIDData = (ItemIDPathData *) rPath.GetDataPtr();

    if(pIDData == NULL)
        return NULL;

    String aObject = GetValidObject(pIDData->sPath);

    if(isVirtual(aObject))
    {
        return new IfcContextMenuImpl(aObject);
    }

    return NULL;
};



/***************************************************************************************
 *
 * ProgFolderImpl - Implementation
 *
 ***************************************************************************************
 */

/*------------------------------------------------------------------------------------
 * GetNextItem()
 *------------------------------------------------------------------------------------
 */

BYTE ProgFolderImpl::GetNextItem(ItemIDPathData& rData)
{
    BYTE nRet;

	while(nRet = WinFolderImpl::GetNextItem(rData))
    {
        if(nRet == FOLDER_PENDING)
            return nRet;

        if(rData.sPath.Compare("<WP_", 4) != COMPARE_EQUAL)
            return TRUE;

        rData.nImplFlags = 0;
        rData.sLocation  = String();
	}

	return FALSE;
}


/***************************************************************************************
 *
 * WorkplaceImpl - Implementation
 *
 ***************************************************************************************
 */
		   
/*------------------------------------------------------------------------------------
 * Constructor
 *------------------------------------------------------------------------------------
 */

WorkplaceImpl::WorkplaceImpl(const ItemIDPath& rPath, const FindFlags aFlags) : DrivesFolderImpl(ItemIDPath(FOLDER_ROOT))
{
	m_nCurrent = 0;
}

/*------------------------------------------------------------------------------------
 * GetNextItem()
 *------------------------------------------------------------------------------------
 */


BOOL WorkplaceImpl::GetNextItem(ItemIDPathData& rData)
{
	static const char pszItemName[][20] =
	{
		"<WP_DESKTOP>",
		"<WP_NETWORK>",
		"<WP_OS2SYS>",
		"<WP_COOLURLSFOLDER>"
	};

	while(m_nCurrent < 3)
	{
		rData.sPath		 = pszItemName[m_nCurrent++];
		rData.sLocation	 = rData.sPath;

		return TRUE;
	}

	return DrivesFolderImpl::GetNextItem(rData);
}

/*------------------------------------------------------------------------------------
 * RestartEnum()
 *------------------------------------------------------------------------------------
 */

BOOL WorkplaceImpl::RestartEnum(const FindFlags aFlags)
{
	m_nCurrent = 0;
	return DrivesFolderImpl::RestartEnum(aFlags);
}

/*------------------------------------------------------------------------------------
 * GetItemIDInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WorkplaceImpl::GetItemIDInfo(const ItemIDPath& rPath, FastItemInfo& rInfo)
{
	ItemIDPathData *pIDData = (ItemIDPathData *) rPath.GetDataPtr();

	if(pIDData == NULL)
		return FALSE;

	if(pIDData->sPath.GetChar(0) == '<')
	{
        // complete the information needed
        if(!(pIDData->nImplFlags & ITEM_IMPL_FLAG_OBJ_INFO))
        {
            if(WinFolderImpl::queryObjectInfo((PSZ) pIDData->sPath.GetStr(),
                                              &pIDData->Cache.wpInfo,
                                              sizeof(pIDData->Cache)))
            {
                pIDData->nImplFlags |= ITEM_IMPL_FLAG_OBJ_INFO;
            }
            else
            {
                return FALSE;
            }
        }

        rInfo.aItemKind	   = ITEM_KIND_NAMESPACE;
        rInfo.aDisplayName = &pIDData->Cache.wpInfo.szTitle[pIDData->Cache.wpInfo.cbName];

        // replace \n with blanks
        USHORT nIndex = 0;
        while(( nIndex = rInfo.aDisplayName.SearchAndReplace( '\n', ' ', nIndex ))
              != STRING_NOTFOUND )
            ;

        rInfo.aDisplayName.EraseAllChars('\r');

        // set icon location
        if(pIDData->Cache.wpInfo.hIcon)
        {
            rInfo.aIconLocation = WinFolderImpl::HandleToString(pIDData->Cache.wpInfo.hIcon);
        }

        // set folder information
        rInfo.aAttributes  = 0;

        if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_COPY))
            rInfo.aAttributes |= ITEM_FLAG_COPYABLE;

        if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_MOVE))
            rInfo.aAttributes |= ITEM_FLAG_MOVABLE;

        if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_DELETE))
            rInfo.aAttributes |= ITEM_FLAG_DISCARDABLE;

        if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_LINK))
            rInfo.aAttributes |= ITEM_FLAG_LINKABLE;

        if(!(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_DO_NOT_RENAME))
            rInfo.aAttributes |= ITEM_FLAG_RENAMABLE;

        if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_LINK)
            rInfo.aAttributes |= ITEM_FLAG_ISLINK;

        // set folder information
        if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_FILESYSTEM)
        {
            String aFileName = (GetItemIDPath() + rPath).GetHostNotationPath();
            rInfo.aAttributes |= ITEM_FLAG_ISFILESYSTEM;

            if(pIDData->Cache.wpInfo.attrObject & OBJECT_ATTRIB_IS_FOLDER)
            {
                rInfo.aAttributes |= ITEM_FLAG_ISFOLDER |
                    ITEM_FLAG_HASSUBFOLDERS |
                    ITEM_FLAG_HASITEMS;
            }
            else
            {
                // handle files als filesystem kind
                rInfo.aItemKind = ITEM_KIND_FILESYSTEM;

                // do not test for .type EA for directories
                rInfo.aContent	= StringEA(aFileName, ".TYPE");
            }
        }

        return TRUE;
    }

	return DrivesFolderImpl::GetItemIDInfo(rPath, rInfo);
}

/*------------------------------------------------------------------------------------
 * GetNameSpaceInfo()
 *------------------------------------------------------------------------------------
 */

BOOL WorkplaceImpl::GetNameSpaceInfo(const ItemIDPath& rPath, NameSpaceInfo& rInfo)
{
	rInfo.aNameSpaceKind = NAMESPACE_KIND_UNKNOWN;
	rInfo.aClassName	 = "";

	return TRUE;
}
