/*************************************************************************
 *
 *  $RCSfile: rmapplet.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef REMOTE_VERSION

#ifndef _RMAPPLET_HXX
#define _RMAPPLET_HXX

#include <tools/urlobj.hxx>

#ifndef _DCAOBJ_HXX
#include <dcca/object.hxx>
#endif

// -----------------------------------------------------------------------

DCA_NAMESPACE(OObjectBroker, dca)* ImpGetBroker();

// -----------------------------------------------------------------------


#define MSG_APPLET_BASE                 5000

#define MSG_APPLET_CREATE				MSG_APPLET_BASE + 0

#define MSG_APPLET_START				MSG_APPLET_BASE + 20
#define MSG_APPLET_STOP					MSG_APPLET_BASE + 21
#define MSG_APPLET_SETSIZE				MSG_APPLET_BASE + 22

#define MSG_SHOWSTATUS					MSG_APPLET_BASE + 50
#define MSG_GETAPPLET					MSG_APPLET_BASE + 51
#define MSG_GETAPPLETS					MSG_APPLET_BASE + 52
#define MSG_SHOWDOCUMENT				MSG_APPLET_BASE + 53
#define MSG_APPLETRESIZE				MSG_APPLET_BASE + 54
#define MSG_APPLETSTARTED				MSG_APPLET_BASE + 55
#define MSG_APPLETABORT					MSG_APPLET_BASE + 56

#define RMAPPLET_PACKAGE                      "stardiv.AppletView."

// -----------------------
// - class RmBasisObject -
// -----------------------

class RmBasisObject : public DCA_NAMESPACE(OObj , dca)
{
protected:
	const char*     pClassName;

public:
					RmBasisObject(  );

	virtual Boolean dispatchMessage( DCA_NAMESPACE(OCallMethodMsg , dca)& rMsg );
	DECL_LINK( executeMessage, DCA_NAMESPACE(OCallMethodMsg , dca)* );

};

// -----------------------------------------------------------------------

class RmAppletContext;
class SvCommandList;
// ----------------------
// - class RmAppletStub -
// ----------------------

class RmAppletStub : public RmBasisObject
{
public:
						RmAppletStub();

	void                Create( RmAppletContext* pContext,
								const INetURLObject& rDocBase,
								const SvCommandList & rList,
								const INetURLObject& rCodeBase,
								BOOL bMayScript );
	virtual void		appletResize(int width, int height) {}
	virtual void		appletStarted() {}
	virtual void		onAppletAbort() {}

};

// -----------------------------------------------------------------------

class RmAppletObject;

// -------------------------
// - class RmAppletContext -
// -------------------------

class RmAppletContext : public RmBasisObject
{
public:
								RmAppletContext( );

	virtual void				showStatus(const XubString & ) const {}
	virtual void				showDocument(const INetURLObject &pURL, const XubString &text) {}
	virtual RmAppletObject*		getApplet(String sName) const { return NULL; }
	virtual void				fillApplets( List & ) {}

	void						Create();

};

// -----------------------------------------------------------------------

// ------------------------
// - class RmAppletObject -
// ------------------------

class RmAppletObject : public RmBasisObject
{
public:
						RmAppletObject( );

	void                Create(const String& rClass, const String& rName,
								const RmAppletStub& rStub, const Window& rParent);
	void				Start( const Size & );
	void				Stop();
	void				SetSizePixel( const Size & );

};



#endif // _RMAPPLET_HXX

#endif // REMOTE_VERSION
