/*************************************************************************
 *
 *  $RCSfile: pusrinst.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:09:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include "maindlg.hxx"
#include "environ.hxx"
#include "script.hxx"
#include "os.hxx"
#include "sihelp.hxx"

#include "pusrinst.hxx"

#include "strings.hrc"
#include "maindlg.hrc"
#include "pusrinst.hrc"

PageUserDefined::PageUserDefined( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aGBModuleInfo	( this, ResId(GB_MODINFO, rResId.GetResMgr()) ),
	aPBDefault		( this, ResId(PB_DEFAULT, rResId.GetResMgr()) ),
	aModuleView		( this, ResId(LB_MODVIEW, rResId.GetResMgr()), GETDLG()->GetLanguage() ),
	aDescInfoText	( this, ResId(FT_DESCTEXT, rResId.GetResMgr()) ),
	aGBSizeInfo		( this, ResId(GB_SIZEINFO, rResId.GetResMgr()) ),
	aFTTarget		( this, ResId(FT_TARGETPATH, rResId.GetResMgr()) ),
	aFTSystem		( this, ResId(FT_SYSTEMPATH, rResId.GetResMgr()) ),
	aFTRequired		( this, ResId(FT_REQUIRED, rResId.GetResMgr()) ),
	aFTTempRequired	( this, ResId(FT_TEMP_REQUIRED, rResId.GetResMgr()) ),
	aFTExists		( this, ResId(FT_EXISTS, rResId.GetResMgr()) ),
	aFTRequiredT	( this, ResId(FT_REQUIRED_TARGET, rResId.GetResMgr()) ),
	aFTTempRequiredT( this, ResId(FT_TEMP_REQUIRED_TARGET, rResId.GetResMgr()) ),
	aFTExistsT		( this, ResId(FT_EXISTS_TARGET, rResId.GetResMgr()) ),
	aFTRequiredS	( this, ResId(FT_REQUIRED_SYS, rResId.GetResMgr()) ),
	aFTTempRequiredS( this, ResId(FT_TEMP_REQUIRED_SYS, rResId.GetResMgr()) ),
	aFTExistsS		( this, ResId(FT_EXISTS_SYS, rResId.GetResMgr()) ),
	aStrMaxModule	( ResId(STR_MAXMODULE, rResId.GetResMgr()) ),
	aStrMaxModules	( ResId(STR_MAXMODULES, rResId.GetResMgr()) ),
	m_bIsFat		( FALSE ),
	m_bIsSysFat		( FALSE )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

	m_pEnv = GETDLG()->GetEnv();

	if( !m_pEnv->IsFirstInstallation() )
		pParent->SetNextText( pParent->GetModifyText() );

	BOOL bHideSys = TRUE;
	aGBSizeInfo.Hide();
	aFTTarget.Hide();
	aFTSystem.Hide();
	aFTRequired.Hide();
	aFTTempRequired.Hide();
	aFTExists.Hide();
	aFTRequiredT.Hide();
	aFTTempRequiredT.Hide();
	aFTExistsT.Hide();
	aFTRequiredS.Hide();
	aFTTempRequiredS.Hide();
	aFTExistsS.Hide();

	if( m_pEnv->GetActiveModuleSet() || bHideSys )
	{
		aFTSystem.Hide();
		aFTRequiredS.Hide();
		aFTTempRequiredS.Hide();
		aFTExistsS.Hide();
	}
	if( m_pEnv->GetActiveModuleSet() || bHideSys )
	{
		aFTTarget.Hide();
		aFTExists.Hide();
		aFTExistsT.Hide();
	}

	aPBDefault.SetClickHdl( LINK(this, PageUserDefined, ClickHdl) );
	if( m_pEnv->IsResponsefileWizardMode() ) aPBDefault.Hide();

	m_lClusterSize	  = OS::GetClusterSize(SiDirEntry(m_pEnv->GetDestPath()));
	m_lSysClusterSize = OS::GetClusterSize(SiDirEntry(OS::GetGUIPath()));

	#ifdef OS2
	m_bIsFat 	= Os2OS::IsFATFileSystem( m_pEnv->GetDestPath() );
	m_bIsSysFat = Os2OS::IsFATFileSystem( OS::GetGUIPath() );
	#endif

	aModuleView.SetWindowBits( WB_HASBUTTONS | WB_HASBUTTONSATROOT | WB_HASLINES | WB_HASLINESATROOT | WB_HSCROLL);
	aModuleView.SetSelectHdl( LINK(this, PageUserDefined, SelectHdl) );
	aModuleView.SetCheckButtonHdl( LINK(this, PageUserDefined, CheckHdl) );
	aModuleView.SetWarnHdl( LINK(this, PageUserDefined, WarnHdl) );

	aModuleView.List( GETDLG()->GetCScript()->GetRootModule(),
				m_lClusterSize, FALSE /*m_eInstallMode == IM_WORKSTATION*/ );

	SiDirEntry	aEntry( m_pEnv->GetDestPath() );
	String		aText( aFTTarget.GetText() );
	#if defined(MAC)
	aText.SearchAndReplace( UniString::CreateFromAscii("%"), aEntry.GetVolume() );
	#else
	aText.SearchAndReplace( UniString::CreateFromAscii("%"), aEntry.GetDevice().GetFull() );
	#endif

	#if defined(UNX)
	Size aSz( aFTTarget.GetSizePixel() );
	aSz.Width() += 100;
	aFTTarget.SetSizePixel( aSz );
	#endif

	aFTTarget.SetText( aText );

	aEntry = OS::GetGUIPath();
	aText  = aFTSystem.GetText();
	#if defined(MAC)
	aText.SearchAndReplace( UniString::CreateFromAscii("%"), aEntry.GetVolume() );
	#else
	aText.SearchAndReplace( UniString::CreateFromAscii("%"), aEntry.GetDevice().GetFull() );
	#endif
	aFTSystem.SetText( aText );

/*	UpdateUsedSize();
	UpdateFreeSize();
*/
}

PageUserDefined::~PageUserDefined()
{
}

SvAgentPage* PageUserDefined::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageUserDefined( pParent, rResId );
}

void _TransformSelection2ModuleSet( SiModuleSet* pSet, SiModule* pMod )
{
	if( pMod->IsSelected() && pMod->GetParent() )
	{
		if( !pSet->Seek(pMod) ) pSet->Add( pMod );
	}
	else
		pSet->Remove( pMod );

	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		_TransformSelection2ModuleSet( pSet, pModuleList->GetObject(x) );
}

BOOL _HasSelection( SiModule* pMod )
{
	if( pMod->IsSelected() ) return TRUE;

	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		BOOL b = _HasSelection( pModuleList->GetObject(x) );
		if( b ) return TRUE;
	}
	return FALSE;
}

BOOL PageUserDefined::AllowNext()
{
	if( m_pEnv->GetActiveModuleSet() )
	{
		if( _HasSelection(GETDLG()->GetCScript()->GetRootModule()) )
			_TransformSelection2ModuleSet( m_pEnv->GetActiveModuleSet(), GETDLG()->GetCScript()->GetRootModule() );
		else
		{
			String aMessage( ResId(STR_NOSELECTION) );
			ErrorBox( this, WB_OK, aMessage ).Execute();
			return FALSE;
		}
		return TRUE;
	}

/*	if( !SiHelp::CheckInstallationSize(GETDLG()->GetCScript(), m_pEnv, m_pEnv->GetDestPath()) )
	{
		ErrorBox( this, WB_OK, String(ResId(STR_FULLDRIVE)) ).Execute();
		return FALSE;
	}
*/	return TRUE;
}

void PageUserDefined::UpdateUsedSize()
{
/*	SiEnvironment* pEnv = GETDLG()->GetEnv();
	SiModule*	pRoot			= GETDLG()->GetCScript()->GetRootModule();
	BOOL  		bWorkstation	= FALSE; // m_pEnv->GetInstallMode() == IM_WORKSTATION;

	ULONG  nSize			= pRoot->CalculateSize( *pEnv, SiModule::INSTALL,
							  m_lClusterSize, FALSE, bWorkstation, m_bIsFat );
	ULONG  nSizeDeinst		= pRoot->CalculateSize( *pEnv, SiModule::UNINSTALL,
							  m_lClusterSize, FALSE, bWorkstation, m_bIsFat );
	ULONG  nSysSize			= pRoot->CalculateSize( *pEnv, SiModule::INSTALL,
							  m_lSysClusterSize, TRUE, bWorkstation, m_bIsSysFat );
	ULONG  nSysSizeDeinst	= pRoot->CalculateSize( *pEnv, SiModule::UNINSTALL,
							  m_lSysClusterSize, TRUE, bWorkstation, m_bIsSysFat );
	ULONG  nTmpSize			= pRoot->CalculateSize( *pEnv, SiModule::TEMP,
							  m_lClusterSize, m_bIsFat );

	nSize += m_pEnv->GetMigrationSize();

	if( nSize >= nSizeDeinst )
		nSize -= nSizeDeinst;
	else
		nSize = 0;

	if( nSysSize >= nSysSizeDeinst )
		nSysSize -= nSysSizeDeinst;
	else
		nSysSize = 0;

	String aText;
	String aKBStr( ResId(STR_KB) );
	ULONG  nSizeSubSys		= (nSize >= nSysSize)? nSize - nSysSize : 0;
	BOOL   bTargetIsSystem	= SiDirEntry(m_pEnv->GetDestPath()).GetDevice()
							  == SiDirEntry(OS::GetGUIPath()).GetDevice();

	// benoetigter Speicher: Ziellaufwerk
	aText  = UniString::CreateFromInt32( (bTargetIsSystem ? nSize : nSizeSubSys) / 1024 );
	(aText += ' ') += aKBStr;
	aFTRequiredT.SetText(aText);

	// temporaerer Speicher: Ziellaufwerk
	aText  = UniString::CreateFromInt32( (bTargetIsSystem ? (nSize + nTmpSize) : nSizeSubSys + nTmpSize) / 1024 );
	(aText += ' ') += aKBStr;
	aFTTempRequiredT.SetText(aText);

	// benoetigter Speicher: Systemlaufwerk
	aText  = UniString::CreateFromInt32( (bTargetIsSystem ? nSize : nSysSize) / 1024 );
	(aText += ' ') += aKBStr;
	aFTRequiredS.SetText(aText);

	// temporaerer Speicher: Systemlaufwerk
	aText  = UniString::CreateFromInt32( (bTargetIsSystem ? (nSize + nTmpSize) : nSysSize) / 1024 );
	( aText += ' ') += aKBStr;
	aFTTempRequiredS.SetText( aText );
*/
}

void PageUserDefined::UpdateFreeSize()
{
/*	String aKBStr( ResId(STR_KB) );
	String aText = UniString::CreateFromInt32( OS::GetDriveSize(SiDirEntry(m_pEnv->GetDestPath())) );

	(aText += ' ') += aKBStr;
	aFTExistsT.SetText( aText );

	aText = UniString::CreateFromInt32( OS::GetDriveSize( SiDirEntry(OS::GetGUIPath())) );
	(aText += ' ') += aKBStr;
	aFTExistsS.SetText( aText );
*/
}

IMPL_LINK(PageUserDefined, SelectHdl, SiModuleView*, EMPTYARG)
{
	SvLBoxEntry *pEntry = aModuleView.GetCurEntry();
	if( pEntry != NULL )
	{
		SiModule* pModule = (SiModule*) pEntry->GetUserData();
		SiModule* pLangRef = NULL;
		if( pModule->HasLangRef() )
		{
			pLangRef = (SiModule*) pModule->GetLangRef( GETDLG()->GetLanguage() );
			if( pLangRef ) pLangRef->JoinWithParent();
		}
		UniString aMess = pLangRef?
				UniString( pLangRef->GetDescription(), Langcode2TextEncoding(GETDLG()->GetLanguage()) ) :
				UniString( pModule->GetDescription(), Langcode2TextEncoding(GETDLG()->GetLanguage()) );

		aDescInfoText.SetText( aMess );
	}
	return 0;
}

IMPL_LINK(PageUserDefined, CheckHdl, SiModuleView*, EMPTYARG)
{
	SvLBoxEntry *pEntry = aModuleView.GetCurEntry();
	SiModule* pModule = (SiModule*) pEntry->GetUserData();

	if( pEntry == NULL || pModule == NULL || pModule->DontSelectByUser() )
		return 0;

	BOOL bChecked = aModuleView.GetCheckButtonState(pEntry) == SV_BUTTON_CHECKED;

	UpdateUsedSize();
	SelectHdl( &aModuleView );

	SiModule* pLangRef = NULL;
	if( pModule->HasLangRef() )
	{
		pLangRef = (SiModule*) pModule->GetLangRef( GETDLG()->GetLanguage() );
		if( pLangRef ) pLangRef->JoinWithParent();
	}

    ByteString aText;
    if ( pLangRef )
        aText = bChecked ? pLangRef->GetOnSelect() : pLangRef->GetOnDeselect();
    else
        aText = bChecked ? pModule->GetOnSelect() : pModule->GetOnDeselect();
    
	if( aText.Len() > 0 )
	{
		UniString aInfoText( aText, Langcode2TextEncoding(GETDLG()->GetLanguage()) );
		InfoBox aIBox( GetAgentDlg(), aInfoText );
		aIBox.Execute();
	}

	return 0;
}

void _DelAllSelectedFlags( SiModule* pMod )
{
	pMod->SetSelected( FALSE );
	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		_DelAllSelectedFlags( pModuleList->GetObject(x) );
}

IMPL_LINK(PageUserDefined, ClickHdl, Control*, pBtn)
{
	if( pBtn == &aPBDefault )
	{
		SiModule* pRoot = GETDLG()->GetCScript()->GetRootModule();
		if( m_pEnv->IsFirstInstallation() )
			pRoot->Select( SiModule::ALL_DEFAULT );
		else
			_DelAllSelectedFlags( pRoot );

		aModuleView.Clear();
		aModuleView.List( GETDLG()->GetCScript()->GetRootModule(),
						  m_lClusterSize, FALSE /*m_eInstallMode == IM_WORKSTATION*/ );

		UpdateUsedSize();
		SelectHdl( &aModuleView );
	}
	return 0;
}

IMPL_LINK(PageUserDefined, WarnHdl, SiModule*, pMod)
{
	String aMsg( pMod->GetMaxSelect() == 1? aStrMaxModule : aStrMaxModules );
	aMsg.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromAscii(pMod->GetName().GetBuffer()) );
	aMsg.SearchAndReplace( UniString::CreateFromAscii("%2"), UniString::CreateFromInt32(pMod->GetMaxSelect()) );

	ErrorBox(this, WB_OK, aMsg).Execute();
	return 0;
}

