/*************************************************************************
 *
 *  $RCSfile: kernelw9x.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hro $ $Date: 2001/07/30 14:36:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <windows.h>

//#include <LoadLibrary.h>
#include <GetModuleFileName.h>
#include <GetLogicalDriveStrings.h>
#include <DeleteFile.h>
#include <CopyFile.h>
#include <MoveFile.h>
#include <MoveFileEx.h>
#include <CreateFile.h>
#include <RemoveDirectory.h>
#include <GetFullPathName.h>

#include <systools/win32/AutoSystoolInit.hxx>
#include "..\inc\systsettings.h"

//------------------------------------------------------------------------
// forward declaration
//------------------------------------------------------------------------

static void WINAPI Kernel9xInit( );
static void WINAPI Kernel9xDeInit( );

extern "C" DWORD WINAPI GetCanonicalPathW(
						LPCWSTR lpszPath,			// file name
						LPWSTR lpszCanonicalPath,	// path buffer
						DWORD cchBuffer				// size of path buffer 
);

//------------------------------------------------------------------------
// global object, used to automatically initialize the systools 
//------------------------------------------------------------------------

static OAutoSystoolInit initKernel9x( Kernel9xInit, Kernel9xDeInit );

//------------------------------------------------------------------------
// function pointers, used instead of the real functions
//------------------------------------------------------------------------

extern "C"
{

typedef HMODULE (WINAPI *LoadLibraryExW_Proc_T ) (
	LPCWSTR lpLibFileName,  // file name of module
	HANDLE hFile,           // reserved, must be NULL
	DWORD dwFlags           // entry-point execution option
);
LoadLibraryExW_Proc_T lpfnLoadLibraryExW;

typedef DWORD (WINAPI *GetModuleFileNameW_Proc_T ) (
	HMODULE hModule,    // handle to module
	LPWSTR lpFilename,  // file name of module
	DWORD nSize         // size of buffer 
);
GetModuleFileNameW_Proc_T lpfnGetModuleFileNameW;

typedef DWORD (WINAPI *GetLogicalDriveStringsW_Proc_T ) (
	DWORD nBufferLength,	// size of buffer
	LPWSTR lpBuffer			// drive strings buffer
);
GetLogicalDriveStringsW_Proc_T lpfnGetLogicalDriveStringsW;

typedef HANDLE ( WINAPI * CreateFileW_Proc_T ) (
	LPCWSTR	lpFileName,
	DWORD	dwDesiredAccess,
	DWORD	dwShareMode,
	LPSECURITY_ATTRIBUTES	lpSecurityAttributes,
	DWORD	dwCreationDisposition,
	DWORD	dwFlagsAndAttributes,
	HANDLE	hTemplateFile );
CreateFileW_Proc_T lpfnCreateFileW;

typedef BOOL (WINAPI *DeleteFileW_Proc_T ) (
	LPCWSTR	lpFileName			// file name
);
DeleteFileW_Proc_T lpfnDeleteFileW;

typedef BOOL (WINAPI *MoveFileW_Proc_T ) (
	LPCWSTR lpExistingFileName,	// file name
	LPCWSTR lpNewFileName		// new file name
);
MoveFileW_Proc_T lpfnMoveFileW;

typedef BOOL (WINAPI *MoveFileExW_Proc_T ) (
  LPCWSTR lpExistingFileName,	// file name
  LPCWSTR lpNewFileName,		// new file name
  DWORD dwFlags					// move options
);
MoveFileExW_Proc_T lpfnMoveFileExW;

typedef BOOL (WINAPI *CopyFileW_Proc_T ) (
	LPCWSTR lpExistingFileName,	// file name
	LPCWSTR lpNewFileName,		// new file name
	BOOL	bFailIfExist		// operation if file exists
);
CopyFileW_Proc_T lpfnCopyFileW;

typedef BOOL (WINAPI *RemoveDirectoryW_Proc_T )( 
	LPCWSTR lpPathName );
RemoveDirectoryW_Proc_T lpfnRemoveDirectoryW;

typedef BOOL ( WINAPI * CreateDirectoryW_Proc_T ) (
	LPCWSTR	lpNewDirectory, LPSECURITY_ATTRIBUTES lpSecurityAttributes );
CreateDirectoryW_Proc_T lpfnCreateDirectoryW;

typedef BOOL ( WINAPI * CreateDirectoryExW_Proc_T ) (
	LPCWSTR	lpTemplateDirectory,
	LPCWSTR	lpNewDirectory,
	LPSECURITY_ATTRIBUTES	lpSecurityAttributes );
CreateDirectoryExW_Proc_T lpfnCreateDirectoryExW;

// GetLongPathName is only available on Windows 2000 and Win98!!!
typedef DWORD ( WINAPI * GetLongPathNameW_Proc_T ) (
  LPCWSTR lpszShortPath, // file name
  LPWSTR lpszLongPath,   // path buffer
  DWORD cchBuffer        // size of path buffer 
);
GetLongPathNameW_Proc_T lpfnGetLongPathNameW;

typedef DWORD ( WINAPI * GetCanonicalPathW_Proc_T ) (
	LPCWSTR lpszPath,			// file name
	LPWSTR lpszCanonicalPath,	// path buffer
	DWORD cchBuffer				// size of path buffer 
);
GetCanonicalPathW_Proc_T lpfnGetCanonicalPathW;

typedef int ( WINAPI* GetLocaleInfoW_Proc_T ) (
    LCID Locale,        // locale identifier
    LCTYPE LCType,      // information type 
    LPWSTR lpLCData,    // information buffer
    int cchData         // size of buffer
);
GetLocaleInfoW_Proc_T lpfnGetLocaleInfoW;

typedef DWORD ( WINAPI* GetFullPathNameW_Proc_T ) (
	LPCWSTR	lpFileName,		// file name
	DWORD	nBufferLength,	// size of path buffer
	LPWSTR	lpBuffer,		// path buffer
	LPWSTR	*lpFilePart		// address of file name in path
);
GetFullPathNameW_Proc_T	lpfnGetFullPathNameW;

typedef BOOL ( WINAPI* CreateProcessW_Proc_T ) (
  LPCWSTR lpApplicationName,                 // name of executable module
  LPWSTR lpCommandLine,                      // command line string
  LPSECURITY_ATTRIBUTES lpProcessAttributes, // SD
  LPSECURITY_ATTRIBUTES lpThreadAttributes,  // SD
  BOOL bInheritHandles,                      // handle inheritance option
  DWORD dwCreationFlags,                     // creation flags
  LPVOID lpEnvironment,                      // new environment block
  LPCWSTR lpCurrentDirectory,                // current directory name
  LPSTARTUPINFOW lpStartupInfo,              // startup information
  LPPROCESS_INFORMATION lpProcessInformation // process information
);
CreateProcessW_Proc_T lpfnCreateProcessW;

typedef BOOL ( WINAPI* CreateProcessAsUserW_Proc_T ) (
  HANDLE hToken,                             // handle to user token
  LPCWSTR lpApplicationName,                 // name of executable module
  LPWSTR lpCommandLine,                      // command-line string
  LPSECURITY_ATTRIBUTES lpProcessAttributes, // SD
  LPSECURITY_ATTRIBUTES lpThreadAttributes,  // SD
  BOOL bInheritHandles,                      // inheritance option
  DWORD dwCreationFlags,                     // creation flags
  LPVOID lpEnvironment,                      // new environment block
  LPCWSTR lpCurrentDirectory,                // current directory name
  LPSTARTUPINFOW lpStartupInfo,              // startup information
  LPPROCESS_INFORMATION lpProcessInformation // process information
);
CreateProcessAsUserW_Proc_T lpfnCreateProcessAsUserW;

typedef DWORD ( WINAPI* GetEnvironmentVariableW_Proc_T )(
  LPCWSTR lpName,  // environment variable name
  LPWSTR lpBuffer, // buffer for variable value
  DWORD nSize      // size of buffer
);
GetEnvironmentVariableW_Proc_T lpfnGetEnvironmentVariableW;

typedef UINT ( WINAPI* GetDriveTypeW_Proc_T )(
	LPCWSTR lpRootPathName	// root directory
);
GetDriveTypeW_Proc_T lpfnGetDriveTypeW;

typedef DWORD ( WINAPI * GetCurrentDirectoryW_Proc_T )(
    DWORD  nBufferLength,   // size of directory buffer
    LPWSTR lpBuffer         // directory buffer
);
GetCurrentDirectoryW_Proc_T lpfnGetCurrentDirectoryW;


typedef BOOL ( WINAPI * SetCurrentDirectoryW_Proc_T )(
    LPCWSTR lpPathName  // new directory name
);
SetCurrentDirectoryW_Proc_T lpfnSetCurrentDirectoryW;


// GetVolumeInformation
typedef BOOL ( WINAPI* GetVolumeInformationW_Proc_T )(
	LPCWSTR	lpRootPathName,				// root directory
	LPWSTR	lpVolumeNameBuffer,			// volume name buffer
	DWORD	nVolumeNameSize,			// length of name buffer
	LPDWORD	lpVolumeSerialNumber,		// volume serial number
	LPDWORD	lpMaximumComponentLength,	// maximum file name length
	LPDWORD	lpFileSystemFlags,			// file system options
	LPWSTR	lpFileSystemName,			// file system name buffer
	DWORD	nFileSystemNameSize			// length of file system name buffer
);
GetVolumeInformationW_Proc_T lpfnGetVolumeInformationW;

// GetDiskFreeSpaceExA
typedef BOOL (WINAPI *GetDiskFreeSpaceExA_Proc_T)(
  LPCSTR lpDirectoryName,                 // directory name
  PULARGE_INTEGER lpFreeBytesAvailable,    // bytes available to caller
  PULARGE_INTEGER lpTotalNumberOfBytes,    // bytes on disk
  PULARGE_INTEGER lpTotalNumberOfFreeBytes // free bytes on disk
);
GetDiskFreeSpaceExA_Proc_T	lpfnGetDiskFreeSpaceExA;

// GetDiskFreeSpaceExW
typedef BOOL (WINAPI *GetDiskFreeSpaceExW_Proc_T)(
  LPCWSTR lpDirectoryName,                 // directory name
  PULARGE_INTEGER lpFreeBytesAvailable,    // bytes available to caller
  PULARGE_INTEGER lpTotalNumberOfBytes,    // bytes on disk
  PULARGE_INTEGER lpTotalNumberOfFreeBytes // free bytes on disk
);
GetDiskFreeSpaceExW_Proc_T	lpfnGetDiskFreeSpaceExW;


} // extern "C" 

//------------------------------------------------------------------------
// initialize the kernel9x systools
//------------------------------------------------------------------------

static void WINAPI Kernel9xInit( )
{
	HMODULE			hModule;
	HMODULE			hModKernel32;
	OSVERSIONINFO	OSVerInfo;
	BOOL			bIsWin9x;
	BOOL			bIsWinNT;
	
	lpfnLoadLibraryExW          = LoadLibraryExW;
	lpfnGetModuleFileNameW      = GetModuleFileNameW;
	lpfnGetLogicalDriveStringsW = GetLogicalDriveStringsW;
	lpfnCreateFileW             = CreateFileW;
	lpfnDeleteFileW             = DeleteFileW;
	lpfnMoveFileW               = MoveFileW;
	lpfnMoveFileExW             = MoveFileExW;
	lpfnCopyFileW               = CopyFileW;
	lpfnRemoveDirectoryW        = RemoveDirectoryW;
	lpfnCreateDirectoryW        = CreateDirectoryW;
	lpfnCreateDirectoryExW      = CreateDirectoryExW;
	lpfnGetLongPathNameW        = 0;
	lpfnGetCanonicalPathW       = GetCanonicalPathW;
    lpfnGetLocaleInfoW          = GetLocaleInfoW;
	lpfnGetFullPathNameW		= GetFullPathNameW;
    lpfnCreateProcessW          = CreateProcessW;
    lpfnGetEnvironmentVariableW = GetEnvironmentVariableW;
	lpfnGetDriveTypeW           = GetDriveTypeW;
    lpfnGetCurrentDirectoryW    = GetCurrentDirectoryW;
    lpfnSetCurrentDirectoryW    = SetCurrentDirectoryW;
	lpfnGetVolumeInformationW	= GetVolumeInformationW;

	OSVerInfo.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
	GetVersionEx( &OSVerInfo );

	bIsWin9x	= ( VER_PLATFORM_WIN32_WINDOWS == OSVerInfo.dwPlatformId );
	bIsWinNT	= ( !bIsWin9x && ( OSVerInfo.dwMajorVersion < 5 ) );

	if ( bIsWin9x || bIsWinNT )
	{
		hModule = LoadLibraryA( SYSTOOLS_DLL_NAME );
		if ( NULL != hModule )
		{
			if ( bIsWin9x )
			{
				lpfnLoadLibraryExW = ( LoadLibraryExW_Proc_T )GetProcAddress( 
					hModule, "LoadLibraryExW_9x" );			
				lpfnGetModuleFileNameW = ( GetModuleFileNameW_Proc_T )GetProcAddress( 
					hModule, "GetModuleFileNameW_9x" );
				lpfnGetLogicalDriveStringsW = ( GetLogicalDriveStringsW_Proc_T )GetProcAddress(
					hModule, "GetLogicalDriveStringsW_9x" );
				lpfnCreateFileW = ( CreateFileW_Proc_T )GetProcAddress(
					hModule, "CreateFileW_9x" );
				lpfnDeleteFileW = ( DeleteFileW_Proc_T )GetProcAddress( 
					hModule, "DeleteFileW_9x" );
				lpfnMoveFileW = ( MoveFileW_Proc_T )GetProcAddress( 
					hModule, "MoveFileW_9x" );
				lpfnMoveFileExW = ( MoveFileExW_Proc_T ) GetProcAddress( 
					hModule, "MoveFileExW_9x" );
				lpfnCopyFileW = ( CopyFileW_Proc_T )GetProcAddress( 
					hModule, "CopyFileW_9x" );
				lpfnRemoveDirectoryW = ( RemoveDirectoryW_Proc_T )GetProcAddress(
					hModule, "RemoveDirectoryW_9x" );
				lpfnCreateDirectoryW = ( CreateDirectoryW_Proc_T )GetProcAddress(
					hModule, "CreateDirectoryW_9x" );
				lpfnCreateDirectoryExW = ( CreateDirectoryExW_Proc_T )GetProcAddress(
					hModule, "CreateDirectoryExW_9x" );	                
                lpfnGetLocaleInfoW = ( GetLocaleInfoW_Proc_T )GetProcAddress(
                    hModule, "GetLocaleInfoW_9x" );
                lpfnGetFullPathNameW = ( GetFullPathNameW_Proc_T )GetProcAddress(
                    hModule, "GetFullPathNameW_9x" );
                lpfnCreateProcessW = ( CreateProcessW_Proc_T )GetProcAddress(
                    hModule, "CreateProcessW_9x" );
                lpfnCreateProcessAsUserW = ( CreateProcessAsUserW_Proc_T )GetProcAddress(
                    hModule, "CreateProcessAsUserW_9x" );
                lpfnGetEnvironmentVariableW = ( GetEnvironmentVariableW_Proc_T )GetProcAddress(
                    hModule, "GetEnvironmentVariableW_9x" );
                lpfnGetDriveTypeW = ( GetDriveTypeW_Proc_T )GetProcAddress(
                    hModule, "GetDriveTypeW_9x" );                
                lpfnGetCurrentDirectoryW = ( GetCurrentDirectoryW_Proc_T )GetProcAddress(
                    hModule, "GetCurrentDirectoryW_9x" );
                lpfnSetCurrentDirectoryW = ( SetCurrentDirectoryW_Proc_T )GetProcAddress(
                    hModule, "SetCurrentDirectoryW_9x" );                 
				lpfnGetVolumeInformationW = (GetVolumeInformationW_Proc_T)GetProcAddress(
                    hModule, "GetVolumeInformationW_9x" );                 
				lpfnGetDiskFreeSpaceExW = (GetDiskFreeSpaceExW_Proc_T)GetProcAddress(
						hModule, "GetDiskFreeSpaceExW_9x" );                 

				// GetDiskSpaceExA is not availiable on Windows 95A

       			hModKernel32 = GetModuleHandleA( "kernel32.dll" );
				if ( NULL != hModKernel32 )
        		{
					// may not be available as an import under Win95a
   					if ( NULL == (lpfnGetDiskFreeSpaceExA = ( GetDiskFreeSpaceExA_Proc_T )GetProcAddress(
   							hModKernel32, "GetDiskFreeSpaceExA" )) )
					{
						lpfnGetDiskFreeSpaceExA = ( GetDiskFreeSpaceExA_Proc_T )GetProcAddress(
							hModule, "GetDiskFreeSpaceExA_95A" );
						lpfnGetDiskFreeSpaceExW = (GetDiskFreeSpaceExW_Proc_T)GetProcAddress(
								hModule, "GetDiskFreeSpaceExW_95A" );                 
					}
				}
				else
				{
					lpfnGetDiskFreeSpaceExA = ( GetDiskFreeSpaceExA_Proc_T )GetProcAddress(
						hModule, "GetDiskFreeSpaceExA_95A" );
					lpfnGetDiskFreeSpaceExW = (GetDiskFreeSpaceExW_Proc_T)GetProcAddress(
						hModule, "GetDiskFreeSpaceExW_95A" );                 
				}

				
			}
            else
            {
        		hModKernel32 = GetModuleHandleA( "kernel32.dll" );
		        if ( NULL != hModKernel32 )
        		{
                    // may not be available as an import under Win9x
        			lpfnCreateProcessAsUserW = ( CreateProcessAsUserW_Proc_T )GetProcAddress(
        					hModKernel32, "CreateProcessAsUserW" );
        			lpfnGetDiskFreeSpaceExW = ( GetDiskFreeSpaceExW_Proc_T )GetProcAddress(
        					hModKernel32, "GetDiskFreeSpaceExW" );
   					lpfnGetDiskFreeSpaceExA = ( GetDiskFreeSpaceExA_Proc_T )GetProcAddress(
   							hModKernel32, "GetDiskFreeSpaceExA" );
		        }
            }
			           
			// GetLongPathName is neither available under Win95 nor under Win NT 3.51 or 4.0
			lpfnGetLongPathNameW = ( GetLongPathNameW_Proc_T )GetProcAddress(
				hModule, "GetLongPathNameW_9x" );
		}		
	}
	else // Win2000
	{				
		hModKernel32 = GetModuleHandleA( "kernel32.dll" );
		if ( NULL != hModKernel32 )
		{
             // may not be available as an import under Win9x
			lpfnGetLongPathNameW = ( GetLongPathNameW_Proc_T )GetProcAddress(
					hModKernel32, "GetLongPathNameW" );
   			lpfnCreateProcessAsUserW = ( CreateProcessAsUserW_Proc_T )GetProcAddress(
   					hModKernel32, "CreateProcessAsUserW" );
   			lpfnGetDiskFreeSpaceExW = ( GetDiskFreeSpaceExW_Proc_T )GetProcAddress(
   					hModKernel32, "GetDiskFreeSpaceExW" );
   			lpfnGetDiskFreeSpaceExA = ( GetDiskFreeSpaceExA_Proc_T )GetProcAddress(
   					hModKernel32, "GetDiskFreeSpaceExA" );
		}
	}		
}

//------------------------------------------------------------------------
// deinitialize the kernel9x systools
//------------------------------------------------------------------------

static void WINAPI Kernel9xDeInit()
{
	// we do not explicitly free the shell9x library but rely
	// on the fact that sal will not be unloaded while the 
	// office is running, so the library will be free at
	// the office shutdown

    // we use this approach in order to unload the w9xucwrp.dll
    // GetModuleHandle will be used in order to avoid a global
    // variable HMODULE which would be set in ...Init
    // if the module handle is valid a LoadLibrary should have
    // been successful
    // nobody should use any of the above function pointer after
    // this call
    HMODULE hModule = GetModuleHandleA( SYSTOOLS_DLL_NAME );
    if ( hModule )
        FreeLibrary( hModule );
}

