/*************************************************************************
 *
 *  $RCSfile: ldap.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <address.hxx>
#include <inet/wrapper.hxx>
#include <inet/ldapwrap.hxx>

#ifndef _SMART_COM_SUN_STAR_UTIL_XCANCELMANAGER_HXX_
#include <smart/com/sun/star/util/XCancelManager.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XCANCELLABLE_HXX_
#include <smart/com/sun/star/util/XCancellable.hxx>
#endif

#ifndef _VOS_CONDITN_HXX_ //autogen wg. OCondition
#include <vos/conditn.hxx>
#endif


#ifdef _USE_NAMESPACE
using namespace vos;
using namespace usr;
using namespace inet;
#endif



struct OAddressBookSourceLDAPData : public OAddressBookSourceData
{
	static void fillClassInfo(
		OObjectClassBase*& rpParentClass, 
		Sequence<OPropertyAccessor>& rProps );

	UString                                               m_Server;
	UString                                               m_User;
	UString                                               m_Password;
	INT32                                                 m_Port;
	INT32                                                 m_TimeLimit;
	INT32                                                 m_SizeLimit;
	AddressBookSourceLDAPScope                            m_Scope;
	Sequence<AddressBookSourceLDAPSchemaDefinition>       m_Schemata;

	const AddressBookSourceLDAPSchemaDefinition* getSchemaDefinition( const UString& rName );
	OAddressBookSourceLDAPData();

};

class OAddressBookSourceLDAPQueryJob;
USR_DECL_OBJECT_REF( OAddressBookSourceLDAPQueryJob );

class INetCoreLDAPFilter;
class OAddressBookLDAPConnection : public UsrObject
{
public:
	void open( );
	void cancel( const OAddressBookSourceLDAPQueryJobRef& xJob );
	void query( const OAddressBookSourceLDAPQueryJobRef& xJob );
	OAddressBookLDAPConnection( 
		const XMultiServiceFactoryRef& xMgr,
		const XAddressBookJobFactorySupplierRef& xJobFactory,
		const OAddressBookSourceLDAPData& rData );
	OMutex& getMutex() const { return (OMutex&)m_aMutex;}
	const OAddressBookSourceLDAPData& getData() const { return m_aData; }
			
	
private:

	INetCoreLDAPFilter* createFilters(
		const AddressBookQueryTerm& rTerm, 
		const Sequence<AddressBookSourceLDAPFieldMapping>& rMap );
	INetCoreLDAPFilter* createFilter(
		const AddressBookQueryTerm& rTerm, const UString& rName, 
		const Sequence<AddressBookSourceLDAPFieldMapping>& rMap );
	void runQueries();
	list<OAddressBookSourceLDAPQueryJobRef>::iterator findJob( UINT16 nMsgId );

	static int requestCallback
	(
		INetCoreLDAPConnection* pConnection,
		int nReplyCode,
		const void* pReplyData,
		USHORT nMsgID, void* pSearcher
	);
	int callback( 	
		INetCoreLDAPConnection* pConnection, int nReplyCode,
		const void* pReplyData,	USHORT nMsgID );

	XAddressBookRecordContainerRef getRecordContainer();

	OAddressBookSourceLDAPData       m_aData;

	INetWrapper                   m_aINetWrapper;
	INetLDAPWrapper*              m_pFactory;
	ORef<INetCoreLDAPConnection>  m_xConnection;
	OMutex                        m_aMutex;
	list<OAddressBookSourceLDAPQueryJobRef> m_aRunningJobs;
	list<OAddressBookSourceLDAPQueryJobRef> m_aQueuedJobs;
	enum { UNCONNECTED, CONNECTING, BINDING, READY } m_eState;
	XAddressBookRecordContainerRef m_xContainr;
	XAddressBookJobFactorySupplierRef m_xJobFactorySup;
	XMultiServiceFactoryRef       m_xMgr;
	UINT16                        m_nNextId;
};

USR_DECLIMPL_OBJECT_REF( OAddressBookLDAPConnection );

class OAddressBookSourceLDAP : 
	public OAddressBookSourceLDAPData, public OPropertySet, 
	public XAddressBookJobFactorySupplier,
	public XJobFactory
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceLDAP, OPropertySet );
	OAddressBookSourceLDAP( const XMultiServiceFactoryRef& xSrv );
	~OAddressBookSourceLDAP();
	
	static XInterfaceRef create( const XMultiServiceFactoryRef& xMgr );


	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );

	virtual XJobFactoryRef getJobFactory();
	virtual XInterfaceRef createJob( 
		const UString& rType, const Sequence<UsrAny>& rArgs );
protected:
	virtual BOOL convertFastPropertyValue( 
		UsrAny & rConvertedValue, UsrAny & rOldValue, 
		INT32 nHandle, const UsrAny& rValue )
		THROWS( (IllegalArgumentException) );
	void setFastPropertyValue_NoBroadcast( 
		INT32 nHandle, const UsrAny& rValue ) THROWS( (Exception) );
private:
	const OAddressBookLDAPConnectionRef& getConnection();

	OMutex                                                m_aMutex;
	XMultiServiceFactoryRef                               m_xMgr;
	XJobFactoryRef                                        m_xJobFactory;
	OAddressBookLDAPConnectionRef                         m_xConnection;
};


class OAddressBookSourceLDAPQueryJob :
	public UsrObject, public XAsynchronJob
{
public:
	SMART_UNO_DECLARATION( OAddressBookSourceLDAPAsynchronJob, UsrObject );
	OAddressBookSourceLDAPQueryJob( 
		const XMultiServiceFactoryRef& xMgr, 
		const OAddressBookLDAPConnectionRef& xConn, 
		const UString& rType, const Sequence<UsrAny>& rArgs );
	~OAddressBookSourceLDAPQueryJob();
	
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	// XCancelable
	virtual void cancel();
	virtual void suspend(){}
	virtual void resume(){}

	virtual void executeAsynchron( const XJobListenerRef& xCallback );

private:
	BOOL eliminateUidQueries( AddressBookQueryTerm& rTerm, BOOL bReverse );

	friend class OAddressBookLDAPConnection;
	Sequence<UString>              m_aSchemata;
	Sequence<UString>              m_aProperties;
	UString                        m_aQuery;
	Sequence<AddressBookSortInfo>  m_aSortInfo;
	
	OAddressBookEvaluator*         m_pEval;
	UString                        m_aUid;
	XMultiServiceFactoryRef        m_xMgr;
	AddressBookQueryTerm           m_aTerm;
	AddressBookQueryTerm           m_aLocalTerm;
	UString                        m_aType;
	OAddressBookLDAPConnectionRef  m_xConn;
	OResultSet*                    m_pSet;
	vector<UINT16>                 m_aMsgIds;
	const AddressBookSourceLDAPSchemaDefinition* m_pCurrentSchema;
	XJobListenerRef               m_xCallback;
};

USR_IMPL_OBJECT_REF( OAddressBookSourceLDAPQueryJob );

class OAddressBookSourceLDAPSynchronJob : 
	public UsrObject,
	public XSynchronJob
{
public:
	SMART_UNO_DECLARATION( 
		OAddressBookSourceLDAPSynchronJob, UsrObject );

	OAddressBookSourceLDAPSynchronJob( 
		const OAddressBookLDAPConnectionRef& rConn,
		const UString& rType,
		const Sequence<UsrAny>& rArgs ) :
		m_aArgs( rArgs ), m_xConn( rConn ),	m_aType( rType )
		{
		}
	
	// XIdlClassProvider
	static XIdlClassRef getStaticIdlClass();
	Sequence<XIdlClassRef>	getIdlClasses();

	virtual BOOL queryInterface( Uik aUik, XInterfaceRef & rOut );
	
	virtual void cancel() {}
	virtual void suspend(){}
	virtual void resume(){}
	virtual UsrAny executeSynchron();

private:

	UString                        m_aType;
	OAddressBookLDAPConnectionRef  m_xConn;
	Sequence<UsrAny>               m_aArgs;
};
