/*************************************************************************
 *
 *  $RCSfile: pkgchk_mgr.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/02 15:28:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"
#include "pkgchk.hxx"


using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;

namespace pkgchk
{

//______________________________________________________________________________
UNO_PackagesManager::UNO_PackagesManager(
    Bootstrap const & unorc, OptionsContainer const & options )
        : m_env( new pkgchk_env( unorc, options ) )
{
}

//______________________________________________________________________________
UNO_PackagesManager::~UNO_PackagesManager()
{
    delete m_env;
    m_env = 0;
}

// packages management

//______________________________________________________________________________
bool UNO_PackagesManager::check()
{
    try
    {
        return m_env->packages_check();
    }
    catch (RuntimeException & exc) // log all errors
    {
        m_env->log(
            OUSTR("> error: ") + exc.Message,
            false /* no verbose writing */ );
        throw;
    }
}

//______________________________________________________________________________
void UNO_PackagesManager::balance()
{
    try
    {
        m_env->packages_balance();
    }
    catch (RuntimeException & exc) // log all errors
    {
        m_env->log(
            OUSTR("> error: ") + exc.Message,
            false /* no verbose writing */ );
        throw;
    }
}

//______________________________________________________________________________
void UNO_PackagesManager::remove_all()
{
    try
    {
        m_env->packages_remove_all();
    }
    catch (RuntimeException & exc) // log all errors
    {
        m_env->log(
            OUSTR("> error: ") + exc.Message,
            false /* no verbose writing */ );
        throw;
    }
}

//______________________________________________________________________________
void UNO_PackagesManager::copy( OUString const & package_path )
{
    try
    {
        path_copy(
            m_env->m_packages_path, package_path,
            *m_env, m_env->m_force_overwrite );
    }
    catch (RuntimeException & exc) // log all errors
    {
        m_env->log(
            OUSTR("> error: ") + exc.Message,
            false /* no verbose writing */ );
        throw;
    }
}

//##############################################################################

// options, arguments retrieval

//______________________________________________________________________________
OptionsContainer::~OptionsContainer()
{
}

//______________________________________________________________________________
bool OptionsContainer::get_option(
    OUString const & name, sal_Unicode shortcut ) const
{
    return false;
}

//______________________________________________________________________________
bool OptionsContainer::get_argument(
    Any * value, OUString const & name, sal_Unicode shortcut ) const
{
    return false;
}

}
