/*
 * Decompiled with CFR 0.152.
 */
package org.openide.debugger;

import java.util.Enumeration;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.cookies.ArgumentsCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.ExecInfo;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class DebuggerType
extends ServiceType {
    static final long serialVersionUID = -3659300496270314301L;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType$Default;

    public abstract void startDebugger(ExecInfo var1, boolean var2) throws DebuggerException;

    public void startDebugger(DataObject dataObject, boolean bl) throws DebuggerException {
        ArgumentsCookie argumentsCookie = (ArgumentsCookie)dataObject.getCookie(this.getKlass("org.openide.cookies.ArgumentsCookie"));
        String[] stringArray = argumentsCookie != null ? argumentsCookie.getArguments() : new String[]{};
        this.startDebugger(new ExecInfo(dataObject.getPrimaryFile().getPackageName('.'), stringArray), bl);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = DebuggerType.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType);
    }

    public static Enumeration debuggerTypes() {
        return TopManager.getDefault().getServices().services(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = DebuggerType.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType);
    }

    public static DebuggerType find(Class clazz) {
        ServiceType serviceType = TopManager.getDefault().getServices().find(clazz);
        if (serviceType instanceof DebuggerType) {
            return (DebuggerType)serviceType;
        }
        return null;
    }

    public static DebuggerType find(String string) {
        ServiceType serviceType = TopManager.getDefault().getServices().find(string);
        if (serviceType instanceof DebuggerType) {
            return (DebuggerType)serviceType;
        }
        return null;
    }

    public static DebuggerType getDefault() {
        Enumeration enumeration = DebuggerType.debuggerTypes();
        if (enumeration.hasMoreElements()) {
            return (DebuggerType)enumeration.nextElement();
        }
        return new Default();
    }

    private final Class getKlass(String string) {
        try {
            return Class.forName(string, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Default
    extends DebuggerType {
        static final long serialVersionUID = 6286540187114472027L;

        public String displayName() {
            return NbBundle.getBundle(class$org$openide$debugger$DebuggerType$Default == null ? (class$org$openide$debugger$DebuggerType$Default = DebuggerType.class$("org.openide.debugger.DebuggerType$Default")) : class$org$openide$debugger$DebuggerType$Default).getString("LAB_DefaultDebuggerType");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$debugger$DebuggerType$Default == null ? (class$org$openide$debugger$DebuggerType$Default = DebuggerType.class$("org.openide.debugger.DebuggerType$Default")) : class$org$openide$debugger$DebuggerType$Default);
        }

        public void startDebugger(ExecInfo execInfo, boolean bl) throws DebuggerException {
            if (bl) {
                TopManager.getDefault().getDebugger().startDebugger(new DebuggerInfo(execInfo.getClassName(), execInfo.getArguments()));
            } else {
                TopManager.getDefault().getDebugger().startDebugger(new DebuggerInfo(execInfo.getClassName(), execInfo.getArguments(), null));
            }
        }
    }
}

