/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.openide.awt.Actions;

final class NbPopupMenuUI
extends BasicPopupMenuUI {
    NbPopupMenuUI() {
    }

    protected void installKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.popupMenu.registerKeyboardAction(new CancelAction(), keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.popupMenu.registerKeyboardAction(new SelectNextItemAction(), keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.popupMenu.registerKeyboardAction(new SelectPreviousItemAction(), keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(39, 0);
        this.popupMenu.registerKeyboardAction(new SelectChildItemAction(), keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        this.popupMenu.registerKeyboardAction(new SelectParentItemAction(), keyStroke, 2);
        ReturnAction returnAction = new ReturnAction();
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.popupMenu.registerKeyboardAction(returnAction, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        this.popupMenu.registerKeyboardAction(returnAction, keyStroke, 2);
    }

    protected void uninstallKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b');
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(39, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
        keyStroke = KeyStroke.getKeyStroke(32, 0);
        this.popupMenu.unregisterKeyboardAction(keyStroke);
    }

    static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        int n3 = menuElementArray.length;
        while (n2 < n3) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            ++n2;
        }
        return null;
    }

    static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n) {
        int n2 = n;
        while (n2 >= 0) {
            Component component;
            if (menuElementArray[n2] != null && (component = menuElementArray[n2].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    static void changeTargetUI(JPopupMenu jPopupMenu) {
        if (jPopupMenu.getUI() instanceof NbPopupMenuUI) {
            return;
        }
        jPopupMenu.setUI(new NbPopupMenuUI());
    }

    static final class SelectParentItemAction
    extends AbstractAction {
        SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 3) {
                if (menuElementArray[menuElementArray.length - 1].getComponent() instanceof JPopupMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray2.length);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                } else {
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length - 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray3.length);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                }
            } else if (menuElementArray.length > 2 && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JPopupMenu) {
                MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length - 1];
                System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray4.length);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
            }
        }
    }

    static final class SelectChildItemAction
    extends AbstractAction {
        SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0) {
                Component component = menuElementArray[menuElementArray.length - 1].getComponent();
                boolean bl = false;
                if (component instanceof JPopupMenu) {
                    if (menuElementArray.length == 1) {
                        return;
                    }
                    component = menuElementArray[menuElementArray.length - 2].getComponent();
                    bl = true;
                }
                if (component.isEnabled() && component instanceof JMenu && (!(component instanceof Actions.SubMenu) || ((Actions.SubMenu)component).getMenuComponentCount() > 1) && !((JMenu)component).isTopLevelMenu()) {
                    JPopupMenu jPopupMenu = ((JMenu)component).getPopupMenu();
                    NbPopupMenuUI.changeTargetUI(jPopupMenu);
                    MenuElement[] menuElementArray2 = jPopupMenu.getSubElements();
                    if (menuElementArray2.length > 0) {
                        int n = bl ? 1 : 2;
                        int n2 = bl ? 1 : 0;
                        MenuElement menuElement = NbPopupMenuUI.nextEnabledChild(menuElementArray2, 0);
                        if (menuElement != null) {
                            boolean bl2;
                            Component component2 = menuElement.getComponent();
                            boolean bl3 = bl2 = component2 instanceof JMenu && (!(component2 instanceof Actions.SubMenu) || ((Actions.SubMenu)component2).getMenuComponentCount() > 1);
                            if (bl2) {
                                ++n;
                            }
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + n];
                            System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                            menuElementArray3[menuElementArray.length - n2] = jPopupMenu;
                            menuElementArray3[menuElementArray.length + 1 - n2] = menuElement;
                            if (bl2) {
                                JMenu jMenu = (JMenu)menuElement.getComponent();
                                menuElementArray3[menuElementArray3.length - 1] = jMenu.getPopupMenu();
                            }
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                        }
                    }
                }
            }
        }
    }

    static final class SelectPreviousItemAction
    extends AbstractAction {
        SelectPreviousItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 1) {
                boolean bl = menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu;
                int n = bl ? 3 : 2;
                int n2 = bl ? 2 : 1;
                MenuElement menuElement = menuElementArray[menuElementArray.length - n];
                MenuElement[] menuElementArray2 = menuElement.getSubElements();
                int n3 = 0;
                int n4 = menuElementArray2.length;
                while (n3 < n4) {
                    if (menuElementArray2[n3] == menuElementArray[menuElementArray.length - n2]) {
                        MenuElement menuElement2 = NbPopupMenuUI.previousEnabledChild(menuElementArray2, n3 - 1);
                        if (menuElement2 == null) {
                            menuElement2 = NbPopupMenuUI.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                        }
                        if (menuElement2 == null) break;
                        JMenu jMenu = null;
                        if (menuElement2 instanceof JMenu && (!(menuElement2 instanceof Actions.SubMenu) || ((Actions.SubMenu)menuElement2).getMenuComponentCount() > 1)) {
                            jMenu = (JMenu)menuElement2;
                        }
                        if (bl != (jMenu != null)) {
                            if (bl) {
                                MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length - 1];
                                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray3.length - 1);
                                menuElementArray3[menuElementArray3.length - 1] = menuElement2;
                                menuElementArray = menuElementArray3;
                            } else {
                                MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 1];
                                System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                                menuElementArray4[menuElementArray4.length - 2] = jMenu;
                                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                                menuElementArray4[menuElementArray4.length - 1] = jPopupMenu;
                                NbPopupMenuUI.changeTargetUI(jPopupMenu);
                                menuElementArray = menuElementArray4;
                            }
                        } else if (bl) {
                            menuElementArray[menuElementArray.length - 2] = menuElement2;
                            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                            menuElementArray[menuElementArray.length - 1] = jPopupMenu;
                            NbPopupMenuUI.changeTargetUI(jPopupMenu);
                        } else {
                            menuElementArray[menuElementArray.length - 1] = menuElement2;
                        }
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    static final class SelectNextItemAction
    extends AbstractAction {
        SelectNextItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 1) {
                boolean bl = menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu;
                int n = bl ? 3 : 2;
                int n2 = bl ? 2 : 1;
                MenuElement menuElement = menuElementArray[menuElementArray.length - n];
                MenuElement[] menuElementArray2 = menuElement.getSubElements();
                int n3 = 0;
                int n4 = menuElementArray2.length;
                while (n3 < n4) {
                    if (menuElementArray2[n3] == menuElementArray[menuElementArray.length - n2]) {
                        MenuElement menuElement2 = NbPopupMenuUI.nextEnabledChild(menuElementArray2, n3 + 1);
                        if (menuElement2 == null) {
                            menuElement2 = NbPopupMenuUI.nextEnabledChild(menuElementArray2, 0);
                        }
                        if (menuElement2 == null) break;
                        JMenu jMenu = null;
                        if (menuElement2 instanceof JMenu && (!(menuElement2 instanceof Actions.SubMenu) || ((Actions.SubMenu)menuElement2).getMenuComponentCount() > 1)) {
                            jMenu = (JMenu)menuElement2;
                        }
                        if (bl != (jMenu != null)) {
                            if (bl) {
                                MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length - 1];
                                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray3.length - 1);
                                menuElementArray3[menuElementArray3.length - 1] = menuElement2;
                                menuElementArray = menuElementArray3;
                            } else {
                                MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 1];
                                System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                                menuElementArray4[menuElementArray4.length - 2] = jMenu;
                                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                                menuElementArray4[menuElementArray4.length - 1] = jPopupMenu;
                                NbPopupMenuUI.changeTargetUI(jPopupMenu);
                                menuElementArray = menuElementArray4;
                            }
                        } else if (bl) {
                            menuElementArray[menuElementArray.length - 2] = menuElement2;
                            JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                            menuElementArray[menuElementArray.length - 1] = jPopupMenu;
                            NbPopupMenuUI.changeTargetUI(jPopupMenu);
                        } else {
                            menuElementArray[menuElementArray.length - 1] = menuElement2;
                        }
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    static final class ReturnAction
    extends AbstractAction {
        ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement menuElement;
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0 && (menuElement = menuElementArray[menuElementArray.length - 1]) instanceof JMenuItem && (!(menuElement instanceof JMenu) || menuElement instanceof Actions.SubMenu && ((Actions.SubMenu)menuElement).getMenuComponentCount() <= 1)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ((JMenuItem)menuElement).doClick(0);
                ((JMenuItem)menuElement).setArmed(false);
            }
        }
    }

    static final class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 1);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length > 2) {
                MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }
}

