'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_tools.inc,v $
'*
'*  $Revision: 1.53 $
'*
'*  last change: $Author: hde $ $Date: 2006/02/16 08:42:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer-Tools
'*
'************************************************************************
'*
' #1 wDokSchreiben ( OutputText
' #1 wDocSetContext
' #1 wBlindtextEinfuegen
' #1 wSelectVorlage ( sVorlagenTyp as String
' #1 wZeichenobjektEinfuegen ( Objekt$
' #1 wObjektSelektieren ( xStart%
' #1 WortAusWoerterbuchLoeschen ( Aufnahme$ ) as Boolean
' #1 wIgnorierenlisteLoeschen
' #1 hLeisteUmschalten(welche as integer)
' #1 hGrafikleisteUmschalten(welche as integer)
' #1 wEinfuegenHyperlink(welcheSeite as integer)
' #1 wNavigatorAuswahl(Gruppe as integer
' #1 wClearDocument
' #1 wMarkObjects(delete as boolean)
' #1 hExportUmstellung ( WasDenn as Boolean )
' #1 wInsertFrame
' #1 wRectangleToClipboard
' #1 wRectangleToClipboardHTML
' #1 MachMirDenEintrag(WoDenn as integer
' #1 wOptionenUndo ( sOption$ )
' #1 wInsertDocumentinMasterDoc(DocumentName as string) as boolean
' #1 CheckForFilters() as boolean
' #1 hInsertFloatingFrame
'*
'\***********************************************************************



sub wDokSchreiben ( OutputText , optional iLoop as Integer )
Dim i as integer
If IsMissing(iLoop) = True then iLoop = 1
    For i = 1 to iLoop
    Select Case Ucase(gApplication)
        Case "WRITER"
        Kontext "DocumentWriter"
        DocumentWriter.TypeKeys OutputText

        Case "MASTERDOC"
        Kontext "DocumentMasterDoc"
        DocumentMasterDoc.TypeKeys OutputText

        Case "HTMLDOKUMENT"
        Kontext "DocumentWriterWeb"
        DocumentWriterWeb.TypeKeys OutputText

        case "DRAW"
        Call hTextrahmenErstellen (OutputText,10,10,50,20)
        case "IMPRESS"
        Call hTextrahmenErstellen (OutputText,10,10,50,20)

    end select
    wait 500
    next i
end sub

' -----------------------------------------------------------------------

sub wDocSetContext
    Select Case Ucase(gApplication)
        Case "WRITER"
        Kontext "DocumentWriter"

        Case "MASTERDOC"
        Kontext "DocumentMasterDoc"

        Case "HTMLDOKUMENT"
        Kontext "DocumentWriterWeb"

        Case "IMPRESS"
        Kontext "DocumentImpress"

        Case "DRAW"
        Kontext "DocumentDraw"

        Case "MATH"
        Kontext "DocumentMath"

        Case "CALC"
        Kontext "DocumentCalc"

    end select
    wait 500
end sub

' -----------------------------------------------------------------------

function wBlindtextEinfuegen() as boolean 
    '/// This functions inserts a Dummytext and returns true if it was inserted    
    Dim BlindText as string, bTemp as boolean
    bTemp = False
    select case iSprache
        case 01    : BlindText = "DT<F3>"
        case 03    : BlindText = "EDT<F3>"
        case 31    : BlindText = "BT<F3>"
        case 34    : BlindText = "TE<F3>"
        case 33    : BlindText = "TEX<F3>"
        case 39    : BlindText = "TE<F3>"
        case 45    : BlindText = "ET<F3>"
        case 46    : BlindText = "BT<F3>"
        case 49    : BlindText = "BT<F3>"
        case 55    : BlindText = "TP<F3>"
        case 81    : BlindText = "DT<F3>"
        case 82    : BlindText = "BT<F3>"
        case 86    : BlindText = "DT<F3>"
        case 88    : BlindText = "BT<F3>"
        case else : QAErrorlog "No Shortcut for Dummytext available!"
    end select

    if BlindText > "" then
        Call wDokSchreiben BlindText
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Warnlog Active.Gettext
                Active.Ok
            else
                bTemp = True 
            endif
        else
            bTemp = True
        endif
    endif
        
    wBlindtextEinfuegen = bTemp        

end function

' -----------------------------------------------------------------------

sub wZeichenobjektEinfuegen ( Objekt$, xStart%, yStart%, xEnde%, yEnde%, optional sCloseToolbar as boolean )

    Kontext "DrawBar"
    if Not DrawBar.Exists then Call hToolbarSelect("Drawing", true)
    Sleep 2

    Objekt = UCase( Objekt )
    select case Objekt
        case "RECHTECK" : Rechteck.Click
        case "LINIE"     : Linie.Click
        case "ELLIPSE"  : Ellipse.Click
        case "TEXT"      : Textobjekt.Click
        case "VTEXT"     :
        try
            VerticalText.Click
        catch
            if gAsianSup = True then
                Warnlog "Unable to insert Vertical Text! Asian Support in Options activated ?"
            endif
        endcatch
        case "LAUFTEXT" : Lauftext.Click
        case "LEGENDE"  : Legende.Click
        case "VLEGENDE" :
        try
            VerticalCallout.Click
        catch
            Warnlog "Unable to insert Vertical Callout! Asian Support in Options activated ?"
        endcatch
    end select

    Select Case gApplication
     Case "WRITER"
         Kontext "DocumentWriter"
         DocumentWriter.MouseDown xStart%, yStart%
         DocumentWriter.MouseMove xEnde%, yEnde%
         DocumentWriter.MouseUp xEnde%, yEnde%
         wait 100
         Kontext "Drawbar"
         if IsMissing(sCloseToolbar) then
             Drawbar.Close
         else
             if sCloseToolbar = true then Drawbar.Close
         endif
         if Objekt <> "TEXT" and Objekt <> "VTEXT" then
             Kontext "DocumentWriter"
             Call gMouseClick (99, 99)
             wait 100
         end if

     Case "MASTERDOC"
         Kontext "DocumentMasterDoc"
         DocumentMasterDoc.MouseDown xStart%, yStart%
         DocumentMasterDoc.MouseMove xEnde%, yEnde%
         DocumentMasterDoc.MouseUp xEnde%, yEnde%
         wait 100
         Kontext "Drawbar"
         if IsMissing(sCloseToolbar) then
             Drawbar.Close
         else
             if sCloseToolbar = true then Drawbar.Close
         endif
         if Objekt <> "TEXT" and Objekt <> "VTEXT" then
             Kontext "DocumentMasterDoc"
             Call gMouseClick (99, 99)
             wait 100
         end if
    end select
end sub

' -----------------------------------------------------------------------

sub wObjektSelektieren ( xStart%, yStart%, xEnde%, yEnde% )
    WL_TB_ZF_Auswahl
    Select Case gApplication
    Case "WRITER"
        Kontext "DocumentWriter"
        DocumentWriter.MouseDown xStart%, yStart%
        DocumentWriter.MouseMove xEnde%, yEnde%
        DocumentWriter.MouseUp xEnde%, yEnde%
    Case "MASTERDOC"
        Kontext "DocumentMasterDoc"
        DocumentMasterDoc.MouseDown xStart%, yStart%
        DocumentMasterDoc.MouseMove xEnde%, yEnde%
        DocumentMasterDoc.MouseUp xEnde%, yEnde%
    end select
    wait 200
end sub

' -----------------------------------------------------------------------

function WortAusWoerterbuchLoeschen ( Aufnahme$ ) as Boolean
    Dim i as integer : Dim AnzahlBuecher as string
    Dim j as integer
    
    ToolsOptions
    Call hToolsOptions("LanguageSettings","WritingAids")
    WortAusWoerterbuchLoeschen = FALSE
    for j = 1 to Benutzerwoerterbuch.GetItemCount
        try
            Bearbeiten.Click
            exit for
        catch
            Benutzerwoerterbuch.Select j
        endcatch
    next j
    Kontext "BenutzerwoerterbuchBearbeiten"
    AnzahlBuecher = Buch.GetItemCount

    for i= 1 to AnzahlBuecher
        Buch.Select i
        printlog "      - search word in module: " + Buch.GetSelText
        Kontext "BenutzerwoerterbuchBearbeiten"
        Inhalt.SetText Aufnahme$
        Sleep 1
        if Entfernen.IsEnabled then
            Entfernen.Click
            WortAusWoerterbuchLoeschen = TRUE
            i = AnzahlBuecher + 1
        endif
  next i
  if WortAusWoerterbuchLoeschen = FALSE then Warnlog "The added word has not been found in modules"
  BenutzerwoerterbuchBearbeiten.Close
  Kontext "ExtrasOptionenDlg"
  ExtrasOptionenDlg.OK
end function

' -----------------------------------------------------------------------

function wIgnorierenlisteLoeschen
    Dim i as integer : Dim j as integer : Dim AlleBuecher as integer

    ToolsOptions
    Call hToolsOptions("LANGUAGESETTINGS","WRITINGAIDS")
    Sleep 3
    for j = 1 to Benutzerwoerterbuch.GetItemCount
        try
            Bearbeiten.Click
            exit for
        catch
            Benutzerwoerterbuch.Select j
        endcatch
    next j
    Kontext "BenutzerwoerterbuchBearbeiten"
    sleep 1
    AlleBuecher = Buch.GetItemCount
    for i = 1 to AlleBuecher
        Buch.Select i
            if Left$(Buch.GetSelText,13)="IgnoreAllList" then
                sleep 2
                for j = 1 to 100
                    if Loeschen.IsEnabled then
                        Loeschen.Click
                        sleep 1
                    else
                        Kontext "Active"
                        if Active.Exists then
                            Warnlog Active.Gettext
                            Active.Ok
                        endif
                        Kontext "BenutzerwoerterbuchBearbeiten"
                        BenutzerwoerterbuchBearbeiten.Cancel
                        sleep 1
                        j=101
                    endif
                    wait 500
                next j
                i=AlleBuecher + 1
            endif
    next i
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
end function

' -----------------------------------------------------------------------

sub hLeisteUmschalten(welche as integer)
    Sleep 2
    Select Case welche
        case 1:
        try                                             ' Textobjectbar
            Kontext "NumObjectbar"
            NumObjectbar.SetNextToolbox
        catch
        endcatch
        Sleep 1
        if gApplication = "HTMLDOKUMENT" then
            Kontext "TextObjectbar"
        else
            Kontext "TextObjectbar"
        endif
        Sleep 1
        try
            Fett.Click    ' Sonst sind Comboboxen fȭr Testtool nicht sichtbar
            Sleep 1
            Fett.Click
        catch
          Warnlog "Error on switching the function bar!"
        endcatch
        Sleep 1

        case 2:
        Select Case gApplication
        ' Numbering-Objectbar
            Case "HTMLDOKUMENT"
                Kontext "TextObjectbar"
                try
                    TextObjectbar.SetNextToolbox
                catch
                endcatch

            Case else
                Kontext "TextObjectbar"
                try
                    TextObjectbar.SetNextToolbox
                catch
                endcatch
            end select
            Sleep 1
            Kontext "NumObjectbar"
            try
                Hinunterstufen.Click
            catch
                try
                    Hochstufen.Click
                catch
                    Warnlog "Error on switching the function bar!"
                endcatch
            endcatch
            Sleep 2
    end select
end sub

' -----------------------------------------------------------------------

sub hGrafikleisteUmschalten(welche as integer)
    Select Case welche
        case 1:
        try
            Kontext "GraphicObjectbar"
            Wait 500
            GraphicObjectbar.SetNextToolBox
        catch
        endcatch
        Kontext "FrameObjectbar"
        Sleep 1

        case 2:
        try
            Kontext "FrameObjectbar"
            Wait 500
            FrameObjectbar.SetNextToolBox
        catch
        endcatch
        Kontext "GraphicObjectbar"
        Sleep 1
    end select
end sub

' -----------------------------------------------------------------------

sub wEinfuegenHyperlink(welcheSeite as integer)
    Kontext "Hyperlink"
    Auswahl.MouseDown 2,2
    Auswahl.MouseUp 2,2
    wait 500
    Auswahl.TypeKeys "<Down>",1
    wait 500
    Auswahl.TypeKeys "<Up>",4
    Sleep 1

    Select case welcheSeite
        case 1:
        Kontext "TabHyperlinkInternet"

        case 2:
        Auswahl.TypeKeys "<Down>",1
        Kontext "TabHyperlinkMailUndNews"

        case 3:
        Auswahl.TypeKeys "<Down>",2
        Kontext "TabHyperlinkDokument"

        case 4:
        Auswahl.TypeKeys "<Down>",3
        Kontext "TabHyperlinkNeuesDokument"

    end select
end sub

' -----------------------------------------------------------------------

sub wNavigatorAuswahl(Gruppe as integer, Eintrag as integer,optional LeaveFocus as boolean)
    dim j as integer, WelcherEintrag as integer
    Dim MinEntrys as integer

    If IsMissing(LeaveFocus) = True then LeaveFocus = False

    Select Case Ucase(gApplication)
        Case "CALC"
            Kontext "NavigatorCalc"
            if NavigatorCalc.NotExists then EditNavigator
            wait 500
            Kontext "NavigatorCalc"
            MinEntrys = 8
        Case "WRITER", "HTMLDOKUMENT", "HTML"
            Kontext "NavigatorWriter"
            if NavigatorWriter.NotExists then EditNavigator
            wait 500
            Kontext "NavigatorWriter"
            MinEntrys = 11
        Case "MASTERDOC"
            Kontext "NavigatorGlobalDoc"
            if NavigatorGlobalDoc.NotExists then EditNavigator
            wait 500
            Kontext "NavigatorGlobalDoc"
            if Liste.IsVisible then
                Kontext "GlobaldokumentToolbox"
                Umschalten.Click
                Kontext "NavigatorWriter"
            endif
            MinEntrys = 11
        Case Else ' for all others!!!!
            Warnlog "Not supported application!"
            exit sub
    end select

	Sleep 2

    Select Case Ucase(gApplication)
        Case "CALC"
        if (Liste.GetItemCount < MinEntrys) then Umschalten.Click
        if Liste.GetItemCount >MinEntrys then
            For j= 1 to 9
                Liste.Select j
                Liste.TypeKeys "-"
            next j
        endif

        Liste.Select Gruppe
        if Eintrag >0 then
          WelcherEintrag = Gruppe + Eintrag
          Liste.TypeKeys "+"
          Liste.Select WelcherEintrag
          Liste.TypeKeys "<Return>"
        endif

        Case "WRITER","HTMLDOKUMENT", "HTML"
        if (Auswahlliste.GetItemCount < MinEntrys) then
            try
                Inhaltsansicht.Click
            catch
            endcatch
        endif
        if Auswahlliste.GetItemCount >MinEntrys then
            For j= 1 to 12
                Auswahlliste.Select j
                Auswahlliste.TypeKeys "-"
            next j
        endif

        Auswahlliste.Select Gruppe
        if Eintrag >0 then
            WelcherEintrag = Gruppe + Eintrag
            Auswahlliste.TypeKeys "+"
            Auswahlliste.Select WelcherEintrag
            Auswahlliste.TypeKeys "<Return>"
        endif

        Case "MASTERDOC"
        if Liste.IsVisible = True then
            Umschalten.Click
        endif

        if Auswahlliste.GetItemCount >MinEntrys then
             For j= 1 to 12
                 Auswahlliste.Select j
                 Auswahlliste.TypeKeys "-"
            next j
        endif

        Auswahlliste.Select Gruppe
        if Eintrag >0 then
            WelcherEintrag = Gruppe + Eintrag
            Auswahlliste.TypeKeys "+"
            Auswahlliste.Select WelcherEintrag
            Auswahlliste.TypeKeys "<Return>"
        endif
    end select

    if LeaveFocus = False then
        Select Case Ucase(gApplication)
            Case "CALC"
                Kontext "DocumentCalc"
            Case "HTMLDOKUMENT", "HTML"
                Kontext "DocumentWriter"
            Case "WRITER"
                Kontext "DocumentWriter"
            Case "MASTERDOC"
                Kontext "DocumentMasterDoc"
        end select
    endif
end sub

' ---------------------------------------------------------------

sub wClearDocument
    Dim i as integer : Dim j as integer
    '/// Remove all Text, Drawing-objects or Objects from document ///
    Call wDokSchreiben "<PageUp><Home>"
    Call wDokSchreiben "<Backspace>",5
    DocumentWriter.MouseDown ( 10,10 )
    DocumentWriter.MouseMove ( 75,60 )
    wait 500
    DocumentWriter.MouseUp ( 75, 60 )
    Sleep 1
    Call wDokSchreiben "<Delete>"
    Sleep 3

    Kontext "NavigatorWriter"
    if Not NavigatorWriter.Exists then EditNavigator
    wait 500

    Kontext "NavigatorWriter"
    if Auswahlliste.GetItemCount <11 then Inhaltsansicht.Click  ' Grundzustand

    if Auswahlliste.GetItemCount >11 then
        For j= 1 to 12
            Auswahlliste.Select j
            Auswahlliste.TypeKeys "-"
        next j
    endif
    wait 500
    for i = 1 to 12
        Auswahlliste.Select i
        Auswahlliste.TypeKeys "+"
        if Auswahlliste.GetItemCount > 11 then
            for j = 1 to 5 ' maximal 5 Elemente in einer Gruppe
                Auswahlliste.TypeKeys "<Down>"
                Auswahlliste.TypeKeys "<Delete>"
                wait 500
                if Auswahlliste.GetItemCount > 11 then Auswahlliste.Select i
            next j
        endif
    next i
    if j= 5 then Warnlog "Try another way to clear page !"

    Kontext "Navigator"
    try
        Navigator.Close
    catch
        Errorlog
        EditNavigator
    endcatch

    try
        Call wDokSchreiben "<Mod1 A>"
    catch
    endcatch
    Call wDokSchreiben "<Delete>"
    DocumentWriter.MouseDown ( 50,10 )
    DocumentWriter.MouseUp ( 50,10 )
    Sleep 2
    Call wDokSchreiben "<Home><PageUp>"
    Sleep 5
end sub

' ---------------------------------------------------------------

sub wMarkObjects(delete as boolean)
    ' The drawing objects has to be selected before deleting them
    Select Case gApplication
        Case "WRITER"
            Kontext "DocumentWriter"
        Case "MASTERDOC"
            Kontext "DocumentMasterDoc"
        Case "HTMLDOKUMENT"
            Kontext "DocumentWriterWeb"
    end select

    Call gMouseClick 50,50
    Call wDokSchreiben "<PageUp><Home>"
    Call wDokSchreiben "<Backspace>",5
    Call gMouseClick 50,50
    Select Case gApplication
        Case "WRITER"
            DocumentWriter.TypeKeys "<Shift F4>"

        Case "MASTERDOC"
            DocumentMasterDoc.TypeKeys "<Shift F4>"

        Case "HTMLDOKUMENT"
            DocumentWriterWeb.TypeKeys "<Shift F4>"        
    end select

    Sleep 1
    if delete = TRUE then
        Call wDokSchreiben "<Delete>"
        Sleep 3
    endif
end sub

' -----------------------------------------------------------------------

sub hExportUmstellung ( WasDenn as Boolean )
    if Ucase(gApplication) = "HTMLDOKUMENT" then
        ToolsOptions
        Call hToolsOptions("LoadSave","HTMLCompatibility")
        if WasDenn = TRUE then
          'Select Case iSprache
          ' Case 81 : Export.Select "Microsoft Internet Explorer 4.0"
          ' Case else : Export.Select "MS Internet Explorer 4.0"
          'end select
            try
                Export.Select "Microsoft Internet Explorer"
            catch
                Warnlog "Unable to choose browser for export !"
            endcatch
        else
            Export.Select "Netscape Navigator"
        end if
        Kontext "ExtrasOptionenDlg"
        ExtrasOptionenDlg.OK
    endif
end sub

' -----------------------------------------------------------------------

sub wSetMacroSecurityLevel ( wLevel as integer ) as boolean
    ToolsOptions
    Call hToolsOptions("StarOffice","Security")
    wSetMacroSecurityLevel = False
    try
        MacroSecurity.Click
    catch
        Warnlog "Unable to set macro security level (Button 'Macro Security' not found)"
        Goto EarlyExit
    endcatch

    Kontext
    Active.SetPage TabSecurityLevel
    Kontext "TabSecurityLevel"

    Select Case wLevel
        Case 1:     VeryHigh.Check
        Case 2:     High.Check
        Case 3:     Medium.Check
        Case 4:     Low.Check
        Case else:  Warnlog "Wrong level number entered. Unknown"
                    goto EarlyExit
    end select
    TabSecurityLevel.Ok
    wSetMacroSecurityLevel = True

EarlyExit:
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK

end sub

' -----------------------------------------------------------------------

sub wInsertFrame
    InsertFrame
    Kontext
    Active.SetPage TabType
    Kontext "TabType"
    TabType.OK
    Sleep 3
end sub

' -----------------------------------------------------------------------

sub wRectangleToClipboard
    Dim tempApplication as string
    tempApplication = gApplication
    gApplication = "DRAW"
    Call hNewDocument
    Call hRechteckErstellen ( 20, 20, 30, 30 )
    ' select the drawn object
    try
        EditSelectAll
    catch
        QAErrorlog "Unable to select object. Maybe not drawn!"
    endcatch
    ' copy the selected object
    try
        EditCopy
    catch
        Warnlog "Unable to copy object. Maybe not selected!"
    endcatch
    
    Call hCloseDocument
    gApplication = tempApplication
    Select Case gApplication
        Case "WRITER"
            Kontext "DocumentWriter"
        Case "MASTERDOC"
            Kontext "DocumentMasterDoc"
    end select
    Call gMouseClick 10,10
end sub

' -----------------------------------------------------------------------

sub wRectangleToClipboardHTML
    gApplication = "DRAW"
    Call hNewDocument
    Call hRechteckErstellen ( 20, 20, 30, 30 )
    EditSelectAll
    EditCopy
    Call hCloseDocument
    gApplication = "HTMLDokument"
    Kontext "DocumentWriterWeb"
    Call gMouseClick
end sub

' -----------------------------------------------------------------------

function MachMirDenEintrag(WoDenn as integer,WieLang as integer, optional Welches as string)
    Call wDokSchreiben "<Home>"
    Call wDokSchreiben "<Down>",WoDenn
    Call wDokSchreiben "<Mod1 Shift Right>" , WieLang
    Kontext "VerzeichniseintragEinfuegen"
    if Welches > "" then
        Select case Welches
            case "Inhalt" : Verzeichnis.Select 1
            case "Stich"  : Verzeichnis.Select 2
            case "Benutz" : Verzeichnis.Select 3
        end select
    endif
    Verzeichniseintrag.TypeKeys "<Up>"
    Wait 500
    EintragOk.Click
end function

' -----------------------------------------------------------------------

sub wOptionenUndo ( sOption$ )
	Dim i as integer

	Printlog "  - Initial state"

    Call hNewDocument
    
    Kontext "ExtrasOptionenDlg"
    if Not ExtrasOptionenDlg.Exists then
        ToolsOptions
    endif

    Call hToolsOptions("Textdocument","General")
    if sOption$ = "Laden" OR sOption$ = "Alle" then
        ' Update
        AufNachfrage.Check
        Feldbefehle.Check
        Diagramme.Uncheck
        ' Settings
        Masseinheit.Select 2
        if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
            Tabulatorenabstand.Settext "1.25 cm"
        else
            Tabulatorenabstand.Settext "1,25 cm"
        endif
    end if

    Call hToolsOptions("Textdocument","View")
    if sOption$ = "Inhalte" OR sOption$ = "Alle" then
        ' Guides
        Hilfslinien.Uncheck
        FarbigeHandles.Check
        GrosseHandles.Uncheck
        ' View
        HorizontaleBildlaufleiste.Check
        VertikaleBildlaufleiste.Check
        Lineal.Check
        HorizontalesLineal.Check
        VertikalesLineal.Check
        WeichesScrollen.Uncheck
        ' Display
        GrafikenUndObjekte.Check
        Tabellen.Check
        Zeichnungen.Check
        Feldname.Uncheck
        Notizen.Check
    end if

    if sOption$ = "Cursor" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","FormattingAids")
        ' Display of
        Absatzenden.UnCheck
        WeicheTrenner.Check
        Leerzeichen.UnCheck
        GeschLeerzeichen.Check
        Tabulatoren.UnCheck
        Umbrueche.UnCheck
        VersteckterText.Uncheck
        VersteckteAbsatze.Check
        'Direct-Cursor
        DirektCursor.Uncheck
        Absatzausrichtung.Check
        'Cursor in protected areas
        Zonen_Cursor.Check
    end if

    if sOption$ = "Raster" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","Grid")
        ' Grid
        FangrasterBenutzen.Uncheck
        RasterSichtbar.Uncheck
        ' Resolution
        AchsenSynchronisieren.Uncheck
        if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
            RasterAufloesungXAchse.SetText "1.00cm"
            RasterAufloesungYAchse.SetText "1.00cm"
        else
            RasterAufloesungXAchse.SetText "1,00cm"
            RasterAufloesungYAchse.SetText "1,00cm"
        end if
        RasterUnterteilungXAchse.ToMin
        RasterUnterteilungXAchse.More 1
        RasterUnterteilungYAchse.ToMin
        RasterUnterteilungYAchse.More 1
    end if

    if sOption$ = "Grundschriften" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","BasicFonts")
        Standard.Click
        AktuellesDokument.Uncheck
    end if

    if sOption$ = "Drucken" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","Print")
        ' Contents
        Grafiken.Check
        Tabellen.Check
        Zeichnungen.Check
        Kontrollfelder.Check
        Hintergrund.Check
        SchwarzDrucken.Uncheck
        ' Pages
        LinkeSeiten.Check
        RechteSeiten.Check
        Umgekehrt.Uncheck
        Prospekt.Uncheck
        ' Notes
        Keine.Check
        ' Other
        EinzelneDruckauftraege.Uncheck
        AusDruckereinstellung.Uncheck
        Fax.SetNoSelection
    end if

    if sOption$ = "Tabelle" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","Table")
        ' Default
        Ueberschrift.Check
        Wiederholen.Check
        NichtTrennen.Uncheck
        Umrandung.Check
        ' Input in Tables
        AutomatischeZahlenerkennung.Check
        Zahlenformaterkennung.Check
        AutomatischeAusrichtung.Check
        AutomatischeZahlenerkennung.UnCheck
        ' Keyboard handling
        if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
            VerschiebenZeile.SetText "0.50cm"
            VerschiebenSpalte.SetText "0.50cm"
            EinfuegenZeile.SetText "0.50cm"
            EinfuegenSpalte.SetText "2.50cm"
        else
            VerschiebenZeile.SetText "0,50cm"
            VerschiebenSpalte.SetText "0,50cm"
            EinfuegenZeile.SetText "0,50cm"
            EinfuegenSpalte.SetText "2,50cm"
        end if
        Sleep 1
        ' Behaviour of rows/columns
        Variabel.Check
    end if

    if sOption$ = "Aenderung" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","Changes")
        ' Text display
        EinfuegenAttribute.Select 4
        EinfuegenFarbe.Select 2
        LoeschenAttribute.Select 4
        LoeschenFarbe.Select 2
        AendernAttribute.Select 2
        AendernFarbe.Select 2
        ' Lines changed
        Zeilenmarkierung.Select 2
        Zeilenfarbe.Select 1
    end if

    if sOption$ = "AutoCaption" OR sOption$ = "Alle" then
        Call hToolsOptions("Textdocument","Autocaption")
		for i = 1 to ObjectList.GetItemCount
			ObjectList.Select i
			ObjectList.UnCheck
		next i
	endif	
	
    Kontext "ExtrasOptionenDlg"
    ExtrasOptionenDlg.OK
    
    Call hCloseDocument
end sub

' -----------------------------------------------------------------------

function wInsertDocumentinMasterDoc(DocumentName as string) as boolean
    Call hNewDocument
    Call hDateiOeffnen(DocumentName)
    Sleep 5
    Call wDokSchreiben "<Mod1 A>"
    Sleep 2
    EditCopy
    Call hCloseDocument
    wInsertDocumentinMasterDoc = True
end function

' -----------------------------------------------------------------------

function CheckForFilters() as boolean
    Kontext "GraphicFilterBar"
    if not GraphicFilterBar.Exists then
        Warnlog "- Toolbox has been closed!"
        Kontext "GraphicObjectbar"
        if Filter.IsEnabled then
            GraphicObjectbar.TearOff Filter
            Kontext "GraphicFilterBar"
            GraphicFilterBar.Move ( 20, 20 )
            CheckForFilters = True
        else
            Warnlog "- Though graphic is selected, the filter button in objectbar is disabled!"
            Select Case gApplication
                Case "WRITER"
                    Kontext "DocumentWriter"
                    DocumentWriter.MouseDoubleClick 10,10
                    DocumentWriter.MouseDown 50,20
                    DocumentWriter.MouseUp 50,20
                case else
                    Kontext "DocumentMasterDoc"
                    DocumentMasterDoc.MouseDoubleClick 10,10
                    DocumentMasterDoc.MouseDown 50,20
                    DocumentMasterDoc.MouseUp 50,20
            end select
            Wait 500
            Kontext "GraphicObjectbar"
            if Filter.IsEnabled then
                GraphicObjectbar.TearOff Filter
                Kontext "GraphicFilterBar"
                GraphicFilterBar.Move ( 20, 20 )
                CheckForFilters = True
            else
                Warnlog "- Reselecting the graphic didn't enable the button in the toolbar! No further test!"
                CheckForFilters = False
            endif
        endif
    else
        CheckForFilters=True
    endif
    Kontext "GraphicFilterBar"
end function

' -----------------------------------------------------------------------

sub hInsertFloatingFrame
    Sleep 3
    InsertFloatingFrame
    Sleep 3
    Kontext "TabEigenschaften"
    FrameName.SetText "Hallo"
    TabEigenschaften.OK
    Sleep 2
    Kontext "OeffnenDlg"
    if OeffnenDlg.Exists(2) then OeffnenDlg.Cancel
end sub

' -----------------------------------------------------------------------

function wStyleCreate( sStyleName as string, sType as string, optional NotFromSelection as boolean ) as boolean
	'/// This function creates a new style through stylist

	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist
    
	select case sType
        case "Paragraph":	Absatzvorlagen.Click
        case "Character":	Zeichenvorlagen.Click
        case "Frame":		Rahmenvorlagen.Click
        case "Page":		Seitenvorlagen.Click
		case "Numbering":	Numerierungsvorlagen.Click
    end select

	if IsMissing ( NotFromSelection ) then
        wait 500
        AusSelektion.OpenMenu
        Sleep 1
        Call hMenuSelectNr(1)
        Sleep 1
        wait 500
        Kontext "VorlageErzeugen"
        Vorlagenname.Settext sStyleName
        VorlageErzeugen.Ok
    else
        if NotFromSelection = true then
            VorlagenListe.TypeKeys "<Mod1 End>"
            Vorlagenliste.TypeKeys "<Mod1 Home>"
            Vorlagenliste.OpenContextMenu
            Sleep 1
            Call hMenuSelectNr(1) 
            wait 500
            Kontext
            Active.SetPage TabVerwalten
            wait 500
            Kontext "TabVerwalten"
            VorlagenName.SetText sStyleName
            wait 500
            TabVerwalten.OK
        endif
    endif

	Kontext "Stylist"
      
    if wStyleSelect ( sStyleName, sType ) = true then
        wStyleCreate = False
    else
        wStyleCreate = True
    endif
	Stylist.Close
end function

' -----------------------------------------------------------------------

function wStyleSelect( sStyleName as string, optional sType as string ) as boolean
	'/// This function selects a given style in Stylist
	'/// function leaves Stylist opened

	Dim i as integer

	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist

    wait 500
    Gruppenliste.Select 2	'-> 'All Styles' has to be selected
    wait 500
    if IsMissing (sType) then
	    Absatzvorlagen.Click    
    else
        select case sType
            case "Paragraph":	Absatzvorlagen.Click
            case "Character":	Zeichenvorlagen.Click
            case "Frame":		Rahmenvorlagen.Click
            case "Page":		Seitenvorlagen.Click
            case "Numbering":	Numerierungsvorlagen.Click
        end select
    endif
    
	Sleep 1
    Vorlagenliste.Select 1
    wait 500
	if Vorlagenliste.GetSelText <> sStyleName then
		For i = 1 to 200
			if Vorlagenliste.GetSelText = sStyleName then
				wStyleSelect = true
				i = 202
            else
                Vorlagenliste.TypeKeys "<Down>"
            endif
		next i
		if i = 202 then wStyleSelect = true
	else
		wStyleSelect = true
	endif

end function

' -----------------------------------------------------------------------

function wStyleDelete ( sStyleName as string, sType as string ) as boolean
	'/// This function selects a given style in Stylist
	'/// function leaves Stylist opened

	Dim i as integer

	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist

	select case sType
		case "Paragraph":	Absatzvorlagen.Click
		case "Character":	Zeichenvorlagen.Click
		case "Frame":		Rahmenvorlagen.Click
		case "Page":		Seitenvorlagen.Click
		case "Numbering":	Numerierungsvorlagen.Click
	end select

	Vorlagenliste.TypeKeys "<Mod1 End>"
    Vorlagenliste.TypeKeys "<Mod1 Home>"
	if Vorlagenliste.GetSelText <> sStyleName then
		For i = 1 to 200
			if Vorlagenliste.GetSelText = sStyleName then
                Vorlagenliste.OpenContextMenu
                Sleep 1
                Call hMenuSelectNr(3) 
                wait 500
                Kontext "Active"
                if Active.Exists then
                    if Active.GetRT = 304 then
                        Active.Yes
						i = 203
                    endif
                endif
			else
                Vorlagenliste.TypeKeys "<Down>"
            endif			
		next i
		if i = 204 then wStyleDelete = true
	else
        Vorlagenliste.OpenContextMenu
        Sleep 1
        Call hMenuSelectNr(3) 
        wait 500
        Kontext "Active"
        if Active.Exists then
            if Active.GetRT = 304 then
                Active.Yes
            endif
        endif
        wStyleDelete = true
	endif

end function

' -----------------------------------------------------------------------

function wStyleSet( sStyleName as string, optional sType as string ) as boolean
	'/// This function sets a given style in Stylist
	'/// function leaves Stylist opened

	Dim i as integer

	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist

    wait 500
    Gruppenliste.Select 2	'-> 'All Styles' has to be selected
    wait 500
    if IsMissing (sType) then
	    Absatzvorlagen.Click    
    else
        select case sType
            case "Paragraph":	Absatzvorlagen.Click
            case "Character":	Zeichenvorlagen.Click
            case "Frame":		Rahmenvorlagen.Click
            case "Page":		Seitenvorlagen.Click
            case "Numbering":	Numerierungsvorlagen.Click
        end select
    endif
    
	Sleep 1
    Vorlagenliste.Select 1
    wait 500
	if Vorlagenliste.GetSelText <> sStyleName then
		For i = 1 to 200
			if Vorlagenliste.GetSelText = sStyleName then
				wStyleSet = true
                Vorlagenliste.TypeKeys "<Return>"
				exit for
            else
                Vorlagenliste.TypeKeys "<Down>"
            endif
		next i
	else
		wStyleSet = true
	endif

end function

' -----------------------------------------------------------------------

function wStyleGet( sStyleName as string, optional sType as string ) as boolean
	'/// This function checks if a given style is selected in Stylist
	'/// function leaves Stylist opened

	Dim i as integer

	Kontext "Stylist"
	If Not Stylist.Exists then FormatStylist

    wait 500
    Gruppenliste.Select 2	'-> 'All Styles' has to be selected
    wait 500
    if IsMissing (sType) then
	    Absatzvorlagen.Click    
    else
        select case sType
            case "Paragraph":	Absatzvorlagen.Click
            case "Character":	Zeichenvorlagen.Click
            case "Frame":		Rahmenvorlagen.Click
            case "Page":		Seitenvorlagen.Click
            case "Numbering":	Numerierungsvorlagen.Click
        end select
    endif
    
    wait 500
	if Vorlagenliste.GetSelText = sStyleName then
		wStyleGet = true
	endif

end function

