'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_contextmenu1.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:27:12 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Pick context for context menus
'*
'\***********************************************************************



sub w_contextmenu1

	Call tPickSimpleText
	Call tPickSimpleTextMultiselection
	Call tPickGraphic
	Call tPickHyperlink
	Call tPickDrawingObjects
	
end sub

' -----------------------------------------------------------------------------

testcase tPickSimpleText
	Dim SetThisFontSize as string, GetThisFontSize as string
	printlog "Open context menu on unselected text"
	'/// Open a new text document
	Call hNewDocument
	' Set zoom to 100%    
	Call wSetZoom
	'/// Write down 'This is a test'
	Call wDokSchreiben "This is a test"

	'/// In text document select word 'test'
	Call wDokSchreiben "<End>"
	Call wDokSchreiben "<Mod1 Shift Left>"	
	'/// Open context menu in word 'This'
	' Shift + F8 changes selection mode in writer
	Call wDokSchreiben "<Shift F8>"
	Call wDokSchreiben "<Mod1 Left>", 3
	Call wDokSchreiben "<Right>"
	Call wDokSchreiben "<Shift F8>"
	Call DocumentWriter.MouseMove 16, 18
	Call wOpenContextMenu(true)
	'/// Change font size for word 'This'
	try
		Call hMenuSelectNr(3)
		wait 500
		SetThisFontSize = hMenuItemGetText(MenuGetItemCount)
		Call hMenuSelectNr(MenuGetItemCount)
	catch
		Warnlog "Unable to open context menu"
	endcatch
		
	Call wDokSchreiben "<Home>"
	'/// Check if font size has changed for word 'This' and not for word 'test'
	Call wDokSchreiben "<Right>"
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True or gCTLSup = True then
		GetThisFontSize = SizeWest.GetSelText
	else
		GetThisFontSize = Size.GetSelText
	endif	
	TabFont.Ok
	
	if GetThisFontSize <> SetThisFontSize then Warnlog "Fontsize for word 'This' has not correctly been set"
		
	Call wDokSchreiben "<Mod1 Right>", 3
	Call wDokSchreiben "<Right>"
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True or gCTLSup = True then
		GetThisFontSize = SizeWest.GetSelText
	else
		GetThisFontSize = Size.GetSelText
	endif	
	TabFont.Ok
	
	if GetThisFontSize = SetThisFontSize then Warnlog "Fontsize for word 'test' has been set"

	
	Call hCloseDocument
	
endcase

' -----------------------------------------------------------------------------

testcase tPickSimpleTextMultiselection
	Dim SetThisFontSize as string, GetThisFontSize as string
	printlog "Open context menu on unselected text"
	'/// Open a new text document
	Call hNewDocument
	' Set zoom to 100%    
	Call wSetZoom
	'/// Write down 'This is a test'
	Call wDokSchreiben "This is a test"

	'/// In text document select word 'test' and 'This'
	Call wDokSchreiben "<End>"
	Call wDokSchreiben "<Mod1 Shift Left>"	
	'/// Open context menu in word 'This'
	' Shift + F8 changes selection mode in writer
	Call wDokSchreiben "<Shift F8>"
	Call wDokSchreiben "<Mod1 Left>", 3
	Call wDokSchreiben "<Mod1 Shift Right>"
	Call wDokSchreiben "<Shift F8>"
	Call DocumentWriter.MouseMove 12, 18
	Call wOpenContextMenu(true)
	'/// Change font size 
	try
		Call hMenuSelectNr(3)
		wait 500
		SetThisFontSize = hMenuItemGetText(MenuGetItemCount)
		Call hMenuSelectNr(MenuGetItemCount)
	catch
		Warnlog "Unable to open context menu"
	endcatch
		
	Call wDokSchreiben "<Home>"
	'/// Check if font size has changed for words 'This' and 'test'
	Call wDokSchreiben "<Right>"
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True or gCTLSup = True then
		GetThisFontSize = SizeWest.GetSelText
	else
		GetThisFontSize = Size.GetSelText
	endif	
	TabFont.Ok
	
	if GetThisFontSize <> SetThisFontSize then Warnlog "Fontsize for word 'This' has not correctly been set"
		
	Call wDokSchreiben "<Mod1 Right>", 3
	Call wDokSchreiben "<Right>"
	FormatCharacter
	Kontext
	Active.Setpage TabFont
	Kontext "TabFont"
	if gAsianSup = True or gCTLSup = True then
		GetThisFontSize = SizeWest.GetSelText
	else
		GetThisFontSize = Size.GetSelText
	endif	
	TabFont.Ok
	
	if GetThisFontSize <> SetThisFontSize then Warnlog "Fontsize for word 'test' has not correctly been set"

	
	Call hCloseDocument
	
endcase

' -----------------------------------------------------------------------------

testcase tPickGraphic

	printlog "Open context menu on not focussed graphic"
	'/// Open a new text document 
	Call hNewDocument
	' Set zoom to 100%    
	Call wSetZoom
	'/// Insert a graphic into writerdocument
	Call hGrafikEinfuegen ( gTesttoolPath + "writer\level1\input\menu\drums.jpg" )
	'/// Deselect graphic with 'Escape' and insert some text in text document
	Call wDokSchreiben "<Escape>"
	Call wDokSchreiben "Don't be afraid !"

	Call DocumentWriter.MouseMove 50,30
	'/// Open context menu upon graphic with mouse
	Call wOpenContextMenu(true)
	
	printlog "Select 'ImageMap' in context menu"
	try
		Call hMenuSelectNr(7)
		wait 500
	catch
		Warnlog "Unable to open context menu"
		Call hCloseDocument
		goto endsub		
	endcatch
	'/// The graphic has to be selected and the context menu has to show graphics related commands 
	Kontext "ImageMapEditor"
	if Not ImageMapEditor.Exists then
		Warnlog "Unfortunately not the context menu from graphics has been used!"
		Kontext
		try
			Active.Setpage TabFont
			Kontext "TabFont"	
			TabFont.Cancel
		catch
		endcatch
	else
		ImageMapEditor.Close
		Kontext "Active"
		if Active.Exists then
			if Active.GetRT = 304 then Active.No
		endif
	endif	

	Kontext "DocumentWriter"		
	try
		FormatGraphics
		Kontext
		Active.Setpage TabType
		Kontext "TabType"
		TabType.Close
	catch
		Warnlog "Graphic has not been selected!"
	endcatch
	'/// Close text document
	Call hCloseDocument
	
endcase

' -----------------------------------------------------------------------------

testcase tPickHyperlink	
	
	printlog "Context menu on hyperlinks"
	'/// Open a new text document
	Call hNewDocument
	' Set zoom to 100%    
	Call wSetZoom
	' empty clipboard
	SetClipBoard = ""
	'/// Insert a hyperlink in document
	Call wDokSchreiben "www.sun.com"
	Call wDokSchreiben " "
	
	'/// Open context menu on hyperlink
	Call DocumentWriter.MouseMove 10, 18
	Call wOpenContextMenu(true)
	'/// Last entry in menu has to be 'Open hyperlink' ....
	if MenuGetItemCount = 12 then
		Warnlog "Missing menu entry for hyperlinks to open"
	else		
		if MenuGetItemCount = 13 then Call hMenuSelectNr(13)
	endif
	
	'/// Close text document
	Call hCloseDocument		
	
endcase

' -----------------------------------------------------------------------------

testcase tPickDrawingObjects
	
	printlog "Context menu on drawing objects"
	'/// Open a new text document
	Call hNewDocument
	' Set zoom to 100%    
	Call wSetZoom
	' empty clipboard
	SetClipBoard = ""
    '/// Insert 2 drawing objects (rectangle)

    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 20, 30, 30 )
	Sleep 2
    Call wZeichenobjektEinfuegen ( "Rechteck", 20, 35, 30, 45 )

    '/// Select both objects
    Call wObjektSelektieren ( 15, 15, 50, 50 )
    
	'///  Open context menu on 1. drawing object
	Call DocumentWriter.MouseMove 25, 25
	Call wOpenContextMenu(true)
	' Normally 'copy' is last menu entry
	Call hMenuSelectNr(12)
	
	'///  Both drawing objects have to leave selected
	try
        FormatGroupGroup
        Sleep 1
	catch        
		Warnlog "Drawing objects did not leave selected after context menu opened"
    endcatch
	
	'/// Close text document
	Call hCloseDocument	
	
endcase
