'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_103_.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:26:02 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description :
'*
'\***********************************************************************


sub w_103_
    printLog Chr(13) + "---------   Level 1  - Menu / View -   ----------"

    Call tViewZoom
    Call tViewToolbarsEtc
    Call tViewOnlineLayout
    Call tViewCurrentDatabase

end sub


'------------------------------------------------------

testcase tViewZoom
  PrintLog "- View / Zoom"
   '/// New document ///
   Call hNewDocument

   '/// View / Zoom ///
   ViewZoom
   Kontext "Massstab"
   '/// Check if 100% is default ///
   if NOT Vergroesserung100.IsChecked then Warnlog "100 % is not default"
  printlog "  - 200 % "
   '/// Check 200% and close dialog / Reopen dialog and check if 200 % is checked ///
   Vergroesserung200.Check
   Massstab.OK
   Sleep 1

   '/// Reopen View / Zoom and check if 200% is checked ///
   ViewZoom
   Kontext "Massstab"
   if NOT Vergroesserung200.IsChecked then Warnlog "200 % is not checked anymore"
  printlog "  - 150 % "
   '/// Check 150% and close dialog / Reopen dialog and check if 150 % is checked ///
   Vergroesserung150.Check
   Massstab.OK
   Sleep 1

   ViewZoom
   Kontext "Massstab"
   if NOT Vergroesserung150.IsChecked then Warnlog "150 % is not checked anymore"
  printlog "  - 100 % "
   '/// Check 75% and close dialog / Reopen dialog and check if 75 % is checked ///
   Vergroesserung100.Check
   Massstab.OK
   Sleep 1

   ViewZoom
   Kontext "Massstab"
   if NOT Vergroesserung100.IsChecked then Warnlog "100 % is not checked anymore"
  printlog "  - 75 % "
   Vergroesserung75.Check
   Massstab.OK
   Sleep 1

   ViewZoom
   Kontext "Massstab"
   if NOT Vergroesserung75.IsChecked then Warnlog "75 % is not checked anymore"
  printlog "  - 50 % "
   Vergroesserung50.Check
   Massstab.OK
   Sleep 1

   ViewZoom
   Kontext "Massstab"
   '/// Check 50% and close dialog / Reopen dialog and check if 50% is checked ///
   if NOT Vergroesserung50.IsChecked then Warnlog "50 % is not checked anymore"
  printlog "  - Stufenlos ( 86% )"
   '/// Check 'Variable' and close dialog / Reopen dialog and check if 'Variable' is checked ///
   VergroesserungStufenlos.Check
   Stufenlos.SetText "86"
   Massstab.OK
   Sleep 1

   ViewZoom
   Kontext "Massstab"
   if NOT VergroesserungStufenlos.IsChecked then Warnlog "Variable is not checked anymore"
   if Stufenlos.GetText <> "86%" then Warnlog "Variable not 86% but : "+ Stufenlos.GetText
  printlog "  - Ganze Seite"
   '/// Check 'Entire Page' and close dialog / Reopen dialog and check if 'Entire Dialog' is checked ///
   GanzeSeite.Check
   Massstab.OK
   Sleep 2

   ViewZoom
   Kontext "Massstab"
   if NOT GanzeSeite.IsChecked then Warnlog "Entire Page is not checked anymore"
  printlog "  - Optimal"
   '/// Check 'Entire Page' and close dialog / Reopen dialog and check if 'Entire Dialog' is checked ///
   Optimal.Check
   Massstab.OK
   Sleep 2

   ViewZoom
   Kontext "Massstab"
   if NOT Optimal.IsChecked then Warnlog "Optimal is not checked anymore"
  printlog "  - Page Width"
   '/// Check 'Page Width' and close dialog / Reopen dialog and check if 'Page Width' is checked ///
   Seitenbreite.Check
   Massstab.OK
   Sleep 2

   ViewZoom
   Kontext "Massstab"
   if NOT Seitenbreite.IsChecked then Warnlog "Page Width is not checked anymore"
  printlog "  - Reselect 100 %-Default"
   '/// Reselect the default value 100% ///
   Vergroesserung100.Check
   Massstab.OK
   Sleep 2
   '/// Close document ///
   Call hCloseDocument
endcase

'-----------------------------------------------------------

testcase tViewToolbarsEtc
  PrintLog "- switch off all Toolbars"

   '/// Open file ' gTesttoolPath + "writer\level1\input\st1_1.sxw" ' ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ConvertPath ( gTesttoolPath + "writer\input\st1_1.sxw" )
   else
    Call hDateiOeffnen ConvertPath ( gTesttoolPath + "writer\level1\input\masterdoc\st1_1.sxg" )
   endif

   '/// Switch off View / Toolbars / Functionbar ///
   ViewToolbarsFunctionbar
   Sleep 1
   '/// Switch off View / Toolbars / Objectbar ///
   ViewToolbarsObjectbar
   Sleep 1
   '/// Switch off View / Toolbars / Main Toolbar ///
   ViewToolbarsMainToolbar
   Sleep 1
   '/// Switch off View / Toolbars / Ruler ///
   ViewRuler
   Sleep 1

  PrintLog "- switch off all"
   '/// Switch off View / Field Shadings ///
   ViewFieldShadings
   Sleep 1
   '/// Switch off / Text Boundaries ///
   ViewTextBoundaries
   Sleep 1
   '/// Switch off View / Hidden Paragraph ///
   ViewHiddenParagraphs
   Sleep 1

   Call wDokSchreiben "Hallo jetzt ist alles unter dem Ansichtmen ausgeschaltet<Return><Return>"

  PrintLog "- switch on"
   Sleep 1
   ViewToolbarsFunctionbar
   '/// Switch on View / Toolbars / Functionbar ///
   Sleep 1
   ViewToolbarsObjectbar
   '/// Switch on View / Toolbars / Objectbar ///
   Sleep 1
   ViewToolbarsMainToolbar
   '/// Switch on View / Toolbars / Main Toolbar ///
   Sleep 1
   ViewToolbarsHyperlinkbar
   '/// Switch on View / Hyperlink bar ///
   Sleep 1
   ViewRuler
   Sleep 1

  PrintLog "- switch on rest"
   ViewFieldShadings
   '/// Switch on View / Field Shadings ///
   Sleep 1
   ViewTextBoundaries
   '/// Switch on View / Text Boundaries ///
   Sleep 1
   ViewHiddenParagraphs
   '/// Switch on View / Hidden Paragraphs ///
   Sleep 1
   ViewFields
   '/// Switch on View / Fields ///
   Sleep 1
   '/// Switch on View / NonPrinting Characters ///
   ViewNonprintingCharacters
   Sleep 1

   Call wDokSchreiben "Hallo jetzt ist alles unter dem Ansichtmen eingeschaltet<Return><Return>"

  Printlog "- reproduce the default"
   Sleep 1
   '/// Switch off View / Toolbars / Hyperlink Bar ///
   ViewToolbarsHyperlinkbar
   Sleep 1
   '/// Switch off View / Fields ///
   ViewFields
   Sleep 1
   '/// Switch off View / NonPrinting Characters ///
   ViewNonprintingCharacters
   Sleep 1

   Call wDokSchreiben "Hallo jetzt ist alles wieder normal<Return><Return>"
   Sleep 1
   '/// Close document ///
   Call hCloseDocument
endcase

'-----------------------------------------------------------

testcase tViewOnlineLayout
   '/// View / Onlinelayout ///
  PrintLog "- View / OnlineLayout"

   '/// Open file ..\writer\level1\input\st1_1.sxw ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ConvertPath ( gTesttoolPath + "writer\input\st1_1.sxw" )
   else
    Call hDateiOeffnen ConvertPath ( gTesttoolPath + "writer\level1\input\masterdoc\st1_1.sxg" )
   endif
   '/// Check View / Online-Layout ///
   ViewOnlineLayout
   Sleep 2
   '/// Uncheck View / Online-Layout ///
   ViewOnlineLayout
   '/// Close document ///
   Call hCloseDocument

endcase

'-----------------------------------------------------------

testcase tViewCurrentDatabase
printlog "- View / Current Database"
   '/// View / Current Database ///
    PrintLog "- View / Current Database"

   '/// Open new writerdocument ///
   Call  hNewDocument
   '/// View / Current Database ///
   ViewCurrentDatabaseWriter

   Kontext "DatabaseTableView"
   '/// Check if database beamer has been opened ///
   if Not DatabaseTableView.Exists then
      Warnlog "Database Beamer has not been opened!"
   else
   '/// Close database beamer ///
    ViewCurrentDatabaseWriter
     Kontext "DatabaseTableView"
      if DatabaseTableView.Exists then
       Warnlog "Could not close Databasebeamer with same slot!"
       ViewBeamer
         Kontext "DatabaseTableView"
         if DatabaseTableView.Exists then Warnlog "Could not close Databasebeamer with Slot->View Beamer!"
      endif
   end if
   Sleep 1

   '/// Close document ///
   Call hCloseDocument
endcase




