'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_101_.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:25:18 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : Writer Level1 Test
'*
'\***********************************************************************

sub w_101_
    printLog Chr(13) + "---------    Stufe 1   - Dateimenü -    ----------"

    if gApplication = "WRITER" then Call tFileNewLabels
    if gApplication = "WRITER" then Call tFileNewBusinessCards

    Call tFileOpenSaveEtc
    Call tFileSendDocumentAsEmail
    if gApplication = "WRITER" then Call tFileSendCreateMasterdocument
    Call tFileSendCreateHTMLDocument
    Call tFileSendOutlineToPresentation
    Call tFileSendOutlineToClipboard
    Call tFileSendCreateAutoabstract
    Call tFileSendAutoabstractToPresentation
    Call tFileProperties
    Call tFilePagePreview
    Call tFilePrint

end sub

' *******************************************************************
' *******************************************************************
' *******************************************************************

testcase tFileNewLabels
 printlog "- File / New / Labels"
 dim dieMarke as string, derTyp as string
 '/// Call Labels dialog ///
 if hCreateLabels = False then Exit Sub
 Kontext
  '/// Choose tabpage forms ///
  Active.Setpage TabEtiketten
  Kontext "TabEtiketten"
  '/// Uncheck Address ///
  Adresse.Uncheck
  '/// Change Label text ///
  Aufschrift.Settext "123456789012"
  Sleep 2
  '/// Check Sheet ///
  Bogen.Check
  try
   '/// Select Type Number 1 ///
   Marke.Select 1
   dieMarke = Marke.GetItemText(1)
  catch
   Warnlog "- There are " + Marke.GetItemCount + " Items in the Brand-Combobox! Test exits !"
   TabEtiketten.Close
   goto endsub
  endcatch

  try
   Typ.Select 1
   derTyp = Typ.GetItemText(1)
  catch
   Warnlog "- There are " + Typ.GetItemCount + " Items in the Brand-Combobox! Test exits !"
   TabEtiketten.Close
   goto endsub
  endcatch

 Kontext
  '/// Check next Tabpage (Format) ///
  Active.Setpage TabFormatEtiketten
  Kontext "TabFormatEtiketten"
  if iSystemSprache = 01 or iSystemSprache = 48 then
   HAbstand.Settext "2.00"
   vAbstand.Settext "7.00"
   Breite.Settext "2.00"
   Hoehe.Settext "3.00"
   RandLinks.Settext ".00"
   RandRechts.Settext ".00"
  else
   '/// Change Horizontal Pitch to 2,00cm ///
   HAbstand.Settext "2,00"
   '/// Change Vertical Pitch to 7,00cm ///
   vAbstand.Settext "7,00"
   '/// Change Width to 2,00cm" ///
   Breite.Settext "2,00"
   '/// Change Height to 3,00cm ///
   Hoehe.Settext "3,00"
   '/// Change Left Margin to 0 ///
   RandLinks.Settext "0"
   '/// Change Right Margin to 0 ///
   RandRechts.Settext "0"
  endif
   '/// Change Columns to 5 ///
   Spalten.Settext "5"
   '/// Change Rows to 5 ///
   Zeilen.Settext "5"

 Kontext
  '/// Select Tabpage Options ///
  Active.Setpage TabZusaetzeEtiketten
  Kontext "TabZusaetzeEtiketten"
  '/// Check entire Page ///
  GanzeSeite.Check
  '/// Check Synchronize contents ///
  InhaltSynchronisieren.Check
  '/// Click new document ///
  NeuesDok.Click
  Sleep 5
  Kontext "Active"
  if Active.Exists then
   try
     Active.Ok
   catch
     Active.Cancel
     Warnlog "Once Document has been opened, office asks to save it! BugID 89702"
   endcatch
  endif
  wait 500
  '/// Save document as Labels.sxw ///
  Call hSpeichernUnter(gOfficepath + "user\work\Labels.sxw")
  Sleep 2
  Call hCloseDocument
  '/// Load previous saved document ///
  Call hDateiOeffnen(ConvertPath(gOfficepath + "user\work\Labels.sxw"))

  printlog "- Checking the Properties"
  if hCreateLabels = False then Exit Sub
  '/// Check the properties of saved document ///
  Kontext
   Active.Setpage TabEtiketten
   Kontext "TabEtiketten"
   if Aufschrift.Gettext<> "123456789012" then Warnlog "Label text is wrong !"
   Sleep 2
   if Not Bogen.IsChecked then Warnlog "Sheet is not checked!"
   if Marke.GetSelText <> dieMarke then Warnlog "Wrong brand selected!"
   if Typ.GetSelText <> derTyp then Warnlog "Wrong Type selected!"

  Kontext
   Active.Setpage TabFormatEtiketten
   Kontext "TabFormatEtiketten"
  if iSystemSprache = 01 or iSystemSprache = 48 or iSystemSprache = 07 then
   if left$(HAbstand.Gettext,4) <> "2.00" then Warnlog "Wrong Horizontal Pitch! Is :" + left$(HAbstand.Gettext,4)
   if left$(vAbstand.Gettext,4) <> "7.00" then Warnlog "Wrong vertical pitch!"
   if left$(Breite.Gettext,4) <> "2.00" then Warnlog "Wrong width!"
   if left$(Hoehe.Gettext,4) <> "3.00" then Warnlog "Wrong height!"
    if iSystemSprache = 48 then
     if Left$(RandLinks.Gettext,4) <> "0.00" then Warnlog "Wrong left margin!"
     if Left$(RandRechts.Gettext,4) <> "0.00" then Warnlog "Wrong top margin!"
    else
     if Left$(RandLinks.Gettext,4) <> ".00" then Warnlog "Wrong left margin!"
     if Left$(RandRechts.Gettext,4) <> ".00" then Warnlog "Wrong top margin!"
    endif
  else
   if left$(HAbstand.Gettext,4) <>"2,00" then Warnlog "Wrong horizontal pitch!"
   if left$(vAbstand.Gettext,4) <>"7,00" then Warnlog "Wrong vertical pitch!"
   if left$(Breite.Gettext,4) <>"2,00" then Warnlog "Wrong Width!"
   if left$(Hoehe.Gettext,4) <>"3,00" then Warnlog "Wrong height!"
   if Left$(RandLinks.Gettext,4) <> "0,00" then Warnlog "Wrong margin left!"
   if Left$(RandRechts.Gettext,4) <> "0,00" then Warnlog "Wrong margin top!"
  endif
   if Spalten.Gettext <> "5" then Warnlog "Wrong number of columns!"
   if Zeilen.Gettext <> "5" then Warnlog "Wrong number of rows!"

  Kontext
   Active.Setpage TabZusaetzeEtiketten
   Kontext "TabZusaetzeEtiketten"
   if Not GanzeSeite.IsChecked then Warnlog "'Entire Page' is not checked!"
   if Not InhaltSynchronisieren.IsChecked then Warnlog "Synchronise contents is not checked!"
   TabZusaetzeEtiketten.Cancel
    '/// Close document ///
   Call hCloseDocument

endcase

'***********************************************************************

testcase tFileNewBusinessCards
 printlog "- File / New / Business Cards"
   '/// Open Business Cards dialog ///
  if hCreateBusinessCards = False then Exit Sub
  Kontext
  Active.Setpage TabEtikettenMedium
  Kontext "TabEtikettenMedium"
  '/// Check Sheet and Slect as Type entry No. 1 ///
  Bogen.Check

  try
   Marke.Select 1
   dieMarke = Marke.GetItemText(1)
  catch
   Warnlog "- There are " + Marke.GetItemCount + " Items in the Brand-Combobox! Test exits !"
   TabEtiketten.Close
   goto endsub
  endcatch

  try
   Typ.Select 1
   derTyp = Typ.GetItemText(1)
  catch
   Warnlog "- There are " + Typ.GetItemCount + " Items in the Brand-Combobox! Test exits !"
   TabEtiketten.Close
   goto endsub
  endcatch
   '/// Select the private tabpage ///

  Wait 500
  Kontext
   Active.Setpage TabPrivat
   Kontext "TabPrivat"
   '/// Enter some User data ///
   Vorname.Settext "Herr"
   Nachname.Settext "Testuser"
   Strasse.Settext "Saxenfeld 4"
   PLZ.Settext "20097"
   Ort.Settext "Hamburg"
   Land.Settext "DE"
   Email.Settext gUser + "@germany.sun.com"

  Wait 500
  Kontext
   '/// Select the tabpage Business ///
   Active.Setpage TabGeschaeft
   Kontext "TabGeschaeft"
   Firma.Settext "StarOffice Software Entwicklungs GmbH"
   Slogan.Settext "Besser is das"
   Strasse.Settext "Saxenfeld 4"
   PLZ.Settext "20097"
   Ort.Settext "Hamburg"
   Land.Settext "DE"
   Email.Settext gUser + "@germany.sun.com"

  Wait 500
  Kontext
   '/// Select the Tabpage Format ///
   Active.Setpage TabFormatEtiketten
   Kontext "TabFormatEtiketten"
   '/// Change value for Horizontal pitch ///
   HAbstand.Settext "2,00"
   '/// Change value for Vertical pitch ///
   vAbstand.Settext "2,00"
   '/// Change value for width ///
   Breite.Settext "2,00"
   '/// Change value for Height ///
   Hoehe.Settext "2,00"
   '/// Change value for Left Margin ///
   RandLinks.Settext "0,00"
   '/// Change value for Right margin ///
   RandRechts.Settext "0,00"
   '/// Cahnge value for Columns ///
   Spalten.Settext "10"
   '/// Change value for Rows ///
   Zeilen.Settext "10"

  Wait 500
  Kontext
   '/// Select Tabpage Options ///
   Active.Setpage TabZusaetzeEtiketten
   Kontext "TabZusaetzeEtiketten"
   '/// Select Radiobutton Entire Page ///
   GanzeSeite.Check
   '/// Check Synchronize Contents ///
   InhaltSynchronisieren.Check
   '/// Hit New Document ///
   NeuesDok.Click
   Sleep 5
   Kontext "Active"
   if Active.Exists then
    try
      Active.Ok
    catch
      Active.Cancel
      Warnlog "Once Document has been opened, office asks to save it! BugID 89702"
    endcatch
   endif
  wait 500
   '/// Save document as Cards.sxw///
   Call hSpeichernUnter (gOfficepath + "user\work\cards.sxw")
   '/// Load previous saved document ///
   Call hCloseDocument
   Sleep 1
   Call hDateiOeffnen (gOfficepath + "user\work\cards.sxw")
   Sleep 2
    '/// Close document ///
   Call hCloseDocument
endcase

'***********************************************************************

testcase tFileOpenSaveEtc
   Dim Dokument$
   Dim Dokument2$ : Dim j as integer

   if gApplication = "WRITER" then
    Dokument$ = ConvertPath ( gOfficePath +"user\work\wst1.sxw")
    Dokument2$ = ConvertPath ( gOfficePath +"user\work\wst1_2.sxw")
   else
    Dokument$ = ConvertPath ( gOfficePath +"user\work\wst1.sxg")
    Dokument2$ = ConvertPath ( gOfficePath +"user\work\wst1_2.sxg")
   endif

   if Dir (Dokument$) <> "" then kill Dokument$
   if Dir (Dokument2$) <> "" then kill Dokument2$
   '/// New document ///
   Call hNewDocument
   '/// Insert a table into document ///
   Call hTabelleEinfuegen

   printlog "- Save and close Writer document with a table"
   '/// Save document ///
   Call hSpeichernUnterKill(Dokument$)
    '/// Close document ///
   Call hCloseDocument

   printlog "- Load and close a document"
   '/// Open previous saved document ///
   Call hDateiOeffnen(Dokument$)
   '/// Close document ///
   Call hCloseDocument
   Sleep 2

   printlog "- Load Document , modify and close"
   '/// Load document, modify and close ///
   Call hDateiOeffnen(Dokument$)
   Call wDokSchreiben "<Down>", 2
   Call wDokSchreiben "Veränderung"
   '/// Close document ///
   FileClose
   '/// Cancel messagebox ///
   Kontext
   Active.Cancel

   printlog "- Versions"
   '/// Reload saved document ///
   FileReload
   Kontext
   '/// Check previous saved document ///
   Active.Yes
   Kontext "Active"
   if Active.Exists then
    if Active.GetRT = 304 then
    try
     Active.Yes
    catch
     For j = 1 to 100
      if Active.Exists then
       Warnlog Active.Gettext
       Active.Ok
      else
       j = 100
      endif
     next j
    endcatch
    endif
   endif
   Sleep 3
   Call wDokSchreiben "<Down>", 3
   Call wDokSchreiben "<Home><Shift End>"
   try
    EditCopy
   catch
   endcatch
   Sleep 1
   if GetClipboardText = "Veränderung" then Warnlog "Last Version of document has not been loaded."

   printlog "- Modify document and save with another name"
   '/// Modify document and save with another name ///

   Call wDokSchreiben "<Down>"
   Call wDokSchreiben "Veränderung"

   '/// Save modified document ///
   Call hSpeichernUnterKill(Dokument2$)

   printlog "- Loading document write protected"
   '/// Reload document and check it ///

   Call hDateiOeffnen(Dokument2$)
   Call wDokSchreiben "<Space>"
   Kontext "Active"
   if Active.Exists then
    if Active.GetRT = 304 then
     Warnlog "Document has been loaded write protected!"
    '/// Close document ///
     Call hCloseDocument
    endif
   endif
    '/// Close document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tFileSendDocumentAsEmail
   PrintLog "- File / Send / Document as eMail"
   '/// New document ///
   Printlog "Currently unable to test!"
   goto endsub
   Call hNewDocument
   '/// Write some text in to document ///

   Call wDokSchreiben "Hallo, ich werde an eine Mail angehaengt"

   FileSendDocumentAsEmail
   '/// Select -> File-> Send-> Document as eMail ///

   Kontext "Active"     ' No SMTP-Server-Entry in options
   if Active.Exists then
      Warnlog Active.GetText
      Active.OK
   end if
   Kontext "TabSendAsEmail"
   Wait 500

   '/// The beamer has to come up, Select Close ///
   CloseIt.Click

   '/// In messagebox select 'Back to message' ///

   Kontext "Active"      ' Push 'Back to message'
   if Active.Exists then Active.Cancel
   Kontext "TabSendAsEmail"
   '/// Select 'Close' again ///
   CloseIt.Click

   '/// Now select 'Discard' in messagebox ///

   Kontext "Active"    ' Click 'Discard'
   if Active.Exists then Active.Click(201)
    '/// Close document ///
   Call hCloseDocument

endcase

' *******************************************************************

testcase tFileSendCreateMasterdocument
   Dim DiesesGlobaldokument as String, DiesesWriterDokument as string,DiesesAndereWriterDokument as string
   Dim SelVorlage as integer : Dim j as integer
   printlog "- File / Send / Create Masterdocument"

  DiesesGlobaldokument = Convertpath( gOfficePath + "user\work\masterdoc.sxg" )
  DiesesWriterDokument= Convertpath(gOfficePath + "user\work\masterdoc1.sxw")
  DiesesAndereWriterDokument= Convertpath(gOfficePath + "user\work\masterdoc2.sxw")

  if hFileExists ( DiesesGlobaldokument ) then app.kill ( DiesesGlobaldokument )
  if hFileExists ( DiesesWriterDokument ) then app.kill ( DiesesWriterDokument )
  if hFileExists ( DiesesAndereWriterDokument ) then app.kill ( DiesesAndereWriterDokument )
   '/// open testdocument (st1_1.sxw) ///

  Call hDateiOeffnen ( gTesttoolPath + "writer\input\st1_1.sxw" )

  printlog "   - Create Master document"
   '/// Select 'File -> Send -> Create Masterdocument ///
   FileSendCreateMasterdocument
   '/// the 'Save as...' dialog has to appear ///
   Kontext "SendMasterDocument"
   if SendMasterDocument.NotExists then
     Warnlog "Save As - Dialog didn't appear!"
     Call hCloseDocument
     goto endsub
   endif

  '/// Select as template 'Default' ///
   try
     Vorlage.Select 1
   catch
     Warnlog "Unable to select template. Maybe wrong dialog!"
     SendMasterDocument.Cancel
     Call hCloseDocument
     goto endsub
   endcatch

  '/// Save document as 'masterdoc.sxg' ///
   if AutomatischeDateinamenserweiterung.IsChecked then
    Dateiname.SetText Convertpath( gOfficePath + "user\work\masterdoc" )
   else
    Dateiname.SetText Convertpath( gOfficePath + "user\work\masterdoc.sxg" )
   endif

   Speichern.Click

   '/// a messagebox asking to update the document has to appear. Select 'yes'///
   Sleep 3
   Kontext "Active"
   if Active.Exists then
    if Active.GetRT = 304 then
     try
      Active.yes
     catch
      For j = 1 to 100
       if Active.Exists then
        Warnlog Active.Gettext
        Active.Ok
       else
        j = 100
       endif
      next j
     endcatch
    else
      Warnlog "- No messagebox asking for the actualizationing of the master document !"
    endif
   else
     Warnlog "- No messagebox asking for the actualizationing of the master document !"
   endif


   Sleep 2

   Kontext "Navigator"
   if Navigator.Exists then
      Navigator.Close
   else
      Warnlog "Navigator in Master document isn't up!"
   end if
    '/// Close document ///
   Call hCloseDocument

   '/// Check if documents have been created ///
  if hFileExists ( DiesesWriterDokument )=False then
   Warnlog "- Document 1 for Master document has not been created!"
  else
   printlog "-  Document 1 for Master document has been created!"
   app.kill ( DiesesWriterDokument )
  endif

  if hFileExists ( DiesesAndereWriterDokument )=False then
   Warnlog "- Document 2 for Master document has not been created!"
  else
   printlog "-  Document 2 for Master document has been created!"
   app.kill ( DiesesAndereWriterDokument )
  endif

endcase

' *******************************************************************

testcase tFileSendCreateHTMLDocument
  Dim DieseHTMLDatei as String

  printlog "- File / Send / Create HTML-Document"

   '/// Open document 'htmltest.sxw' ///
   DieseHTMLDatei = ConvertPath( gOfficePath + "user\work\hfred.html" )
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\htmltest.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\htmltest.sxg" )
   endif
   if hFileExists ( DieseHTMLDatei ) then app.kill ( DieseHTMLDatei )

  printlog "   - Create HTML-Document"
   '/// Select File->Send-> Create HTML-Document///
   FileSendCreateHTMLDocument
   Kontext "SendHTMLDocument"
   if SendHTMLDocument.NotExists then
    Warnlog "Save as dialog didn't appear!"
    Call hCloseDocument
    goto endsub
   endif

   '/// Save as.. dialog has to appear -> Select template 'Standard' ///
   try
     Vorlage.Select 1
   catch
     Warnlog "Unable to select template. Maybe wrong dialog!"
     SendHTMLDocument.Cancel
     Call hCloseDocument
     goto endsub
   endcatch

   if AutomatischeDateinamenserweiterung.IsChecked then
    Dateiname.SetText Convertpath( gOfficePath + "user\work\hfred" )
   else
    Dateiname.SetText ( DieseHTMLDatei )
   endif
   Speichern.Click
   '/// Check if previous saved document exists ///
   Kontext "Active"
   if Active.Exists then
    if Active.GetRT = 304 then
     try
      Active.yes
     catch
      For j = 1 to 100
       if Active.Exists then
        Warnlog Active.Gettext
        Active.Ok
       else
        j = 100
       endif
      next j
     endcatch
    endif
   endif


   Sleep 3

   FileClose

   if hFileExists ( DieseHTMLDatei )=False then Warnlog "-  HTML-File has not been created!"

endcase

' *******************************************************************

testcase tFileSendOutlineToPresentation
   PrintLog "- File / Send / Outline to presentation"
   '/// Open document htmltest.sxw ///

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\htmltest.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\htmltest.sxg" )
   endif
   Sleep 1
   '/// Select File->Send->Outline to presentation ///

   FileSendOutlineToPresentation
   Sleep 3
   '/// Check results ///
    Printlog "    - check results"
     Kontext "DocumentImpressOutlineView"
      DocumentImpressOutlineView.TypeKeys "<Shift End>"
      EditCopy
      wait 500
      if GetClipboardText <> "Seite 1." then Warnlog "- Error on first outline"
      DocumentImpressOutlineView.TypeKeys "<Home>"
      DocumentImpressOutlineView.TypeKeys "<Down>",4
      DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
      wait 500
      EditCopy
      Sleep 2
      if GetClipboardText <> "Untertitel 2 der Seite 2" then Warnlog "- Error at 2nd subtitel of second outline"
      printlog GetClipboardtext
      '/// Close created document ///
      Call hCloseDocument
      Sleep 2
      '/// Close source document ///
      Call hCloseDocument
endcase

' *******************************************************************

testcase tFileSendOutlineToClipboard
  Dim j as Integer
  Dim Fehler as Integer

   PrintLog "- File / Send / Outline to clipboard"
   '/// Open document 'htmltest.sxw' ///

   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\htmltest.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\htmltest.sxg" )
   endif
   '/// Select File->Send->Outline to Clipboard ///
   FileSendOutlineToClipboard
   Sleep 2
    '/// Close opened document ///
   Call hCloseDocument

   Printlog "    - check Results"
   Sleep 2
   '/// New document ///
   Call hNewDocument
   '/// Paste clipboard content and check the results ///
   EditPaste
   Call wDokSchreiben "<Up>", 10
   Call wDokSchreiben "<Home><Shift End>"
   sleep 1
   EditCopy
   if GetClipboardText <> ("Seite 1.") then Warnlog "A page break was taken over in clipboard!"
   Call wDokSchreiben "<Home>"
   Call wDokSchreiben "<Down>", 4
   Call wDokSchreiben "<Home><Shift End>"
   EditCopy
   if GetClipboardText <> ("Untertitel 2 der Seite 2") then Warnlog "Outline has not been created correctly!"
    '/// Close document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tFileSendCreateAutoabstract
   PrintLog "- File / Send / Create Autoabstract"

   '/// Open document 'htmltest.sxw' ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\htmltest.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\htmltest.sxg" )
   endif
   Sleep 2
   '/// Select File->Send->Create Autoabstract ///
   FileSendCreateAutoabstract
   '/// Close following dialog with 'OK' ///
   Kontext "AutoAbstractErzeugen"
   AutoAbstractErzeugen.OK

   Sleep 2
   '/// Check results in created document ///
   Printlog "    - Check results"
      Call wDokSchreiben "<Shift End>"
      EditCopy
      if GetClipboardText <> "Seite 1." then Warnlog "- Error on first outline"

      Call wDokSchreiben "<Home><Down>",5
      Call wDokSchreiben "<Home><Shift End>"
      EditCopy
      if GetClipboardText <> "Untertitel 2 der Seite 1" then Warnlog "- Error at subtitel of first outline"

      if gPlatgroup <> "unx" then
       Call wDokSchreiben "<Home><Down>",4
      else
       Call wDokSchreiben "<Home><Down>",5
      endif

      Call wDokSchreiben "<Home><Shift End>"
      EditCopy
      if GetClipboardText <> "Seite 2" then Warnlog "- Error on second outline"

      Call wDokSchreiben "<Home><Down>",5
      Call wDokSchreiben "<Home><Shift End>"
      EditCopy
      if GetClipboardText <> "Untertitel 1 der Seite 2" then Warnlog "- Error at subtitel of second outline"

      if gPlatGroup <> "unx" then
       Call wDokSchreiben "<Home><Down>",4
      else
       Call wDokSchreiben "<Home><Down>",5
      endif
      Call wDokSchreiben "<Home><Shift End>"
      EditCopy
      if GetClipboardText <> "Untertitel 2 der Seite 2" then Warnlog "- Error at subtitel of second outline"


    '/// Close created document ///
   Call hCloseDocument
   Sleep 2
    '/// Close source document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tFileSendAutoabstractToPresentation
   PrintLog "- File / Send / Autoabstract to Presentation"
   '/// Open document 'htmltest.sxw' ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gTesttoolPath + "writer\input\htmltest.sxw" )
   else
    Call hDateiOeffnen ( gTesttoolPath + "writer\level1\input\masterdoc\htmltest.sxg" )
   endif
   Sleep 2
   '/// Select File->Send-> Autoabstract to presentation ///
   FileSendAutoabstractToPresentation
   '/// Close following dialog with 'OK' ///
   Kontext "AutoAbstractErzeugen"
   AutoAbstractErzeugen.OK
   Sleep 2

   '/// Check results in created document ///
    Kontext "DocumentImpressOutlineView"
   if DocumentImpressOutlineView.Exists then
    Printlog "    - check results"
    DocumentImpressOutlineView.TypeKeys "<Mod1 Home>"
    DocumentImpressOutlineView.TypeKeys "<Shift End>"
    EditCopy
     if GetClipboardText <> "Seite 1." then Warnlog "- Error on first outline"

    DocumentImpressOutlineView.TypeKeys "<Home><Down>",12
    DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
    EditCopy
    ' Need more tolerance here so check a line upper or lower
    if GetClipboardText <> "Untertitel 2 der Seite 1" then
       if wCheckOutline("Untertitel 2 der Seite 1") = False then
          Warnlog "- Error on first outline"
       endif
    endif
    DocumentImpressOutlineView.TypeKeys "<Home><Down>",11
    DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
    EditCopy
    if GetClipboardText <> "Seite 2" then
       if wCheckOutline("Seite 2") = False then
          Warnlog "- Error on second outline"
       endif
    endif
    DocumentImpressOutlineView.TypeKeys "<Home><Down>",12
    DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
    EditCopy
    if GetClipboardText <> "Untertitel 1 der Seite 2" then
       if wCheckOutline("Untertitel 1 der Seite 2") = False then
          Warnlog "- Error at subtitel of second outline"
       endif
    endif
    DocumentImpressOutlineView.TypeKeys "<Home><Down>",11
    DocumentImpressOutlineView.TypeKeys "<Home><Shift End>"
    EditCopy
    if GetClipboardText <> "Untertitel 2 der Seite 2" then
       if wCheckOutline("Untertitel 2 der Seite 2") = False then
          Warnlog "- Error at subtitel of second outline"
       endif
    endif
    '/// Close created document ///
    Call hCloseDocument
    wait 500
   '/// Select File->Send->Autoabstract to presentation again///
    FileSendAutoabstractToPresentation
   '/// Close following dialog with 'OK' and check if document has been created ///
    Kontext "AutoAbstractErzeugen"
    AutoAbstractErzeugen.OK
    Kontext "DocumentImpressOutlineView"
     if DocumentImpressOutlineView.Exists then
      '/// Close created document ///
      Call hCloseDocument
     else
      Warnlog "- Document has not been created at the second time! No Test!"
      Call hCloseDocument
      goto endsub
     endif
   else
    Warnlog "- Document has not been created at the first time! No Test!"
    Call hCloseDocument
    goto endsub
   endif
    '/// Close source document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tFileProperties
   PrintLog "- File / Properties"
   '/// New document and insert some text ///
   Call hNewDocument
   Call wDokSchreiben "Dies ist ein Dokument für die Dokumenteigenschaften"
   '/// Select File->Properties ///

   FileProperties
   Sleep 1
   '/// In dialog select Tabpage 'Description' and modify properties ///
   Kontext
   active.SetPage TabDokumentinfo
   Sleep 1
   Kontext "TabDokumentinfo"
   Titel.SetText "Eigenschaften"
   Thema.SetText "Dokumenteigenschaften"
   Schluesselworte.SetText "keine"
   '/// Select Tabpage User-defined and modify properties ///
   Kontext
   active.SetPage TabBenutzer
   Sleep 1
   Kontext "TabBenutzer"
   Info2.SetText "Helge Delfs"

   Infofelder.Click
   Kontext "InfonamenBearbeiten"
   Namen2.SetText "Name"
   InfonamenBearbeiten.OK

   '/// Select Tabpage Internet and modify properties ///
   Kontext
   active.SetPage TabInternet
   Sleep 1
   Kontext "TabInternet"
   RefreshThisDocument.Check
   TimeReload.Settext "30"
   '/// Close properties dialog ///

   TabInternet.OK
   '/// Save document as dokeigen.sxw ///

   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath +"user\work\dokeigen.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath +"user\work\dokeigen.sxg" )
   endif
   Sleep 2
   '/// Close document ///
   FileClose
   Sleep 2

   PrintLog "- File / compare properties"
   Sleep 2
   '/// Open previous saved document ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gOfficePath +"user\work\dokeigen.sxw" )
   else
    Call hDateiOeffnen ( gOfficePath +"user\work\dokeigen.sxg" )
   endif
   Sleep 2
   '/// Select File->Properties and check the saved properties ///
   FileProperties
   Sleep 1
   Kontext
   active.SetPage TabDokumentinfo
   Sleep 1
   Kontext "TabDokumentinfo"
   Sleep 1
   if Titel.GetText <> "Eigenschaften" then Warnlog "Description / Title wrong"
   if Thema.GetText <> "Dokumenteigenschaften" then Warnlog "Description / Subject wrong"
   if Schluesselworte.GetText <> "keine" then Warnlog "Description / Key words wrong"

   Kontext
   Sleep 1
   active.SetPage TabBenutzer
   Sleep 1
   Kontext "TabBenutzer"
   if Info2.GetText <> "Helge Delfs" then Warnlog "User Defined / Info2 wrong"

   Infofelder.Click
   Sleep 2
   Kontext "InfonamenBearbeiten"
   if Namen2.GetText <> "Name" then Warnlog "User Defined / Info2 wrong ("+Namen2.Gettext+")"
   InfonamenBearbeiten.OK

   Kontext
   active.SetPage TabInternet
   Sleep 1
   Kontext "TabInternet"

   if RefreshThisDocument.IsChecked = FALSE then Warnlog "Internet / 'Refresh this document' isn't checked (Bug#101614)"
   if TimeReload.Gettext <> "30" then Warnlog "Internet / Refresh Time is wrong  (Bug#101614)!"

   TabInternet.Close
   Sleep 1
    '/// Close document ///
   Call hCloseDocument
   Sleep 1
endcase

' *******************************************************************

testcase tFilePagePreview
   Dim i as Integer, sSeparator as string
   Dim w1, w2, w3, w4, w5, w6, w7, w8 as String

   PrintLog "- File / Page Preview"
    '/// New document ///
   Call hNewDocument
   '/// Insert 6 manual breaks ///
   for i = 1 to 6
      InsertManualBreak
      Kontext "UmbruchEinfuegen"
      Seitenumbruch.Check
      UmbruchEinfuegen.OK
   next i
   '/// Select File->Page Preview ///

   FilePageView
   Sleep 2

  '/// Select to document begin ///
  Printlog "  - to Document begin"
   Kontext "OL_SW_Seitenansicht"
   ErsteSeite.Click
   Sleep 2
   '/// Select to document end ///
  Printlog "  - to document end"
   LetzteSeite.Click
   Sleep 2
  '/// Select to document begin again ///
   ErsteSeite.Click
   Sleep 2

   '/// Select next page 3 times ///
  Printlog "  - next Pages"
   for i=1 to 3
      NaechsteSeite.Click
      Sleep 1
   next i
   try
       OL_SEITENANSICHT_NaechsteSeite            ' nur der Slot bemerkt, ob der Punkt aktiv ist oder nicht
       Warnlog "Next Page could have been clicked too often"
   catch
   endcatch
   Sleep 1
  '/// Select previous page 3 times ///
  Printlog "  - previous Pages"
   for i=1 to 3
      VorherigeSeite.Click
      Sleep 1
   next i
   try
      OL_SEITENANSICHT_VorherigeSeite            ' nur der Slot bemerkt, ob der Punkt aktiv ist oder nicht
      Warnlog "Next Page could have been clicked too often"
   catch
   endcatch
   Sleep 1

  '/// Select Preview: Several page in one view ///
  Printlog "  - 4 Pages"
   VierSeiten.Click
   Sleep 1

   Kontext "MassstabSeitenansicht"
   '/// Set value for columns to 3 and close dialog with 'OK' ///
   Zeilen.SetText "3"
   MassstabSeitenansicht.OK
   Sleep 1
   Kontext "OL_SW_Seitenansicht"
   VierSeiten.Click
   Sleep 1
   '/// Reopen the dialog and check if value has been set ///
   Kontext "MassstabSeitenansicht"
   if Zeilen.GetText <> "3" then Warnlog "No. of Columns has not been maintained. Now it is at " + Zeilen.GetText
   Zeilen.SetText "1"
   Spalten.Settext "1"
   '/// Close dialog ///
   MassstabSeitenansicht.OK
   Sleep 1

   '/// Select Preview: Two Pages ///
   Printlog "  - 2 Pages"
    Kontext "OL_SW_Seitenansicht"
   try
      ZweiSeiten.Click
      Sleep 1
   catch
      Warnlog "Button 'Two pages' is not enabled !"
   endcatch

  '/// Select 4th entry in Zoom-Combobox ///
  Printlog "  - Zoom"
   Kontext "OL_SW_Seitenansicht"
   try
      Massstab.Select 4
   catch
      Warnlog "Unable to change Zoom factor in toolbar!"
   endcatch

   '/// Increase Zoom-Factor until button is disabled ///
   for i = 1 to 10
      try
         Groesser.Click
         printlog "Increase Zoom to " + Massstab.GetSeltext
      catch
      endcatch
   next i

   '/// Decrease Zoom-Factor until button is disabled ///
   for i = 1 to 10
         try
            Kleiner.Click
            printlog "Decrease Zoom to " + Massstab.GetSeltext
         catch
         endcatch
   next i

   '/// Select Full Screen ///
   Kontext "OL_SW_Seitenansicht"
   Printlog "  - Full Screen"
   GanzerBildschirm.Click
   Sleep 1
   '/// Close full Screen View ///
   ViewFullScreen
   Sleep 1

  '/// Select Print Page view ///
   Printlog "  - call Printerdialog"
   DruckenSeitenansicht.Click
   Kontext "DruckenDlg"
   if DruckenDlg.Exists then
      DruckenDlg.Cancel
   else
      Kontext "Active"
      if Active.Exists then
         Active.Ok
         Warnlog "- No Default Printer !"
      endif
   endif

   Kontext "OL_SW_Seitenansicht"
   printlog "  - adjust printer options"
   '/// Adjust printer options ///
   Skalierung.Click
   Kontext "Druckoptionen"
   sSeparator  = GetDecimalSeperator(Rechts.Gettext)
   Zeilen.More 3     : w1 = Zeilen.GetText
   Spalten.More 4    : w2 = Spalten.GetText
   Links.More 2      : w3 = Links.GetText
   Rechts.Less 4     : w4 = Rechts.GetText
   Oben.Less 4       : w5 = Oben.GetText
   Unten.More 2      : w6 = Unten.GetText
   Horizontal.More 1 : w7 = Horizontal.GetText
   Vertikal.More 9   : w8 = Vertikal.GetText

   if w4 =  "0" + sSeparator + "00" then Warnlog "Right isn't 0" + sSeparator + "00.., but " + w4
   if w5 =  "0" + sSeparator + "00" then Warnlog "Right isn't 0" + sSeparator + "00.., but " + w5

   '/// Close dialog for print options with 'OK' ///
   Druckoptionen.OK

   Kontext "OL_SW_Seitenansicht"
   '/// Check previous made printer options ///
  printlog "  - check printer options"
   Skalierung.Click
   Kontext "Druckoptionen"
   if Zeilen.GetText     <> w1 then Warnlog "Columns Setting isn't " + w1 + " anymore, but " + Zeilen.GetText
   if Spalten.GetText    <> w2 then Warnlog "Rows Setting isn't " + w2 + " anymore, but " + Spalten.GetText
   if Links.GetText      <> w3 then Warnlog "Left Setting isn't " + w3 + " anymore, but " + Links.GetText
   if Rechts.GetText     <> w4 then Warnlog "Right Setting isn't " + w4 + " anymore, but " + Rechts.GetText
   if Oben.GetText       <> w5 then Warnlog "Top Setting isn't " + w5 + " anymore, but " + Oben.GetText
   if Unten.GetText      <> w6 then Warnlog "Bottom Setting isn't " + w6 + " anymore, but " + Unten.GetText
   if Horizontal.GetText <> w7 then Warnlog "Horizontal Setting isn't " + w7 + " anymore, but " + Horizontal.GetText
   if Vertikal.GetText   <> w8 then Warnlog "Vertical Setting isn't " + w8 + " anymore, but " + Vertikal.GetText
   Druckoptionen.Cancel

   Kontext "OL_SW_Seitenansicht"
   '/// close page preview ///
  Printlog "  - close page preview"
   SeitenansichtSchliessen.Click
   '/// Save modified document ///
  Printlog "  - Check if printer options has been saved!"
   if gApplication = "WRITER" then
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxw" )
   else
    Call hSpeichernUnterKill ( gOfficePath + "user\work\stufe1.sxg" )
   endif
    '/// Close document ///
   Call hCloseDocument
   '/// Reopen previous saved document ///
   if gApplication = "WRITER" then
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxw" )
   else
    Call hDateiOeffnen ( gOfficePath + "user\work\stufe1.sxg" )
   endif

   '/// Select File->Page Preview and check properties ///
   FilePageView
   Sleep 2
   Kontext "OL_SW_Seitenansicht"
   Skalierung.Click
   Kontext "Druckoptionen"
   if Zeilen.GetText     <> w1 then Warnlog "Columns Setting isn't " + w1 + " anymore, but " + Zeilen.GetText
   if Spalten.GetText    <> w2 then Warnlog "Rows Setting isn't " + w2 + " anymore, but " + Spalten.GetText
   if Links.GetText      <> w3 then Warnlog "Left Setting isn't " + w3 + " anymore, but " + Links.GetText
   if Rechts.GetText     <> w4 then Warnlog "Right Setting isn't " + w4 + " anymore, but " + Rechts.GetText
   if Oben.GetText       <> w5 then Warnlog "Top Setting isn't " + w5 + " anymore, but " + Oben.GetText
   if Unten.GetText      <> w6 then Warnlog "Bottom Setting isn't " + w6 + " anymore, but " + Unten.GetText
   if Horizontal.GetText <> w7 then Warnlog "Horizontal Setting isn't " + w7 + " anymore, but " + Horizontal.GetText
   if Vertikal.GetText   <> w8 then Warnlog "Vertical Setting isn't " + w8 + " anymore, but " + Vertikal.GetText
   Druckoptionen.Cancel
   Kontext "OL_SW_Seitenansicht"
   SeitenansichtSchliessen.Click
   Sleep 1
    '/// Close document ///
   Call hCloseDocument
endcase

' *******************************************************************

testcase tFilePrint
   PrintLog "- File / Print"
    '/// New document ///
   Call hNewDocument
   '/// Insert some text in document ///
   Call wDokSchreiben "Dies ist ein automatischer Drucktest mit dem Testtool"
   Call wDokSchreiben "<Return>Version    : "+ gVersionsnummer + " / " + gLanguage
   Call wDokSchreiben "<Return>Datum/Zeit : "+  Date + " / " + Time
   Call wDokSchreiben "<Return><Return> Wer Das Liest Ist Doof ;-)"
   Call wDokSchreiben "<Return><Return> Nach Ablauf einer Woche ist dieses als allgemeines Notizpapier freigegeben :-))"
   '/// Select File->Print///
   FilePrint
  Kontext "Active"
 if Active.Exists then
  If Active.GetRT = 304 then
   Active.Ok       ' Messagebox abfangen-> Kein Standarddrucker
   Warnlog "No Default-Printer!"
  endif
 else
    Kontext "DruckenDlg"
   '/// Modify print Options///
    Printlog "  - modify Options"
    Zusaetze.Click
    Kontext "DruckerZusaetzeWriter"
    Sleep 1
    Prospekt.Check
    Seitenende.Check
    AusDruckereinstellung.Check
    DruckerZusaetzeWriter.OK

   '/// Compare print options ///
    Printlog "  - compare Options"
    Kontext "DruckenDlg"
    Sleep 1
    Zusaetze.Click
    Kontext "DruckerZusaetzeWriter"
    if Not Prospekt.IsChecked then Warnlog "Brochure isn't checked"
    if Not Seitenende.IsChecked then Warnlog "End of page isn't checked"
    if Not AusDruckereinstellung.IsChecked then Warnlog "Printer tray isn't checked"
    Prospekt.UnCheck
    Keine.Check
    AusDruckereinstellung.UnCheck
    DruckerZusaetzeWriter.OK

    Printlog "  - Print"
    Kontext "DruckenDlg"
   '/// Close print dialog with ok ///
    DruckenDlg.OK
    Sleep 5
  endif
    '/// Close document ///
  Call hCloseDocument
endcase
