'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_214_.inc,v $
'*
'*  $Revision: 1.6 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:22:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_214_

    Call WriterToHTMLText
    Call WriterToHTMLField
    Call WriterToHTMLTable
    Call WriterToHTMLFrame
    Call WriterToHTMLDrawingObject
    Call WriterToHTMLGraphicLinked
    Call WriterToHTMLGraphicEmbedded
    Call WriterToHTMLOLEObject
    Call WriterToHTMLControl

end sub

' ---------------------------------------------------------------------------------

testcase WriterToHTMLText
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("text") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Text' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_text.htm")
     '///+ Save document as "..\user\work\writer_to_html_text.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_text.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Text' failed !"
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLField
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("field") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_field.htm")
     '///+ Save document as "..\user\work\writer_to_html_field.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_field.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Field' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLTable
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  if wSetClipboardtestDefaults("table") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_table.htm")
     '///+ Save document as "..\user\work\writer_to_html_table.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_table.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Table' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLFrame
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Frame' ///
  '///+ Copy selected frame ///
  if wSetClipboardtestDefaults("frame") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"frame")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_frame.htm")
     '///+ Save document as "..\user\work\writer_to_html_frame.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_frame.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Frame' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLDrawingObject
  gApplication = "WRITER"
  QAErrorlog "Crashes unreproducable only with testtool"
  goto endsub
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Drawing Object' ///
  '///+ Copy selected Drawing Object ///
  if wSetClipboardtestDefaults("draw") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_draw.htm")
     '///+ Save document as "..\user\work\writer_to_html_draw.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_draw.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Drawing Object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLGraphicLinked
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Linked Graphic' ///
  '///+ Copy selected Linked Graphic ///
  if wSetClipboardtestDefaults("graphicL") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_graphic1.htm")
     '///+ Save document as "..\user\work\writer_to_html_graphic1.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_graphic1.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Linked Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLGraphicEmbedded
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Embedded Graphic' ///
  '///+ Copy selected Embedded Graphic ///
  if wSetClipboardtestDefaults("graphicE") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Embedded Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicE")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_graphic2.htm")
     '///+ Save document as "..\user\work\writer_to_html_graphic2.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_graphic2.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Embedded Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLOLEObject
  gApplication = "WRITER"
  QAErrorlog "Crashes unreproducable only with testtool"
  goto endsub
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'OLE Object' ///
  '///+ Copy selected OLE Object ///
  if wSetClipboardtestDefaults("ole") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'OLE object' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ole")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_ole.htm")
     '///+ Save document as "..\user\work\writer_to_html_ole.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_ole.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'OLE object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToHTMLControl
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Control' ///
  '///+ Copy selected Control ///
  if wSetClipboardtestDefaults("control") = True then
    gApplication = "HTMLDOKUMENT"
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    Sleep 2
    try
       EditPasteSpecialWriter
    catch
       Warnlog "Unable to execute 'Edit / Paste Special' ! Test failed!"
       Call hCloseDocument ' Close Source-File
       Call hCloseDocument ' Close Target-File
       goto endsub
    endcatch
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_html_control.htm")
     '///+ Save document as "..\user\work\writer_to_html_control.htm" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     wait 500
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_html_control.htm")
     '///+ Reopen saved document ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To HTML -> 'Control' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase
