'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: w_210_.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:26:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : helge.delfs@sun.com
'*
'* short description : CROSS-APPLICATIONS CLIPBOARD TEST (Writer)
'*
'\***********************************************************************

sub w_210_

    Call WriterToWriterText
    Call WriterToWriterField
    Call WriterToWriterTable
    Call WriterToWriterFrame
    Call WriterToWriterDrawingObject
    Call WriterToWriterGraphicLinked
    Call WriterToWriterGraphicEmbedded
    Call WriterToWriterOLEObject
    Call WriterToWriterControl

end sub

' ---------------------------------------------------------------------------------

testcase WriterToWriterText
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select first paragraph ///
  '///+ Copy selected text ///
  if wSetClipboardtestDefaults("text") = True then
    '///+ Open new document ///
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Text' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"text")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_text.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_text.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_text.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Text' failed !"
  endif
  Call hCloseDocument
  '/// Close active document ///

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterField
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select paragraph with 'Date Field' ///
  '///+ Copy selected text ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("field") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Field' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"field")
    '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_field.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_field.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_field.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Field' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument

endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterTable
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Table' ///
  '///+ Copy selected table ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("table") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"table")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_table.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_table.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_table.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Table' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterFrame
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Frame' ///
  '///+ Copy selected frame ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("frame") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"frame")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_frame.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_frame.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_frame.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Frame' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterDrawingObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Drawing Object' ///
  '///+ Copy selected Drawing Object ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("draw") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Table' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"draw")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_draw.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_draw.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_draw.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Drawing Object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterGraphicLinked
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Linked Graphic' ///
  '///+ Copy selected Linked Graphic ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("graphicL") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Linked Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicL")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_graphic1.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_graphic1.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_graphic1.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Linked Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterGraphicEmbedded
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Embedded Graphic' ///
  '///+ Copy selected Embedded Graphic ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("graphicE") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Embedded Graphic' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"graphicE")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_graphic2.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_graphic2.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_graphic2.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Embedded Graphic' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterOLEObject
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'OLE Object' ///
  '///+ Copy selected OLE Object ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("ole") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'OLE object' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"ole")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_ole.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_ole.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_ole.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'OLE object' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase

' ----------------------------------------------------------------------------------------------

testcase WriterToWriterControl
  gApplication = "WRITER"
  '/// Open File '..\\writer\\level1\\input\\clipboard\\writer.sxw' ///
  '///+ Jump to beginning of document ///
  '///+ Select 'Control' ///
  '///+ Copy selected Control ///
  '///+ Open new document ///
  if wSetClipboardtestDefaults("control") = True then
    Call hNewDocument
    '///+ Edit / Paste Special ///
    EditPasteSpecialWriter
    Wait 500
    '/// Paste 'Control' in all available clipboard formats ///
    Kontext "InhaltEinfuegen"
    if InhaltEinfuegen.Exists then
     Call wPasteAvailableClipboardFormats(Auswahl.GetItemCount,"control")
     '///+ Write Clipboard format under pasted content ///
     Call hSpeichernUnterKill (gOfficepath + "user\work\writer_to_writer_control.sxw")
     '///+ Save document as "..\user\work\writer_to_writer_control.sxw" ///
     Wait 500
     Call hCloseDocument
     '///+ Close saved document ///
     Call hDateiOeffnen (gOfficepath + "user\work\writer_to_writer_control.sxw",true)
     '///+ Reopen saved document ///
     Call hCloseDocument
     '///+ Close saved document ///
    else
     Warnlog "Dialog 'Paste Special' is not up!"
     Call hCloseDocument
     goto endsub
    endif
  else
   Warnlog "Writer To Writer -> 'Control' failed !"
  endif
  '/// Close active document ///
  Call hCloseDocument
endcase
