#*************************************************************************
#*
#*  OpenOffice.org - a multi-platform office productivity suite
#*
#*  $RCSfile: math.pl,v $
#*
#*  $Revision: 1.2 $
#*
#*  last change: $Author: tbo $ $Date: 2005/09/08 08:51:36 $
#*
#*  The Contents of this file are made available subject to
#*  the terms of GNU Lesser General Public License Version 2.1.
#*
#*
#*    GNU Lesser General Public License Version 2.1
#*    =============================================
#*    Copyright 2005 by Sun Microsystems, Inc.
#*    901 San Antonio Road, Palo Alto, CA 94303, USA
#*
#*    This library is free software; you can redistribute it and/or
#*    modify it under the terms of the GNU Lesser General Public
#*    License version 2.1, as published by the Free Software Foundation.
#*
#*    This library is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#*    Lesser General Public License for more details.
#*
#*    You should have received a copy of the GNU Lesser General Public
#*    License along with this library; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#*    MA  02111-1307  USA
#*
#******************************************************************
#*
#* Owner : thorsten.bosbach@sun.com
#*
#* short description : Find new Functions in Selection window
#*
#******************************************************************
#
# syntax : math.pl
# usually: math.pl
#
# Perl Script
# Used to put the Formula-Functions into a testcase
# Input is the 'declare' of the 'Selection' window in the file 'math.txt' and 
#       the already used testcase 'm_010_.inc'
# Output is a file with lines to be inserted into the testcase
# newout.txt / newsort.txt
# Just put the inputfiles to this directory!
# Only 8.3 file Names are allowed to use with Perl!!

# TODO
# put outputfiles in list :-)
# make option for test/release: remove files
# dokument the levels :-)

# Files

# 1. Level
# take 'declare' file and you get...

$scPATH = "qa/qatesttool/math/tools/";

open (INPUTF , $scPATH . "math.txt") || warn "Nix open";
open (OUTPUTF, ">" . $scPATH . "out2.txt") || warn "Nix open";

print OUTPUTF "---------- declare file ----------\n";
while (<INPUTF>){
#	print OUTPUTF "$_" if s/.Click/-Klack/; # irgendwo
	# throw away: all with "*" at beginning of row
	if (s/(^\*)(.*)/\1\2/) { 
		print "$_";
		$_ = "";
	}; # anfang der zeile
	# throw away: all with "_TBX" at end of row
	if (s/(.*)($\\_TBX)/\1\2/) {
		print "$_";
		$_ = "";
	}; # ende der zeile
	# put first word in file, seperator: "/" or " "
	if (s/(.*?)([\ \/])(.*)/\1/) {
		print OUTPUTF "$_";
		$_ = "";
	}; # ende der zeile
	# something forgotten ???!!!
	print "$_" if s/(.+)/-\1-/; # is was uebrig ?? :-(
}

close INPUTF;
close OUTPUTF;

# extract already used testcase information
system ("grep .Clic m_010_.inc > math_fde.txt");

# 2. Level
# take extracted info and you get ...

#open (INPUTF , $scPATH + "math.txt") || warn "Nix open";
open (INPUTF , $scPATH . "math_fde.txt") || warn "Nix open";
open (OUTPUTF, ">" . $scPATH . "out1.txt") || warn "Nix open";

print OUTPUTF "---------- Test file ----------\n";
while (<INPUTF>){
	if (s/(\s*)(\')(.*)/\1\2\3/) { 
		print "$_";
		$_ = "";
	}; # anfang der zeile
	print OUTPUTF "$_" if s/\s*(.*)\.Click/\1/i; # irgendwo
}

close INPUTF;
close OUTPUTF;

# sort both outputs for difference search (from level 1 and 2)
system ("sort","out1.txt","/o sout1.txt");
system ("sort","out2.txt","/o sout2.txt");
system ("diff sout1.txt sout2.txt > out.dif");
system ("grep \">\" out.dif > newin.dif");

# 3. Level
# do smth :-))

$sLastTB;
$sFunction;
$sFound;

open (INPUTF , $scPATH . "newin.dif") || warn "Nix open";
open (OUTPUTF, ">" . $scPATH . "newout.txt") || warn "Nix open";

while (<INPUTF>){
#	if (s/(^\*)(.*)/\1\2/) { 
#		print "$_";
#		$_ = "";
#	}; # anfang der zeile
	if (s/(^\>\ -)(.*)/\1\2/) {
#		print "$_";
		$_ = "";
	}; # ende der zeile
	# get new function, search it in "declare", put in file
	if (s/(^\>\ )(.*)/\2/) {
		$sFunction = $_;
#		print "looking for function: " . $sFunction;
		# search function & categorie
open (REFERENCEF , $scPATH . "math.txt") || warn "Nix open";
		while (<REFERENCEF>){
			$sTemp = $_;
			if (s/(.*?)([\ \/])(.*)($\\_TBX)/\1/) {
				$sLastTB = $1;
#				print "found TBX: " . $sLastTB;
				$_ = $sTemp;
			};
			if (s/(.*?)([\ \/])(.*)/\1/) {
				$sFound = $_;
				if ($sFound eq $sFunction) {
					print OUTPUTF $sLastTB . " " . $sFound ;
				};
				$_ = "";
			};
		};
close REFERENCEF;
	# schreibe TB_... in datei OUTPUTF,
	# schreibe wort dahinter,
	# schreibe <return>.
	# extern: sortiere -> nehme als vorlage fuer insert into :-)
#		print OUTPUTF "$_";
#		$_ = "";
	}; # ende der zeile
#	print "$_" if s/(.+)/-\1-/; # is was uebrig ?? :-(
}

close INPUTF;
close OUTPUTF;

print "press annykey!";
getc;

system ("sort","newout.txt","/o newsort.txt");


