'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: install_userinstall.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:07:35 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check all files in the installation directory
'*
'*******************************************************************************
' **
' #1 tCheckUserInstallation ' check all files in the installation directory
' **
'\******************************************************************************

testcase tCheckUserInstallation

   '///Check if all files in the installation are present

   ' files, categories and languages
   dim sCurFileList( FILECOUNTLIMIT ) as string
   dim sRefFileList( FILECOUNTLIMIT ) as string
   dim sLanguageList( 15 )   as string
   dim sCategoryList( 30 )   as string
   dim datafile as string

   ' filecounter
   dim iCurFileCount as integer
   dim iRefFileCount as integer
   dim iCurrentFile  as integer

   ' errorcounters
   dim iRefFileErr as integer
   dim iMisFileErr as integer
   dim iAddFileErr as integer
   dim iChgFileErr as integer

   printlog( "" )
   printlog( " * Using installation path: " & OFFICEHOME )

   '///<ul><li>Get the list of installed languages</li>
   hGetInstalledLanguages( sLanguageList() )

   '///<li>Get the list of language specific categories (e.g. templates)</li>
   datafile = convertpath( TESTHOME & "/category_user.dat" )
   hGetDataFile( datafile , _
                 sCategoryList() , _
                 "user" , _
                 " * Categorylist" , _
                 "" )

   '///<li>Make sure all workdirectories exist</li>
   iRefFileErr = hCheckWorkDirectories( sCategoryList() )

   '///<li>Collect all files from the installation directory</li>
   printlog( "" )
   printlog( " * Collecting files..." )
   iCurFileCount = hGetAllFileNames( OFFICEHOME , sCurFileList() )
   printlog( "" )
   printlog( "    * Collection complete. " & iCurFileCount & " Files read."
   printlog( "" )

   '///<li>Check if reference files exist. If not: Create them</li>
   iRefFileErr = hWriteRefLists( sCurFileList() , _
                                 sLanguageList() , _
                                 sCategoryList() )

   '///<li>Read the reference-lists</li>
   iRefFileCount = hReadRefLists( sRefFileList() , _
                                  sLanguageList() , _
                                  sCategoryList() )

   '///<li>Find out which files have been removed</li>
   iMisFileErr = hCheckForMissingFiles( sRefFileList() )

   '///<li>Find out which files have been added</li>
   iAddFileErr = hCheckForAddedFiles( sCurFileList() , sRefFileList() )

   '///<li>Check Filesizes</li>
   iChgFileErr = hCheckForChangedFiles( sRefFileList() )

   '///<li>Printout summary</li></ul>
   printlog( "" )
   printlog( " * Summary: " )
   printlog( "" )
   printlog( "    * The installation contains: " & iCurFileCount & " files." )
   printlog( "    * The ref-files contain....: " & iRefFileCount & " files." )
   printlog( "" )
   printlog( " * Error Statistics:" )
   printlog( "" )
   logprint( "* Newly created reference files: " , iRefFileErr )
   logprint( "* Test for missing files.......: " , iMisFileErr )
   logprint( "* Test for added files.........: " , iAddFileErr )
   logprint( "* Test for changed files.......: " , iChgFileErr )

endcase


