'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg2.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: jsk $ $Date: 2006/06/23 12:09:11 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : check the internal file dialog ( 1. part )
'*
'************************************************************************
'**
' #1 tOnlyRead            ' load all filestypes with enabled readonly checkbox
' #1 tReadOnly            ' load all filetypes with readonly attribute
'**
'\***************************************************************************

testcase tOnlyRead

    '///Open files with the 'Read only'-Flag in the file/open-dialoge
    '///test directory : [TesttoolPath]\framework\filedlg\input\alldocs

    'Files in use during the test
    'TODO: Shrink the routine by using Arrays.

    dim BASEPATH as string
    BASEPATH = gTesttoolPath + "framework\filedlg\input\readonly\"
    dim SXWFILE  as string : SXWFILE  = BASEPATH + "fdlg.sxw"
    dim SXCFILE  as string : SXCFILE  = BASEPATH + "fdlg.sxc"
    dim SXIFILE  as string : SXIFILE  = BASEPATH + "fdlg.sxi"
    dim SXDFILE  as string : SXDFILE  = BASEPATH + "fdlg.sxd"
    dim SXMFILE  as string : SXMFILE  = BASEPATH + "fdlg.sxm"
    dim SXGFILE  as string : SXGFILE  = BASEPATH + "fdlg.sxg"
    dim JPGFILE  as string : JPGFILE  = BASEPATH + "borabora.jpg"
    dim DXFFILE  as string : DXFFILE  = BASEPATH + "columbia.dxf"
    dim SDWFILE  as string : SDWFILE  = BASEPATH + "erwin.sdw"
    dim SDCFILE  as string : SDCFILE  = BASEPATH + "bereich.sdc"
    dim SDDFILE  as string : SDDFILE  = BASEPATH + "schach.sdd"
    dim SDAFILE  as string : SDAFILE  = BASEPATH + "aendern.sda"
    dim SDSFILE  as string : SDSFILE  = BASEPATH + "ls3_3_15.sds"
    dim SMFFILE  as string : SMFFILE  = BASEPATH + "ffortpf.smf"
    dim HTMFILE  as string : HTMFILE  = BASEPATH + "body.htm"
    dim HTMLFILE as string : HTMLFILE = BASEPATH + "fdlg.html"

    printlog "Open files with the 'Read only'-Flag in the file/open-dialoge"

    '///- open a Writer-File
    printlog " - open a Writer-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXWFILE ), 1, TRUE ) = TRUE then
        '///+Close the document
        hDestroyDocument()
    end if


    '///- open a Calc-File
    printlog " - open a Calc-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXCFILE ), 2, TRUE ) = TRUE then
        '///+Close the document
        hDestroyDocument()
    end if


    '///- open a Impress-File
    printlog " - open a Impress-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXIFILE ), 3, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Draw-File
    printlog " - open a Draw-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXDFILE ), 4, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Math-File
    printlog " - open a Math-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXMFILE ), 6, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Master-Document-File
    printlog " - open a Master-Document-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXGFILE ), 1, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open an Image-File ( JPG )
    printlog " - open an Image-File ( JPG )"

    if LoadDocumentReadOnly ( ConvertPath ( JPGFILE ), 4, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open an Image-File ( DXF )
    printlog " - open an Image-File ( DXF )"

    if LoadDocumentReadOnly ( ConvertPath ( DXFFILE ), 4, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Writer-File ( 5.2 )
    printlog " - open a Writer-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDWFILE ), 1, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Calc-File ( 5.2 )
    printlog " - open a Calc-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDCFILE ), 2, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Impress-File ( 5.2 )
    printlog " - open a Impress-File ( 5.2 )"
    '   warnlog( "#i39041# - skipping SDD file" )
    qaerrorlog( "#i65703# - skipping SDD file" )
    'if LoadDocumentReadOnly ( ConvertPath ( SDDFILE ), 3, TRUE ) = TRUE then
    '    hDestroyDocument()
    'end if


    '///- open a Draw-File ( 5.2 )
    printlog " - open a Draw-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDAFILE ), 4, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Chart-File ( 5.2 )
    printlog " - open a Chart-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDSFILE ), 5, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Math-File ( 5.2 )
    'qaerrorlog( "#i49003# Math (5.2) triggers filterdialog, skipping" )
    printlog " - open a Math-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SMFFILE ), 6, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a HTML-File ( with extension 'htm' )
    printlog " - open a HTML-File ( with extension 'htm' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMFILE ), 1, TRUE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a HTML-File ( with extension 'html' )
    printlog " - open a HTML-File ( with extension 'html' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMLFILE ), 1, TRUE ) = TRUE then
        hDestroyDocument()
    end if


endcase

'*******************************************************************************

testcase tReadOnly

    '///Open files which are 'Read only' on the system
    '///+Make sure the files are set to readonly on <b>filesystemlevel</b>!
    '///+test directory : [TesttoolPath]\framework\filedlg\input\readonly

    'Files in use during the test
    'TODO: Shrink the routine by using Arrays.

    dim BASEPATH as string
    BASEPATH = gTesttoolPath + "framework\filedlg\input\readonly\"
    dim SXWFILE  as string : SXWFILE  = BASEPATH + "fdlg.sxw"
    dim SXCFILE  as string : SXCFILE  = BASEPATH + "fdlg.sxc"
    dim SXIFILE  as string : SXIFILE  = BASEPATH + "fdlg.sxi"
    dim SXDFILE  as string : SXDFILE  = BASEPATH + "fdlg.sxd"
    dim SXMFILE  as string : SXMFILE  = BASEPATH + "fdlg.sxm"
    dim SXGFILE  as string : SXGFILE  = BASEPATH + "fdlg.sxg"
    dim JPGFILE  as string : JPGFILE  = BASEPATH + "borabora.jpg"
    dim DXFFILE  as string : DXFFILE  = BASEPATH + "columbia.dxf"
    dim SDWFILE  as string : SDWFILE  = BASEPATH + "erwin.sdw"
    dim SDCFILE  as string : SDCFILE  = BASEPATH + "bereich.sdc"
    dim SDDFILE  as string : SDDFILE  = BASEPATH + "schach.sdd"
    dim SDAFILE  as string : SDAFILE  = BASEPATH + "aendern.sda"
    dim SDSFILE  as string : SDSFILE  = BASEPATH + "ls3_3_15.sds"
    dim SMFFILE  as string : SMFFILE  = BASEPATH + "ffortpf.smf"
    dim HTMFILE  as string : HTMFILE  = BASEPATH + "body.htm"
    dim HTMLFILE as string : HTMLFILE = BASEPATH + "fdlg.html"

    printlog "Load files with system 'read only'-Flag"
    '///- open a Writer-File
    printlog " - open a Writer-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXWFILE ), 1, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Calc-File
    printlog " - open a Calc-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXCFILE ), 2, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Impress-File
    printlog " - open a Impress-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXIFILE ), 3, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Draw-File
    printlog " - open a Draw-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXDFILE ), 4, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Math-File
    printlog " - open a Math-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXMFILE ), 6, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Master-Document-File
    printlog " - open a Master-Document-File"

    if LoadDocumentReadOnly ( ConvertPath ( SXGFILE ), 6, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open an Image-File ( JPG )
    printlog " - open an Image-File ( JPG )"

    if LoadDocumentReadOnly ( ConvertPath ( JPGFILE ), 4, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open an Image-File ( DXF )
    printlog " - open an Image-File ( DXF )"

    if LoadDocumentReadOnly ( ConvertPath ( DXFFILE ), 4, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Writer-File ( 5.2 )
    printlog " - open a Writer-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDWFILE ), 1, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Calc-File ( 5.2 )
    printlog " - open a Calc-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDCFILE ), 2, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Impress-File ( 5.2 )
    printlog " - open a Impress-File ( 5.2 )"
    '  warnlog( "#i39041# - skipping SDD file" )

    qaerrorlog( "#i65703# - excluded SDD file" )
    'if LoadDocumentReadOnly ( ConvertPath ( SDDFILE ), 3, FALSE ) = TRUE then
    '    hDestroyDocument()
    'end if


    '///- open a Draw-File ( 5.2 )
    printlog " - open a Draw-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDAFILE ), 4, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Chart-File ( 5.2 )
    printlog " - open a Chart-File ( 5.2 )"

    if LoadDocumentReadOnly ( ConvertPath ( SDSFILE ), 5, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a Math-File ( 5.2 )
    printlog " - open a Math-File ( 5.2 )"
    'qaerrorlog( "#i49003# Math file (5.2) triggers Filter-dialog" )

    if LoadDocumentReadOnly ( ConvertPath ( SMFFILE ), 6, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a HTML-File ( with extension 'htm' )
    printlog " - open a HTML-File ( with extension 'htm' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMFILE ), 1, FALSE ) = TRUE then
        hDestroyDocument()
    end if


    '///- open a HTML-File ( with extension 'html' )
    printlog " - open a HTML-File ( with extension 'html' )"

    if LoadDocumentReadOnly ( ConvertPath ( HTMLFILE ), 1, FALSE ) = TRUE then
        hDestroyDocument()
    end if


endcase


