'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: filedlg_filenames3.bas,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/07/24 13:41:50 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : check special filenames and destinations
' **
'\******************************************************************************

sub main
    
    use "framework\filedlg\inc\filename1.inc"
    use "framework\tools\inc\docfuncs.inc"
    use "framework\tools\inc\filetools.inc"
    use "framework\tools\inc\stringtools.inc"
    use "framework\tools\inc\fileoperations.inc"
    
    dim iCounter    as integer ' increment
    dim iFileCount  as integer ' Number of files in the current workdirectory
    dim cCurrentApp as string  ' the active application before start of this test
    
    call hStatusIn ( "framework", "filedlg_filenames3.bas" )
    
    cCurrentApp = gApplication()
    iFileCount = hGetFileCountViaFileOpen() ' get the number of files in the current workdir
    
    ' check saving files to reserved names on Windows in the six main
    ' applications. Here the ASCII character 1 .. 31 are tested
    ' All operations here are expected to fail. On UNIX those
    ' limitations don't exist, so in this case save/load and deletion is
    ' expected to succeed.
    ' tSLD = tSave/Load/Del
    
    for iCounter = 3 to 3
        if ( gPlatGroup = "w95" ) then
            printlog( " " + CHR$(13) + hNumericDoctype( iCounter ) )
            call tSLDForbiddenNamesWin()
        else
            printlog( " " + CHR$(13) + hNumericDoctype( iCounter ) )
            call tSLDForbiddenNamesUNIX()
        end if
    next iCounter
    
    ' finalize the test / statistics etc.
    gApplication = cCurrentApp
    
    call hStatusOut()
    
end sub

' ****************************************

sub LoadIncludeFiles
    
    use "global\system\inc\master.inc"
    use "global\system\inc\gvariabl.inc"
    gApplication = "WRITER"
    Call GetUseFiles
    
end sub

