'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_scripting_organizers.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/18 11:09:56 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test scripting-organizers / document-attached scripts
'*
'*******************************************************************************
'**
' #1 tScriptingOrganizers ' Test scripting-organizers / document-attached scripts
'**
'\******************************************************************************

testcase tScriptingOrganizers( iDialog as integer )

    const IDOCPOS = 4

    ' make sure we have a valid parameter
    ' 1 = BeanShell (.bsh)
    ' 2 = JavaScript (.js)
    if ( ( iDialog < 1 ) or ( iDialog > 2 ) ) then
        warnlog( "Invalid parameter passed to function: " & iDialog )
        goto endsub
    endif

    '///<H1>Test scripting-organizers</H1>
    '///<ul>
    
    dim cFileName as string
        cFileName = "sftest" & hGetSuffix( "current" )
    dim cCompare as string
        
    dim cFilePath as string
        cFilePath= hGetWorkPath() & cFileName
        cFilePath= convertpath( cFilePath )
        
    dim iPos as integer  ' position of the workdocument in treelist
    dim brc as boolean   ' boolean return code used to determine the status
    
    dim cLibName as string
        cLibName = "TTLib"
    dim cModName as string
        cModName = "TTMod"
    dim cScriptName as string
    
    
    printlog( "" ) 
    printlog( "Test init: Create and prepare document" )

    ' Unfortunately we nned to restart the office before testing. Reason:
    ' If a prior run fails, the document "Untitled1" might have a script attached
    ' resulting in an incorrect documentcount
    call exitRestartTheOffice()
    
    ' Define a name for the script depending on which dialog we want to test
    select case iDialog
    case 1 : cScriptName = cModName & ".bsh"
    case 2 : cScriptName = cModName & ".js"
    end select
      
    '///+<li>Delete the workfile in case it has been left over by prior run</li>
    brc = hDeleteFile( cFilePath )
    
    '///+<li>Open a new document</li>
    brc =  hCreateDocument()
    
    '///+<li>Modify the document</li>
    call hChangeDoc()
    
    '///+<li>Save the document (Save As). Flags: no autosuffix, overwrite</li>
    brc = hSaveFile( cFilePath , "current" , false , true )
    
    '///+<li>Open the ScriptOrganizer</li>
    printlog( "" )
    printlog( "Test 1: ScriptOrganizer/Documents" )
    brc = hOpenScriptOrganizer( iDialog )
    if ( not brc ) then
        warnlog( "Could not open the script Organizer, aborting" )
        brc = hDestroyDocument()
        goto endsub
    endif
    
    ' Initially we wait an additional moment, java needs to beloaded completely
    ' to display the treelist
    sleep( 10 )
    
    brc = hWaitForTreelist( ScriptTreeList, "ScriptOrganizer" , 4 )
    
    '///+<li>Count the objects in the collapsed treelist: Should be 4</li>
    if ( ScriptTreeList.getItemCount() <> IDOCPOS ) then
        warnlog( "Incorrect number of documents listed in treelist, aborting" )
        kontext "ScriptOrganizer"
        ScriptOrganizer.cancel()
        brc = hDestroyDocument()
        goto endsub
    endif    
    
    kontext "ScriptOrganizer"
    ScriptTreeList.select( IDOCPOS )
    
    '///+<li>Test status of Buttons</li>
    brc = hTestControlMode( PBCreate , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif
    brc = hTestControlMode( PBEdit   , false )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBRename , false )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBDelete , false )
    if ( not brc ) then
        qaerrorlog(  "#i50527# Delete Button should not be enabled" )
    endif
    
    
    '///+<li>Create a new library and rename it afterwards</li>
    printlog( "" )
    printlog( "Test 2: Libraries/Scripts create/rename" )
    brc = hCreateScriptingObject( "initial_lib" )
    brc = hRenameScriptingObject( cLibName )
    brc = hVerifyNodeName( ScriptTreeList , cLibName )
    if ( not brc ) then
        qaerrorlog(  "#i50526# Renaming failed: " & cLibName )
    endif
    
    ' however, we use the name from the treelist
    cLibName = ScriptTreeList.getSelText()
    
    '///+<li>Test status of Buttons</li>
    brc = hTestControlMode( PBCreate , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif
    brc = hTestControlMode( PBEdit   , false )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBRename , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBDelete , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    
    '///+<li>Create a new script and rename it afterwards</li>
    brc = hCreateScriptingObject( "initial_mod" )
    brc = hRenameScriptingObject( cModName )
    brc = hVerifyNodeName( ScriptTreeList , cScriptName )
    if ( not brc ) then
        qaerrorlog( "#i50526# Renaming failed: " & cScriptName )
    endif    
    
    'Handle two things: Script with suffix or script rename failed
    cModName = ScriptTreeList.getSelText()
    
    '///+<li>Test status of Buttons</li>
    brc = hTestControlMode( PBCreate , false )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBEdit   , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBRename , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    brc = hTestControlMode( PBDelete , true )
    if ( not brc ) then
        warnlog( "Bad rc, inconsistent button-/object status" )
    endif    
    
    '///+<li>Exit the scriptorganizer (cancel)</li>
    kontext "ScriptOrganizer"
    brc = hCloseScriptOrganizer()
    
    '///+<li>Save the file</li>
    printlog( "" )
    printlog( "Test 3: Script storage in documents (save/load)" )
    try
        FileSave
    catch
        warnlog( "Document Changed status not set" )
        hChangeDoc()
        FileSave
    endcatch
    
    '///+<li>Close the document</li>
    brc = hDestroyDocument()   
    
    '///+<li>Reload the document. Special: Expect Macro-Warning</li>
    brc = hLoadFile( cFilePath )
    brc = hHandleSecurityWarning()
    brc = hCheckDocCount( 2 , false )
    
    sleep( 5 )
    
    '///+<li>Open the ScriptOrganizer, delete all scripts/libraries</li>
    brc = hOpenScriptOrganizer( iDialog )
    brc = hWaitForTreelist( ScriptTreeList, "ScriptOrganizer" , 4 )
    ScriptTreeList.select( 4 )
    iPos = hExpandNode( ScriptTreeList , 0 )
    ScriptTreeList.select( 5 )
    iPos = hExpandNode( ScriptTreeList , 0 )
    ScriptTreeList.select( 6 )
    

    printlog( "" )
    printlog( "Test 4: Script removal / Document changed" )
    brc = hDeleteScript( cModName , true )
    if ( not brc ) then
        warnlog( "Bad rc: hDelteScript()" )
    endif    
    brc = hDeleteScript( cLibName , true )
    if ( not brc ) then
        warnlog( "Bad rc: hDelteScript()" )
    endif        
    brc = hDeleteScript( cFileName , false )
    if ( not brc ) then
       qaerrorlog( "#i50527# Delete enabled for document object" )
    endif
        
    '///+<li>Exit all dialogs</li>
    kontext "ScriptOrganizer"
    brc = hCloseScriptOrganizer()
    
    '///+<li>Save the file</li>
    try
        FileSave
    catch
        warnlog( "Document Changed status expected after script deletion" )
        brc = hChangeDoc()
        FileSave
    endcatch
    
    '///+<li>Close the document</li>
    brc = hDestroyDocument()   
    
    '///+<li>Reload the document. Special: No Macro-Warning expected</li>
    printlog( "Reload the document. Special: No Macro-Warning expected" )
    brc = hLoadFile( cFilePath )
    brc = hHandleSecurityWarning()
    if ( brc ) then
        qaerrorlog( "#i50530# Macros not completely removed from doc when deleted" )
    endif
    
    sleep( 5 )
    
    '///+<li>Open the ScriptOrganizer, look for the library</li>
    printlog( "" )
    printlog( "Test 5: Verification of script removal" )
    brc = hOpenScriptOrganizer( iDialog )
    brc = hWaitForTreelist( ScriptTreeList, "ScriptOrganizer" , 4 )
    if ( not brc ) then
        warnlog( "Treelist not populated, the test cannot continue" )
        brc = hCloseScriptOrganizer()
        brc = hDestroyDocument()
        goto endsub
    endif
    
    '///+<li>Verify that all libraries/scripts have been removed</li>
    iPos = hExpandNode( ScriptTreeList , IDOCPOS )
    if ( iPos <> 0 ) then
        warnlog( "Not all libraries/scripts have been deleted" )
    endif
            
    '///+<li>Test Exit: Cleanup - close all dialogs</li>
    brc = hCloseScriptOrganizer()

    '///+<li>Close the navigator if it is open</li>
    kontext "Navigator"
    if ( Navigator.exists() ) then
        printlog( "Close Navigator" )
        Navigator.close()
    endif
    
    '///+<li>Close the document</li>
    brc = hDestroyDocument()
    
    '///+<li>Delete the workfile</li>
    brc = hDeleteFile( cFilePath )
    if ( not brc ) then
        warnlog( "Could not delete: " & cFilePath & " - do so manually!" )
    endif
    
    '///</ul>

endcase
