'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: ch_105_.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:00:48 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Chart Level 1 test - section FORMAT 1
'*
'************************************************************************
'*
' #1 CH_105_     ' Description
' #1 tFormatChartArea
' #1 tFormatChartWall
' #1 tFormatChartFloor
'*
'\***********************************************************************

sub CH_105_

printLog "---------  Ch_105_     ----------"

  call tFormatChartArea
  call tFormatChartWall
  call tFormatChartFloor

end sub
'
'-----------------------------------------------------------
'
testcase tFormatChartArea
'/// This test checks the available settings in the ChartArea dialog.
'/// First a chart is created 

   Dim Stile$, Farben$, Auswahl$
   Dim Stilresult$, Farbenresult$, Auswahlresult$
   Dim styleNr as integer, colorNr as integer, chooseNr as integer
   Dim x
   Dim Sfile as string
   Sfile = convertpath(gOfficePath & "user/work/data1" & Ext)
   Call basedocument ("CHART")
   EditObjectEdit
'/// Then the chart type is set to 3D and the settings line style, color, colorgradient
'/// and gradient type are modified.
   FormatChartType
   Kontext "Diagrammtyp"
     DreiD.Check
     Diagrammtyp.OK
     Kontext
       FormatChartArea
       Kontext "Diagrammflaeche"
         active.setpage TabLinie
   Kontext "TabLinie"
     Stil.select 3
     Farbe.select 5
   Kontext
     active.setpage TabArea
   Kontext "TabArea"
     FillOptions.select 3
     GradientList.select 3
     Automatic.uncheck
     Increments.settext "50"
     TabArea.Ok
   printlog "Saving modified diagram"
   Kontext "DocumentCalc"
'/// The modified embedded chart in the calc is saved as calc document
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
   try
       if NOT hSpeichernUnterMitFilterKill (sFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           exit sub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText sFile
       DateiTyp.Select 1
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch
     call hCloseDocument
   Kontext "DocumentChart"
     printlog "Loading file and check adjustments"
'/// The file is closed reopened again and the made settings are checked, if they are still present
     call hDateioeffnen Sfile
   Kontext "DocumentCalc"
     if NOT fSelectChartByNumber ( 1 ) then
         warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
     endif
     EditObjectEdit
     sleep (2)
     FormatChartArea
   Kontext
     active.setpage TabLinie
     kontext "TabLinie"
       try
         Stile$ = Stil.GetSelText
         printlog "Stil.getselIndex: " & Stil.getselIndex
         Farben$ = Farbe.GetSelText
         printlog "Style is: " + Stile$ + " color is: " + Farben$
       catch
         warnlog "TabLinie: Couldn't find values of style and color"
       endcatch
       kontext
         active.setpage TabArea
         Kontext "TabArea"
           try
             if NOT FillOptions.GetSelIndex = 3 then
                 warnlog "Color gradient isn't checked"
             endif
             if Automatic.ischecked then warnlog "Automatic is checked"
             Auswahl$ = GradientList.GetSelText
             printlog "Color gradient is: " + Auswahl$
           catch
             warnlog "TabArea: Couldn't find values of color gradient and stepwidth"
           endcatch
           TabArea.OK
   select case isprache
          case 01 : Stilresult$ = "Ultrafine dashed" : Farbenresult$ = "Red" : Auswahlresult$ = "Gradient 3"
          case 31 : Stilresult$ = "Extra fijne streepjes" : Farbenresult$ = "Rood" : Auswahlresult$ = "Kleurovergang 3"
          case 33 : Stilresult$ = "Tirets ultrafins" : Farbenresult$ = "Rouge" : Auswahlresult$ = "Dégradé 3"
          case 34 : Stilresult$ = "Trazos ultrafinos" : Farbenresult$ = "Rojo" : Auswahlresult$ = "Gradiente 3"
          case 39 : Stilresult$ = "A tratti finissimi" : Farbenresult$ = "Rosso" : Auswahlresult$ = "Sfumatura 3"
          case 46 : Stilresult$ = "Mycket fint streckad" : Farbenresult$ = "Rött" : Auswahlresult$ = "Färggradient 3"
          case 49 : Stilresult$ = "Ultrafein gestrichelt" : Farbenresult$ = "Rot" : Auswahlresult$ = "Farbverlauf 3"
          case 55 : Stilresult$ = "Tracejado ultrafino" : Farbenresult$ = "Vermelho" : Auswahlresult$ = "Gradiente 3"
          case 81 : Stilresult$ = "極細の破線" : Farbenresult$ = "赤" : Auswahlresult$ = "グラデーション 3"
          case 82 : Stilresult$ = "미세한 파선" : Farbenresult$ = "적색" : Auswahlresult$ = "그라디언트 3"
          case 86 : Stilresult$ = "超细划线" : Farbenresult$ = "红色" : Auswahlresult$ = "彩色图案 3"
          case 88 : Stilresult$ = "超細點劃線" : Farbenresult$ = "紅色" : Auswahlresult$ = "彩色圖案 3"
          case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                      hCloseDocument
                      goto endsub
   end select

         if Stilresult$ <> Stile$ then
            warnlog "Style hasn't been adapted" + " Style is: " + Stile$
         else
            printlog "OK: style has been adapted"
         end if

         if Farbenresult$ <> Farben$ then
            warnlog "Color hasn't been adapted" + " color is: " + Farben$
         else
            printlog "OK: Color has been adapted"
         end if
         if Auswahlresult$ <> Auswahl$ then
            warnlog "Color gradient hasn't been adapted" + " color gradient is: " + Auswahl$
         else
            printlog "OK: color gradient has been adapted"
         end if
        Kontext "DocumentCalc"

        DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"

        call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatChartWall
'/// This test checks the available settings in the chart wall dialog.
'/// First a chart is created 

        Dim Stile$, Farben$, Auswahl$
        Dim Stilresult$, Farbenresult$, Auswahlresult$
        dim styleNr as integer, colorNr as integer, gradientNr as integer
        dim SFile as String
        SFile = convertpath(gOfficePath & "user/work/data1" & Ext)

        Call basedocument ("CHART")
   EditObjectEdit
        FormatChartType
'/// Set the chart type to 3D
   Kontext "Diagrammtyp"
   DreiD.Check
   Diagrammtyp.OK
        Kontext
'/// Call the menuitem 'FormatChartWall' and modify the line style, color, gradient and gradient type
        FormatChartWall
        Kontext "Diagrammwand"
   active.setpage TabLinie
   kontext "TabLinie"
   Stil.select 4
   Farbe.select 6
   Kontext
   active.setpage TabArea
   Kontext "TabArea"
   FillOptions.select 3
   GradientList.select 6
   Automatic.uncheck
   Increments.settext "50"
   TabArea.Ok
   Kontext "DocumentCalc"
'/// The modified embedded chart in the calc is saved as calc document
   DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
        printlog "Saving modified diagram"
   try
       if NOT hSpeichernUnterMitFilterKill (sFile, FileFormat) then
           warnlog "Saving test document localy failed -> Aborting"
           call hCloseDocument
           exit sub
       endif
   catch 
       qaErrorLog "Most probably there's no filter name for this language available. Trying to save without filter."
       'PJ: I would consider calling the following code a hack!
       Kontext "SpeichernDlg"
       Dateiname.SetText sFile
       DateiTyp.Select 1
       Speichern.Click
       Kontext "Active"
       if active.exists(2) then
           active.YES
       endif
   endcatch
        call hCloseDocument
'/// The file is closed reopened again and the made settings are checked, if they are still present
        Kontext "DocumentChart"
        printlog "Loading file and check adjustments"
        call hDateioeffnen SFile
        sleep (3)
        Kontext "DocumentCalc"
        if NOT fSelectChartByNumber ( 1 ) then
            warnlog "Selecting desired chart seems to fail -> Expecting more errors to come in this testcase"
        endif
        EditObjectEdit
        sleep (2)
        FormatChartWall
        Kontext
   active.setpage TabLinie
   kontext "TabLinie"
        try
                Stile$ = Stil.GetSelText
                Farben$ = Farbe.GetSelText
                printlog "Style is: " + Stile$ + " color is: " + Farben$
        catch
                warnlog "TabLinie: Couldn't find values of style and color"
        endcatch
        kontext
        active.setpage TabArea
        Kontext "TabArea"
        try
                if NOT FillOptions.GetSelIndex = 3 then
                    warnlog "Color gradient isn't checked"
                endif
                if Automatic.ischecked then warnlog "Automatic has been checked"
                Auswahl$ = GradientList.GetSelText
                printlog "Color gradient is: " + Auswahl$
        catch
                warnlog "TabArea: Couldn't find values of color gradient and step width"
        endcatch
        TabArea.OK

   select case isprache
                case 01 : Stilresult$ = "Fine dashed"   : Farbenresult$ = "Magenta" : Auswahlresult$ = "Gradient 6"
                case 31 : Stilresult$ = "Fijne streepjes" : Farbenresult$ = "Violet" : Auswahlresult$ = "Kleurovergang 6"
                case 33 : Stilresult$ = "Tirets fins" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Dégradé 6"
                case 34 : Stilresult$ = "Trazos finos" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Gradiente 6"
                case 39 : Stilresult$ = "A tratti fini" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Sfumatura 6"
                case 46 : Stilresult$ = "Fint streckad" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Färggradient 6"
                case 49 : Stilresult$ = "Fein gestrichelt" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Farbverlauf 6"
                case 55 : Stilresult$ = "Tracejado fino" : Farbenresult$ = "Magenta" : Auswahlresult$ = "Gradiente 6"
                case 81 : Stilresult$ = "細かい破線" : Farbenresult$ = "マゼンタ" : Auswahlresult$ = "グラデーション 6"
                case 82 : Stilresult$ = "섬세한 파선" : Farbenresult$ = "선홍색" : Auswahlresult$ = "그라디언트 6"
                case 86 : Stilresult$ = "细划线" : Farbenresult$ = "紫红色" : Auswahlresult$ = "彩色图案 6"
                case 88 : Stilresult$ = "細點劃線" : Farbenresult$ = "紫紅色" : Auswahlresult$ = "彩色圖案 6"
                case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                            hCloseDocument
                            goto endsub
   end select

                if Stilresult$ <> Stile$ then
                        warnlog "Style hasn't been adapted" + " Style is: " + Stile$
                else
                        printlog "OK: Style has been adapted"
                end if

                if Farbenresult$ <> Farben$ then
                        warnlog "Color hasn't been adapted" + " color is: " + Farben$
                else
                        printlog "OK: Color has been adapted"
                end if

                if Auswahlresult$ <> Auswahl$ then
                        warnlog "Color gradient hasn't been adapted" + " color gradient is: " + Auswahl$
                else
                        printlog "OK: Color gradient has been adapted"
                end if

        Kontext
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "<ESCAPE><ESCAPE>"
        call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tFormatChartFloor
'/// This test checks the available settings in the ChartFloor dialog.
'/// First a chart is created 

        Dim Stile$, Farben$, FAuswahl$
        Dim Stilresult$, Farbenresult$, Auswahlresult$
        Dim x    'Nur f³r Umlauttest
        dim Sfile as string
        SFile = convertpath(gOfficePath & "user/work/data1" & Ext)
        Call basedocument ("CHART")
        sleep(2)
        EditObjectEdit
        sleep(2)
        FormatChartType
        sleep(2)
'/// Set the chart type to 3D
   Kontext "Diagrammtyp"
   DreiD.Check
   Diagrammtyp.OK
'/// Call the menu item 'FormatChartFloor' and modify the line style, color, gradient and gradient type
        Kontext
        FormatChartFloor
        Kontext "Diagrammboden"
   active.setpage TabLinie
   kontext "TabLinie"
   Stil.select 7
   Farbe.select 8
   Kontext
   active.setpage TabArea
   Kontext "TabArea"
   FillOptions.select 3
   GradientList.select 7
   Automatic.uncheck
   Increments.settext "60"
   TabArea.Ok

'/// The modified embedded chart in the calc is saved as calc document
        printlog "Saving modified diagram"
        call hspeichernunterkill Sfile
        call hCloseDocument
        Kontext "DocumentChart"
        printlog "Loading file and check adjustments"
'/// The file is closed, reopened again and the made settings are checked, if they are still present
        call hDateioeffnen Sfile
        sleep(2)
        call selectFirstOLE
        EditObjectEdit
        sleep(2)
        FormatChartFloor
        Kontext
   active.setpage TabLinie
   kontext "TabLinie"
        try
                Stile$ = Stil.GetSelText
                Farben$ = Farbe.GetSelText
                printlog "Style is: " + Stile$ + " Color is: " + Farben$
        catch
                warnlog "TabLinie: Couldn't find values of style and color"
        endcatch
        kontext
        active.setpage TabArea
        Kontext "TabArea"
        try
                if NOT FillOptions.GetSelIndex = 3 then
                    warnlog "Color gradient isn't checked"
                endif
                if Automatic.ischecked then warnlog "Automatic was checked!"
                FAuswahl$ = GradientList.GetSelText
                printlog "FarbverlaufAuswahl ist: " + FAuswahl
        catch
                warnlog "TabArea:Couldn't find values for gradient and step width"
        endcatch
        TabArea.OK

   select case isprache
          case 01 : Stilresult$ = "Line with fine dots"   : Farbenresult$ = "Gray"        :  Auswahlresult$ = "Linear blue/white"
          case 31 : Stilresult$ = "Lijn met fijne puntjes" : Farbenresult$ = "Grijs" : Auswahlresult$ = "Lineair blauw/wit"
          case 33 : Stilresult$ = "Trait avec des points fins" : Farbenresult$ = "Gris" : Auswahlresult$ = "Linéaire bleu/blanc"
          case 34 : Stilresult$ = "Trazo con puntos finos" : Farbenresult$ = "Gris" : Auswahlresult$ = "Lineal azul/blanco"
          case 39 : Stilresult$ = "Linea con punti fini" : Farbenresult$ = "Grigio" : Auswahlresult$ = "Lineare blu/bianco"
          case 46 : Stilresult$ = "Streck med fina prickar" : Farbenresult$ = "Grått" : Auswahlresult$ ="Linjär blått/vitt"
          case 49 : Stilresult$ = "Strich mit feinen Punkten" : Farbenresult$ = "Grau" : Auswahlresult$ = "Linear Blau/weiß"
          case 55 : Stilresult$ = "Linha com pontos finos" : Farbenresult$ = "Cinza" : Auswahlresult$ = "Azul/branco linear"
          case 81 : Stilresult$ = "細かい点の集まった線" : Farbenresult$ = "灰色" : Auswahlresult$ = "線状 青/白"
          case 82 : Stilresult$ = "섬세한 점선" : Farbenresult$ = "회색" : Auswahlresult$ = "선형 청색/흰색"
          case 86 : Stilresult$ = "细点划线" : Farbenresult$ = "灰色" : Auswahlresult$ = "线性 蓝/白"
          case 88 : Stilresult$ = "細點線條" : Farbenresult$ = "灰色" : Auswahlresult$ = "線條藍/白"
          case else : QAErrorLog "This testcase is only designed to run on BIG 10 languges"
                      hCloseDocument
                      goto endsub
   end select

        if Stilresult$ <> Stile$ then
                warnlog "Style hasn't been adapted" & " Style is: " + Stile$
        else
                printlog "OK: Style has been adapted"
        end if

        if Farbenresult$ <> Farben$ then
                warnlog "Color hasn't been adapted" + " Color is: " + Farben$
        else
                printlog "OK: Color has been adapted"
        end if

        if Auswahlresult$ <> FAuswahl then
                warnlog "Color gradient hasn't been adapted" & " Color gradient is: " + FAuswahl
        else
                printlog "OK: Color gradient has been adapted"
        end if
        Kontext
        call hCloseDocument

endcase
'
'-----------------------------------------------------------

