'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_print_scale.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : Check correct print scaling settings
'*
'*************************************************************************************************
'*
' #1 subPrintScaling
' #1 tPrintScaling
'*
'\*************************************************************************************************
sub subPrintScaling
  printLog Chr(13) + "---------  Print scaling settings  ----------"

     call tPrintScaling

end sub
'*************************************************************************************************
testcase tPrintScaling
'///<u><b>Check correct print scaling settings</b></u>///

dim iIndex as INTEGER
    
dim sExtension
    sExtension = ".ods"

dim sOutputFile as STRING
    sOutputFile = ( gOfficePath & ConvertPath( "user\work\printScaling" ) & sExtension )
    
dim sNameSheet1 as STRING
    sNameSheet1 = "Ten"
dim sNameSheet2 as STRING
    sNameSheet2 = "Moves"
dim sNameSheet3 as STRING
    sNameSheet3 = "Ahead"
    
dim sNameStyle1 as STRING
    sNameStyle1 = "1stStyle"
dim sNameStyle2 as STRING
    sNameStyle2 = "2ndStyle"
dim sNameStyle3 as STRING
    sNameStyle3 = "3rdStyle"
    
dim sPagesToPrint as STRING

'///<ul>
'///<li>Open test document</li>///
    Call hNewDocument
    sleep(2)
    
    for iIndex = 1 to 3
        '///<li>Add minimal content to all sheets</li>///
        Kontext "RechenleisteCalc"
        if not RechenleisteCalc.isvisible then
            ViewToolbarsFormulaBar
        end if
        sleep(1)
        '///<li>Create simple data area</li>///
        Kontext "RechenleisteCalc"
        Bereich.TypeKeys "<MOD1 A>"
        if iIndex = 1 then
            Bereich.TypeKeys "A1:B2"
        else
            Bereich.TypeKeys "A1:AG400"
        endif
        sleep(1)
        Bereich.TypeKeys "<RETURN>"
        Kontext "DocumentCalc"
        DocumentCalc.TypeKeys "=13<SHIFT MOD1 RETURN>"
        sleep(1)
        '///<li>Assign specific names for sheets to avoid language dependencies</li>///
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        select case iIndex
               case 1 : Tabellenname.SetText sNameSheet1
               case 2 : Tabellenname.SetText sNameSheet2
               case 3 : Tabellenname.SetText sNameSheet3
        end select
        TabelleUmbenennen.OK
        sleep(1)
        
        '///<li>(Don't forget to change sheets inbetween)</li>///
        EditSheetSelect
        Kontext "SelectSheets"
        if iIndex = 3 then
            '///<li>(At the end return to first sheet)</li>///
            SheetSelectionBox.Select sNameSheet1
        else
            SheetSelectionBox.Select ( iIndex + 1 )
        endif
        SelectSheets.OK
        sleep(1)
    next iIndex
    
    FormatStylesCatalog
    '///<li>Invoke Style catalog</li>///
    Kontext "Vorlagenkatalog"
    Vorlagen.select ( 2 )
    sleep(1)
    '///<li>Create three styles using different page scaling features</li>///
    for iIndex = 1 to 3
        Kontext "Vorlagenkatalog"
        '///<li>Click new</li>///
        Neu.Click
        Kontext
        '///<li>(Page format dilog shoud appear)</li>///
        '///<li>Select Page 'Organizer'</li>///
        active.SetPage TabVerwalten
        '///<li>Close MsgBox when appeared</li>///
        if Active.Exists(2) then
            if Active.GetRT = 304 then
                Printlog Active.GetText
                Active.Yes
            end if
        end if
        Kontext "TabVerwalten"
        '///<li>Assign name for each style</li>///
        select case iIndex
               case 1 : VorlagenName.setText sNameStyle1
               case 2 : VorlagenName.setText sNameStyle2
               case 3 : VorlagenName.setText sNameStyle3
        end select
        Kontext
        '///<li>Select Page 'Sheet'</li>///
        active.SetPage TabTabelleCalc
        Kontext "TabTabelleCalc"
        '///<li>For all three styles use different page scaling features</li>///
        '///<ol>
        scalingMode.Select ( iIndex )
        select case iIndex
               '///<li>Scale size to 444%</li>///
               '///<li>NOTE: Maximum scale in 400%! Entering 444% should be decreased to 400%.</li>///
               case 1 : SkalierungProzent.setText "444%"
               '///<li>Scale output to 3 pages wide and 3 pages high</li>///
               case 2 : ScalePageWidth.setText "3"
                        ScalePageHeight.setText "3"
               '///<li>Scale output to a total of 4 pages</li>///
               case 3 : AnzahlMaxSeiten.setText "4"
        end select
        '///<li>Leave page format dilog using OK</li>///
        TabTabelleCalc.OK
        '///</ol>
    next iIndex
    '///<li>Close style catalog using OK</li>///
    Kontext "Vorlagenkatalog"
    Vorlagenkatalog.OK
    sleep(2)
    '///<li>Assign the three styles created to the three sheets in document</li>///
    for iIndex = 1 to 3
    '///<li>First select a sheet</li>///
        EditSheetSelect
        Kontext "SelectSheets"
        SheetSelectionBox.Select ( iIndex  )
        SelectSheets.OK
        sleep(1)
        '///<li>Open the stylist</li>///
        Kontext "Gestalter"
        if NOT Gestalter.exists(2) then
            FormatStylist
        endif
        '///<li>Assign styles using the stylist</li>///
        Kontext "Gestalter"
        Seitenvorlagen.Click
        Kontext "Vorlagenliste"
        Vorlagenliste.TypeKeys "<HOME>"
        sleep (2)
        Vorlagenliste.Select ( iIndex )
        Vorlagenliste.TypeKeys "<RETURN>"
    next iIndex
    '///<li>Close stylist</li>///
    Kontext "Gestalter"
    if Gestalter.exists(2) then
        FormatStylist
    endif
        
    '///<li>Save in current default format</li>///
    if hSpeichernUnterMitFilterKill ( sOutputFile , gsFileFormat ) = FALSE then
        warnlog "Saving " & sOutputFile & " failed! -> Exiting test!"
        call hCloseDocument
    else
        '///<li>... and close</li>///
        call hCloseDocument
        sleep(2)
        '///<li>Reopen document</li>///
        call hDateiOeffnen ( sOutputFile )
        sleep(2)
        '///<li>Invoke File::Print</li>///
        FilePrint
        Kontext "Active"
        Sleep 1
        '///<li>Check if a MsgBox pops up due to misconfigured printer settings</li>///
        if Active.Exists(2) then
            if Active.GetRT = 304 then  
                qaErrorlog "OOPS, are you sure that a printer is configured at all?"
                try
                   Active.Ok
                catch
                   Active.Yes
                endcatch
            endif
        endif
        '///<li>Check if print dialog exists</li>///
        Kontext "DruckenDlg"
        if DruckenDlg.Exists(2) then
            Seiten.check
            '///<li>Check for string '1-12' in pages textbox</li>///
            sPagesToPrint = SeitenText.getText
            if sPagesToPrint = "1-12" then
                printlog "OK, expected number of pages for output"
            else
                warnlog "Unexpected number of pages for print output: " & sPagesToPrint & " -> Check this out!"
            endif
            DruckenDlg.Cancel
        else
            qaErrorlog "OOPS, are you sure that a printer is configured at all?"
        endif
        '///<li>For all sheets ...</li>///
        for iIndex = 1 to 3
        '///<li>... select currently desired one</li>///
            EditSheetSelect
            Kontext "SelectSheets"
            SheetSelectionBox.Select ( iIndex  )
            SelectSheets.OK
            sleep(1)
            '///<li>Invoke Format::Page...</li>///
            FormatPageCalc
            Kontext
            '///<li>Select Page 'Sheet'</li>///
            active.SetPage TabTabelleCalc
            '///<li>Close MsgBox when appeared</li>///
            if Active.Exists(2) then
                if Active.GetRT = 304 then
                    Printlog Active.GetText
                    Active.Yes
                end if
            end if
            Kontext "TabTabelleCalc"
            if scalingMode.GetSelIndex = iIndex then
            '///<li>Check if styles for print scaling have be appropriately assign</li>///
                printlog "Correct scaling mode selected"
                select case iIndex
                       case 1 
                           if SkalierungProzent.GetText <> "400%" then
                               warnlog "Unexpected scaling factor detected -> Check this out!"
                           endif
                       case 2
                           if ScalePageWidth.GetText <> "3" then
                               warnlog "Unexpected page width detected -> Check this out!"
                           endif
                           if ScalePageHeight.GetText <> "3" then
                               warnlog "Unexpected page height detected -> Check this out!"
                           endif
                       case 3 
                           if AnzahlMaxSeiten.GetText <> "4" then
                               warnlog "Unexpected page height detected -> Check this out!"
                           endif
                end select
            else
                warnlog "Unexpected scaling mode found -> Check this out!"
            endif
            '///<li>Quit dialog</li>///
            TabTabelleCalc.Cancel
        next iIndex
        '///<li>Close document</li>///
        call hCloseDocument
       
    endif
'///</ul>
endcase

