'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: validity.inc,v $
'*
'*  $Revision: 1.12 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:51:04 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'**
'** owner : joerg.sievers@Sun.COM
'**
'** short description :  Complete test for data validity
'**
'************************************************************************
' **
' #1 validity                ' Initial routine
' #1 tValidity_Check_Message
' #1 tValidity_Check_Excel
' #1 tValidity_Check_SXC
' **
'\***********************************************************************

sub validity

Printlog Chr(13) + "--------- validity ---------"

        call tValidity_Check_Message
        call tValidity_Check_Excel
        call tValidity_Check_SXC

end sub

'**************************************************************************************************

testcase tValidity_Check_Message
'/// This test checks, if an error messgae appears, when a wrong content is inserted into the appropriate cells

   dim sFilterName
       sFilterName = hGetUIFiltername("calc8")
   dim sExtNames(20)
       sExtNames() = hGetFilternameExtension("calc8")
   dim sFileFormat as string
       sFileFormat = sFilterName & " (." & sExtNames(0) & ")"
   dim sInputFile as String
       sInputFile = convertpath(gTesttoolPath & "calc/special/input/validity.ods")
   dim sOutputFile as String
       sOutputFile = convertpath(gOfficePath & "user/work/validity." & sExtNames(0))

   dim sMType as String
   dim iCount as integer
   dim sInfoStr as String
   
   ' dim locatesetting as integer, doclocate as integer
' 
   ' select case iSprache
      ' case 01: locatesetting = 36   :  doclocate = 42
      ' case 33: locatesetting = 2    :  doclocate = 4
      ' case 34: locatesetting = 2    :  doclocate = 4
      ' case 39: locatesetting = 81   :  doclocate = 101
      ' case 46: locatesetting = 85   :  doclocate = 103
      ' case 49: locatesetting = 8    :  doclocate = 13
      ' case 81: locatesetting = 45   :  doclocate = 60
      ' case 82: locatesetting = 9    :  doclocate = 11
      ' case 86: locatesetting = 27   :  doclocate = 35
      ' case 88: locatesetting = 26   :  doclocate = 31
      ' case else QAErrorlog "The test is not adjusted for language code " & iSprache : goto endsub
   ' end select
'TODO: Routine that reads the original values for localesetting anc doclocate
'TODO: ... and restores the settings after test has been run

   sleep 2

   call hDateiOeffnen sInputFile, true
   Kontext "SecurityWarning"
   if SecurityWarning.exists(2) then
       SecurityWarning.OK
   endif
   sleep 3
   if NOT hSpeichernUnterMitFilterKill ( sOutputFile, sFileFormat ) then
       warnlog "Saving test document localy failed -> Aborting"
       call hCloseDocument
       goto endsub
   endif
   sleep 3

   for iCount = 1 to 4
      select case iCount
         case 1 : sMType = "Stop"          : sInfoStr = "First"
         case 2 : sMType = "Warning"       : sInfoStr = "Second"
         case 3 : sMType = "Information"   : sInfoStr = "Third"
         case 4 : sMType = "Macro"         : sInfoStr = "Macro"
      end select

      call fCalcSelectSheet(sMType)
      printlog " *** " & sInfoStr & " it is checked, if the " & sMType & " messages appears, if wrong contents are " & _
            "inserted into the appropriate cells"
'/// Goto first cell and insert the correct value 
'///+ then press RETURN
'///+ no warning or information message should appear
'///+ repeat the same procedure for several other options
'///+ first check with correct values
'///+ then check incorrect values
'///+ and check the correct result
      call check_message(sMType, "B4", "3", "8")
      call check_message(sMType, "B5", "9", "10")
      call check_message(sMType, "B6", "28", "25")
      call check_message(sMType, "B7", "10", "12")
      call check_message(sMType, "B8", "11", "9")
      call check_message(sMType, "B9", "5", "3")
      call check_message(sMType, "B10", "1", "6")
      call check_message(sMType, "B11", "1", "6")
      call check_message(sMType, "B17", "3,14", "3,15")
      call check_message(sMType, "B18", "10,14", "10,16")
      call check_message(sMType, "B19", "25,10", "25,09")
      call check_message(sMType, "B20", "10,5", "10,7")
      call check_message(sMType, "B21", "11,9", "10")
      call check_message(sMType, "B22", "3,145", "3,14")
      call check_message(sMType, "B23", "1,45", "1,38")
      call check_message(sMType, "B24", "2,03", "2,15")
      
      call check_message(sMType, "E4", "13.12.99", "13.11.99")
      call check_message(sMType, "E5", "12.12.99", "13.12.99")
      call check_message(sMType, "E6", "14.12.99", "13.12.99")
      call check_message(sMType, "E7", "13.12.99", "14.12.99")
      call check_message(sMType, "E8", "13.12.99", "12.12.99")
      call check_message(sMType, "E9", "13.11.99", "13.12.99")
      call check_message(sMType, "E10", "23.12.99", "12.12.99")
      call check_message(sMType, "E11", "24.12.99", "23.12.99")
      call check_message(sMType, "E17", "13:15", "13:16")
      call check_message(sMType, "E18", "10:15", "14:16")
      call check_message(sMType, "E19", "23:10", "12:09")
      call check_message(sMType, "E20", "13:15", "13:16")
      call check_message(sMType, "E21", "13:15", "13:14")
      call check_message(sMType, "E22", "13:16", "13:15")
      call check_message(sMType, "E23", "13:15", "23:13")
      call check_message(sMType, "E24", "12:59", "13:00")
      
      call check_message(sMType, "H4", "abc", "abcd")
      call check_message(sMType, "H5", "abcdefgrd", "aderfgtzjm")
      call check_message(sMType, "H6", "rftgzhujikolmnbvcxyaswqepk", "ftgzhnujikm,lopredswqayx")
      call check_message(sMType, "H7", "asweqrfvbg", "edcvfrtgbnh")
      call check_message(sMType, "H8", "edcswxyaqtgb", "ujnmkipztr")
      call check_message(sMType, "H9", "sdxc", "tgb")
      call check_message(sMType, "H10", "rfvbj", "dfcvgb")
      call check_message(sMType, "H11", "g", "we")
      
      'New featurs OpenOffice 2.0
      call check_message(sMType, "B30", "February", "January")
      call check_message(sMType, "B31", "May", "February")
      call check_message(sMType, "B32", "June", "January")
      call check_message(sMType, "B33", "August", "November")
      call check_message(sMType, "B34", "September", "December")
      call check_message(sMType, "B35", "October", "March")
      call check_message(sMType, "B36", "July", "August")
      call check_message(sMType, "B37", "April", "October")
      call check_message(sMType, "B38", "Name03", "Name07")
      
      call check_message(sMType, "E30", "alpha", "omega")
      call check_message(sMType, "E31", "beta", "zeta")
      call check_message(sMType, "E32", "gamma", "psi")
      call check_message(sMType, "E33", "delta", "pi/2")

   next iCount

   call hCloseDocument

endcase

'**************************************************************************************************

testcase tValidity_Check_Excel
'/// This test checks, if an error messgae appears, when a wrong content is inserted into the appropriate cells

   dim sFilterName
       sFilterName = hGetUIFiltername("MS Excel 97")
   dim sExtNames(20)
       sExtNames() = hGetFilternameExtension("calc_MS_Excel_97")
   dim sFileFormat as string
       sFileFormat = sFilterName & " (." & sExtNames(0) & ")"
   dim sInputFile as String
       sInputFile = convertpath(gTesttoolPath & "calc/special/input/validity.ods")
   dim sOutputFile as String
       sOutputFile = convertpath(gOfficePath & "user/work/validity." & sExtNames(0))

   dim sMType as String
   dim iCount as integer
   dim sInfoStr as String
   dim sWert as STRING
   dim sDelimiter as STRING

   ' dim locatesetting as integer, doclocate as integer
' 
   ' select case iSprache
      ' case 01: locatesetting = 36   :  doclocate = 42
      ' case 33: locatesetting = 2    :  doclocate = 4
      ' case 34: locatesetting = 2    :  doclocate = 4
      ' case 39: locatesetting = 81   :  doclocate = 101
      ' case 46: locatesetting = 85   :  doclocate = 103
      ' case 49: locatesetting = 8    :  doclocate = 13
      ' case 81: locatesetting = 45   :  doclocate = 60
      ' case 82: locatesetting = 9    :  doclocate = 11
      ' case 86: locatesetting = 27   :  doclocate = 35
      ' case 88: locatesetting = 26   :  doclocate = 31
      ' case else QAErrorlog "The test is not adjusted for language code " & iSprache : goto endsub
   ' end select
'TODO: Routine that reads the original values for localesetting anc doclocate
'TODO: ... and restores the settings after test has been run

   sleep 2

   call hDateiOeffnen sInputFile, true
   Kontext "SecurityWarning"
   if SecurityWarning.exists(2) then
       SecurityWarning.OK
   endif
   sleep (2)
   if NOT hSpeichernUnterMitFilterKill ( sOutputFile, sFileFormat ) then
       warnlog "Saving test document localy failed -> Aborting"
       call hCloseDocument
       goto endsub
   endif
   sleep (2)
   call hCloseDocument
   sleep (2)
   call hDateiOeffnen ( sOutputFile )
   sleep (2)
   
   fCalcSelectCell("B17")
   DataValidity
   Kontext
   Active.setpage TabWerte
   Kontext "TabWerte"
   sWert = Wert.GetText
   TabWerte.Cancel
   
   select case sWert
        case "3.14" : sDelimiter = "."
        case "3,14" : sDelimiter = ","
        case else
             warnlog "Unexpected definition for data::validity in cell 'B17' -> Aborting"
             call hCloseDocument
             goto endsub
   end select
   

   for iCount = 1 to 3
      select case iCount
         case 1 : sMType = "Stop"          : sInfoStr = "First"
         case 2 : sMType = "Warning"       : sInfoStr = "Second"
         case 3 : sMType = "Information"   : sInfoStr = "Third"
      end select

      call fCalcSelectSheet(sMType)
      printlog " *** " & sInfoStr & " it is checked, if the " & sMType & " messages appears, if wrong contents are " & _
            "inserted into the appropriate cells"
'/// Goto first cell and insert the correct value 
'///+ then press RETURN
'///+ no warning or information message should appear
'///+ repeat the same procedure for several other options
'///+ first check with correct values
'///+ then check incorrect values
'///+ and check the correct result
      call check_message(sMType, "B4", "3", "8")
      call check_message(sMType, "B5", "9", "10")
      call check_message(sMType, "B6", "28", "25")
      call check_message(sMType, "B7", "10", "12")
      call check_message(sMType, "B8", "11", "9")
      call check_message(sMType, "B9", "5", "3")
      call check_message(sMType, "B10", "1", "6")
      call check_message(sMType, "B11", "1", "6")
      call check_message(sMType, "B17", "3" & sDelimiter & "14", "3" & sDelimiter & "15")
      call check_message(sMType, "B18", "10" & sDelimiter & "14", "10" & sDelimiter & "16")
      call check_message(sMType, "B19", "25" & sDelimiter & "10", "25" & sDelimiter & "09")
      call check_message(sMType, "B20", "10" & sDelimiter & "5", "10" & sDelimiter & "7")
      call check_message(sMType, "B21", "11" & sDelimiter & "9", "10")
      call check_message(sMType, "B22", "3" & sDelimiter & "145", "3" & sDelimiter & "14")
      call check_message(sMType, "B23", "1" & sDelimiter & "45", "1" & sDelimiter & "38")
      call check_message(sMType, "B24", "2" & sDelimiter & "03", "2" & sDelimiter & "15")
      
      call check_message(sMType, "E4", "13.12.99", "13.11.99")
      call check_message(sMType, "E5", "12.12.99", "13.12.99")
      call check_message(sMType, "E6", "14.12.99", "13.12.99")
      call check_message(sMType, "E7", "13.12.99", "14.12.99")
      call check_message(sMType, "E8", "13.12.99", "12.12.99")
      call check_message(sMType, "E9", "13.11.99", "13.12.99")
      call check_message(sMType, "E10", "23.12.99", "12.12.99")
      call check_message(sMType, "E11", "24.12.99", "23.12.99")
      call check_message(sMType, "E17", "13:15", "13:16")
      call check_message(sMType, "E18", "10:15", "14:16")
      call check_message(sMType, "E19", "23:10", "12:09")
      call check_message(sMType, "E20", "13:15", "13:16")
      call check_message(sMType, "E21", "13:15", "13:14")
      call check_message(sMType, "E22", "13:16", "13:15")
      call check_message(sMType, "E23", "13:15", "23:13")
      call check_message(sMType, "E24", "12:59", "13:00")
      
      call check_message(sMType, "H4", "abc", "abcd")
      call check_message(sMType, "H5", "abcdefgrd", "aderfgtzjm")
      call check_message(sMType, "H6", "rftgzhujikolmnbvcxyaswqepk", "ftgzhnujikm,lopredswqayx")
      call check_message(sMType, "H7", "asweqrfvbg", "edcvfrtgbnh")
      call check_message(sMType, "H8", "edcswxyaqtgb", "ujnmkipztr")
      call check_message(sMType, "H9", "sdxc", "tgb")
      call check_message(sMType, "H10", "rfvbj", "dfcvgb")
      call check_message(sMType, "H11", "g", "we")
      
      'New featurs OpenOffice 2.0
      call check_message(sMType, "B30", "February", "January")
      call check_message(sMType, "B31", "May", "February")
      call check_message(sMType, "B32", "June", "January")
      call check_message(sMType, "B33", "August", "November")
      call check_message(sMType, "B34", "September", "December")
      call check_message(sMType, "B35", "October", "March")
      call check_message(sMType, "B36", "July", "August")
      call check_message(sMType, "B37", "April", "October")
      call check_message(sMType, "B38", "Name03", "Name07")
      
      call check_message(sMType, "E30", "alpha", "omega")
      call check_message(sMType, "E31", "beta", "zeta")
      call check_message(sMType, "E32", "gamma", "psi")
      call check_message(sMType, "E33", "delta", "pi/2")

   next iCount

   call hCloseDocument

endcase

'**************************************************************************************************

testcase tValidity_Check_SXC
'/// This test checks, if an error messgae appears, when a wrong content is inserted into the appropriate cells

   dim sFilterName
       sFilterName = hGetUIFiltername("StarOffice XML (Calc)")
   dim sExtNames(20)
       sExtNames() = hGetFilternameExtension("calc_StarOffice_XML_Calc")
   dim sFileFormat as string
       sFileFormat = sFilterName & " (." & sExtNames(0) & ")"
   dim sInputFile as String
       sInputFile = convertpath(gTesttoolPath & "calc/special/input/validity.ods")
   dim sOutputFile as String
       sOutputFile = convertpath(gOfficePath & "user/work/validity." & sExtNames(0))

   dim sMType as String
   dim iCount as integer
   dim sInfoStr as String

   ' dim locatesetting as integer, doclocate as integer
' 
   ' select case iSprache
      ' case 01: locatesetting = 36   :  doclocate = 42
      ' case 33: locatesetting = 2    :  doclocate = 4
      ' case 34: locatesetting = 2    :  doclocate = 4
      ' case 39: locatesetting = 81   :  doclocate = 101
      ' case 46: locatesetting = 85   :  doclocate = 103
      ' case 49: locatesetting = 8    :  doclocate = 13
      ' case 81: locatesetting = 45   :  doclocate = 60
      ' case 82: locatesetting = 9    :  doclocate = 11
      ' case 86: locatesetting = 27   :  doclocate = 35
      ' case 88: locatesetting = 26   :  doclocate = 31
      ' case else QAErrorlog "The test is not adjusted for language code " & iSprache : goto endsub
   ' end select
'TODO: Routine that reads the original values for localesetting anc doclocate
'TODO: ... and restores the settings after test has been run

   call hDateiOeffnen sInputFile, true
   Kontext "SecurityWarning"
   if SecurityWarning.exists(2) then
       SecurityWarning.OK
   endif
   sleep 3
   if NOT hSpeichernUnterMitFilterKill ( sOutputFile, sFileFormat ) then
       warnlog "Saving test document localy failed -> Aborting"
       call hCloseDocument
       goto endsub
   endif
   sleep (2)
   call hCloseDocument
   sleep (2)
   call hDateiOeffnen ( sOutputFile )
   sleep (2)
   Kontext "SecurityWarning"
   if SecurityWarning.exists(2) then
       SecurityWarning.OK
   endif
   sleep 3

   for iCount = 1 to 4
      select case iCount
         case 1 : sMType = "Stop"          : sInfoStr = "First"
         case 2 : sMType = "Warning"       : sInfoStr = "Second"
         case 3 : sMType = "Information"   : sInfoStr = "Third"
         case 4 : sMType = "Macro"         : sInfoStr = "Macro"
      end select

      call fCalcSelectSheet(sMType)
      printlog " *** " & sInfoStr & " it is checked, if the " & sMType & " messages appears, if wrong contents are " & _
            "inserted into the appropriate cells"
'/// Goto first cell and insert the correct value 
'///+ then press RETURN
'///+ no warning or information message should appear
'///+ repeat the same procedure for several other options
'///+ first check with correct values
'///+ then check incorrect values
'///+ and check the correct result
      call check_message(sMType, "B4", "3", "8")
      call check_message(sMType, "B5", "9", "10")
      call check_message(sMType, "B6", "28", "25")
      call check_message(sMType, "B7", "10", "12")
      call check_message(sMType, "B8", "11", "9")
      call check_message(sMType, "B9", "5", "3")
      call check_message(sMType, "B10", "1", "6")
      call check_message(sMType, "B11", "1", "6")
      call check_message(sMType, "B17", "3,14", "3,15")
      call check_message(sMType, "B18", "10,14", "10,16")
      call check_message(sMType, "B19", "25,10", "25,09")
      call check_message(sMType, "B20", "10,5", "10,7")
      call check_message(sMType, "B21", "11,9", "10")
      call check_message(sMType, "B22", "3,145", "3,14")
      call check_message(sMType, "B23", "1,45", "1,38")
      call check_message(sMType, "B24", "2,03", "2,15")
      
      call check_message(sMType, "E4", "13.12.99", "13.11.99")
      call check_message(sMType, "E5", "12.12.99", "13.12.99")
      call check_message(sMType, "E6", "14.12.99", "13.12.99")
      call check_message(sMType, "E7", "13.12.99", "14.12.99")
      call check_message(sMType, "E8", "13.12.99", "12.12.99")
      call check_message(sMType, "E9", "13.11.99", "13.12.99")
      call check_message(sMType, "E10", "23.12.99", "12.12.99")
      call check_message(sMType, "E11", "24.12.99", "23.12.99")
      call check_message(sMType, "E17", "13:15", "13:16")
      call check_message(sMType, "E18", "10:15", "14:16")
      call check_message(sMType, "E19", "23:10", "12:09")
      call check_message(sMType, "E20", "13:15", "13:16")
      call check_message(sMType, "E21", "13:15", "13:14")
      call check_message(sMType, "E22", "13:16", "13:15")
      call check_message(sMType, "E23", "13:15", "23:13")
      call check_message(sMType, "E24", "12:59", "13:00")
      
      call check_message(sMType, "H4", "abc", "abcd")
      call check_message(sMType, "H5", "abcdefgrd", "aderfgtzjm")
      call check_message(sMType, "H6", "rftgzhujikolmnbvcxyaswqepk", "ftgzhnujikm,lopredswqayx")
      call check_message(sMType, "H7", "asweqrfvbg", "edcvfrtgbnh")
      call check_message(sMType, "H8", "edcswxyaqtgb", "ujnmkipztr")
      call check_message(sMType, "H9", "sdxc", "tgb")
      call check_message(sMType, "H10", "rfvbj", "dfcvgb")
      call check_message(sMType, "H11", "g", "we")
      
   next iCount

   call hCloseDocument

endcase

