'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_shortcut.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/15 13:33:00 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@sun.com
'*
'* short description : test shortcuts and keyboard in Calc
'*
'************************************************************************
'*
' #1 C_ShortCut ' Initial routine
' #1 tSelectInputLine
' #1 tKeyboardControls
' #1 tSelectSheetArea
'*
'\***********************************************************************


sub C_ShortCut
Printlog "--------- C_ShortCut ---------"

   call tSelectInputLine
   call tKeyboardControls
   call tSelectSheetArea

End sub

testcase tSelectInputLine
'/// This testcase checks, if the shortcut <CTRL+SHIFT+F2> switch
'/// the cursor to the inputline

   Call hNewDocument

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 SHIFT F2>"
   Kontext "RechenleisteCalc"
   EingabeZeileCalc.TypeKeys "This is a Text"
   EingabeZeileCalc.TypeKeys "<MOD1 SHIFT HOME>"
   EingabeZeileCalc.TypeKeys "<MOD1 C>"
   Kontext "DocumentCalc"
   call cgotocell("A5")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 V>"
   if cZellwert("A5") = "This is a Text" then
      printlog "OK, the switch to the input line works"
   else
      if gPlatgroup = "unx" then
         warnlog "The switch to the input line doesn't work with <CTRL+SHIFT+F2>, if this test"
         warnlog "runs on linux with kde you should enable this shortcut for our office"
      else
         warnlog "The switch to the input line doesn't work with <CTRL+SHIFT+F2>"
      end if
   end if

   Kontext "DocumentCalc"
   Call hCloseDocument

endcase

testcase tKeyboardControls
'/// This test checks the following shortcuts with a defined document
'/// (gTesttoolPath & "calc/level1/input/c_shortcut/shortcuts.sxc")
'/// - CURSOR     : LEFT, RIGHT, UP, DOWN
'/// - CTRL+CURSOR: <CTRL+LEFT/RIGHT/UP/DOWN>
'/// - <CTRL+PAGEUP/PAGEDOWN>
'/// - HOME/END
'/// - CTRL+HOME/END
'/// - SHIFT+MOD1+LEFT/RIGHT/UP/DOWN
'/// - PAGEUP/PAGEDOWN
'/// - <ALT+PAGEUP/PAGEDOWN>

   dim File as String
   File = convertpath(gTesttoolPath & "calc/level1/input/c_shortcut/shortcuts.sxc")
   call hDateiOeffnen File
   sleep 5
   ' goto the first sheet
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 PAGEUP PAGEUP>"

   ' - CURSOR     : LEFT, RIGHT, UP, DOWN
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<DOWN>"
   if fWhereIsTheCellCursor = "A2" then
      printlog "OK, Button DOWN works"
   else
      warnlog "Button DOWN has moved the selection to " & fWhereIsTheCellCursor & " instead of A2"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<RIGHT>"
   if fWhereIsTheCellCursor = "B2" then
      printlog "OK, Button RIGHT works"
   else
      warnlog "Button RIGHT has moved the selection to " & fWhereIsTheCellCursor & " instead of B2"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<UP>"
   if fWhereIsTheCellCursor = "B1" then
      printlog "OK, Button UP works"
   else
      warnlog "Button UP has moved the selection to " & fWhereIsTheCellCursor & " instead of B1"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<LEFT>"
   if fWhereIsTheCellCursor = "A1" then
      printlog "OK, Button LEFT works"
   else
      warnlog "Button LEFT has moved the selection to " & fWhereIsTheCellCursor & " instead of A1"
   end if

   ' - CTRL+CURSOR: <CTRL+LEFT/RIGHT/UP/DOWN>
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 DOWN>"
   if fWhereIsTheCellCursor = "A65536" then
      printlog "OK, Button MOD1 DOWN works"
   else
      warnlog "Button MOD1 DOWN has moved the selection to " & fWhereIsTheCellCursor & " instead of A65536"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 RIGHT>"
   if fWhereIsTheCellCursor = "IV65536" then
      printlog "OK, Button MOD1 RIGHT works"
   else
      warnlog "Button MOD1 RIGHT has moved the selection to " & fWhereIsTheCellCursor & " instead of IV65536"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 UP>"
   if fWhereIsTheCellCursor = "IV1" then
      printlog "OK, Button MOD1 UP works"
   else
      warnlog "Button MOD1 UP has moved the selection to " & fWhereIsTheCellCursor & " instead of IV1"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 LEFT>"
   if fWhereIsTheCellCursor = "IQ1" then
      printlog "OK, Button MOD1 LEFT works"
   else
      warnlog "Button MOD1 LEFT has moved the selection to " & fWhereIsTheCellCursor & " instead of IQ1"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 LEFT>"
   if fWhereIsTheCellCursor = "A1" then
      printlog "OK, Button MOD1 LEFT works"
   else
      warnlog "Button MOD1 LEFT has moved the selection to " & fWhereIsTheCellCursor & " instead of A1"
   end if

   printlog "*** Now moving to the filled area and check the last four shortcuts again"

   call cgotocell("E6")
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 DOWN>"
   if fWhereIsTheCellCursor = "E21" then
      printlog "OK, Button MOD1 DOWN works"
   else
      warnlog "Button MOD1 DOWN has moved the selection to " & fWhereIsTheCellCursor & " instead of E21"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 RIGHT>"
   if fWhereIsTheCellCursor = "I21" then
      printlog "OK, Button MOD1 RIGHT works"
   else
      warnlog "Button MOD1 RIGHT has moved the selection to " & fWhereIsTheCellCursor & " instead of I21"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 UP>"
   if fWhereIsTheCellCursor = "I6" then
      printlog "OK, Button MOD1 UP works"
   else
      warnlog "Button MOD1 UP has moved the selection to " & fWhereIsTheCellCursor & " instead of I6"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 LEFT>"
   if fWhereIsTheCellCursor = "E6" then
      printlog "OK, Button MOD1 LEFT works"
   else
      warnlog "Button MOD1 LEFT has moved the selection to " & fWhereIsTheCellCursor & " instead of I6"
   end if

   printlog "*** Now lets check, if the shortcuts to switch to the next sheets works"

   ' - <CTRL+PAGEUP/PAGEDOWN>
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 PAGEDOWN>"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DataConsolidate
   Kontext "Konsolidieren"
   if Ausgeben.getText = "$Tabelle2.$A$1" then
      printlog "OK, the shortcut has moved to the next sheet"
   else
      warnlog "The shortcut has moved to " & Ausgeben.getText & " instead of $Tabelle2.$A$1"
   end if
   Konsolidieren.close

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 PAGEDOWN>"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DataConsolidate
   Kontext "Konsolidieren"
   if Ausgeben.getText = "$Tabelle3.$A$1" then
      printlog "OK, the shortcut has moved to the next sheet"
   else
      warnlog "The shortcut has moved to " & Ausgeben.getText & " instead of $Tabelle3.$A$1"
   end if
   Konsolidieren.close

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 PAGEUP PAGEUP>"

   ' - HOME/END
   printlog "*** Check the shortcut HOME/END"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<END>"
   if fWhereIsTheCellCursor = "IQ1" then
      printlog "OK, the last used column of the sheet is selected"
   else
      warnlog "The cursor is in " & fWhereIsTheCellCursor & " instead of 'IQ1'"
   end if

   ' - <CTRL+HOME/END>
   printlog "*** Check the shortcut <CTRL+HOME/END>"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   if fWhereIsTheCellCursor = "A1" then
      printlog "OK, the cell 'A1' is selected"
   else
      warnlog "The cell " & fWhereIsTheCellCursor & " is selected instead of 'A1'"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 END>"
   if fWhereIsTheCellCursor = "IQ21" then
      printlog "OK, the cell 'IQ21' is selected"
   else
      warnlog "The cell " & fWhereIsTheCellCursor & " is selected instead of 'IQ21'"
   end if

   ' - SHIFT+MOD1+LEFT/RIGHT/UP/DOWN
   printlog "*** Check the shortcuts for selection expansion"
   Kontext "DocumentCalc"
   call cgotocell("E6")
   DocumentCalc.TypeKeys "<MOD1 SHIFT RIGHT>"
   if fWhereIsTheCellCursor = "E6:I6" then
      printlog "OK, the expansion to the rigth works"
   else
      warnlog "The cells " & fWhereIsTheCellCursor & " are selected instead of 'E6:I6'"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 SHIFT DOWN>"
   if fWhereIsTheCellCursor = "E6:I21" then
      printlog "OK, the expansion to the rigth works"
   else
      warnlog "The cells " & fWhereIsTheCellCursor & " are selected instead of 'E6:I21'"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 SHIFT LEFT>"
   if fWhereIsTheCellCursor = "E6:E21" then
      printlog "OK, the expansion to the rigth works"
   else
      warnlog "The cells " & fWhereIsTheCellCursor & " are selected instead of 'E6:E21'"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 SHIFT UP>"
   if fWhereIsTheCellCursor = "E6" then
      printlog "OK, the expansion to the rigth works"
   else
      warnlog "The cells " & fWhereIsTheCellCursor & " are selected instead of 'E6'"
   end if

   '  - PAGEUP/PAGEDOWN
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<PAGEDOWN>"
   if fWhereIsTheCellCursor <> "A1" then
      printlog "OK, the cursor is on the next page downwards"
   else
      warnlog "PageDown did not work."
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<PAGEUP>"
   if fWhereIsTheCellCursor = "A1" then
      printlog "OK, the cursor is on the next page downwards"
   else
      warnlog "The cursor is in cell " & fWhereIsTheCellCursor & " instead of 'A1'"
   end if

   ' - <ALT+PAGEUP/PAGEDOWN>
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD2 PAGEDOWN>"
   if fWhereIsTheCellCursor <> "A1" then
      printlog "OK, the cursor is on the next page downwards"
   else
      warnlog "Moving right with ALT+PageDown failed"
   end if

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD2 PAGEUP>"
   if fWhereIsTheCellCursor = "A1" then
      printlog "OK, the cursor is on the next page right"
   else
      warnlog "The cursor is in cell " & fWhereIsTheCellCursor & " instead of 'A1'"
   end if

   call hCloseDocument

endcase

testcase tSelectSheetArea
'/// Test if CTRL+SHIFT+F5 enters the range selector
'/// 1. Send CTRL+SHIFT+F5 to the calc document
'/// 2. Check if focus is in the range selector
'///+ by writing something into it
'///+ and paste the content into a cell

   call hNewDocument

   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys "<MOD1 SHIFT F5>"
   Kontext "RechenleisteCalc"
   Bereich.TypeKeys "<MOD1 SHIFT RIGHT>"
   Bereich.TypeKeys "sheetarea"
   Bereich.TypeKeys "<MOD1 SHIFT LEFT>"
   Bereich.TypeKeys "<MOD1 C>"
   Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   DocumentCalc.TypeKeys  "<MOD1 V>"
   if cZellwert("A1") = "sheetarea" then
      printlog "OK, ShortCut CTRL+SHIFT+F5 works"
   else
      warnlog "ShortCut CTRL+SHIFT+F5 doesn't work"
   end if
   printlog "Content of A1: " & cZellwert("A1")

   call hCloseDocument

endcase

