'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_102_.inc,v $
'*
'*  $Revision: 1.26 $
'*
'*  last change: $Author: jsi $ $Date: 2006/06/22 09:18:07 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.sievers@Sun.COM
'*
'* short description  :  Detailed test of the functions in the Edit menu - Part 1
'*
'*************************************************************************
'*
' #1 C_102_ ' Initial routine
' #1 tEditUndo
' #1 tEditRedo
' #1 tEditLastCommand
' #1 tEditCut
' #1 tEditCopy
' #1 tEditPaste
' #1 tEditPasteOverwrite
' #1 tEditPasteContents
' #1 tEditSelectAll
' #1 tEditNavigator
' #1 tEditHeaderAndFooter
' #1 tEditFillDown
' #1 tEditFillRight
' #1 tEditFillTop
' #1 tEditFillLeft
' #1 tEditFillTable
' #1 tEditFillSerie
' #1 tEditDeleteContents
' #0 Suezurueck
' #0 closeNavigator
' #0 MoveAndRenameOLE
'*
'\************************************************************************

sub C_102_

Printlog "--------- C_102_ ---------"

'   call tEditUndo
   call tEditRedo
   call tEditLastCommand
   call tEditCut
   call tEditCopy
   call tEditPaste
   call tEditPasteOverwrite
   call tEditPasteContents
   call tEditSelectAll
   call tEditNavigator
   call tEditHeaderAndFooter
   call tEditFillDown
   call tEditFillRight
   call tEditFillTop
   call tEditFillLeft
   call tEditFillTable
   call tEditFillSerie
   call tEditDeleteContents

end sub

'-------------------------------------------------------------------------

testcase tEditUndo
'/// This testprocedure checks the function "process retrogressive". In this connection it is ///
'/// also checked if the made adjustment in the menu "Tools|Options|StarOffice|General ///
'/// "NumberOfSteps" is maintained. ///
'/// Due to bug:97627, it is also checked, if an inserted table from the internet is delete
'/// by the undo command.

   dim wh : dim Lager
   dim rSchritte As Integer
   dim File$
   dim whichCell$, targetCell$
   dim colLoop%, colIndex$, rowIndex%, cellHits%
   
   File$ = convertpath(gOfficePath & "user/work/tEditUndo.ods")
   cellHits% = 0
   printlog "gtesttoolpath: " & gtesttoolpath
   Printlog "Process retrogressive"

    call  hNewDocument

    ToolsOptions
    hToolsOptions ("STAROFFICE", "MEMORY")
'/// Modify the number steps from 20 to 10. ///
    UndoSteps.settext "10"
    rSchritte = UndoSteps.GetText
    Kontext "OptionenDLG"
    OptionenDLG.Ok
    kontext
'/// Enter 11 times a 1 into a cell and go with TAB to the next cell. ///
    for wh = 1 to 11
                DocumentCalc.TypeKeys "1<TAB>"
                sleep(1)
    next wh
    sleep(1)
    for wh = 1 to rSchritte
                EditUndo
                sleep(1)
    next wh
    sleep(1)
'/// Call 10 times the menu EditUndo ///'
    try
        EditUndo
        Warnlog "Process was 11 times possible with 10 retrogressive steps!"
    catch
        Printlog "Number of retrogressive steps is OK"
    endcatch
    lager = TrimTab (cZellwert("A1:K1"))
    printlog "content of Lager :" + lager + ":"
    if lager = "1" then
        Printlog "Retrogressive has correctly operated"
    else
        Warnlog "Retrogressive doesn't work :" + lager + ":"
    end if
    DocumentCalc.TypeKeys "<Mod1 Home>"
    printlog " - Check adjustment before saving file!"
    call CheckOptions
    call hSpeichernUnterMitFilterKill File$, gCalcFilter
    FileClose
    Sleep 1
    call hDateiOeffnen File$
    printlog " - Check adjustment after saving file!"
'/// Check adjustments after saving file. ///
    call CheckOptions

    call hCloseDocument
    
    QAErrorLog "On behalf of JSI undo/redo with live connection to the internet is skipped!"
    goto endsub

    printlog "Now due to the bug:97627, this functionality is tested with an inserted chart from"
    printlog "the internet"
    dim httpText as String
    httpText = "http://de.finance.yahoo.com/q?s=@NE50_XE.DE&d=v1"
    call hNewDocument
    sleep 3
    Kontext "DocumentCalc"
   DocumentCalc.TypeKeys "<MOD1 HOME>"
   InsertLinkToExternalData
   sleep 2
   Kontext "ExternalData"
   sleep 2
   URLField.setText httpText
   sleep 5
   URLField.TypeKeys "<RETURN>"
   sleep 15
   Kontext "ExternalData"
   while TableListBox.getItemCount = 0
      sleep 3
   wend
   TableListBox.select 2
   sleep 5
   ExternalData.OK
   sleep 10
   for colLoop% = 1 to 2
       if colLoop% = 1 then colIndex$ ="A"
       if colLoop% = 2 then colIndex$ ="B"
       for rowIndex% = 13 to 19
           whichCell$ = colIndex$ & CStr(rowIndex%)
           if cZellWert(whichCell$) = "WKN" then
              targetCell$ = whichCell$
              cellHits% = cellHits% + 1
           end if
       next rowIndex%
   next colLoop%
   select case cellHits%
          case 0 : WarnLog "Search string not found"
                   QAErrorLog "Please Check if it's a bug or maybe Yahoo changed the page layout!"
                   goto endsub
          case 1 : printlog "OK, the html chart was inserted"
          case else : printlog "OK, the html chart was inserted"
                      QAErrorLog "OOPS, found more occurences of search string than expected"
   end select
   
   sleep (2)
   printlog "Undo paste"
   EditUndo
   if cZellWert(targetCell$) <> "" then
      warnlog "The content of cell " & targetCell$ & " is " & cZellWert(targetCell$) & " but it should be ''"
   else
      printlog "OK, the cell is empty - Undo successful"
   end if
   
   sleep(2)
   printlog "Redo paste"
   EditRedo
   if cZellWert(targetCell$) <> "WKN" then
      warnlog "The content of cell " & targetCell$ & " is " & cZellWert(targetCell$) & " but it should be 'WKN'"
   else
      printlog "OK, Redo was successful"
   end if

   call hCloseDocument

endcase

Sub CheckOptions

   ToolsOptions
   sleep 3
   hToolsOptions ("STAROFFICE", "MEMORY")
   sleep 3
   if UndoSteps.GetText = "10" then
      printlog "OK! The made adjustment is maintained"
   else
      warnlog "Failure! Adjustment is lost"
   end if
   Kontext "OptionenDLG"
   OptionenDLG.Ok
   sleep 3

End Sub
'
'-----------------------------------------------------------
'
testcase tEditRedo
'/// This testprocedure checks the function "process repeat". In this connection it is ///
'/// also checked if the made adjustment in the menu "Tools|Options|StarOffice|General| ///
'/// "NumberOfSteps" is maintained. ///
    dim wh : dim lager
    dim rSteps As Integer
    dim file$
    file$ = convertpath(gOfficePath & "user/work/teditredo.ods")

    call  hNewDocument

    ToolsOptions
    hToolsOptions ("STAROFFICE", "MEMORY")
'/// The number of steps is set to 10 ///
    UndoSteps.settext "10"
    rSteps = UndoSteps.GetText
    Kontext "ExtrasOptionenDLG"
        ExtrasOptionenDLG.Ok
        kontext
'/// Then the number 1 is input 11 times into a cell ///
    for wh = 1 to 11
                DocumentCalc.TypeKeys "1<TAB>"
    next wh
'/// After this, the command redo is executed 10 times ///
    for wh = 1 to rSteps
                EditUndo
    next wh
    lager = TrimTab(cZellwert("A1:K1"))
    if lager = "1" then
    Printlog "Process retrogressive has operated correctly!"
    else
       Warnlog "Retrogressive doesn't work :" + lager + ":"
    end if
    for wh = 1 to rSteps
                EditRedo
    next wh
    try
        EditRedo
        Warnlog "Process was 11 times possible with 10 repeating steps!"
    catch
        Printlog "Number of repeating is OK"
    endcatch
    lager = TrimString(cZellwert("A1:K1"), 32)
    lager = TrimString(lager, 9)
    printlog "Content of lager:" & lager
    if lager = "11111111111" then
        Printlog "Retrogressive has operated correctly"
    else
        Warnlog "Retrogressive doesn't work :" & lager & ":"
    end if
    printlog " - Check adjustment before saving file!"
    call CheckOptions
    call hSpeichernUnterMitFilterKill file$, gCalcFilter
    sleep 5
    FileClose
    sleep 5
    call hDateiOeffnen file$
'/// Check all made settings after saving, closing and reloading the file
    printlog " - Check adjustment after saving file!"
    call CheckOptions

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditLastCommand
'/// This testcase check, if the command 'LastCommand' works ///

   dim wh : dim lager

    call  hNewDocument
'/// Enter a 1 into a cell ///
    DocumentCalc.TypeKeys "1<TAB>"
'/// Repeat it 10 times ///
    for wh = 1 to 10
                EditRepeat
                DocumentCalc.TypeKeys "<TAB>"
    next wh
'/// copy the marked cells into the clipboard ///
    lager = TrimString(cZellwert("A1:K1"), 32)
    lager = TrimString(lager, 9)
'/// Check the clipboard content ///
    if lager = "11111111111" then
        Printlog "Last command has operated correctly!"
    else
        Warnlog "Last command doesn't work :" + lager + ":"
    end if

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditCut
'/// This testcase checks, if the Command 'Cut' works ///

    call  hNewDocument

    SetClipboard = ""
'/// At first a number is put into a cell ///
    DocumentCalc.TypeKeys "1<RETURN><Up>"
    EditCut
    call cClipboardVergleichen ( 1 )
    call cCellCompare ( 1, 0, 0 )
    SetClipboard = ""
'/// Then the clipborad is tested with some words ///
    DocumentCalc.TypeKeys "This is a test with some words!<RETURN><Up>"
    EditCut
    call cClipboardVergleichen ( "This is a test with some words!" )
    call cCellCompare ( 1, 0, 0 )

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditCopy
'/// This testcase test the clipboard function ///
    call  hNewDocument
    sleep 5

    SetClipboard = ""
    sleep 2
    DocumentCalc.TypeKeys "1Mr. Bean<TAB><LEFT SHIFT LEFT>"
    EditCopy
    call cClipboardVergleichen ( "1Mr. Bean" )

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditPaste
'/// This testcase test the Copy and Paste function works ///
    call  hNewDocument
    dim ResString as String
    SetClipboard = ""
    DocumentCalc.TypeKeys "1<TAB>Mr. Bean<TAB><LEFT SHIFT LEFT>"
    EditCopy
    DocumentCalc.TypeKeys "<Down>"
    EditPaste
    ResString = TrimString(cZellwert("A2:B2"), 32)
    ResString = TrimString(ResString, 9)
    if ResString = "1Mr.Bean" then
      Printlog "OK! Process paste work"
    else
      Warnlog "Paste doesn't work!"
    end if
    DocumentCalc.TypeKeys "<LEFT UP><SHIFT RIGHT>"
    EditCopy
    'call cClipboardVergleichen ( "1Mr.Bean" )

      call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditPasteOverwrite
'/// This testcase checks the MsgBox that should pop up when the target cell of a paste already has content ///
'/// It will also be checked if applying Yes/No works as expected ///

   call hNewDocument
   
   Kontext "DocumentCalc"
     DocumentCalc.typekeys "1<Return>2<Return><Up><MOD1 C><Up><MOD1 V>"
     try
        Kontext "CellWarning"
        Printlog CellWarning.GetCheckBoxText
        CellWarning.Check
        if CellWarning.IsChecked then
           printlog "Correct - CheckBox is checked"
        else 
           warnlog "Failed - CheckBox wasn't checked"
        endif
        CellWarning.UnCheck
        if CellWarning.IsChecked then
           warnlog "Failed - CheckBox is checked"
        else 
           printlog "Correct - CheckBox wasn't checked"
        endif
         
        Kontext "CellWarning"    
          CellWarning.No
                
      Kontext "DocumentCalc"
        DocumentCalc.typekeys "<MOD1 C>"
          if getClipboardText = "1" then
            printlog "OK - Cell has expected content"
          else
            warnlog "Failed - Cell has wrong content"
          endif
           
        DocumentCalc.typekeys "<Down><MOD1 C><Up><MOD1 V>"
        Kontext "CellWarning"
          CellWarning.Yes
           
      Kontext "DocumentCalc"
        DocumentCalc.typekeys "<MOD1 C>"
          if getClipboardText = "2" then
            printlog "OK - Cell has expected content"
          else
            warnlog "Failed - Cell has wrong content"
          endif 
         
     catch
       warnlog "MsgBox for overwrite warning doesn't exist or method on MsgBox doesn't apply"
     endcatch
         
   call hCloseDocument
   
endcase
'
'-----------------------------------------------------------
'
testcase tEditPasteContents
'/// This procedure checks the clipboardfunction the insertfunction by inserting a diagram ///
'/// and numbers with and without computing options ///

   dim Fehlerda : fehlerda = False
   Dim Machit
   select case iSprache
        case 01   : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Englisch(US)
        case 03   : Machit = "13<TAB>Kirk<TAb>=Concatenar(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Portugisich
        case 07   : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case 31   : Machit = "13<TAB>Kirk<TAb>=TEKST.SAMENVOEGEN(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Niederlaendisch
        case 33   : Machit = "13<TAB>Kirk<TAb>=Concatener(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Franz÷sisch
        case 34   : Machit = "13<TAB>Kirk<TAb>=Concatenar(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Spanisch
        case 39   : Machit = "13<TAB>Kirk<TAb>=Concatena(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Italienisch
        case 45   : Machit = "13<TAB>Kirk<TAb>=SAMMENKÆDNING(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" '
        case 46   : Machit = "13<TAB>Kirk<TAb>=SAMMANFOGA(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Schwedisch
        case 49   : Machit = "13<TAB>Kirk<TAB>=Verketten(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>" 'Deutsch
        case 55   : Machit = "13<TAB>Kirk<TAB>=Concatenar(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case 81     : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case 82     : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case 86     : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case 88     : Machit = "13<TAB>Kirk<TAb>=Concatenate(A1;" + chr$(34) + chr$(32) + chr$(34) + ";B1)<TAB>"
        case else : QAErrorlog "No adjustment for current language" : goto endsub
   end select

    call  hNewDocument
'/// At first there is only inserted a word into the clipboard ///
    call SetClipboard( "Test" )
    if getclipboardtext <> "Test" then
        Warnlog "Content of Clipboard isn't right" & GetClipboardText
        call SetClipboard( "Test" )
        if getclipboardtext <> "Test" then
                Warnlog "2. attempt doesn't work too: " & GetClipboardtext
        end if
    end if
    Printlog " Insert contents unformated text"
    EditPasteSpecialCalc
    Kontext "InhaltEinfuegen"
    try
      Auswahl.select 1
        InhaltEinfuegen.OK
    catch
        Warnlog "Auswahl.select 1 doesn't work"
      if Auswahl.Getitemcount <> 1 then
         Warnlog "Number of inserting possibilities isn't no more correct old: 1  new: " & Auswahl.GetItemCount
      end if
      InhaltEinfuegen.Cancel
   endcatch
    call cClipboardVergleichen ("Test")
'/// Then a graphic is inserted and copy into the clipboard ///
    Printlog "Insert contents bitmap "
    InsertGraphicsFromFile
    Kontext "GrafikEinfuegenDlg"
    Dateiname.settext convertpath(gTesttoolpath + "global\input\graf_inp\baer.tif")
    'warnlog "If the test crahses by inserting the file, it could be the bug:90336"
    Oeffnen.click
    sleep (2)
    EditCopy
    sleep (2)
    try
        EditImageMap
        Kontext "ImageMapEditor"
        ImageMapEditor.close
        kontext
        if active.exists then active.no
        Printlog "graphic is inserted"
        Kontext
        call gMouseclick (90,90)
    catch
        Warnlog "  Diagram wasn't inserted"
        Fehlerda = true
    endcatch
    if Fehlerda = false then
    sleep (2)
    call cgotoCell ("D1")
'/// Now it is checked if the number of objects in the clipboard are 3
    EditPasteSpecialCalc
    Kontext "InhaltEinfuegen"
            if Auswahl.Getitemcount <> 3 then Warnlog "Number of inserting possibilities isn't no more correct old: 3   Neu: " & Auswahl.GetItemCount
            Auswahl.select 2
            InhaltEinfuegen.OK
    try
            EditImageMap
            Kontext "ImageMapEditor"
         ImageMapEditor.close
         kontext
         if active.exists then active.no                          'wird das Objekt eingefuegt keine Fehlermeldung
            Printlog "  Diagram was inserted again"
            Kontext
            call gMouseclick (90,90)
        catch
            Warnlog "  Diagram wasn't inserted"
            Kontext
            call gMouseclick (90,90)
    endcatch
    else
    Printlog "Nothing work without diagram"
    end if

   call hCloseDocument

'/// Insert cellcontents ///

   call hNewDocument

Printlog " Insert contents with computing options.."
        Kontext
        DocumentCalc.typekeys Machit
        sleep 5
        DocumentCalc.typekeys "<LEFT>"
        sleep 5
        DocumentCalc.typekeys "<SHIFT LEFT LEFT>"
        sleep 5
        FormatCells
        sleep 5
    Kontext
    active.setpage TabFontEffects
    Kontext "TabFontEffects"
    FontColor.select 13
    TabFontEffects.Ok
    sleep 5
'/// In the next steps there are inserted some contents in cells with ///
'/// different options. After paste, the inserted contents are checked ///
'/// if their properties are similar to the made paste settings ///
'/// go to Cells "A1:C1" and copy this, then go to Cell "B3" and paste ///
   gosub gibsmir
    Alleseinfuegen.check
    Keine.check
    Nichtverschieben.check
    LeerzellenUeberspringen.uncheck
    Transponieren.uncheck
    Verknuepfen.uncheck
    InhalteeinfuegenCalc.Ok
    sleep 5
    Machit = cZellwert("B3:D3")
    printlog "Content of Machit:" + Machit
    If Machit = "13" + chr(9) + "Kirk" + chr(9) + "13 Kirk" then
        Printlog "Content OK with Alles einfuegen"
    else
        Warnlog "Content isn't right with Alles einfuegen" & Machit
    end if
    FormatCells
    Kontext
    active.setpage TabFontEffects
    Kontext "TabFontEffects"
    if FontColor.getselIndex = 13 then
        Printlog "Formatting is OK with Alles einfuegen"
    else
        Warnlog "Formatting isn't right with Alles einfuegen"
    end if
    TabFontEffects.Ok

'/// go to Cells "A1:C1" and copy this, then go to Cell "B3" and paste ///
  gosub gibsmir
    Alleseinfuegen.uncheck
    Zeichenketten.check
    Zahlen.check
    DatumZeit.uncheck
    Formeln.uncheck
    Notizen.uncheck
    Formate.uncheck
    Addieren.check
    Nichtverschieben.check
    LeerzellenUeberspringen.uncheck
    Transponieren.uncheck
    Verknuepfen.uncheck
    InhalteeinfuegenCalc.Ok
    sleep 5
    Machit = cZellwert("B3:D3")
    printlog "Content of Machit:" + Machit
    if Machit = "26" + chr(9) + "Kirk" + chr(9) + "26 Kirk" then
        Printlog "Content OK with Zeichenkette, Zahlen, Addition einfuegen"
    else
      Warnlog "Content isn't right with Zeichenkette, Zahlen, Addition einfuegen" & Machit
    end if

'/// go to Cells "A1:C1" and copy this, then go to Cell "B3" and paste ///
   gosub gibsmir
    Alleseinfuegen.uncheck
    Zeichenketten.check
    Zahlen.check
    DatumZeit.uncheck
    Formeln.check
    Notizen.uncheck
    Formate.check
    Multiplizieren.check
    Nachrechts.check
    LeerzellenUeberspringen.uncheck
    Transponieren.uncheck
    Verknuepfen.uncheck
    InhalteeinfuegenCalc.Ok
    sleep 5
    Machit = cZellwert("B3:G3")
    printlog "Content of Machit:" + Machit
    if Machit = "0" + chr(9) + "" + chr(9) + "0" + chr(9) + "26" + chr(9) + "Kirk" + chr(9) + "26 Kirk" then
        Printlog "Content OK with Zeichenkette, Zahlen, Multiplizieren, nach rechts einfuegen"
    else
      Warnlog "Content isn't right with Zeichenkette, Zahlen, Multiplizieren, nach rechts einfuegen" & Machit
    end if

  gosub gibsmir
    Formate.check
    Keine.check
    Nichtverschieben.check
    Transponieren.check
    InhalteeinfuegenCalc.Ok
    sleep 5
    Machit = cZellwert("B3:G5")
    Machit = cZellwert("B3:G5")
    Machit = cZellwert("B3:G5")
    dim ghi,gha
    for ghi = 1 to len(Machit) : gha = gha + asc(mid(Machit,ghi,1) ) : gha = gha + " " : next
    printlog gha
    If Machit = "13&T&&T&0&T&26&T&Kirk&T&26 Kirk&R&Kirk&T&&T&&T&&T&&T&&R&13 Kirk&T&&T&&T&&T&&T&&R" then
        Printlog "Content Ok with Zeichenkette, Zahlen, Transponieren einfuegen"
    else
        Warnlog "Content isn't right with Zeichenkette, Zahlen, Multiplizieren, nach rechts einfuegen " & Machit &  " instead of: 13&T&&T&0&T&26&T&Kirk&T&26 Kirk&R&Kirk&T&&T&&T&&T&&T&&R&13 Kirk&T&&T&&T&&T&&T&&R"
    end if
        goto ende
gibsmir:
    try
      Kontext "DocumentCalc"
      DocumentCalc.TypeKeys "<MOD1 HOME>"
      DocumentCalc.TypeKeys "<MOD1 SHIFT RIGHT>"
      'call cbereichmarkieren("A1:C1")
      sleep 5
      EditCopy
    catch
      Warnlog "tInhalteeinfuegen2 subroutine gibsmir"
      exceptlog
    endcatch
    call cgotocell("B3")
    EditPasteSpecialCalc
    Kontext "InhalteeinfuegenCalc"
    return
ende:

   call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditSelectAll
'/// This procedure checks, if the adjustments made in the menu "Edit|DeleteContents" ///
'/// will be maintened and if this function work right. ///
    dim i As Integer : dim k As Integer
    dim celladdress$ : celladdress$ = "A1"
    dim content$(1 to 6): dim delete_state$(1 to 8): dim delete_state_n$(1 to 8)

    if iSystemsprache <> 1 AND iSprache <> 1 then
       QAErrorLog "Sorry, this Testcase only runs on locale en_US"
       goto endsub
    end if
    
    call  hNewDocument
'/// Some cellcontents are inserted into the cells ///
    call atinsertcontent6(celladdress$)
    call atinsertcontent6chk(celladdress)
    cgotocell(celladdress$)
    for i = 1 to 6
      content$(i) = cZellinhalt(fWhereIsTheCellCursor)
      Kontext
      DocumentCalc.TypeKeys "<down>"
    next i
'/// This contents are deleted completely ///
    EditSelectAll
    EditDeleteContents
    Kontext "InhalteLoeschen"
    Alles.Check
    InhalteLoeschen.OK
    Kontext
    cgotocell (celladdress$)
'/// It is checked if something is there after deleting all ///
    for i = 1 to 6
      FormatCells
      Kontext
      active.setpage TabZahlen
      Kontext "TabZahlen"
      if FormatCode.GetText = "Standard" or FormatCode.GetText = "General" then
         TabZahlen.OK
      else
         warnlog "The cellformat from cell " & fWhereIsTheCellCursor & " was not deleted!"
         TabZahlen.OK
      end if
      Kontext
      DocumentCalc.TypeKeys "<down>"
    next i
    Kontext
' /// Undo deleting ///
    EditUndo ' Without  addition "Loeschen", because this slot is unknown
    EditDeleteContents
'/// Now the cellcontents are deleted with options like 'delete only numbers' and so on ... ///
    Kontext "InhalteLoeschen"
    Alles.uncheck
    delete_state$(1) = Alles.GetState
    Zeichenketten.uncheck
    delete_state$(2) = Zeichenketten.GetState
    Zahlen.uncheck
    delete_state$(3) = Zahlen.GetState
    DatumZeit.check
    delete_state$(4) = DatumZeit.GetState
    Formeln.uncheck
    delete_state$(5) = Formeln.GetState
    Notizen.uncheck
    delete_state$(6) = Notizen.GetState
    Formate.uncheck
    delete_state$(7) = Formate.GetState
    Objekte.uncheck
    delete_state$(8) = Objekte.GetState
    InhalteLoeschen.OK
'/// It is checked if the delete options are work ///
    ' for i = 1 to 8
    ' printlog "delete_state" & i & ": " & delete_state$(i)
    ' next i
    Kontext
    call atinsertcontent6chk(celladdress) 'Checking the cellformat after deleting only date and time
    printlog " - Checking cellcontents"
    cgotocell("A1")
    if cZellinhalt("A1") <> "" then
      warnlog "The cellcontent from cell A1 wasn't deleted!"
    end if
    cgotocell("A2")
    for i = 2 to 5
      if cZellinhalt(fWhereIsTheCellCursor) <> content$(i) then
         warnlog "The cellcontent from cell " & fWhereIsTheCellCursor & " was changed!"
      end if
      Kontext
      DocumentCalc.TypeKeys "<down>"
    next i
    if cZellinhalt("A6") <> "" then
      warnlog "The cellcontent from cell A6 wasn't deleted!"
    end if
    Kontext
    DocumentCalc.TypeKeys "This is a short sentence!<Return><Up>"
    DocumentCalc.TypeKeys "<F2>"
    EditSelectAll
    EditCopy
    if getClipboardText = "This is a short sentence!" then
      Printlog " OK, within a cell"
    else
      Warnlog " All selecting did not function within a cell "
    end if
    call hCloseDocument
    printlog " Open a new document and check the adjustments in the menu 'InhalteLoeschen'!"
    call hNewDocument
    EditDeleteContents
    Kontext "InhalteLoeschen"
    delete_state_n$(1) = Alles.GetState
    delete_state_n$(2) = Zeichenketten.GetState
    delete_state_n$(3) = Zahlen.GetState
    delete_state_n$(4) = DatumZeit.GetState
    delete_state_n$(5) = Formeln.GetState
    delete_state_n$(6) = Notizen.GetState
    delete_state_n$(7) = Formate.GetState
    delete_state_n$(8) = Objekte.GetState
    InhalteLoeschen.OK
    printlog " - Check if the state of 'InhalteLoeschen' was taken over!"
    k = 0
    for i = 1 to 8
    ' printlog "delete_state_n$" & i & ": " & delete_state_n$(i)
      if delete_state_n$(i) <> delete_state$(i) then
         warnlog "State of 'BearbeitenInhalteLoeschen' wasn't taken over!"
      else
         k = k + 1
      end if
    next i
    if k = 8 then
      printlog " - OK! All states were taken over!"
    end if
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
sub Suezurueck
dim wh
    Kontext "SuchenUndErsetzenCalc"
    for wh = 1 to 5
    try
      if Aehnlichkeitssuche.ischecked then Aehnlichkeitssuche.uncheck
      if NurganzeZellen.ischecked then NurganzeZellen.Uncheck
      if Rueckwaerts.ischecked then Rueckwaerts.Uncheck
      if RegulaererAusdruck.ischecked then RegulaererAusdruck.Uncheck
      if ExakteSuche.ischecked then ExakteSuche.Uncheck
      if NurInSelection.ischecked then NurInSelection.Uncheck
      if SuchenachVorlagen.ischecked then SuchenachVorlagen.Uncheck
    catch
    endcatch
    next wh
      if not formeln.isvisible then Zusaetze.Click
      if not Formeln.ischecked then Formeln.Check
      if not Zeilenweise.ischecked then Zeilenweise.Check
end sub

'-------------------------------------------------------------------------------
'

testcase tEditNavigator
'/// This testcase test the functionality of the navigator.
    Dim sGetCurrentCell as string
    Dim sTableLabel as string
    Dim sWhereIsTheCursor as string

    '/// Open Document in <i>...level1/input/c_102_navigare.sxc</i> with links but don't refresh them 
    call hDateioeffnenmitverknuepfung (gTesttoolPath + "calc\level1\input\c_102\navigare.sxc", FALSE)
 
    Kontext "NavigatorCalc"
        if NOT NavigatorCalc.Exists(10) then            
            EditNavigator
        end if
        if NavigatorCalc.exists(10) then
            printlog "Navigator is appeared."
        else            
            warnlog "The Navigator wasn't visible! Exiting testcase!"
            Call hCloseDocument            
            goto endsub
        end if
        '/// Press HOME-button in Navigator
        Spalte.TypeKeys "<HOME>"
        sleep(5)
        '/// Press SHIFT+END together
        Spalte.TypeKeys "<SHIFT END>"
        '/// Press 'M'-key
        Spalte.SetText "M"
        sleep(5)
        Zeile.TypeKeys "<HOME>"
        '/// Press again HOME-key
        sleep(5)
        '/// Press SHIFT+END together
        Spalte.TypeKeys "<SHIFT END>"
        '/// Type '13'
        Zeile.SetText "13"
        '/// Press RETURN
        Zeile.typekeys "<RETURN>"
        '/// Verify that cursor is in cell M13
        sGetCurrentCell = fWhereIsTheCellCursor
        if sGetCurrentCell = "M13" then
            printlog "Selected cell was achieved"
        else
            warnlog "Selected cell wasn't achieved; we are in:" & sGetCurrentCell             
        end if
        '/// Select the sheet by name 'Bruecke'
        fCalcSelectSheet ("Bruecke")
        '/// Go to cell C10
        cgotoCell ("C10")
        Kontext "NavigatorCalc"
        '/// If the Navigator isn't open, open it.
        if NavigatorCalc.Exists(2) = FALSE then    
            EditNavigator
        end if
        Kontext "Navigator"
        '/// Set the size of 234,294
        Navigator.Size(334,394)
        Kontext "NavigatorCalc"
        '/// Close the tree in the Navigator        
        call closeNavigator
        '/// Select first node
        Liste.Select(1)
        '/// Click on 'Formular'
        call Navigatorclick ("Formular")
        '/// Format>Sheet>Rename
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        '/// Verify that the table name is 'Formular'
        sTableLabel = ""
        sTableLabel = TabellenName.gettext
        if sTableLabel <> "Formular" then
            warnlog "Tables select doesn't work " & sTableLabel & " instead of 'Formular'"
        end if
        '/// Cancel the dialog
        TabelleUmbenennen.Cancel
        '/// Close the tree in the Navigator
        call closeNavigator
        '/// Select second node in the Navigator
        Liste.Select(2)
        '/// Click on 'thisRange'-entry
        Navigatorclick ("thisRange")
        sWhereIsTheCursor = ""
        sWhereIsTheCursor = fWhereIsTheCellCursor
        if sWhereIsTheCursor <> "thisRange" then
            warnlog "Selecting block names test failed. Block name is '" & sWhereIsTheCursor & " 'instead of 'thisRange'."
        end if
        '/// Close tree in Navigator
        call closeNavigator
        '/// Select third node
        Liste.Select(3)
        '/// Click on 'thatDatabaseRange'
        Navigatorclick ("thatDatabaseRange")
        sWhereIsTheCursor = ""
        sWhereIsTheCursor = fWhereIsTheCellCursor
        if sWhereIsTheCursor <> "B17:D23" then          
            warnlog "Selecting database names test FAILED. Selected '" & fWhereIsTheCellCursor & "' instead of 'B17:D23'"
        end if
        '/// Close tree in Navigator
        call closeNavigator
        '/// Select fourth node in Navigator
        Liste.Select(4)
        '/// Type '+'-key
        Liste.Typekeys "+"
        '/// Select 'Romulus'-entry
        Navigatorclick ("Romulus")
        sWhereIsTheCursor = ""
        sWhereIsTheCursor = fWhereIsTheCellCursor        
        if sWhereIsTheCursor <> "B3:E4" then
            warnlog "Linked areas select didn't work" & fWhereIsTheCellCursor & " instead of B3:E4"
        end if
        '/// Close tree in Navigator
        call closeNavigator
        '/// Select fifth entry
        Liste.Select(5)
        '/// Click on 'Graphics 1'-entry
        Navigatorclick ("Graphics 1")
        '/// Format>Sheet>Rename        
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        sTableLabel = ""
        sTableLabel = TabellenName.gettext
        '/// Verify the label that it's called 'Arrow'.        
        if sTableLabel <> "Arrow" then
            warnlog "Selecting charts didn't work. Selected " & sTableLabel & " instead of 'Arrow'"
        end if
        '/// Leave the dialog with cancel.
        TabelleUmbenennen.Cancel
        '/// Close tree in Navigator
        call closeNavigator
        '/// Select sixth node in Navigator
        Liste.Select(6)
        '/// Select 'Object 1'
        Navigatorclick ("Object 1")
        '/// Format>Sheet>Rename
        FormatSheetRename
        Kontext "TabelleUmbenennen"
        '/// Verify that the labe is 'Formular'
        sTableLabel = ""
        sTableLabel = TabellenName.gettext        
        if sTableLabel <> "Formular" then                
            warnlog "Selecting OLE object didn't work. It's " & sTableLabel & " instead of 'Formular'"
        end if
        '/// Leave the dialog with cancel.
        TabelleUmbenennen.Cancel
        '/// Close the tree in Navigator
        call closeNavigator
        '/// Select seventh entry
        Liste.Select(7)
        '/// Type '+'-key
        Liste.Typekeys "+"
        '/// Select 'It's gone'-entry
        call Navigatorclick ("It's gone")
        sWhereIsTheCursor = ""
        sWhereIsTheCursor = fWhereIsTheCellCursor
        '/// Verify that the cursor is in 'B14'
        if sWhereIsTheCursor <> "B14" then
            warnlog "Selecting notes didn't work. Is " & sWhereIsTheCursor & " instead of 'B14'"
        end if
        '/// Close the tree in Navigator
        call closeNavigator
        Liste.Select(6)
        printlog "Now, check the new feature 'Named OLE Objects'"
        Call MoveAndRenameOLE("Chart_Cylinder", "Name modified")
		Kontext "NavigatorCalc"
        if NavigatorCalc.exists(10) then
            '/// Closing Navigator
            EditNavigator
        end if            
        '/// Closing document.
    call hCloseDocument
endcase
'
'-------------------------------------------------------------------------------
'
sub closeNavigator

    dim Lager : dim wh
    Kontext "NavigatorCalc"
    if NavigatorCalc.notexists (2) then EditNavigator
    sleep(2)
    Kontext "NavigatorCalc"
    lager = Liste.getitemcount
    Liste.select 1
    For wh = 1 to Lager
    Liste.typekeys "-<DOWN>"
    next wh
    if Liste.getItemCount <> 8 then
      printlog "  Navigtorlist contents: " & Liste.getItemCount & " Entries instead of 8"
      Umschalten.click
      lager = Liste.getitemcount
      Liste.select 1
      for wh = 1 to Lager
         Liste.typekeys "-<DOWN>"
      next wh
      if Liste.getItemCount <> 8 then Warnlog "Switching didn't function"
    end if
end sub
'
'-------------------------------------------------------------------------------
'
sub MoveAndRenameOLE (OLE_Name as String, Modify as String)
   Navigatorclick(OLE_Name)
    if getSheetName() = "Chart" then
      printlog " Select the "& Modify &" chart works, it is the sheet 'Chart'"
    else
      warnlog "The navigator goto table: " & getSheetName() & " instead of 'Chart'"
    end if
   '/// At first the chart is cut from the sheet 'Chart' and insert it into the sheet 'Arrow'
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 X>"
    fCalcSelectSheet ("Arrow")
    cgotoCell("A16")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 V>"
    DocumentCalc.TypeKeys "<ESCAPE>"
    sleep 2
    '/// Check if the navigator go to the correct sheet 'Arrow'
    fCalcSelectSheet ("Bruecke")
    call closeNavigator
    Liste.select 6
    Navigatorclick(OLE_Name)
    if getSheetName() = "Arrow" then
      printlog " Select the "& Modify &" chart works, it is correct detected in the sheet 'Arrow'"
    else
      warnlog "The navigator goto table: " & getSheetName() & " instead of 'Arrow'"
    end if
    '/// Cut hte chart and insert it back inot the sheet 'Chart'
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<MOD1 X>"
    fCalcSelectSheet ("Chart")
    cgotoCell("A10")
    Kontext "DocumentCalc"
    DocumentCalc.TypeKeys "<Mod1 V>"
    DocumentCalc.TypeKeys "<ESCAPE>"
    sleep 2
    '/// Check again if the navigator go to the correct sheet 'Chart'
    EditNavigator
    fCalcSelectSheet ("Bruecke")
    call closeNavigator
    Liste.select 6
    Navigatorclick(OLE_Name)
    if getSheetName() = "Chart" then
      printlog " Select the "& Modify &" chart works, it is back again in the sheet 'Chart'"
    else
      warnlog "The navigator goto table: " & getSheetName() & " instead of 'Chart'"
    end if

end sub
'
'-------------------------------------------------------------------------------
'
testcase tEditHeaderAndFooter
    Dim sThisFile as string
    Dim i as integer
        
    Dim sHeaderLeftCenterArea as string
    Dim sFooterRightRightArea as string
    Dim sFooterLeftLeftArea as string

    Dim sNowHeaderRightLeftArea as string
    Dim sNowHeaderLeftCenterArea as string
    Dim sNowFooterRightRightArea as string
    Dim sNowFooterLeftLeftArea as string
    
    sThisFile = convertpath(gOfficePath & "user/work/tEditHeaderAndFooter.ods")
    
    '/// Create new spreadsheet document
    call  hNewDocument
        '/// Format / Page
        FormatPageCalc
        sleep(2)
        Kontext
        '/// Switch to Header tab page
        Active.SetPage TabKopfzeile
        Kontext
        'Check for '...Margin ... out of print range' message.
        if Active.Exists(2) then
            if Active.GetRT = 304 then
                printlog Active.GetText
                Active.Yes
                sleep(2)
            end if
        end if
        Kontext "TabKopfzeile"
        '/// Uncheck 'Same content left right'-checkbox
        InhaltLinksRechtsGleich.uncheck
        Kontext
        '/// Switch to tab page Footer
        Active.SetPage TabFusszeile
        sleep(2)
        Kontext "TabFussZeile"
        '/// Uncheck 'Same content left right'-checkbox
        InhaltLinksRechtsGleich.uncheck
        '/// Leave dialog with OK
        TabFusszeile.Ok
        sleep(2)
        '/// Edit / Header and footers
        EditHeadersAndFooters
        sleep(5)
        Kontext
        '/// Switching to Tab page Header (right)
        Active.SetPage TabKopfzeileCalc
        Kontext "TabKopfzeileCalc"
        if TabKopfzeileCalc.exists(1) then
            printlog "Tab page Header (right) is visible."
            '/// Type in left area 'Left ' 
            LinkerBereich.TypeKeys "Left "
            Kontext "TabKopfzeileCalc"
            '/// Click 'file'-button
            Datei.click
        else
            warnlog "Header (right) tab page not visible"
        end if
        Kontext
        '/// Switching to Tab page Header (left)
        Active.SetPage TabKopfzeileCalcLinks
        Kontext "TabKopfzeileCalcLinks"
        if TabKopfzeileCalcLinks.exists(1) then 
            printlog "Tab page Header (left) is visible"
            '/// Type in the center area 'Center '
            Mittlererbereich.typekeys "Center "
            '/// Click table button
            Tabelle.click
            '/// Select the whole value.
            Mittlererbereich.TypeKeys ("<HOME><SHIFT DOWN END>")        
            '/// Remember the value.
            Mittlererbereich.TypeKeys "<MOD1 C>"
            '/// which will be verified later that it has been saved.
            sHeaderLeftCenterArea = GetClipboardText
            Textattribute.click
            '/// Click on font attributes button         
            Kontext "TextattributeCalc"
            Kontext
            '/// Switch to font effects tab page
            Active.SetPage TabFontEffects
            Kontext "TabFontEffects"
            '/// Check 'outline'-checkbox
            Outline.check
            '/// Leave dialog with OK
            TabFontEffects.Ok
        else
            warnlog "Header (left) tab page is not visible."
        end if
        Kontext
        '/// Switch to tab page Footer (right)
        Active.SetPage TabFusszeileCalc
        Kontext "TabFusszeileCalc"
        if TabFusszeileCalc.exists(1) then 
            printlog "Tab page Footer (right) is visible"
            '/// Type in the right area 'Right '
            Rechterbereich.typekeys "Right "
            '/// and click on the 'date'-button
            Datum.Click
            '/// Select the whole value.
            Rechterbereich.TypeKeys ("<HOME><SHIFT DOWN END>")        
            '/// Remember the value.
            Rechterbereich.TypeKeys "<MOD1 C>"
            '/// which will be verified later that it has been saved.
            sFooterRightRightArea = GetClipboardText
        else
            warnlog "Footer (right) tab page is not visible."
        end if
        Kontext
        '/// Switch to the Footer (left)
        Active.SetPage TabFusszeileCalcLinks
        Kontext "TabFusszeileCalcLinks"
        if TabFusszeileCalcLinks.exists(1) then 
            printlog "Tab page Footer (left) is visible"
            '/// Click on 'Page number'-button
            Seitennummer.Click
            '/// Select the whole value.
            Linkerbereich.TypeKeys ("<HOME><SHIFT DOWN END>")        
            '/// Remember the value.
            Linkerbereich.TypeKeys "<MOD1 C>"
            '/// which will be verified later that it has been saved.
            sFooterLeftLeftArea = GetClipboardText        
            TabFusszeileCalcLinks.Ok
        else
            warnlog "Footer (left) tab page is not visible."
        end if
        '/// Save the file
        call hSpeichernUnterMitFilterKill sThisFile, gCalcFilter 

        for i = 1 to 2
            '/// <i>Loop twice</i>
            if i = 1 then 
                printlog " - Checking adjustments without closing the document"
                '/// In first loop just verify the settings in the dialog.
            end if
            if i = 2 then
                printlog " - Checking adjustments from the saved file!"
                '/// in second loop open the file.
                call hDateiOeffnen sThisFile
            end if
            '/// Edit / Headers and Footers
            EditHeadersAndFooters
            Kontext
            '/// Switch to tab page Header (right)
            Active.SetPage TabKopfzeileCalc
            Kontext "TabKopfzeileCalc"
            '/// Verify the value of the left area with that you have typed in.
            Linkerbereich.typekeys "<HOME><SHIFT DOWN END>"
            Linkerbereich.typekeys "<MOD1 C>"
            sNowHeaderRightLeftArea = GetClipboardText
            printlog sNowHeaderRightLeftArea 
            if i = 1 then            
                if "Left tEditHeaderAndFooter.ods" <> sNowHeaderRightLeftArea then
                    warnlog "Header (right) tab page left area value is incorrect."
                else
                    printlog "PASSED. Header (right) tab page left area value is correct."
                end if
            end if
            if i = 2 then
                if "Left tEditHeaderAndFooter" <> sNowHeaderRightLeftArea then
                    warnlog "Header (right) tab page left area value is incorrect."
                else
                    QAErrorLog "#i65655# File name-button in Header & Footer inserts file name without extension"                    
                end if            
            end if
            Kontext
            '/// Switch to tab page Header (left)         
            Active.SetPage TabKopfzeileCalcLinks
            Kontext "TabKopfzeileCalcLinks"
            '/// Verify the value of the center area with that you have typed in.
            Mittlererbereich.typekeys "<HOME><SHIFT DOWN END>"
            Mittlererbereich.typekeys "<MOD1 C>"
            sNowHeaderLeftCenterArea = GetClipboardText 
            if sHeaderLeftCenterArea <> sNowHeaderLeftCenterArea then
                warnlog "Header (left) tab page center area value is incorrect."
            else
                printlog "PASSED. Header (left) tab page center area value is correct."
            end if
            '/// Click on 'text attributes'-button             
            Textattribute.click
            Kontext
            '/// Switch to Font effects page
            Active.SetPage TabFontEffects
            Kontext "TabFontEffects"
            if Outline.ischecked then
                printlog "PASSED. Character formatting was taken over"
            else
                warnlog "Character formatting has not been saved."
            end if
            '/// Leave dialog with CANCEL
            TabFontEffects.Cancel             
            Kontext
            '/// Switching to tab page Footer (right)
            Active.SetPage TabFusszeileCalc
            Kontext "TabFusszeileCalc"
            '/// Verify the value of the center area with that you have typed in.
            Rechterbereich.TypeKeys "<HOME><SHIFT DOWN END>"
            Rechterbereich.TypeKeys "<MOD1 C>"
            sNowFooterRightRightArea = GetClipboardText 
            if sFooterRightRightArea <> sNowFooterRightRightArea then
                warnlog "Footer (right) tab page right area value is incorrect."
            else
                printlog "PASSED. Footer (right) tab page right area value is correct."
            end if
            Kontext
            '/// Switch to tab page Footer (left)
            Active.SetPage TabFusszeileCalcLinks
            Kontext "TabFusszeileCalcLinks"
            '/// Verify the value of the center area with that you have typed in.
            Linkerbereich.TypeKeys "<HOME><SHIFT DOWN END>"
            Linkerbereich.TypeKeys "<MOD1 C>"
            sNowFooterLeftLeftArea = GetClipboardText 
            if sFooterLeftLeftArea <> sNowFooterLeftLeftArea then
                warnlog "Footer (left) tab page left area value is incorrect."
            else
                printlog "PASSED. Footer (left) tab page left area value is correct."
            end if                    
            TabFusszeileCalcLinks.Cancel                   
            '///  Close document   
            call hCloseDocument
        next i
endcase
'-------------------------------------------------------------------------------
'
testcase tEditFillDown
'/// This test check the fill down functionality.///
'/// In a document is inserted a number, then a cellrange is marked ///
'/// and the autfill method is applied on this range. ///

    call  hNewDocument

    DocumentCalc.Typekeys "13<Return><Up>"
    call ZellenMarkieren ( 4, 1 )
    EditFillDown
    call DocumentCalc.Typekeys "<Up>",3
    call cCellCompare (3,0,0)

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillRight
'/// This test check the fill right functionality.///
'/// In a document is inserted a number, then a cellrange is marked ///
'/// and the autfill method is applied on this range. ///

    call  hNewDocument

    DocumentCalc.Typekeys "13<Return><Up>"
    call ZellenMarkieren ( 1, 4 )
    EditFillRight
    call DocumentCalc.Typekeys "<left>",3
    call cCellCompare (0,3,0)

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillTop
'/// This test check the fill top functionality.///
'/// In a document is inserted a number, then a cellrange is marked ///
'/// and the autfill method is applied on this range. ///

    call  hNewDocument

    DocumentCalc.Typekeys "<Down><Down><Down>13<Return><Up><Up><Up><Up>"
    call ZellenMarkieren ( 4, 1 )
    EditFillUp
    call DocumentCalc.Typekeys "<Up>",3
    call cCellCompare (3,0,0)
    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillLeft
'/// This test check the fill left functionality.///
'/// In a document is inserted a number, then a cellrange is marked ///
'/// and the autfill method is applied on this range. ///

    call hNewDocument

    DocumentCalc.Typekeys "<Right><Right><Right>13<Return><Up><Left><Left><Left><Left>"
    call ZellenMarkieren ( 1, 4 )
    EditFillLeft
    DocumentCalc.Typekeys "<Left>",3
    call cCellCompare (0,3,0)

    call hCloseDocument

endcase
'
'-----------------------------------------------------------
'
testcase tEditFillTable
'/// In this testcase the autofill functionalitty is tested with all sheets.///


    if iSprache = 7 then
        qaErrorLog "Not supported for Russian Office"
        goto endsub
    endif
    dim content
'/// Load an empty new calc document
    call  hNewDocument

    Kontext
'/// Select cell 'A1' and call the menuitem 'InsertNamesDefine', then set a text for the range
    DocumentCalc.Typekeys "<SHIFT DOWN UP>"
    InsertNamesDefine
    Kontext "Namenfestlegen"
    BereichsName.settext "BlaBla"
    content = ZugeordnetZu.gettext
    Namenfestlegen.cancel
'/// Copy this sheet and insert it before sheet_2
    EditCopyMoveSheet
    Kontext "TabelleVerschiebenKopieren"
    EinfuegenVor.select 2
    Kopieren.Check
    TabelleVerschiebenKopieren.OK
    sleep 5
    Kontext
'/// Insert in cell 'A1' a '1' and in cell 'A2' a link to the inserted first sheet to cell 'A1'
    DocumentCalc.Typekeys "1<Return>=" + content + "<Return><Up><Up><Shift Down Up>"
'/// Select all sheets and call the menuitem 'EditFillSheet'
    AlleTabellenAuswaehlen
    EditFillSheet
    Kontext "TabellenFuellen"
    AuswahlAllesEinfuegen.check
    TabellenFuellen.Ok
'/// Check if the cellcontents from 'A1:A2' are the same in all sheets
    FilePageView
    Kontext "Previewbar"
    if Previewbar.notexists (2) then ViewToolbarsObjectbar
    Seitenansicht.click
    WindowNewWindow
    call cCellCompare (1,0,0)

    call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditFillSerie
'/// This testcase check the fill series function.///
'/// For this purpose a number is inserted in the cell A1.///
'/// Then the next 3 cells below are marked and the function ///
'/// fill series is called. At last the cellcontents are checked. ///

    call  hNewDocument

    DocumentCalc.typekeys("13<RETURN><UP>")
    call ZellenMarkieren ( 4, 1 )
    EditFillSeries
    Kontext "ReiheFuellen"
    if ReiheFuellen.exists(2) then
      if Startwert.gettext <> "13" then
         Warnlog "Current value (13) not imported"
      else
         printlog "OK, the current value correct"
      end if
      ReiheFuellen.Ok
      sleep (2)
      Kontext
      call ZellenMarkieren ( 1,1 )
      DocumentCalc.Typekeys "<Right><Left><Up><Up><Up>"
      call cCellCompare (3,0,3)
    else
      warnlog "Dialog Fill Series not shown"
    end if

    call hCloseDocument

endcase
'
'-------------------------------------------------------------------------------
'
testcase tEditDeleteContents
'/// A short test to check the function DeleteContents. ///

    call  hNewDocument
'/// Insert '1' in cell 'A1'
    DocumentCalc.TypeKeys "1<Return><Up>"
    EditDeleteContents
'/// Call the menuitem 'EditDeleteContents' and check all, then confirm
    Kontext "InhalteLoeschen"
    If InhalteLoeschen.exists(10) then
      Printlog "Ok"
    else
      Warnlog "InhalteLoeschen"
    end if
    Alles.Check
    InhalteLoeschen.ok
'/// Check if the content of cell 'A1' is '0'
    call cCellCompare (1,0,0)

    call hCloseDocument

endcase

