'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Forms.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: msc $ $Date: 2006/03/30 07:40:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Form Test
'*
'************************************************************************
'*
' #1 tCreateForm
' #1 tNavigate
' #1 tSearch
' #1 tSort
' #1 tViewAsGrid
' #1 tNewSaveDelete
' #1 tCreateSubForms
' #1 tCreateSubFormsNewMethod
' #1 tCheckSubForm
' #1 tDatabaseFormsMain
' #1 tNewFolder
'*
'\***********************************************************************
global gDSName as String

sub b_lvl1_Forms(sdsname)
    
    gDSName = sdsname    
    call tCreateForm
    call tNavigate
    call tSearch
    call tSort
    ' due to internal issue 121276 this testcase is disabled for 2.0 
    ' call tViewAsGrid
    call tNewSaveDelete
    call tCreateSubForms
    call tCheckSubForm
    call tCreateSubFormsNewMethod
    call tCheckSubForm
    
    'test forms inside a database
    app.FileCopy gTesttoolPath + ConvertPath("base\level1\input\TT_hsqldb.odb"),gOfficePath + ConvertPath("user\work\TT_hsqldb.odb")    
    call tDatabaseFormsMain
    call tNewFolder    

end sub
'--------------------------------------------------------------------------------------
testcase tDatabaseFormsMain
    
    call fOpenDatabase(gOfficePath + "user/work/TT_hsqldb.odb")
    
    call fOpenNewFormDesign
    
    call hToolbarSelect("FormControls",true)	
    
    '/// insert a textfield
    printlog "insert a textfield"
    Kontext "FormControls"   	        
        Edit.Click
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(1)

    Kontext "FormControls"
        ControlProperties.Click
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
        sleep(1)
        
    Kontext "TabDataControl"
        DataField.setText "id"        
        sleep(1)
        
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
        sleep(1)
                
    '/// save the form under the name TT_form1
    printlog "save the form under the name TT_form1"
    call fSaveForm( "TT_Form1", true )

    '/// close the database
    printlog "close the database"            
    call fCloseDatabase
    
    '/// open the database again
    printlog "open the database again"
    call fOpenDatabase(gOfficePath + "user/work/TT_hsqldb.odb")

    '/// open the form
    printlog "open the form"
    call fOpenForm("TT_Form1")
    
    '/// close the form
    printlog "close the form"
    call fCloseForm()

    '/// close the database
    printlog "close the database"
    call fCloseDatabase()
    
endcase
'--------------------------------------------------------------------------------------
testcase tCreateForm
          
	'/// open a new text document
    printlog "open a new text document"
	call hNewDocument
	sleep(1)
	'/// create a new form via the form navigator
    printlog "create a new form via the form navigator"
    call hToolbarSelect("FORMDESIGNTOOLS",true)	

    Kontext "FormDesignTools"
	    ShowFmExplorer.Click	
        sleep(2)
	Kontext "FormularNavigator" 
        Liste.TypeKeys "<SPACE>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (1)
        sleep(2)
        hMenuSelectNr (1)
        sleep(3)
        Liste.TypeKeys "<RETURN>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (6)
        sleep(4)      
        
  	Kontext "FormPropertiesDialog"
   	    FormPropertiesTabControl.SetPage TabDataForm
        sleep(1)
  	Kontext "TabDataForm"   	
        '/// set the datasource gDatasourceName
        printlog "set the datasource " + gDSName          
        DataSource.setText(gDSName)
        TabDataForm.TypeKeys("<RETURN>")
        sleep(1)
        '/// set the table TT_Forms
        printlog "set the table TT_Forms"              
        Content.setText("TT_Forms")
        TabDataForm.TypeKeys("<RETURN>")
        sleep(1)
  	Kontext "FormPropertiesDialog"
        FormPropertiesDialog.Close
        sleep(3)
  	Kontext "FormularNavigator"
        FormularNavigator.Close
        sleep(4)

    call hToolbarSelect("FormControls",true)	

  	Kontext "FormControls"
   	'/// insert a textfield
    printlog "insert a textfield"        
    Edit.Click
   	call hDrawingWithSelection ( 20, 20, 30, 30 )
   	sleep(1)
    
    Kontext "FormControls"
        ControlProperties.Click
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
        sleep(1)
    Kontext "TabDataControl"
        DataField.setText "id"
        TabDataControl.TypeKeys("<RETURN>")        
        sleep(1)            
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
        sleep(1)
    
    Kontext "FormControls"
	 SwitchControlDesignMode.Click	
   	 sleep(1)
     
    hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"),gWriterFilter)
    
    call hCloseDocument
    
endcase
'-------------------------------------------------------------------------
testcase tNavigate
    
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"))
    
    FM_Next_Record
    sleep(1)
    FM_Last_Record
    sleep(1)
    FM_Previous_Record
    sleep(1)
    FM_First_Record
    sleep(1)
    
    hCloseDocument 
    
endcase
'-------------------------------------------------------------------------
testcase tSearch
    
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"))
    
    FM_Search
    sleep(1)
    Kontext "RecordSearch"
        SearchText.setText "3"
        Search.Click
        sleep(1)
        CloseBtn.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 3 then
            warnlog "wrong record is displayed"
        endif
        sleep(1)
    hCloseDocument 
    
endcase
'-------------------------------------------------------------------------
testcase tSort
    
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"))
    
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
    
    FM_Sort_Des
    sleep(1)
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 3 then
            warnlog "wrong record is displayed. It is " + getClipboard + " but it have to 3"
        endif
    sleep(1)
    
    FM_Sort_Asc
    sleep(1)
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 1 then
            warnlog "wrong record is displayed. It is " + getClipboard + " but it have to 1" 
        endif
    sleep(1)
    
    FM_Sort_Des
    sleep(1)    
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 3 then
            warnlog "wrong record is displayed. It is " + getClipboard + " but it have to 3" 
        endif
    sleep(1)
    
    FM_Remove_Filter
    sleep(1)
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 1 then
            warnlog "wrong record is displayed. It is " + getClipboard + " but it have to 1" 
        endif
    sleep(1)
      
    FM_Sort_Order
    sleep(1)
    Kontext "SortOrder"
        FieldName1.select 1
        Order1.select 2
        SortOrder.OK
        
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)        
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if getClipboard <> 3 then
            warnlog "wrong record is displayed. It is " + getClipboard + " but it have to 3" 
        endif
    sleep(1)
    hCloseDocument 
    
endcase
'-------------------------------------------------------------------------
testcase tViewAsGrid
    
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"))
    
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        
    FM_View_As_Grid
    
    sleep(1)
    
    Kontext "TableView"    
        if CurrentRecord.getText <> "1" then
            warnlog "the first record is wrong"
        endif
        sleep(1)
        NextRecord.Click
        if CurrentRecord.getText <> "2" then
            warnlog "the next record button in the table grid doesn't work"
        endif
        sleep(1)        
        
    FM_View_As_Grid
    
    sleep(1)
    hCloseDocument 
    
endcase
'-------------------------------------------------------------------------
testcase tNewSaveDelete
    
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Forms.odt"))
    
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        
    FM_New_Record
    
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "7" , true
    
    FM_Save_Record
    
    FM_First_Record
    FM_Last_Record    
    
    FM_Delete_Record
      
    Kontext "MessageBox"
        if MessageBox.exists(3) then
            MessageBox.Yes
        else
            warnlog "No confirm dialog when press delete record"
        endif
        
    sleep(1)
    hCloseDocument 
    
endcase
'-------------------------------------------------------------------------
testcase tCreateSubForms
    
    '/// open a new text document
    printlog "open a new text document"
	call hNewDocument
	sleep(1)
	'/// create a new form via the form navigator
    printlog "create a new form via the form navigator"
    
    call hToolbarSelect("FORMDESIGNTOOLS",true)	

    Kontext "FormDesignTools"
	    ShowFmExplorer.Click	
        sleep(2)

	Kontext "FormularNavigator" 
   	 Liste.TypeKeys "<SPACE>"
   	 sleep(3)
   	 Liste.OpenContextmenu
   	 sleep(2)
   	 hMenuSelectNr (1)
   	 sleep(2)
   	 hMenuSelectNr (1)
   	 sleep(3)
   	 Liste.TypeKeys "<RETURN>"
  	 sleep(3)
   	 Liste.OpenContextmenu
  	 sleep(2)
   	 hMenuSelectNr (6)
   	 sleep(4)      
        
  	Kontext "FormPropertiesDialog"
   	 FormPropertiesTabControl.SetPage TabDataForm
  	Kontext "TabDataForm"   	
   	 '/// set the datasource gDatasourceName
     printlog "set the datasource gDatasourceName"          
     DataSource.setText(gDSName)	
     TabDataForm.TypeKeys("<RETURN>")
     '/// set the table TT_Forms
     printlog "set the table TT_Forms"              
	 Content.setText("TT_Forms")
     TabDataForm.TypeKeys("<RETURN>")        
  	Kontext "FormPropertiesDialog"
   	 FormPropertiesDialog.Close
   	sleep(3)
  	Kontext "FormularNavigator"
   	 FormularNavigator.Close
   	sleep(4)

    call hToolbarSelect("FormControls",true)	

  	Kontext "FormControls"
   	'/// insert a textfield
    printlog "insert a textfield"        
    Edit.Click
   	call hDrawingWithSelection ( 20, 20, 30, 30 )
   	sleep(1)
    
    Kontext "FormControls"
        ControlProperties.Click
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
    Kontext "TabDataControl"
        DataField.setText "id"
        TabDataControl.TypeKeys("<RETURN>",true)
        sleep(1)            
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
    
    '/// now create the sub form
    
    call hToolbarSelect("FORMDESIGNTOOLS",true)	

    Kontext "FormDesignTools"
	    ShowFmExplorer.Click	
        sleep(2)

	Kontext "FormularNavigator" 
        Liste.TypeKeys "<HOME>" ' move to the first entry in the formnavigator tree
        sleep(1)
        Liste.TypeKeys "<LEFT>" ' collaps the tree
        sleep(1)
        Liste.TypeKeys "<RIGHT>" ' expand the tree
        sleep(1)
        Liste.TypeKeys "<DOWN>" ' go one down
        sleep(1)     
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (1)
        sleep(2)
        hMenuSelectNr (1)
        sleep(3)
        Liste.TypeKeys "<RETURN>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (6)
        sleep(4)      

    Kontext "FormPropertiesDialog"
       FormPropertiesTabControl.SetPage TabDataForm
  	 Kontext "TabDataForm"   	
       '/// set the datasource gDatasourceName
       printlog "set the datasource gDatasourceName"          
       DataSource.setText(gDSName)
       TabDataForm.TypeKeys("<RETURN>",true)	
       '/// set the contenttype SQL
       printlog "set the contenttype SQL"
       ContentType.select 3       
       sleep(1)       
       '/// set the sql string : select * from TT_Forms where id=:var1"
       printlog "set the sql string : select * from TT_Forms where id=:var1"
       TabDataForm.TypeKeys "<RETURN>" , true
       TabDataForm.TypeKeys "select * from TT_Forms where id=:var1" , true
       '/// set link master field
       printlog "set link master field"
       TabDataForm.TypeKeys "<TAB>" , 11 , true
       sleep(1)
       TabDataForm.TypeKeys "id" , true
       sleep(1)
       TabDataForm.TypeKeys "<RETURN>" , true
       sleep(1)       
       '/// set link slave field
       printlog "set link slave field"
       TabDataForm.TypeKeys "<RETURN>" , true
       sleep(1)
       TabDataForm.TypeKeys "var1" , true
       sleep(1)  
       TabDataForm.TypeKeys("<RETURN>",true)
       sleep(1)
       
    Kontext "FormPropertiesDialog"
   	 FormPropertiesDialog.Close
   	 sleep(3)
    Kontext "FormularNavigator"
   	 FormularNavigator.Close
   	 sleep(4)

    call hToolbarSelect("FormControls",true)	

  	Kontext "FormControls"

       '/// insert a textfield
       printlog "insert a textfield"
       'Edit.Click
   	 call hDrawingWithSelection ( 70, 70, 80, 80 )
   	 sleep(1)
    
    Kontext "FormControls"
        ControlProperties.Click
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
    Kontext "TabDataControl"
        DataField.setText "id"
        TabDataControl.TypeKeys("<RETURN>")
        sleep(1)            
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
    	     
    Kontext "FormControls"
	    SwitchControlDesignMode.Click	
   	 sleep(1)
     
    hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_SubForm.odt"),gWriterFilter)
        
    call hCloseDocument     
    
endcase
'-------------------------------------------------------------------------
testcase tCheckSubForm
   
   '/// open the file TTSubForm.sxw
   printlog "open the file TTSubForm.sxw"
   hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_SubForm.odt"))
   
   '/// set cursor into the first control
   printlog "set cursor into the first control"   
   Kontext "DocumentWriter"
      DocumentWriter.TypeKeys "<MOD1 F5>" , true
      sleep(1)
           
   FM_Next_Record
   sleep(1)
    
   Kontext "DocumentWriter"
      DocumentWriter.TypeKeys "<TAB>" , true
      sleep(1)
      DocumentWriter.TypeKeys "<SHIFT END>" , true
      sleep(1)
      DocumentWriter.TypeKeys "<MOD1 C>" , true
      sleep(1)        
      if getClipboard <> 2 then
         warnlog "wrong record is displayed in subform. It is " + getClipboard + " but it have to 2" 
      endif
   sleep(1)
   call hCloseDocument
   
endcase
'-------------------------------------------------------------------------
testcase tCreateSubFormsNewMethod
    
    '/// open a new text document
    printlog "open a new text document"
	call hNewDocument
	sleep(1)
	'/// create a new form via the form navigator
    printlog "create a new form via the form navigator"

    call hToolbarSelect("FORMDESIGNTOOLS",true)	

    Kontext "FormDesignTools"
	    ShowFmExplorer.Click	
        sleep(2)    

	Kontext "FormularNavigator" 
        Liste.TypeKeys "<SPACE>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (1)
        sleep(2)
        hMenuSelectNr (1)
        sleep(3)
        Liste.TypeKeys "<RETURN>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (6)
        sleep(4)      
    
  	Kontext "FormPropertiesDialog"
        FormPropertiesTabControl.SetPage TabDataForm
  	Kontext "TabDataForm"   	
        '/// set the datasource gDatasourceName
        printlog "set the datasource gDatasourceName"          
        DataSource.setText(gDSName)	
        TabDataForm.TypeKeys "<RETURN>" , true
        '/// set the table TT_Forms
        printlog "set the table TT_Forms"              
        Content.setText("TT_Forms")     
        TabDataForm.TypeKeys "<RETURN>" , true
        sleep 1
  	Kontext "FormPropertiesDialog"
        FormPropertiesDialog.Close
        sleep(3)
  	Kontext "FormularNavigator"
   	    FormularNavigator.Close
        sleep(4)

    call hToolbarSelect("FormControls",true)	

  	Kontext "FormControls"  	
        '/// insert a textfield
        printlog "insert a textfield"        
        Edit.Click
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(1)
    
    Kontext "FormControls"
        ControlProperties.Click        
        sleep 1
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
   	    sleep 1
    Kontext "TabDataControl"
        DataField.setText "id"
        TabDataControl.TypeKeys "<RETURN>" , true
        sleep(1)            
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
        sleep 1
    
    Kontext "DocumentWriter"
    	DocumentWriter.TypeKeys("subform",true)
    
    '/// now create the sub form
    call hToolbarSelect("FORMDESIGNTOOLS",true)	

    Kontext "FormDesignTools"
	    ShowFmExplorer.Click	
        sleep(2)
       
	Kontext "FormularNavigator" 
        Liste.TypeKeys "<HOME>" ' move to the first entry in the formnavigator tree
        sleep(1)
        Liste.TypeKeys "<LEFT>" ' collaps the tree
        sleep(1)
        Liste.TypeKeys "<RIGHT>" ' expand the tree
        sleep(1)
        Liste.TypeKeys "<DOWN>" ' go one down
        sleep(1)     
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (1)
        sleep(2)
        hMenuSelectNr (1)
        sleep(3)
        Liste.TypeKeys "<RETURN>"
        sleep(3)
        Liste.OpenContextmenu
        sleep(2)
        hMenuSelectNr (6)
        sleep(4)      

    Kontext "FormPropertiesDialog"
        FormPropertiesTabControl.SetPage TabDataForm
  	Kontext "TabDataForm"   	
        '/// set the datasource gDatasourceName
        printlog "set the datasource gDatasourceName"          
        DataSource.setText(gDSName)	
        TabDataForm.TypeKeys("<RETURN>", true)
        sleep 1
        '/// set the contenttype SQL
        printlog "set the contenttype to table"
        ContentType.select 1
        TabDataForm.TypeKeys("<RETURN>", true)
        sleep(1)       
        '/// set the table TT_Forms
        printlog "set the table TT_Forms"
        Content.select 1
        sleep(1)
        TabDataForm.TypeKeys("<RETURN>", true)
        sleep 1
        '/// open the Form Link dialog set link master field
        printlog "open the Form Link dialog set link master field"       
        FormLinkDLGButton.click
        sleep(1)
    Kontext "FormLinkDialog"       
        '/// select the field id for the master and the link field
        printlog "select the field id for the master and the link field"
        LinkDetail1.select 1
        LinkMaster1.select 1
        '/// close the dialog with OK
        printlog "close the dialog with OK"
        FormLinkDialog.OK         
       
    Kontext "FormPropertiesDialog"
        FormPropertiesDialog.Close
        sleep(3)
    
    Kontext "FormularNavigator"
        FormularNavigator.Close
        sleep(4)

    call hToolbarSelect("FormControls",true)	

  	Kontext "FormControls"
    
       '/// insert a textfield
       printlog "insert a textfield"
       'Edit.Click
       call hDrawingWithSelection ( 70, 70, 80, 80 )
       sleep(1)
    
    Kontext "FormControls"
        ControlProperties.Click
    
    Kontext "ControlPropertiesDialog"
   	    ControlPropertiesTabControl.SetPage TabDataControl
    Kontext "TabDataControl"
        DataField.setText "id"
        TabDataControl.TypeKeys("<RETURN>" , true)
        sleep(1)            
    Kontext "ControlPropertiesDialog"        
        ControlPropertiesDialog.Close
    sleep(1)
    
    Kontext "FormControls"
	    SwitchControlDesignMode.Click	
   	 sleep(1)
    
    hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_SubForm.odt"),gWriterFilter)
        
    call hCloseDocument     
    
endcase
'--------------------------------------------------------------------------------------
testcase tNewFolder
    '/// test the folder feature inside the form container
    
    '/// open the database <OfficePath>/user/work/TT_hsqldb.odb
    printlog "open the database " + gOfficePath + "user/work/TT_hsqldb.odb"
    call fOpenDatabase(gOfficePath + "user/work/TT_hsqldb.odb")
    
    '/// display the form container
    printlog "display the form container"
    Kontext "ContainerView"    
        ViewForms
        if ( Not FormTree.exists(1) ) then
            warnlog "The form tree doesn't exists"            
            goto endsub
        end if

    '/// insert a new folder via INSERT/FOLDER menu
    printlog "insert a new folder via INSERT/FOLDER menu"
    Kontext "Insight"
        Insight.UseMenu
        hMenuSelectNr(4)
        hMenuSelectNr(8)

    '/// insert a new folder name
    printlog "insert a new folder name"
    Kontext "FormFolderNameDialog"
        Foldername.setText("Folder1")
        FormFolderNameDialog.OK

    '/// close the database and save changes
    printlog "close the database and save changes"
    call fCloseDatabase(true)

    '/// open the database again
    printlog "open the database again"
    call fOpenDatabase(gOfficePath + "user/work/TT_hsqldb.odb")    

    '/// check if he folder still exists
    printlog "check if he folder still exists"
    if (fFindForm("Folder1")) then
        printlog "Folder available after save and reload"
    else
        warnlog "Folder _not_ available after save and reload"
    endif

    '/// close the database again
    printlog "close the database again"
    call fCloseDatabase()
    
endcase
'-------------------------------------------------------------------------


