'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Text_Control.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: msc $ $Date: 2005/10/13 12:27:09 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Text Control
'*
'************************************************************************
'* 
' #1 tTextControl
' #1 tRichTextControl
' #1 tRichTextControlDraw
'*
'\***********************************************************************

sub b_lvl1_Text_Control

    call tTextControl
    call tRichTextControl
    call tRichTextControlDraw
    
end sub
'--------------------------------------------------------------------------------------
testcase tTextControl 
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
  	Kontext "FormControls"   	
   	Edit.Click
   	sleep(1)      
	'/// insert a text box
    printlog "insert a text box"                    
    call hDrawingWithSelection ( 50, 50, 70, 70 )    
    sleep(1)    
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// set properties: Background color, Horizontal scrollbar, Vertical scrollbar, Password
    printlog "set properties"  
	fsetControlProperty("TextBox","Background","92")
    fsetControlProperty("TextBox","TextType","3")    
    '/// save the document
    printlog "save the document"
	hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_TextBox.odt"),gWriterFilter)
	hCloseDocument
    sleep(1)
    '/// reload the document
    printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_TextBox.odt"))    

    call hToolbarSelect("FormControls",true)    

  	Kontext "FormControls"  
     SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
     DocumentWriter.TypeKeys "<SHIFT F4>"
    sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
    '/// check if the values are saved
    printlog "check if the values are saved"
	sleep(2)
    if fgetControlProperty("TextBox","Background") <> "92" then
        warnlog "the value: background is not saved"
    endif      
    
    if fgetControlProperty("TextBox","TextType") <> "3" then
        warnlog "the value: TextType is not saved"
    endif       
    sleep(1)    	
    hCloseDocument 
endcase
'--------------------------------------------------------------------------------------
testcase tRichTextControl 
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
  	Kontext "FormControls"   	
   	Edit.Click
   	sleep(1)      
	'/// insert a text box
    printlog "insert a text box"                    
    call hDrawingWithSelection ( 50, 50, 70, 70 )    
    sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// set properties: Background color, Horizontal scrollbar, Vertical scrollbar, Password
    printlog "set properties"  
	fsetControlProperty("TextBox","TextType","3")
    '/// turn off the design view
    printlog "turn off the design view"
    
    call hToolbarSelect("FormControls",true)

  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    '/// insert some text in the control
    printlog "insert some text in the control"
    Kontext "DocumentWriter"
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)
        DocumentWriter.TypeKeys "this is a blind text" , true        
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT MOD1 LEFT>" ,2, true        
        sleep(1)
        FormatStyleStrikeThrough
        sleep(1)
    '/// save the document
    printlog "save the document"
	hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_RichTextBox.odt"),gWriterFilter)
	hCloseDocument
    sleep(1)
    '/// reload the document
    printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_RichTextBox.odt"))
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<MOD1 F5>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)
        'printlog "getClipboard = " + getClipboard
        if ( getClipboard <> "this is a blind text" ) then
            warnlog "The text in the control is not saved"
        end if
        DocumentWriter.TypeKeys "<END>" , true        
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT MOD1 LEFT>" ,2, true        
        sleep(1)
        FormatCharacter
        Kontext
            active.SetPage TabFontEffects
        Kontext "TabFontEffects"
        if StrikeThrough.getSelIndex() <> 2 then            
            warnlog "StrikeThrought is not set"
        else
            printlog "StrikeThrought is set"
        end if        
        TabFontEffects.Cancel
        
        sleep(1)
                
    hCloseDocument 
endcase
'--------------------------------------------------------------------------------------
testcase tRichTextControlDraw 
    
    '/// Open a new document,
    printlog "Open a new document,"
	gApplication = "Draw"
    call hNewDocument
    Kontext "DocumentDraw"       
	DocumentDraw.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
    Kontext "DocumentDraw"
    DocumentDraw.MouseDown ( 20, 20 )
    sleep(1)
    DocumentDraw.MouseUp ( 20, 20 )
    sleep(1)
    Kontext "FormControls" 
    sleep(1)  	
   	Edit.Click
   	sleep(1) 
    call hDrawingWithSelection ( 50, 50, 70, 70 )
    sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    '/// set properties: Background color, Horizontal scrollbar, Vertical scrollbar, Password
    printlog "set properties"  
	fsetControlProperty("TextBox","TextType","3")
    '/// turn off the design view
    printlog "turn off the design view"

    call hToolbarSelect("FormControls",true)

  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    '/// insert some text in the control
    printlog "insert some text in the control"
    Kontext "DocumentDraw"
        sleep(1)
        DocumentDraw.TypeKeys "<MOD1 F5>" , true
        sleep(1)
        DocumentDraw.TypeKeys "this is a blind text" , true        
        sleep(1)
        DocumentDraw.TypeKeys "<SHIFT MOD1 LEFT>" ,2, true        
        sleep(1)
        FormatStyleStrikeThrough
        sleep(1)
    '/// save the document
    printlog "save the document"
	hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_RichTextBox.odg"),gDrawFilter)
	hCloseDocument
    sleep(1)
    '/// reload the document
    printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_RichTextBox.odg"))
    Kontext "DocumentDraw"
        DocumentDraw.TypeKeys "<MOD1 F5>" , true
        sleep(1)
        DocumentDraw.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentDraw.TypeKeys "<MOD1 C>" , true
        sleep(1)
        printlog "getClipboard = " + getClipboard
        if ( getClipboard <> "this is a blind text" ) then
            warnlog "The text in the control is not saved"
        end if
        DocumentDraw.TypeKeys "<END>" , true        
        sleep(1)
        DocumentDraw.TypeKeys "<SHIFT MOD1 LEFT>" ,2, true        
        sleep(1)
        FormatCharacter
        Kontext
            active.SetPage TabFontEffects
        Kontext "TabFontEffects"
        if StrikeThrough.getSelIndex() <> 2 then            
            warnlog "StrikeThrought is not set (issue 32921)"
        else
            printlog "StrikeThrought is set"
        end if        
        TabFontEffects.Cancel
        
        sleep(1)
                
    hCloseDocument 
endcase
'--------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------
'--------------------------------------------------------------------------------------

