/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Blob;
import com.mysql.jdbc.BlobFromLocator;
import com.mysql.jdbc.Clob;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.NotUpdatable;
import com.mysql.jdbc.ResultSetMetaData;
import com.mysql.jdbc.RowData;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class ResultSet
implements java.sql.ResultSet {
    protected static int resultCounter = 1;
    protected Connection connection;
    protected Map columnNameToIndex = null;
    protected Map fullColumnNameToIndex = null;
    protected ProfileEventSink eventSink = null;
    protected ResultSet nextResultSet = null;
    protected RowData rowData;
    protected SQLWarning warningChain = null;
    protected Statement owningStatement;
    protected String catalog = null;
    protected String serverInfo = null;
    protected Throwable pointOfOrigin;
    protected boolean[] columnUsed = null;
    protected Field[] fields;
    protected Object[] thisRow = null;
    protected boolean doingUpdates = false;
    protected boolean hasBuiltIndexMapping = false;
    protected boolean isBinaryEncoded = false;
    protected boolean isClosed = false;
    protected boolean onInsertRow = false;
    protected boolean profileSql = false;
    protected boolean reallyResult = false;
    protected boolean useUsageAdvisor = false;
    protected boolean wasNullFlag = false;
    protected char firstCharOfQuery;
    protected int currentRow = -1;
    protected int fetchDirection = 1000;
    protected int fetchSize = 0;
    protected int resultId;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected long updateCount;
    protected long updateId = -1L;
    private Calendar fastDateCal = null;
    private TimeZone defaultTimeZone;
    private boolean useStrictFloatingPoint = false;

    public ResultSet(long updateCount, long updateID, Connection conn, Statement creatorStmt) {
        this.updateCount = updateCount;
        this.updateId = updateID;
        this.reallyResult = false;
        this.fields = new Field[0];
        this.connection = conn;
        this.owningStatement = creatorStmt;
    }

    public ResultSet(String catalog, Field[] fields, RowData tuples, Connection conn, Statement creatorStmt) throws SQLException {
        this.connection = conn;
        if (this.connection != null) {
            this.useStrictFloatingPoint = this.connection.getStrictFloatingPoint();
            this.setDefaultTimeZone(this.connection.getDefaultTimeZone());
        }
        this.owningStatement = creatorStmt;
        this.catalog = catalog;
        this.profileSql = this.connection.getProfileSql();
        this.fields = fields;
        this.rowData = tuples;
        this.updateCount = this.rowData.size();
        this.reallyResult = true;
        if (this.rowData.size() > 0) {
            if (this.updateCount == 1L && this.thisRow == null) {
                this.rowData.close();
                this.updateCount = -1L;
            }
        } else {
            this.thisRow = null;
        }
        this.rowData.setOwner(this);
        this.pointOfOrigin = new Throwable();
        if (this.profileSql || this.connection.getUseUsageAdvisor()) {
            this.columnUsed = new boolean[this.fields.length];
            this.pointOfOrigin = new Throwable();
            this.resultId = resultCounter++;
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfileEventSink.getInstance(this.connection);
        }
    }

    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        boolean b = this.rowData.isAfterLast();
        return b;
    }

    public Array getArray(int i) throws SQLException {
        throw new NotImplemented();
    }

    public Array getArray(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (!this.isBinaryEncoded) {
            return this.getBinaryStream(columnIndex);
        }
        return this.getNativeBinaryStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        return this.rowData.isBeforeFirst();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (!this.isBinaryEncoded) {
            String stringVal = this.getString(columnIndex);
            if (stringVal != null) {
                BigDecimal val;
                if (stringVal.length() == 0) {
                    BigDecimal val2 = new BigDecimal(0.0);
                    return val2.setScale(scale);
                }
                try {
                    val = new BigDecimal(stringVal);
                }
                catch (NumberFormatException ex) {
                    throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal", new Object[]{new Integer(columnIndex), stringVal}), "S1009");
                }
                try {
                    return val.setScale(scale);
                }
                catch (ArithmeticException ex) {
                    throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal", new Object[]{new Integer(columnIndex), stringVal}), "S1009");
                }
            }
            return null;
        }
        return this.getNativeBigDecimal(columnIndex, scale);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            String stringVal = this.getString(columnIndex);
            if (stringVal != null) {
                if (stringVal.length() == 0) {
                    BigDecimal val = new BigDecimal(0.0);
                    return val;
                }
                try {
                    BigDecimal val = new BigDecimal(stringVal);
                    return val;
                }
                catch (NumberFormatException ex) {
                    throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal", new Object[]{new Integer(columnIndex), stringVal}), "S1009");
                }
            }
            return null;
        }
        return this.getNativeBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        if (!this.isBinaryEncoded) {
            byte[] b = this.getBytes(columnIndex);
            if (b != null) {
                return new ByteArrayInputStream(b);
            }
            return null;
        }
        return this.getNativeBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public java.sql.Blob getBlob(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            if (columnIndex < 1 || columnIndex > this.fields.length) {
                throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
            }
            try {
                this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
            }
            catch (NullPointerException ex) {
                this.wasNullFlag = true;
            }
            if (this.wasNullFlag) {
                return null;
            }
            if (!this.connection.getEmulateLocators()) {
                return new Blob((byte[])this.thisRow[columnIndex - 1]);
            }
            return new BlobFromLocator(this, columnIndex);
        }
        return this.getNativeBlob(columnIndex);
    }

    public java.sql.Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            String stringVal = this.getString(columnIndex);
            if (stringVal != null && stringVal.length() > 0) {
                char c = Character.toLowerCase(stringVal.charAt(0));
                return c == 't' || c == 'y' || c == '1' || stringVal.equals("-1");
            }
            return false;
        }
        return this.getNativeBoolean(columnIndex);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            String stringVal = this.getString(columnIndex);
            if (this.wasNullFlag || stringVal == null) {
                return 0;
            }
            return this.getByteFromString(stringVal, columnIndex);
        }
        return this.getNativeByte(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            try {
                this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
            }
            catch (ArrayIndexOutOfBoundsException aioobEx) {
                throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
            }
            if (this.wasNullFlag) {
                return null;
            }
            return (byte[])this.thisRow[columnIndex - 1];
        }
        return this.getNativeBytes(columnIndex);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            String stringVal = this.getString(columnIndex);
            if (stringVal != null) {
                return new StringReader(stringVal);
            }
            return null;
        }
        return this.getNativeCharacterStream(columnIndex);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public java.sql.Clob getClob(int i) throws SQLException {
        if (!this.isBinaryEncoded) {
            return new Clob(this.getString(i));
        }
        return this.getNativeClob(i);
    }

    public java.sql.Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException(Messages.getString("ResultSet.Positioned_Update_not_supported"), "S1C00");
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.isBinaryEncoded) {
            return this.getNativeDate(columnIndex, cal != null ? cal.getTimeZone() : this.getDefaultTimeZone());
        }
        String stringVal = this.getString(columnIndex);
        if (stringVal == null) {
            return null;
        }
        return this.getDateFromString(stringVal, columnIndex);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            return this.getDoubleInternal(columnIndex);
        }
        return this.getNativeDouble(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException(Messages.getString("ResultSet.Illegal_value_for_fetch_direction_64"), "S1009");
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException(Messages.getString("ResultSet.Value_must_be_between_0_and_getMaxRows()_66"), "S1009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public boolean isFirst() throws SQLException {
        this.checkClosed();
        return this.rowData.isFirst();
    }

    public float getFloat(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            String val = null;
            val = this.getString(columnIndex);
            return this.getFloatFromString(val, columnIndex);
        }
        return this.getNativeFloat(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            if (this.connection.getUseFastIntParsing()) {
                this.checkRowPos();
                try {
                    this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
                }
                catch (NullPointerException E) {
                    this.wasNullFlag = true;
                }
                catch (ArrayIndexOutOfBoundsException aioobEx) {
                    throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
                }
                if (this.wasNullFlag) {
                    return 0;
                }
                byte[] intAsBytes = (byte[])this.thisRow[columnIndex - 1];
                boolean needsFullParse = false;
                for (int i = 0; i < intAsBytes.length; ++i) {
                    if ((char)intAsBytes[i] != 'e' && (char)intAsBytes[i] != 'E') continue;
                    needsFullParse = true;
                    break;
                }
                if (!needsFullParse) {
                    try {
                        return this.parseIntWithOverflowCheck(columnIndex, intAsBytes, null);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            return this.parseIntAsDouble(columnIndex, new String(intAsBytes));
                        }
                        catch (NumberFormatException newNfe) {
                            throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getInt()_-____74") + new String(intAsBytes) + "'", "S1009");
                        }
                    }
                }
            }
            String val = null;
            try {
                val = this.getString(columnIndex);
                if (val != null && val.length() != 0) {
                    if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                        return Integer.parseInt(val);
                    }
                    return this.parseIntAsDouble(columnIndex, val);
                }
                return 0;
            }
            catch (NumberFormatException nfe) {
                try {
                    return this.parseIntAsDouble(columnIndex, val);
                }
                catch (NumberFormatException newNfe) {
                    throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getInt()_-____74") + val + "'", "S1009");
                }
            }
        }
        return this.getNativeInt(columnIndex);
    }

    private short parseShortWithOverflowCheck(int columnIndex, byte[] valueAsBytes, String valueAsString) throws NumberFormatException, SQLException {
        long valueAsLong;
        short shortValue = 0;
        if (valueAsBytes == null && valueAsString == null) {
            return 0;
        }
        shortValue = valueAsBytes != null ? StringUtils.getShort(valueAsBytes) : Short.parseShort(valueAsString);
        if (!(!this.connection.getJdbcCompliantTruncation() || shortValue != Short.MIN_VALUE && shortValue != Short.MAX_VALUE || (valueAsLong = Long.parseLong(valueAsString == null ? new String(valueAsBytes) : valueAsString)) >= -32768L && valueAsLong <= 32767L)) {
            this.throwRangeException(valueAsString == null ? new String(valueAsBytes) : valueAsString, columnIndex, 5);
        }
        return shortValue;
    }

    private short parseShortAsDouble(int columnIndex, String val) throws NumberFormatException, SQLException {
        if (val == null) {
            return 0;
        }
        double valueAsDouble = Double.parseDouble(val);
        if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -32768.0 || valueAsDouble > 32767.0)) {
            this.throwRangeException(String.valueOf(valueAsDouble), columnIndex, 5);
        }
        return (short)valueAsDouble;
    }

    private int parseIntWithOverflowCheck(int columnIndex, byte[] valueAsBytes, String valueAsString) throws NumberFormatException, SQLException {
        long valueAsLong;
        int intValue = 0;
        if (valueAsBytes == null && valueAsString == null) {
            return 0;
        }
        intValue = valueAsBytes != null ? StringUtils.getInt(valueAsBytes) : Integer.parseInt(valueAsString);
        if (!(!this.connection.getJdbcCompliantTruncation() || intValue != Integer.MIN_VALUE && intValue != Integer.MAX_VALUE || (valueAsLong = Long.parseLong(valueAsString == null ? new String(valueAsBytes) : valueAsString)) >= Integer.MIN_VALUE && valueAsLong <= Integer.MAX_VALUE)) {
            this.throwRangeException(valueAsString == null ? new String(valueAsBytes) : valueAsString, columnIndex, 4);
        }
        return intValue;
    }

    private int parseIntAsDouble(int columnIndex, String val) throws NumberFormatException, SQLException {
        if (val == null) {
            return 0;
        }
        double valueAsDouble = Double.parseDouble(val);
        if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -2.147483648E9 || valueAsDouble > 2.147483647E9)) {
            this.throwRangeException(String.valueOf(valueAsDouble), columnIndex, 4);
        }
        return (int)valueAsDouble;
    }

    private long parseLongWithOverflowCheck(int columnIndex, byte[] valueAsBytes, String valueAsString) throws NumberFormatException, SQLException {
        double valueAsDouble;
        long longValue = 0L;
        if (valueAsBytes == null && valueAsString == null) {
            return 0L;
        }
        longValue = valueAsBytes != null ? StringUtils.getLong(valueAsBytes) : Long.parseLong(valueAsString);
        if (this.connection.getJdbcCompliantTruncation() && (longValue == Integer.MIN_VALUE || longValue == Integer.MAX_VALUE) && ((valueAsDouble = Double.parseDouble(valueAsString == null ? new String(valueAsBytes) : valueAsString)) < -9.223372036854776E18 || valueAsDouble > 9.223372036854776E18)) {
            this.throwRangeException(valueAsString == null ? new String(valueAsBytes) : valueAsString, columnIndex, -5);
        }
        return longValue;
    }

    private long parseLongAsDouble(int columnIndex, String val) throws NumberFormatException, SQLException {
        if (val == null) {
            return 0L;
        }
        double valueAsDouble = Double.parseDouble(val);
        if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -9.223372036854776E18 || valueAsDouble > 9.223372036854776E18)) {
            this.throwRangeException(val, columnIndex, -5);
        }
        return (long)valueAsDouble;
    }

    private synchronized void addaWarning(SQLWarning warning) {
        if (this.warningChain == null) {
            this.warningChain = warning;
        } else {
            SQLWarning warningToAppendTo = this.warningChain;
            while (warningToAppendTo.getNextWarning() != null) {
                warningToAppendTo = warningToAppendTo.getNextWarning();
            }
            warningToAppendTo.setNextWarning(warning);
        }
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        String datatype = null;
        switch (jdbcType) {
            case -6: {
                datatype = "TINYINT";
                break;
            }
            case 5: {
                datatype = "SMALLINT";
                break;
            }
            case 4: {
                datatype = "INTEGER";
                break;
            }
            case -5: {
                datatype = "BIGINT";
                break;
            }
            case 7: {
                datatype = "REAL";
                break;
            }
            case 6: {
                datatype = "FLOAT";
                break;
            }
            case 8: {
                datatype = "DOUBLE";
                break;
            }
            case 3: {
                datatype = "DECIMAL";
                break;
            }
            default: {
                datatype = " (JDBC type '" + jdbcType + "')";
            }
        }
        throw new SQLException("'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the datatype " + datatype + ".", "22003");
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public boolean isLast() throws SQLException {
        this.checkClosed();
        return this.rowData.isLast();
    }

    public long getLong(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            if (this.connection.getUseFastIntParsing()) {
                this.checkRowPos();
                try {
                    this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
                }
                catch (NullPointerException E) {
                    this.wasNullFlag = true;
                }
                catch (ArrayIndexOutOfBoundsException aioobEx) {
                    throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
                }
                if (this.wasNullFlag) {
                    return 0L;
                }
                byte[] longAsBytes = (byte[])this.thisRow[columnIndex - 1];
                boolean needsFullParse = false;
                for (int i = 0; i < longAsBytes.length; ++i) {
                    if ((char)longAsBytes[i] != 'e' && (char)longAsBytes[i] != 'E') continue;
                    needsFullParse = true;
                    break;
                }
                if (!needsFullParse) {
                    try {
                        return this.parseLongWithOverflowCheck(columnIndex, longAsBytes, null);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            return this.parseLongAsDouble(columnIndex, new String(longAsBytes));
                        }
                        catch (NumberFormatException newNfe) {
                            throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getLong()_-____79") + new String(longAsBytes) + "'", "S1009");
                        }
                    }
                }
            }
            String val = null;
            try {
                val = this.getString(columnIndex);
                if (val != null && val.length() != 0) {
                    if (val.indexOf("e") == -1 && val.indexOf("E") == -1) {
                        return this.parseLongWithOverflowCheck(columnIndex, null, val);
                    }
                    return this.parseLongAsDouble(columnIndex, val);
                }
                return 0L;
            }
            catch (NumberFormatException nfe) {
                try {
                    return this.parseLongAsDouble(columnIndex, val);
                }
                catch (NumberFormatException newNfe) {
                    throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getLong()_-____79") + val + "'", "S1009");
                }
            }
        }
        return this.getNativeLong(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new ResultSetMetaData(this.fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkRowPos();
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobEx) {
            throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
        }
        this.wasNullFlag = false;
        Field field = this.fields[columnIndex - 1];
        if (this.isBinaryEncoded && !(this.thisRow[columnIndex - 1] instanceof byte[])) {
            if (field.getSQLType() == -7) {
                return this.getBoolean(columnIndex);
            }
            Object columnValue = this.thisRow[columnIndex - 1];
            if (columnValue == null) {
                this.wasNullFlag = true;
                return null;
            }
            return columnValue;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex);
            }
            case -6: {
                return new Integer(this.getByte(columnIndex));
            }
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case 4: {
                if (!field.isUnsigned()) {
                    return new Integer(this.getInt(columnIndex));
                }
                return new Long(this.getLong(columnIndex));
            }
            case -5: {
                if (!field.isUnsigned()) {
                    return new Long(this.getLong(columnIndex));
                }
                String stringVal = this.getString(columnIndex);
                if (stringVal == null) {
                    return null;
                }
                try {
                    return new BigInteger(stringVal);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigInteger", new Object[]{new Integer(columnIndex), stringVal}), "S1009");
                }
            }
            case 2: 
            case 3: {
                String stringVal = this.getString(columnIndex);
                if (stringVal != null) {
                    BigDecimal val;
                    if (stringVal.length() == 0) {
                        BigDecimal val2 = new BigDecimal(0.0);
                        return val2;
                    }
                    try {
                        val = new BigDecimal(stringVal);
                    }
                    catch (NumberFormatException ex) {
                        throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal____86") + stringVal + Messages.getString("ResultSet.___in_column__87") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                    }
                    return val;
                }
                return null;
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data;
                if (!field.isBlob()) {
                    return this.getString(columnIndex);
                }
                if (!field.isBinary()) {
                    return this.getString(columnIndex);
                }
                Object obj = data = this.getBytes(columnIndex);
                if (data != null && data.length >= 2 && data[0] == -84 && data[1] == -19) {
                    try {
                        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
                        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
                        obj = objIn.readObject();
                        objIn.close();
                        bytesIn.close();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SQLException(Messages.getString("ResultSet.Class_not_found___91") + cnfe.toString() + Messages.getString("ResultSet._while_reading_serialized_object_92"));
                    }
                    catch (IOException ex) {
                        obj = data;
                    }
                }
                return obj;
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(int i) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String colName) throws SQLException {
        throw new NotImplemented();
    }

    public int getRow() throws SQLException {
        this.checkClosed();
        int currentRowNumber = this.rowData.getCurrentRowNumber();
        int row = 0;
        row = !this.rowData.isDynamic() ? (currentRowNumber < 0 || this.rowData.isAfterLast() || this.rowData.isEmpty() ? 0 : currentRowNumber + 1) : currentRowNumber + 1;
        return row;
    }

    public short getShort(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            if (this.connection.getUseFastIntParsing()) {
                this.checkRowPos();
                try {
                    this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
                }
                catch (NullPointerException E) {
                    this.wasNullFlag = true;
                }
                catch (ArrayIndexOutOfBoundsException aioobEx) {
                    throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
                }
                if (this.wasNullFlag) {
                    return 0;
                }
                byte[] shortAsBytes = (byte[])this.thisRow[columnIndex - 1];
                boolean needsFullParse = false;
                for (int i = 0; i < shortAsBytes.length; ++i) {
                    if ((char)shortAsBytes[i] != 'e' && (char)shortAsBytes[i] != 'E') continue;
                    needsFullParse = true;
                    break;
                }
                if (!needsFullParse) {
                    try {
                        return this.parseShortWithOverflowCheck(columnIndex, shortAsBytes, null);
                    }
                    catch (NumberFormatException nfe) {
                        try {
                            return this.parseShortAsDouble(columnIndex, new String(shortAsBytes));
                        }
                        catch (NumberFormatException newNfe) {
                            throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getShort()_-____96") + new String(shortAsBytes) + "'", "S1009");
                        }
                    }
                }
            }
            String val = null;
            try {
                val = this.getString(columnIndex);
                if (val != null && val.length() != 0) {
                    if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                        return this.parseShortWithOverflowCheck(columnIndex, null, val);
                    }
                    return this.parseShortAsDouble(columnIndex, val);
                }
                return 0;
            }
            catch (NumberFormatException nfe) {
                try {
                    return this.parseShortAsDouble(columnIndex, val);
                }
                catch (NumberFormatException newNfe) {
                    throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getShort()_-____96") + val + "'", "S1009");
                }
            }
        }
        return this.getNativeShort(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public java.sql.Statement getStatement() throws SQLException {
        return this.owningStatement;
    }

    public String getString(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            this.checkColumnBounds(columnIndex);
            if (this.fields == null) {
                throw new SQLException(Messages.getString("ResultSet.Query_generated_no_fields_for_ResultSet_99"), "S1002");
            }
            try {
                if (this.thisRow[columnIndex - 1] == null) {
                    this.wasNullFlag = true;
                    return null;
                }
                this.wasNullFlag = false;
            }
            catch (NullPointerException E) {
                this.wasNullFlag = true;
                return null;
            }
            String stringVal = null;
            --columnIndex;
            if (this.connection != null && this.connection.getUseUnicode()) {
                try {
                    String encoding = this.fields[columnIndex].getCharacterSet();
                    if (encoding == null) {
                        stringVal = new String((byte[])this.thisRow[columnIndex]);
                    }
                    SingleByteCharsetConverter converter = this.connection.getCharsetConverter(encoding);
                    if (converter != null) {
                        stringVal = converter.toString((byte[])this.thisRow[columnIndex]);
                    }
                    stringVal = new String((byte[])this.thisRow[columnIndex], encoding);
                }
                catch (UnsupportedEncodingException E) {
                    throw new SQLException(Messages.getString("ResultSet.Unsupported_character_encoding____101") + this.connection.getEncoding() + "'.", "0S100");
                }
            } else {
                stringVal = StringUtils.toAsciiString((byte[])this.thisRow[columnIndex]);
            }
            return stringVal;
        }
        return this.getNativeString(columnIndex);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.getTimeInternal(columnIndex, this.getDefaultTimeZone());
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimeInternal(columnIndex, cal.getTimeZone());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestampInternal(columnIndex, this.getDefaultTimeZone());
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestampInternal(columnIndex, cal.getTimeZone());
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public URL getURL(int colIndex) throws SQLException {
        String val = this.getString(colIndex);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException(Messages.getString("ResultSet.Malformed_URL____104") + val + "'", "S1009");
        }
    }

    public URL getURL(String colName) throws SQLException {
        String val = this.getString(colName);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException(Messages.getString("ResultSet.Malformed_URL____107") + val + "'", "S1009");
        }
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (!this.isBinaryEncoded) {
            this.checkRowPos();
            return this.getBinaryStream(columnIndex);
        }
        return this.getNativeBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    public boolean absolute(int row) throws SQLException {
        boolean b;
        this.checkClosed();
        if (this.rowData.size() == 0) {
            b = false;
        } else {
            if (row == 0) {
                throw new SQLException(Messages.getString("ResultSet.Cannot_absolute_position_to_row_0_110"), "S1009");
            }
            if (this.onInsertRow) {
                this.onInsertRow = false;
            }
            if (this.doingUpdates) {
                this.doingUpdates = false;
            }
            if (row == 1) {
                b = this.first();
            } else if (row == -1) {
                b = this.last();
            } else if (row > this.rowData.size()) {
                this.afterLast();
                b = false;
            } else if (row < 0) {
                int newRowPosition = this.rowData.size() + row + 1;
                if (newRowPosition <= 0) {
                    this.beforeFirst();
                    b = false;
                } else {
                    b = this.absolute(newRowPosition);
                }
            } else {
                this.rowData.setCurrentRow(--row);
                this.thisRow = this.rowData.getAt(row);
                b = true;
            }
        }
        return b;
    }

    public void afterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (this.rowData.size() != 0) {
            this.rowData.afterLast();
            this.thisRow = null;
        }
    }

    public void beforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (this.rowData.size() == 0) {
            return;
        }
        this.rowData.beforeFirst();
        this.thisRow = null;
    }

    public void cancelRowUpdates() throws SQLException {
        throw new NotUpdatable();
    }

    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public void close() throws SQLException {
        this.realClose(true);
    }

    public void deleteRow() throws SQLException {
        throw new NotUpdatable();
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        Integer index;
        if (!this.hasBuiltIndexMapping) {
            this.buildIndexMapping();
        }
        if ((index = (Integer)this.columnNameToIndex.get(columnName)) == null) {
            index = (Integer)this.fullColumnNameToIndex.get(columnName);
        }
        if (index != null) {
            return index + 1;
        }
        String columnNameUC = columnName.toUpperCase();
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getName().toUpperCase().equals(columnNameUC)) {
                return i + 1;
            }
            if (!this.fields[i].getFullName().toUpperCase().equals(columnNameUC)) continue;
            return i + 1;
        }
        throw new SQLException(Messages.getString("ResultSet.Column____112") + columnName + Messages.getString("ResultSet.___not_found._113"), "S0022");
    }

    public boolean first() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.rowData.isEmpty()) {
            return false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.rowData.beforeFirst();
        this.thisRow = this.rowData.next();
        return true;
    }

    public void insertRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean last() throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return false;
        }
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        this.rowData.beforeLast();
        this.thisRow = this.rowData.next();
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        throw new NotUpdatable();
    }

    public void moveToInsertRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean next() throws SQLException {
        boolean b;
        this.checkClosed();
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        if (!this.reallyResult()) {
            throw new SQLException(Messages.getString("ResultSet.ResultSet_is_from_UPDATE._No_Data_115"), "S1000");
        }
        if (this.rowData.size() == 0) {
            b = false;
        } else if (!this.rowData.hasNext()) {
            this.rowData.next();
            b = false;
        } else {
            this.clearWarnings();
            this.thisRow = this.rowData.next();
            b = true;
        }
        return b;
    }

    public boolean prev() throws SQLException {
        this.checkClosed();
        int rowIndex = this.rowData.getCurrentRowNumber();
        if (rowIndex - 1 >= 0) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = this.rowData.getAt(rowIndex);
            return true;
        }
        if (rowIndex - 1 == -1) {
            this.rowData.setCurrentRow(--rowIndex);
            this.thisRow = null;
            return false;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.onInsertRow) {
            this.onInsertRow = false;
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
        }
        return this.prev();
    }

    public void refreshRow() throws SQLException {
        throw new NotUpdatable();
    }

    public boolean relative(int rows) throws SQLException {
        this.checkClosed();
        if (this.rowData.size() == 0) {
            return false;
        }
        this.rowData.moveRowRelative(rows);
        this.thisRow = this.rowData.getAt(this.rowData.getCurrentRowNumber());
        return !this.rowData.isAfterLast() && !this.rowData.isBeforeFirst();
    }

    public boolean rowDeleted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw new NotImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw new NotImplemented();
    }

    public String toString() {
        if (this.reallyResult) {
            return super.toString();
        }
        return "Result set representing update count of " + this.updateCount;
    }

    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateBlob(int arg0, java.sql.Blob arg1) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBlob(String arg0, java.sql.Blob arg1) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateClob(int arg0, java.sql.Clob arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateClob(String columnName, java.sql.Clob clob) throws SQLException {
        this.updateClob(this.findColumn(columnName), clob);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new NotImplemented();
    }

    public void updateRow() throws SQLException {
        throw new NotUpdatable();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new NotUpdatable();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    protected void setBinaryEncoded() {
        this.isBinaryEncoded = true;
    }

    protected double getDoubleInternal(int colIndex) throws SQLException {
        return this.getDoubleInternal(this.getString(colIndex), colIndex);
    }

    protected double getDoubleInternal(String stringVal, int colIndex) throws SQLException {
        try {
            if (stringVal == null || stringVal.length() == 0) {
                return 0.0;
            }
            double d = Double.parseDouble(stringVal);
            if (this.useStrictFloatingPoint) {
                if (d == 2.147483648E9) {
                    d = 2.147483647E9;
                } else if (d == 1.0000000036275E-15) {
                    d = 1.0E-15;
                } else if (d == 9.999999869911E14) {
                    d = 9.99999999999999E14;
                } else if (d == 1.4012984643248E-45) {
                    d = 1.4E-45;
                } else if (d == 1.4013E-45) {
                    d = 1.4E-45;
                } else if (d == 3.4028234663853E37) {
                    d = 3.4028235E37;
                } else if (d == -2.14748E9) {
                    d = -2.147483648E9;
                } else if (d == 3.40282E37) {
                    d = 3.4028235E37;
                }
            }
            return d;
        }
        catch (NumberFormatException e) {
            throw new SQLException(Messages.getString("ResultSet.Bad_format_for_number", new Object[]{stringVal, new Integer(colIndex)}), "S1009");
        }
    }

    protected void setFirstCharOfQuery(char c) {
        this.firstCharOfQuery = c;
    }

    protected char getFirstCharOfQuery() {
        return this.firstCharOfQuery;
    }

    protected Array getNativeArray(int i) throws SQLException {
        throw new NotImplemented();
    }

    protected InputStream getNativeAsciiStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getNativeBinaryStream(columnIndex);
    }

    protected BigDecimal getNativeBigDecimal(int columnIndex, int scale) throws SQLException {
        String stringVal = this.getNativeString(columnIndex);
        if (stringVal != null) {
            BigDecimal val;
            if (stringVal.length() == 0) {
                BigDecimal val2 = new BigDecimal(0.0);
                return val2.setScale(scale);
            }
            try {
                val = new BigDecimal(stringVal);
            }
            catch (NumberFormatException ex) {
                throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal____119") + stringVal + "' in column " + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException ex) {
                throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal____124") + stringVal + Messages.getString("ResultSet.___in_column__125") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
        }
        return null;
    }

    protected BigDecimal getNativeBigDecimal(int columnIndex) throws SQLException {
        String stringVal = this.getNativeString(columnIndex);
        return this.getBigDecimalFromString(stringVal, columnIndex);
    }

    protected InputStream getNativeBinaryStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        byte[] b = this.getNativeBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    protected java.sql.Blob getNativeBlob(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException ex) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        int mysqlType = this.fields[columnIndex - 1].getMysqlType();
        byte[] dataAsBytes = null;
        switch (mysqlType) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                dataAsBytes = (byte[])this.thisRow[columnIndex - 1];
            }
        }
        dataAsBytes = this.getNativeBytes(columnIndex);
        if (!this.connection.getEmulateLocators()) {
            return new Blob(dataAsBytes);
        }
        return new BlobFromLocator(this, columnIndex);
    }

    protected boolean getNativeBoolean(int columnIndex) throws SQLException {
        String stringVal = this.getNativeString(columnIndex);
        return this.getBooleanFromString(stringVal, columnIndex);
    }

    protected byte getNativeByte(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[columnIndex - 1] == null) {
            this.wasNullFlag = true;
            return 0;
        }
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return 0;
        }
        Field field = this.fields[columnIndex - 1];
        switch (field.getMysqlType()) {
            case 1: {
                return (byte)((Integer)this.thisRow[columnIndex - 1]).intValue();
            }
            case 2: 
            case 3: {
                int valueAsInt = (Integer)this.thisRow[columnIndex - 1];
                if (this.connection.getJdbcCompliantTruncation() && (valueAsInt < -128 || valueAsInt > 127)) {
                    this.throwRangeException(String.valueOf(valueAsInt), columnIndex, -6);
                }
                return (byte)valueAsInt;
            }
            case 4: {
                float valueAsFloat = ((Float)this.thisRow[columnIndex - 1]).floatValue();
                if (this.connection.getJdbcCompliantTruncation() && (valueAsFloat < -128.0f || valueAsFloat > 127.0f)) {
                    this.throwRangeException(String.valueOf(valueAsFloat), columnIndex, -6);
                }
                return (byte)valueAsFloat;
            }
            case 5: {
                double valueAsDouble = (Double)this.thisRow[columnIndex - 1];
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -128.0 || valueAsDouble > 127.0)) {
                    this.throwRangeException(String.valueOf(valueAsDouble), columnIndex, -6);
                }
                return (byte)valueAsDouble;
            }
            case 8: {
                long valueAsLong = (Long)this.thisRow[columnIndex - 1];
                if (this.connection.getJdbcCompliantTruncation() && (valueAsLong < -128L || valueAsLong > 127L)) {
                    this.throwRangeException(String.valueOf(valueAsLong), columnIndex, -6);
                }
                return (byte)valueAsLong;
            }
        }
        return this.getByteFromString(this.getNativeString(columnIndex), columnIndex);
    }

    protected byte[] getNativeBytes(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        try {
            this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
        }
        if (this.wasNullFlag) {
            return null;
        }
        int mysqlType = this.fields[columnIndex - 1].getMysqlType();
        switch (mysqlType) {
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                return (byte[])this.thisRow[columnIndex - 1];
            }
        }
        return this.getBytesFromString(this.getNativeString(columnIndex), columnIndex);
    }

    protected Object getObjectStoredProc(String columnName, int desiredSqlType) throws SQLException {
        return this.getObjectStoredProc(this.findColumn(columnName), desiredSqlType);
    }

    protected Object getObjectStoredProc(String colName, Map map, int desiredSqlType) throws SQLException {
        return this.getObjectStoredProc(this.findColumn(colName), map, desiredSqlType);
    }

    protected Object getObjectStoredProc(int i, Map map, int desiredSqlType) throws SQLException {
        return this.getObjectStoredProc(i, desiredSqlType);
    }

    protected Object getObjectStoredProc(int columnIndex, int desiredSqlType) throws SQLException {
        this.checkRowPos();
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobEx) {
            throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
        }
        this.wasNullFlag = false;
        Field field = this.fields[columnIndex - 1];
        switch (desiredSqlType) {
            case -7: {
                return this.getBoolean(columnIndex);
            }
            case -6: {
                return new Integer(this.getInt(columnIndex));
            }
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case 4: {
                if (field.isUnsigned()) {
                    return new Long(this.getLong(columnIndex));
                }
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                if (field.isUnsigned()) {
                    return this.getBigDecimal(columnIndex);
                }
                return new Long(this.getLong(columnIndex));
            }
            case 2: 
            case 3: {
                String stringVal = this.getString(columnIndex);
                if (stringVal != null) {
                    BigDecimal val;
                    if (stringVal.length() == 0) {
                        BigDecimal val2 = new BigDecimal(0.0);
                        return val2;
                    }
                    try {
                        val = new BigDecimal(stringVal);
                    }
                    catch (NumberFormatException ex) {
                        throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal____86") + stringVal + Messages.getString("ResultSet.___in_column__87") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                    }
                    return val;
                }
                return null;
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] data;
                if (!field.isBlob()) {
                    return this.getString(columnIndex);
                }
                if (!field.isBinary()) {
                    return this.getString(columnIndex);
                }
                Object obj = data = this.getBytes(columnIndex);
                if (data != null && data.length >= 2 && data[0] == -84 && data[1] == -19) {
                    try {
                        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data);
                        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
                        obj = objIn.readObject();
                        objIn.close();
                        bytesIn.close();
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new SQLException(Messages.getString("ResultSet.Class_not_found___91") + cnfe.toString() + Messages.getString("ResultSet._while_reading_serialized_object_92"));
                    }
                    catch (IOException ex) {
                        obj = data;
                    }
                }
                return obj;
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.getString(columnIndex);
    }

    protected final void checkColumnBounds(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new SQLException(Messages.getString("ResultSet.Column_Index_out_of_range", new Object[]{new Integer(columnIndex), new Integer(this.fields.length)}), "S1009");
        }
        if (this.profileSql || this.useUsageAdvisor) {
            this.columnUsed[columnIndex - 1] = true;
        }
    }

    protected Reader getNativeCharacterStream(int columnIndex) throws SQLException {
        String stringVal = this.getNativeString(columnIndex);
        return this.getCharacterStreamFromString(stringVal, columnIndex);
    }

    protected java.sql.Clob getNativeClob(int columnIndex) throws SQLException {
        String stringVal = this.getNativeString(columnIndex);
        return this.getClobFromString(stringVal, columnIndex);
    }

    protected Date getNativeDate(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.fields[columnIndex - 1].getMysqlType() == 10) {
            Date dateToReturn = (Date)this.thisRow[columnIndex - 1];
            this.wasNullFlag = dateToReturn == null;
            return dateToReturn;
        }
        String stringVal = this.getNativeString(columnIndex);
        return this.getDateFromString(stringVal, columnIndex);
    }

    protected Date getNativeDate(int columnIndex, TimeZone tz) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        int mysqlType = this.fields[columnIndex - 1].getMysqlType();
        if (mysqlType == 10) {
            if (this.thisRow[columnIndex - 1] == "0000-00-00" || this.thisRow[columnIndex - 1] == "0000-00-00 00:00:00") {
                if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                    this.wasNullFlag = true;
                    return null;
                }
                if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                    throw new SQLException("Value '" + this.thisRow[columnIndex - 1].toString() + " can not be represented as java.sql.Date", "S1009");
                }
                return this.fastDateCreate(null, 1, 1, 1);
            }
            return (Date)this.thisRow[columnIndex - 1];
        }
        String strDate = this.getNativeString(columnIndex);
        return this.getDateFromString(strDate, columnIndex);
    }

    protected double getNativeDouble(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[--columnIndex] == null) {
            this.wasNullFlag = true;
            return 0.0;
        }
        this.wasNullFlag = false;
        switch (this.fields[columnIndex].getMysqlType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return ((Number)this.thisRow[columnIndex]).doubleValue();
            }
        }
        String stringVal = this.getNativeString(columnIndex + 1);
        return this.getDoubleFromString(stringVal, columnIndex + 1);
    }

    protected float getNativeFloat(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[--columnIndex] == null) {
            this.wasNullFlag = true;
            return 0.0f;
        }
        this.wasNullFlag = false;
        switch (this.fields[columnIndex].getMysqlType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return ((Number)this.thisRow[columnIndex]).floatValue();
            }
        }
        String stringVal = this.getNativeString(columnIndex + 1);
        return this.getFloatFromString(stringVal, columnIndex + 1);
    }

    protected int getNativeInt(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[--columnIndex] == null) {
            this.wasNullFlag = true;
            return 0;
        }
        this.wasNullFlag = false;
        switch (this.fields[columnIndex].getMysqlType()) {
            case 1: 
            case 2: 
            case 3: {
                return ((Number)this.thisRow[columnIndex]).intValue();
            }
            case 8: {
                long valueAsLong = ((Number)this.thisRow[columnIndex]).longValue();
                if (this.connection.getJdbcCompliantTruncation() && (valueAsLong < Integer.MIN_VALUE || valueAsLong > Integer.MAX_VALUE)) {
                    this.throwRangeException(String.valueOf(valueAsLong), columnIndex + 1, 4);
                }
                return (int)valueAsLong;
            }
            case 4: 
            case 5: {
                double valueAsDouble = ((Number)this.thisRow[columnIndex]).doubleValue();
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -2.147483648E9 || valueAsDouble > 2.147483647E9)) {
                    this.throwRangeException(String.valueOf(valueAsDouble), columnIndex + 1, 4);
                }
                return (int)valueAsDouble;
            }
        }
        String stringVal = this.getNativeString(columnIndex + 1);
        return this.getIntFromString(stringVal, columnIndex + 1);
    }

    protected long getNativeLong(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[--columnIndex] == null) {
            this.wasNullFlag = true;
            return 0L;
        }
        this.wasNullFlag = false;
        switch (this.fields[columnIndex].getMysqlType()) {
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return ((Number)this.thisRow[columnIndex]).longValue();
            }
            case 4: 
            case 5: {
                double valueAsDouble = ((Number)this.thisRow[columnIndex]).doubleValue();
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -9.223372036854776E18 || valueAsDouble > 9.223372036854776E18)) {
                    this.throwRangeException(String.valueOf(valueAsDouble), columnIndex + 1, -5);
                }
                return (long)valueAsDouble;
            }
        }
        String stringVal = this.getNativeString(columnIndex + 1);
        return this.getLongFromString(stringVal, columnIndex + 1);
    }

    protected Ref getNativeRef(int i) throws SQLException {
        throw new NotImplemented();
    }

    protected short getNativeShort(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[--columnIndex] == null) {
            this.wasNullFlag = true;
            return 0;
        }
        this.wasNullFlag = false;
        switch (this.fields[columnIndex].getMysqlType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return ((Number)this.thisRow[columnIndex]).shortValue();
            }
        }
        String stringVal = this.getNativeString(columnIndex + 1);
        return this.getShortFromString(stringVal, columnIndex + 1);
    }

    protected String getNativeString(int columnIndex) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.fields == null) {
            throw new SQLException(Messages.getString("ResultSet.Query_generated_no_fields_for_ResultSet_133"), "S1002");
        }
        try {
            if (this.thisRow[columnIndex - 1] == null) {
                this.wasNullFlag = true;
                return null;
            }
            this.wasNullFlag = false;
        }
        catch (NullPointerException E) {
            this.wasNullFlag = true;
            return null;
        }
        String stringVal = null;
        if (this.thisRow[columnIndex - 1] instanceof String) {
            return (String)this.thisRow[columnIndex - 1];
        }
        Field field = this.fields[columnIndex - 1];
        int mysqlType = field.getMysqlType();
        switch (mysqlType) {
            case 0: 
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                if (this.connection != null && this.connection.getUseUnicode()) {
                    try {
                        String encoding = this.fields[columnIndex - 1].getCharacterSet();
                        if (encoding == null) {
                            stringVal = new String((byte[])this.thisRow[columnIndex - 1]);
                        }
                        SingleByteCharsetConverter converter = this.connection.getCharsetConverter(encoding);
                        if (converter != null) {
                            stringVal = converter.toString((byte[])this.thisRow[columnIndex - 1]);
                        }
                        stringVal = new String((byte[])this.thisRow[columnIndex - 1], encoding);
                    }
                    catch (UnsupportedEncodingException E) {
                        throw new SQLException(Messages.getString("ResultSet.Unsupported_character_encoding____135") + this.connection.getEncoding() + "'.", "0S100");
                    }
                } else {
                    stringVal = StringUtils.toAsciiString((byte[])this.thisRow[columnIndex - 1]);
                }
                if (mysqlType == 254 || mysqlType == 253) {
                    this.thisRow[columnIndex - 1] = stringVal;
                }
                return stringVal;
            }
            case 253: 
            case 254: {
                try {
                    return (String)this.thisRow[columnIndex - 1];
                }
                catch (ClassCastException cce) {
                    if (this.connection != null && this.connection.getUseUnicode()) {
                        try {
                            String encoding = this.fields[columnIndex - 1].getCharacterSet();
                            if (encoding == null) {
                                stringVal = new String((byte[])this.thisRow[columnIndex - 1]);
                            }
                            SingleByteCharsetConverter converter = this.connection.getCharsetConverter(encoding);
                            if (converter != null) {
                                stringVal = converter.toString((byte[])this.thisRow[columnIndex - 1]);
                            }
                            stringVal = new String((byte[])this.thisRow[columnIndex - 1], encoding);
                        }
                        catch (UnsupportedEncodingException E) {
                            throw new SQLException(Messages.getString("ResultSet.Unsupported_character_encoding____138") + this.connection.getEncoding() + "'.", "0S100");
                        }
                    } else {
                        stringVal = StringUtils.toAsciiString((byte[])this.thisRow[columnIndex - 1]);
                    }
                    if (mysqlType == 254 || mysqlType == 253) {
                        this.thisRow[columnIndex - 1] = stringVal;
                    }
                    return stringVal;
                }
            }
        }
        stringVal = this.thisRow[columnIndex - 1].toString();
        if (field.isZeroFill() && stringVal != null) {
            int origLength = stringVal.length();
            StringBuffer zeroFillBuf = new StringBuffer(origLength);
            int numZeros = field.getLength() - origLength;
            for (int i = 0; i < numZeros; ++i) {
                zeroFillBuf.append('0');
            }
            zeroFillBuf.append(stringVal);
            stringVal = zeroFillBuf.toString();
        }
        return stringVal;
    }

    protected URL getNativeURL(int colIndex) throws SQLException {
        String val = this.getString(colIndex);
        if (val == null) {
            return null;
        }
        try {
            return new URL(val);
        }
        catch (MalformedURLException mfe) {
            throw new SQLException(Messages.getString("ResultSet.Malformed_URL____141") + val + "'", "S1009");
        }
    }

    protected static BigInteger convertLongToUlong(long longVal) {
        byte[] asBytes = new byte[]{(byte)(longVal & 0xFFL), (byte)(longVal >>> 8), (byte)(longVal >>> 16), (byte)(longVal >>> 24), (byte)(longVal >>> 32), (byte)(longVal >>> 40), (byte)(longVal >>> 48), (byte)(longVal >>> 56)};
        return new BigInteger(1, asBytes);
    }

    protected InputStream getNativeUnicodeStream(int columnIndex) throws SQLException {
        this.checkRowPos();
        return this.getBinaryStream(columnIndex);
    }

    protected void setNextResultSet(ResultSet nextResultSet) {
        this.nextResultSet = nextResultSet;
    }

    protected ResultSet getNextResultSet() {
        return this.nextResultSet;
    }

    protected void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    protected void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    protected void setServerInfo(String info) {
        this.serverInfo = info;
    }

    protected String getServerInfo() {
        return this.serverInfo;
    }

    protected void buildIndexMapping() {
        int numFields = this.fields.length;
        this.columnNameToIndex = new HashMap();
        this.fullColumnNameToIndex = new HashMap();
        for (int i = numFields - 1; i >= 0; --i) {
            Integer index = new Integer(i);
            String columnName = this.fields[i].getName();
            String fullColumnName = this.fields[i].getFullName();
            if (columnName != null) {
                this.columnNameToIndex.put(columnName, index);
                this.columnNameToIndex.put(columnName.toUpperCase(), index);
                this.columnNameToIndex.put(columnName.toLowerCase(), index);
            }
            if (fullColumnName == null) continue;
            this.fullColumnNameToIndex.put(fullColumnName, index);
            this.fullColumnNameToIndex.put(fullColumnName.toUpperCase(), index);
            this.fullColumnNameToIndex.put(fullColumnName.toLowerCase(), index);
        }
        this.hasBuiltIndexMapping = true;
    }

    protected final synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(Messages.getString("ResultSet.Operation_not_allowed_after_ResultSet_closed_144"), "S1000");
        }
    }

    protected void checkRowPos() throws SQLException {
        this.checkClosed();
        if (!this.rowData.isDynamic() && this.rowData.size() == 0) {
            throw new SQLException(Messages.getString("ResultSet.Illegal_operation_on_empty_result_set"), "S1000");
        }
        if (this.rowData.isBeforeFirst()) {
            throw new SQLException(Messages.getString("ResultSet.Before_start_of_result_set_146"), "S1000");
        }
        if (this.rowData.isAfterLast()) {
            throw new SQLException(Messages.getString("ResultSet.After_end_of_result_set_148"), "S1000");
        }
    }

    protected final ResultSet copy() throws SQLException {
        ResultSet rs = new ResultSet(this.catalog, this.fields, this.rowData, this.connection, this.owningStatement);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realClose(boolean calledExplicitly) throws SQLException {
        SQLException exceptionDuringClose2;
        block16: {
            try {
                if (this.useUsageAdvisor) {
                    if (!calledExplicitly && !this.isClosed) {
                        String message = Messages.getString("ResultSet.ResultSet_implicitly_closed_by_driver._150") + Messages.getString("ResultSet._n_nYou_should_close_ResultSets_explicitly_from_your_code_to_free_up_resources_in_a_more_efficient_manner._151");
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.owningStatement == null ? "N/A" : this.owningStatement.currentCatalog, this.connection.getId(), this.owningStatement == null ? -1 : this.owningStatement.getId(), this.resultId, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
                    }
                    if (this.rowData instanceof RowDataStatic && !this.isLast() && !this.isAfterLast() && this.rowData.size() != 0) {
                        StringBuffer messageBuf = new StringBuffer(Messages.getString("ResultSet.Possible_incomplete_traversal_of_result_set._Cursor_was_left_on_row__154"));
                        messageBuf.append(this.getRow());
                        messageBuf.append(Messages.getString("ResultSet._of__155"));
                        messageBuf.append(this.rowData.size());
                        messageBuf.append(Messages.getString("ResultSet._rows_when_it_was_closed._156"));
                        messageBuf.append(Messages.getString("ResultSet._n_nYou_should_consider_re-formulating_your_query_to_return_only_the_rows_you_are_interested_in_using._157"));
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.owningStatement == null ? Messages.getString("ResultSet.N/A_159") : this.owningStatement.currentCatalog, this.connection.getId(), this.owningStatement == null ? -1 : this.owningStatement.getId(), this.resultId, System.currentTimeMillis(), 0, null, this.pointOfOrigin, messageBuf.toString()));
                    }
                    if (this.columnUsed.length > 0) {
                        StringBuffer buf = new StringBuffer(Messages.getString("ResultSet.The_following_columns_were__160"));
                        buf.append(Messages.getString("ResultSet._part_of_the_SELECT_statement_for_this_result_set,_but_were_161"));
                        buf.append(Messages.getString("ResultSet._never_referenced___162"));
                        boolean issueWarn = false;
                        for (int i = 0; i < this.columnUsed.length; ++i) {
                            if (this.columnUsed[i]) continue;
                            if (!issueWarn) {
                                issueWarn = true;
                            } else {
                                buf.append(", ");
                            }
                            buf.append(this.fields[i].getFullName());
                        }
                        if (issueWarn) {
                            this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.owningStatement == null ? "N/A" : this.owningStatement.currentCatalog, this.connection.getId(), this.owningStatement == null ? -1 : this.owningStatement.getId(), 0, System.currentTimeMillis(), 0, null, this.pointOfOrigin, buf.toString()));
                        }
                    }
                }
                Object var6_5 = null;
                exceptionDuringClose2 = null;
                if (this.rowData == null) break block16;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SQLException exceptionDuringClose2 = null;
                if (this.rowData != null) {
                    try {
                        this.rowData.close();
                    }
                    catch (SQLException sqlEx) {
                        exceptionDuringClose2 = sqlEx;
                    }
                }
                this.rowData = null;
                this.defaultTimeZone = null;
                this.fields = null;
                this.columnNameToIndex = null;
                this.fullColumnNameToIndex = null;
                this.eventSink = null;
                this.nextResultSet = null;
                this.warningChain = null;
                this.owningStatement = null;
                this.catalog = null;
                this.serverInfo = null;
                this.thisRow = null;
                this.fastDateCal = null;
                this.isClosed = true;
                if (exceptionDuringClose2 != null) {
                    throw exceptionDuringClose2;
                }
                throw throwable;
            }
            try {
                this.rowData.close();
            }
            catch (SQLException sqlEx) {
                exceptionDuringClose2 = sqlEx;
            }
        }
        this.rowData = null;
        this.defaultTimeZone = null;
        this.fields = null;
        this.columnNameToIndex = null;
        this.fullColumnNameToIndex = null;
        this.eventSink = null;
        this.nextResultSet = null;
        this.warningChain = null;
        this.owningStatement = null;
        this.catalog = null;
        this.serverInfo = null;
        this.thisRow = null;
        this.fastDateCal = null;
        this.isClosed = true;
        if (exceptionDuringClose2 != null) {
            throw exceptionDuringClose2;
        }
    }

    long getUpdateCount() {
        return this.updateCount;
    }

    long getUpdateID() {
        return this.updateId;
    }

    boolean reallyResult() {
        if (this.rowData != null) {
            return true;
        }
        return this.reallyResult;
    }

    private final BigDecimal getBigDecimalFromString(String stringVal, int columnIndex) throws SQLException {
        if (stringVal != null) {
            if (stringVal.length() == 0) {
                BigDecimal bdVal = new BigDecimal(0.0);
                return bdVal;
            }
            try {
                BigDecimal bdVal = new BigDecimal(stringVal);
                return bdVal;
            }
            catch (NumberFormatException ex) {
                throw new SQLException(Messages.getString("ResultSet.Bad_format_for_BigDecimal____166") + stringVal + Messages.getString("ResultSet.___in_column__167") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
            }
        }
        return null;
    }

    private final boolean getBooleanFromString(String stringVal, int columnIndex) throws SQLException {
        if (stringVal != null && stringVal.length() > 0) {
            char c = Character.toLowerCase(stringVal.charAt(0));
            return c == 't' || c == 'y' || c == '1' || stringVal.equals("-1");
        }
        return false;
    }

    private final byte getByteFromString(String stringVal, int columnIndex) throws SQLException {
        try {
            int decimalIndex = stringVal.indexOf(".");
            if (decimalIndex != -1) {
                double valueAsDouble = Double.parseDouble(stringVal);
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -128.0 || valueAsDouble > 127.0)) {
                    this.throwRangeException(stringVal, columnIndex, -6);
                }
                return (byte)valueAsDouble;
            }
            long valueAsLong = Long.parseLong(stringVal);
            if (this.connection.getJdbcCompliantTruncation() && (valueAsLong < -128L || valueAsLong > 127L)) {
                this.throwRangeException(String.valueOf(valueAsLong), columnIndex, -6);
            }
            return (byte)valueAsLong;
        }
        catch (NumberFormatException NFE) {
            throw new SQLException(Messages.getString("ResultSet.Value____173") + stringVal + Messages.getString("ResultSet.___is_out_of_range_[-127,127]_174"), "S1009");
        }
    }

    private final byte[] getBytesFromString(String stringVal, int columnIndex) throws SQLException {
        if (stringVal != null) {
            return StringUtils.getBytes(stringVal, this.connection.getEncoding(), this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode());
        }
        return null;
    }

    private final Reader getCharacterStreamFromString(String stringVal, int columnIndex) throws SQLException {
        if (stringVal != null) {
            return new StringReader(stringVal);
        }
        return null;
    }

    private final java.sql.Clob getClobFromString(String stringVal, int columnIndex) throws SQLException {
        return new Clob(stringVal);
    }

    private final Date getDateFromString(String stringVal, int columnIndex) throws SQLException {
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            this.wasNullFlag = false;
            if (stringVal == null) {
                this.wasNullFlag = true;
                return null;
            }
            if (stringVal.equals("0000-00-00") || stringVal.equals("0000-00-00 00:00:00") || stringVal.equals("00000000000000") || stringVal.equals("0")) {
                if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                    this.wasNullFlag = true;
                    return null;
                }
                if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                    throw new SQLException("Value '" + stringVal + "' can not be represented as java.sql.Date", "S1009");
                }
                return this.fastDateCreate(null, 1, 1, 1);
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 7) {
                switch (stringVal.length()) {
                    case 19: 
                    case 21: {
                        year = Integer.parseInt(stringVal.substring(0, 4));
                        month = Integer.parseInt(stringVal.substring(5, 7));
                        day = Integer.parseInt(stringVal.substring(8, 10));
                        return this.fastDateCreate(null, year, month, day);
                    }
                    case 8: 
                    case 14: {
                        year = Integer.parseInt(stringVal.substring(0, 4));
                        month = Integer.parseInt(stringVal.substring(4, 6));
                        day = Integer.parseInt(stringVal.substring(6, 8));
                        return this.fastDateCreate(null, year, month, day);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        year = Integer.parseInt(stringVal.substring(0, 2));
                        if (year <= 69) {
                            year += 100;
                        }
                        month = Integer.parseInt(stringVal.substring(2, 4));
                        day = Integer.parseInt(stringVal.substring(4, 6));
                        return this.fastDateCreate(null, year + 1900, month, day);
                    }
                    case 4: {
                        year = Integer.parseInt(stringVal.substring(0, 4));
                        if (year <= 69) {
                            year += 100;
                        }
                        month = Integer.parseInt(stringVal.substring(2, 4));
                        return this.fastDateCreate(null, year + 1900, month, 1);
                    }
                    case 2: {
                        year = Integer.parseInt(stringVal.substring(0, 2));
                        if (year <= 69) {
                            year += 100;
                        }
                        return this.fastDateCreate(null, year + 1900, 1, 1);
                    }
                }
                throw new SQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{stringVal, new Integer(columnIndex)}), "S1009");
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 13) {
                year = Integer.parseInt(stringVal.substring(0, 4));
                return this.fastDateCreate(null, year, 1, 1);
            }
            if (stringVal.length() < 10) {
                throw new SQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{stringVal, new Integer(columnIndex)}), "S1009");
            }
            year = Integer.parseInt(stringVal.substring(0, 4));
            month = Integer.parseInt(stringVal.substring(5, 7));
            day = Integer.parseInt(stringVal.substring(8, 10));
            return this.fastDateCreate(null, year, month, day);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw new SQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{stringVal, new Integer(columnIndex)}), "S1009");
        }
    }

    private final double getDoubleFromString(String stringVal, int columnIndex) throws SQLException {
        return this.getDoubleInternal(stringVal, columnIndex);
    }

    private final float getFloatFromString(String val, int columnIndex) throws SQLException {
        try {
            if (val != null && val.length() != 0) {
                double valAsDouble;
                float f = Float.parseFloat(val);
                if (this.connection.getJdbcCompliantTruncation() && (f == Float.MIN_VALUE || f == Float.MAX_VALUE) && ((valAsDouble = Double.parseDouble(val)) < (double)1.4E-45f || valAsDouble > 3.4028234663852886E38)) {
                    this.throwRangeException(String.valueOf(valAsDouble), columnIndex, 6);
                }
                return f;
            }
            return 0.0f;
        }
        catch (NumberFormatException nfe) {
            try {
                double valAsDouble = Double.parseDouble(val);
                if (this.connection.getJdbcCompliantTruncation() && (valAsDouble < (double)1.4E-45f || valAsDouble > 3.4028234663852886E38)) {
                    this.throwRangeException(String.valueOf(valAsDouble), columnIndex, 6);
                }
                return (float)valAsDouble;
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getFloat()_-____200") + val + Messages.getString("ResultSet.___in_column__201") + columnIndex, "S1009");
            }
        }
    }

    private final int getIntFromString(String val, int columnIndex) throws SQLException {
        try {
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                    long valueAsLong;
                    int valueAsInt = Integer.parseInt(val);
                    if (!(!this.connection.getJdbcCompliantTruncation() || valueAsInt != Integer.MIN_VALUE && valueAsInt != Integer.MAX_VALUE || (valueAsLong = Long.parseLong(val)) >= Integer.MIN_VALUE && valueAsLong <= Integer.MAX_VALUE)) {
                        this.throwRangeException(String.valueOf(valueAsLong), columnIndex, 4);
                    }
                    return valueAsInt;
                }
                double valueAsDouble = Double.parseDouble(val);
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -2.147483648E9 || valueAsDouble > 2.147483647E9)) {
                    this.throwRangeException(String.valueOf(valueAsDouble), columnIndex, 4);
                }
                return (int)valueAsDouble;
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            try {
                double valueAsDouble = Double.parseDouble(val);
                if (this.connection.getJdbcCompliantTruncation() && (valueAsDouble < -2.147483648E9 || valueAsDouble > 2.147483647E9)) {
                    this.throwRangeException(String.valueOf(valueAsDouble), columnIndex, 4);
                }
                return (int)valueAsDouble;
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getInt()_-____206") + val + Messages.getString("ResultSet.___in_column__207") + columnIndex, "S1009");
            }
        }
    }

    private final long getLongFromString(String val, int columnIndex) throws SQLException {
        try {
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1) {
                    return this.parseLongWithOverflowCheck(columnIndex, null, val);
                }
                return this.parseLongAsDouble(columnIndex, val);
            }
            return 0L;
        }
        catch (NumberFormatException nfe) {
            try {
                return this.parseLongAsDouble(columnIndex, val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getLong()_-____211") + val + Messages.getString("ResultSet.___in_column__212") + columnIndex, "S1009");
            }
        }
    }

    private void setDefaultTimeZone(TimeZone defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    private synchronized TimeZone getDefaultTimeZone() {
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = TimeZone.getDefault();
        }
        return this.defaultTimeZone;
    }

    private Time getNativeTime(int columnIndex, TimeZone tz) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        this.wasNullFlag = this.thisRow[columnIndex - 1] == null;
        int mysqlType = this.fields[columnIndex - 1].getMysqlType();
        if (mysqlType == 11) {
            Time time = (Time)this.thisRow[columnIndex - 1];
            Time adjustedTime = TimeUtil.changeTimezone(this.connection, time, this.connection.getServerTimezoneTZ(), tz);
            return adjustedTime;
        }
        String strTime = this.getNativeString(columnIndex);
        return this.getTimeFromString(strTime, columnIndex, tz);
    }

    private Timestamp getNativeTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        this.checkRowPos();
        this.checkColumnBounds(columnIndex);
        if (this.thisRow[columnIndex - 1] == null) {
            this.wasNullFlag = true;
            return null;
        }
        this.wasNullFlag = false;
        int mysqlType = this.fields[columnIndex - 1].getMysqlType();
        switch (mysqlType) {
            case 7: 
            case 12: {
                if (this.thisRow[columnIndex - 1] == "0000-00-00" || this.thisRow[columnIndex - 1] == "0000-00-00 00:00:00") {
                    if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                        this.wasNullFlag = true;
                        return null;
                    }
                    if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                        throw new SQLException("Value '" + this.thisRow[columnIndex - 1].toString() + " can not be represented as java.sql.Timestamp", "S1009");
                    }
                    return this.fastTimestampCreate(null, 1, 1, 1, 0, 0, 0, 0);
                }
                Timestamp ts = (Timestamp)this.thisRow[columnIndex - 1];
                Timestamp adjustedTs = TimeUtil.changeTimezone(this.connection, ts, this.connection.getServerTimezoneTZ(), tz);
                return adjustedTs;
            }
        }
        String strTimestamp = this.getNativeString(columnIndex);
        return this.getTimestampFromString(columnIndex, strTimestamp, tz);
    }

    private final short getShortFromString(String val, int columnIndex) throws SQLException {
        try {
            if (val != null && val.length() != 0) {
                if (val.indexOf("e") == -1 && val.indexOf("E") == -1 && val.indexOf(".") == -1) {
                    return this.parseShortWithOverflowCheck(columnIndex, null, val);
                }
                return this.parseShortAsDouble(columnIndex, val);
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            try {
                return this.parseShortAsDouble(columnIndex, val);
            }
            catch (NumberFormatException newNfe) {
                throw new SQLException(Messages.getString("ResultSet.Invalid_value_for_getShort()_-____217") + val + Messages.getString("ResultSet.___in_column__218") + columnIndex, "S1009");
            }
        }
    }

    private Time getTimeFromString(String timeAsString, int columnIndex, TimeZone tz) throws SQLException {
        int hr = 0;
        int min = 0;
        int sec = 0;
        try {
            if (timeAsString == null) {
                this.wasNullFlag = true;
                return null;
            }
            if (timeAsString.equals("0000-00-00") || timeAsString.equals("0000-00-00 00:00:00") || timeAsString.equals("00000000000000")) {
                if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                    this.wasNullFlag = true;
                    return null;
                }
                if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                    throw new SQLException("Value '" + timeAsString + " can not be represented as java.sql.Time", "S1009");
                }
            }
            this.wasNullFlag = false;
            Field timeColField = this.fields[columnIndex - 1];
            if (timeColField.getMysqlType() == 7) {
                int length = timeAsString.length();
                switch (length) {
                    case 12: 
                    case 14: {
                        hr = Integer.parseInt(timeAsString.substring(length - 6, length - 4));
                        min = Integer.parseInt(timeAsString.substring(length - 4, length - 2));
                        sec = Integer.parseInt(timeAsString.substring(length - 2, length));
                        break;
                    }
                    case 10: {
                        hr = Integer.parseInt(timeAsString.substring(6, 8));
                        min = Integer.parseInt(timeAsString.substring(8, 10));
                        sec = 0;
                        break;
                    }
                    default: {
                        throw new SQLException(Messages.getString("ResultSet.Timestamp_too_small_to_convert_to_Time_value_in_column__257") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                    }
                }
                SQLWarning precisionLost = new SQLWarning(Messages.getString("ResultSet.Precision_lost_converting_TIMESTAMP_to_Time_with_getTime()_on_column__261") + columnIndex + "(" + this.fields[columnIndex - 1] + ").");
                if (this.warningChain == null) {
                    this.warningChain = precisionLost;
                } else {
                    this.warningChain.setNextWarning(precisionLost);
                }
            } else if (timeColField.getMysqlType() == 12) {
                hr = Integer.parseInt(timeAsString.substring(11, 13));
                min = Integer.parseInt(timeAsString.substring(14, 16));
                sec = Integer.parseInt(timeAsString.substring(17, 19));
                SQLWarning precisionLost = new SQLWarning(Messages.getString("ResultSet.Precision_lost_converting_DATETIME_to_Time_with_getTime()_on_column__264") + columnIndex + "(" + this.fields[columnIndex - 1] + ").");
                if (this.warningChain == null) {
                    this.warningChain = precisionLost;
                } else {
                    this.warningChain.setNextWarning(precisionLost);
                }
            } else {
                if (timeAsString.length() != 5 && timeAsString.length() != 8) {
                    throw new SQLException(Messages.getString("ResultSet.Bad_format_for_Time____267") + timeAsString + Messages.getString("ResultSet.___in_column__268") + columnIndex + "(" + this.fields[columnIndex - 1] + ").", "S1009");
                }
                hr = Integer.parseInt(timeAsString.substring(0, 2));
                min = Integer.parseInt(timeAsString.substring(3, 5));
                sec = timeAsString.length() == 5 ? 0 : Integer.parseInt(timeAsString.substring(6));
            }
            return TimeUtil.changeTimezone(this.connection, this.fastTimeCreate(null, hr, min, sec), this.connection.getServerTimezoneTZ(), tz);
        }
        catch (Exception ex) {
            throw new SQLException(ex.getClass().getName(), "S1009");
        }
    }

    private Time getTimeInternal(int columnIndex, TimeZone tz) throws SQLException {
        if (this.isBinaryEncoded) {
            return this.getNativeTime(columnIndex, tz);
        }
        String timeAsString = this.getString(columnIndex);
        return this.getTimeFromString(timeAsString, columnIndex, tz);
    }

    private Timestamp getTimestampFromString(int columnIndex, String timestampValue, TimeZone tz) throws SQLException {
        try {
            this.wasNullFlag = false;
            if (timestampValue == null) {
                this.wasNullFlag = true;
                return null;
            }
            int length = timestampValue.length();
            if (length > 0 && timestampValue.charAt(0) == '0' && (timestampValue.equals("0000-00-00") || timestampValue.equals("0000-00-00 00:00:00") || timestampValue.equals("00000000000000") || timestampValue.equals("0"))) {
                if ("convertToNull".equals(this.connection.getZeroDateTimeBehavior())) {
                    this.wasNullFlag = true;
                    return null;
                }
                if ("exception".equals(this.connection.getZeroDateTimeBehavior())) {
                    throw new SQLException("Value '" + timestampValue + " can not be represented as java.sql.Timestamp", "S1009");
                }
                return this.fastTimestampCreate(null, 1, 1, 1, 0, 0, 0, 0);
            }
            if (this.fields[columnIndex - 1].getMysqlType() == 13) {
                return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, Integer.parseInt(timestampValue.substring(0, 4)), 1, 1, 0, 0, 0, 0), this.connection.getServerTimezoneTZ(), tz);
            }
            switch (length) {
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int decimalIndex;
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(5, 7));
                    int day = Integer.parseInt(timestampValue.substring(8, 10));
                    int hour = Integer.parseInt(timestampValue.substring(11, 13));
                    int minutes = Integer.parseInt(timestampValue.substring(14, 16));
                    int seconds = Integer.parseInt(timestampValue.substring(17, 19));
                    int nanos = 0;
                    if (length > 19 && (decimalIndex = timestampValue.lastIndexOf(46)) != -1) {
                        if (decimalIndex + 2 <= timestampValue.length()) {
                            nanos = Integer.parseInt(timestampValue.substring(decimalIndex + 1));
                        } else {
                            throw new IllegalArgumentException();
                        }
                    }
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month, day, hour, minutes, seconds, nanos), this.connection.getServerTimezoneTZ(), tz);
                }
                case 14: {
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(4, 6));
                    int day = Integer.parseInt(timestampValue.substring(6, 8));
                    int hour = Integer.parseInt(timestampValue.substring(8, 10));
                    int minutes = Integer.parseInt(timestampValue.substring(10, 12));
                    int seconds = Integer.parseInt(timestampValue.substring(12, 14));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month, day, hour, minutes, seconds, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 12: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    int day = Integer.parseInt(timestampValue.substring(4, 6));
                    int hour = Integer.parseInt(timestampValue.substring(6, 8));
                    int minutes = Integer.parseInt(timestampValue.substring(8, 10));
                    int seconds = Integer.parseInt(timestampValue.substring(10, 12));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year + 1900, month, day, hour, minutes, seconds, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 10: {
                    int minutes;
                    int hour;
                    int day;
                    int month;
                    int year;
                    if (this.fields[columnIndex - 1].getMysqlType() == 10 || timestampValue.indexOf("-") != -1) {
                        year = Integer.parseInt(timestampValue.substring(0, 4));
                        month = Integer.parseInt(timestampValue.substring(5, 7));
                        day = Integer.parseInt(timestampValue.substring(8, 10));
                        hour = 0;
                        minutes = 0;
                    } else {
                        year = Integer.parseInt(timestampValue.substring(0, 2));
                        if (year <= 69) {
                            year += 100;
                        }
                        month = Integer.parseInt(timestampValue.substring(2, 4));
                        day = Integer.parseInt(timestampValue.substring(4, 6));
                        hour = Integer.parseInt(timestampValue.substring(6, 8));
                        minutes = Integer.parseInt(timestampValue.substring(8, 10));
                        year += 1900;
                    }
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month, day, hour, minutes, 0, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 8: {
                    int year = Integer.parseInt(timestampValue.substring(0, 4));
                    int month = Integer.parseInt(timestampValue.substring(4, 6));
                    int day = Integer.parseInt(timestampValue.substring(6, 8));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year, month, day, 0, 0, 0, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 6: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    int day = Integer.parseInt(timestampValue.substring(4, 6));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year + 1900, month, day, 0, 0, 0, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 4: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    int month = Integer.parseInt(timestampValue.substring(2, 4));
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year + 1900, month, 1, 0, 0, 0, 0), this.connection.getServerTimezoneTZ(), tz);
                }
                case 2: {
                    int year = Integer.parseInt(timestampValue.substring(0, 2));
                    if (year <= 69) {
                        year += 100;
                    }
                    return TimeUtil.changeTimezone(this.connection, this.fastTimestampCreate(null, year + 1900, 1, 1, 0, 0, 0, 0), this.connection.getServerTimezoneTZ(), tz);
                }
            }
            throw new SQLException("Bad format for Timestamp '" + timestampValue + "' in column " + columnIndex + ".", "S1009");
        }
        catch (Exception e) {
            throw new SQLException("Cannot convert value '" + timestampValue + "' from column " + columnIndex + " to TIMESTAMP.", "S1009");
        }
    }

    private Timestamp getTimestampInternal(int columnIndex, TimeZone tz) throws SQLException {
        if (this.isBinaryEncoded) {
            return this.getNativeTimestamp(columnIndex, tz);
        }
        String timestampValue = this.getString(columnIndex);
        return this.getTimestampFromString(columnIndex, timestampValue, tz);
    }

    private synchronized Date fastDateCreate(Calendar cal, int year, int month, int day) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.getDefaultTimeZone());
            }
            cal = this.fastDateCal;
        }
        return TimeUtil.fastDateCreate(cal, year, month, day);
    }

    private synchronized Time fastTimeCreate(Calendar cal, int hour, int minute, int second) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.getDefaultTimeZone());
            }
            cal = this.fastDateCal;
        }
        return TimeUtil.fastTimeCreate(cal, hour, minute, second);
    }

    private synchronized Timestamp fastTimestampCreate(Calendar cal, int year, int month, int day, int hour, int minute, int seconds, int secondsPart) {
        if (cal == null) {
            if (this.fastDateCal == null) {
                this.fastDateCal = new GregorianCalendar();
                this.fastDateCal.setTimeZone(this.getDefaultTimeZone());
            }
            cal = this.fastDateCal;
        }
        return TimeUtil.fastTimestampCreate(cal, year, month, day, hour, minute, seconds, secondsPart);
    }

    private void issueDataTruncationWarningIfConfigured(int columnIndex, int readSize, int truncatedToSize) {
        DataTruncation dt = new DataTruncation(columnIndex, false, true, readSize, truncatedToSize);
    }
}

