/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final byte[] TABLE_AS_BYTES = "TABLE".getBytes();
    private static final byte[] VIEW_AS_BYTES = "VIEW".getBytes();
    private static final String SUPPORTS_FK = "SUPPORTS_FK";
    private static final int PKTABLE_CAT = 0;
    private static final int PKTABLE_SCHEM = 1;
    private static final int PKTABLE_NAME = 2;
    private static final int PKCOLUMN_NAME = 3;
    private static final int FKTABLE_CAT = 4;
    private static final int FKTABLE_SCHEM = 5;
    private static final int FKTABLE_NAME = 6;
    private static final int FKCOLUMN_NAME = 7;
    private static final int KEY_SEQ = 8;
    private static final int UPDATE_RULE = 9;
    private static final int DELETE_RULE = 10;
    private static final int FK_NAME = 11;
    private static final int PK_NAME = 12;
    private static final int DEFERRABILITY = 13;
    protected Connection conn;
    private String database = null;
    private String quotedId = null;

    public DatabaseMetaData(Connection connToSet, String databaseToSet) {
        this.conn = connToSet;
        this.database = databaseToSet;
        try {
            this.quotedId = this.conn.supportsQuotedIdentifiers() ? this.getIdentifierQuoteString() : "";
        }
        catch (SQLException sqlEx) {
            AssertionFailedException.shouldNotHappen(sqlEx);
        }
    }

    public java.sql.ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 1, 32), new Field("", "TYPE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "ATTR_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "ATTR_TYPE_NAME", 1, 32), new Field("", "ATTR_SIZE", 4, 32), new Field("", "DECIMAL_DIGITS", 4, 32), new Field("", "NUM_PREC_RADIX", 4, 32), new Field("", "NULLABLE ", 4, 32), new Field("", "REMARKS", 1, 32), new Field("", "ATTR_DEF", 1, 32), new Field("", "SQL_DATA_TYPE", 4, 32), new Field("", "SQL_DATETIME_SUB", 4, 32), new Field("", "CHAR_OCTET_LENGTH", 4, 32), new Field("", "ORDINAL_POSITION", 4, 32), new Field("", "IS_NULLABLE", 1, 32), new Field("", "SCOPE_CATALOG", 1, 32), new Field("", "SCOPE_SCHEMA", 1, 32), new Field("", "SCOPE_TABLE", 1, 32), new Field("", "SOURCE_DATA_TYPE", 5, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Exception ex22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block21: {
            Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (table == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            java.sql.ResultSet results = null;
            stmt = null;
            try {
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                StringBuffer queryBuf = new StringBuffer("SHOW COLUMNS FROM ");
                queryBuf.append(this.quotedId);
                queryBuf.append(table);
                queryBuf.append(this.quotedId);
                queryBuf.append(databasePart);
                results = stmt.executeQuery(queryBuf.toString());
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    String keyType = results.getString("Key");
                    if (keyType == null || !StringUtils.startsWithIgnoreCase(keyType, "PRI")) continue;
                    byte[][] rowVal = new byte[8][];
                    rowVal[0] = Integer.toString(2).getBytes();
                    rowVal[1] = results.getBytes("Field");
                    String type = results.getString("Type");
                    int size = MysqlIO.getMaxBuf();
                    int decimals = 0;
                    if (type.indexOf("enum") != -1) {
                        String temp = type.substring(type.indexOf("("), type.indexOf(")"));
                        StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                        int maxLength = 0;
                        while (tokenizer.hasMoreTokens()) {
                            maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                        }
                        size = maxLength;
                        decimals = 0;
                        type = "enum";
                    } else if (type.indexOf("(") != -1) {
                        if (type.indexOf(",") != -1) {
                            size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(",")));
                            decimals = Integer.parseInt(type.substring(type.indexOf(",") + 1, type.indexOf(")")));
                        } else {
                            size = Integer.parseInt(type.substring(type.indexOf("(") + 1, type.indexOf(")")));
                        }
                        type = type.substring(type.indexOf("("));
                    }
                    rowVal[2] = new byte[0];
                    rowVal[3] = this.s2b(type);
                    rowVal[4] = Integer.toString(size + decimals).getBytes();
                    rowVal[5] = Integer.toString(size + decimals).getBytes();
                    rowVal[6] = Integer.toString(decimals).getBytes();
                    rowVal[7] = Integer.toString(1).getBytes();
                    tuples.add(rowVal);
                }
                resultSet = this.buildResultSet(fields, tuples);
                Object var21_20 = null;
                if (results == null) break block21;
            }
            catch (Throwable throwable) {
                block24: {
                    Exception ex22;
                    Object var21_21 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt == null) break block24;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
        }
        return resultSet;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCatalogs() throws SQLException {
        SQLException sqlEx22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block11: {
            java.sql.ResultSet results = null;
            stmt = null;
            try {
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                results = stmt.executeQuery("SHOW DATABASES");
                ResultSetMetaData resultsMD = results.getMetaData();
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, resultsMD.getColumnDisplaySize(1))};
                ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                while (results.next()) {
                    byte[][] rowVal = new byte[][]{results.getBytes(1)};
                    tuples.add(rowVal);
                }
                resultSet = this.buildResultSet(fields, tuples);
                Object var8_7 = null;
                if (results == null) break block11;
            }
            catch (Throwable throwable) {
                block14: {
                    SQLException sqlEx22;
                    Object var8_8 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlEx22) {
                            AssertionFailedException.shouldNotHappen(sqlEx22);
                        }
                        results = null;
                    }
                    if (stmt == null) break block14;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        AssertionFailedException.shouldNotHappen(sqlEx22);
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqlEx22) {
                AssertionFailedException.shouldNotHappen(sqlEx22);
            }
            stmt = null;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ArrayList<byte[][]> grantRows;
        Field[] fields;
        block18: {
            Exception ex22;
            Statement stmt;
            block15: {
                fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "COLUMN_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
                StringBuffer grantQuery = new StringBuffer("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv from mysql.columns_priv c, mysql.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
                if (catalog != null && catalog.length() != 0) {
                    grantQuery.append(" AND c.db='");
                    grantQuery.append(catalog);
                    grantQuery.append("' ");
                }
                grantQuery.append(" AND c.table_name ='");
                grantQuery.append(table);
                grantQuery.append("' AND c.column_name like '");
                grantQuery.append(columnNamePattern);
                grantQuery.append("'");
                stmt = null;
                java.sql.ResultSet results = null;
                grantRows = new ArrayList<byte[][]>();
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    results = stmt.executeQuery(grantQuery.toString());
                    while (results.next()) {
                        String host = results.getString(1);
                        String db = results.getString(2);
                        String grantor = results.getString(3);
                        String user = results.getString(4);
                        if (user == null || user.length() == 0) {
                            user = "%";
                        }
                        StringBuffer fullUser = new StringBuffer(user);
                        if (host != null && this.conn.getUseHostsInPrivileges()) {
                            fullUser.append("@");
                            fullUser.append(host);
                        }
                        String columnName = results.getString(6);
                        String allPrivileges = results.getString(7);
                        if (allPrivileges == null) continue;
                        allPrivileges = allPrivileges.toUpperCase();
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        while (st.hasMoreTokens()) {
                            String privilege = st.nextToken().trim();
                            byte[][] tuple = new byte[][]{this.s2b(db), null, this.s2b(table), this.s2b(columnName), (byte[])(grantor != null ? this.s2b(grantor) : null), this.s2b(fullUser.toString()), this.s2b(privilege), null};
                            grantRows.add(tuple);
                        }
                    }
                    Object var21_20 = null;
                    if (results == null) break block15;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var21_21 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
                results = null;
            }
            if (stmt == null) break block18;
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
            {
            }
        }
        return this.buildResultSet(fields, grantRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableName, String columnNamePattern) throws SQLException {
        int tablenameLength;
        ArrayList<String> tableNameList;
        String databasePart;
        block43: {
            String tableNameFromList;
            java.sql.ResultSet tables;
            databasePart = "";
            if (columnNamePattern == null) {
                columnNamePattern = "%";
            }
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            tableNameList = new ArrayList<String>();
            tablenameLength = 0;
            if (tableName == null) {
                tables = null;
                try {
                    tables = this.getTables(catalog, schemaPattern, "%", new String[0]);
                    while (tables.next()) {
                        tableNameFromList = tables.getString("TABLE_NAME");
                        tableNameList.add(tableNameFromList);
                        if (tableNameFromList.length() <= tablenameLength) continue;
                        tablenameLength = tableNameFromList.length();
                    }
                    Object var11_11 = null;
                    if (tables == null) break block43;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Exception sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        tables = null;
                    }
                    throw throwable;
                }
                try {
                    tables.close();
                }
                catch (Exception sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                tables = null;
                {
                    break block43;
                }
            }
            tables = null;
            try {
                tables = this.getTables(catalog, schemaPattern, tableName, new String[0]);
                while (tables.next()) {
                    tableNameFromList = tables.getString("TABLE_NAME");
                    tableNameList.add(tableNameFromList);
                    if (tableNameFromList.length() <= tablenameLength) continue;
                    tablenameLength = tableNameFromList.length();
                }
                Object var14_17 = null;
                if (tables == null) break block43;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (tables != null) {
                    try {
                        tables.close();
                    }
                    catch (SQLException sqlEx) {
                        AssertionFailedException.shouldNotHappen(sqlEx);
                    }
                    tables = null;
                }
                throw throwable;
            }
            try {
                tables.close();
            }
            catch (SQLException sqlEx) {
                AssertionFailedException.shouldNotHappen(sqlEx);
            }
            tables = null;
            {
            }
        }
        int catalogLength = 0;
        if (catalog != null) {
            catalogLength = catalog.length();
        } else {
            catalog = "";
            catalogLength = 0;
        }
        Iterator tableNames = tableNameList.iterator();
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, catalogLength), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, tablenameLength), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        while (tableNames.hasNext()) {
            Exception ex2;
            Statement stmt;
            block46: {
                Object var24_33;
                String tableNamePattern = (String)tableNames.next();
                stmt = null;
                java.sql.ResultSet results = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    StringBuffer queryBuf = new StringBuffer("SHOW ");
                    if (this.conn.getIO().versionMeetsMinimum(4, 1, 0)) {
                        queryBuf.append("FULL ");
                    }
                    queryBuf.append("COLUMNS FROM ");
                    queryBuf.append(this.quotedId);
                    queryBuf.append(tableNamePattern);
                    queryBuf.append(this.quotedId);
                    queryBuf.append(databasePart);
                    queryBuf.append(" LIKE '");
                    queryBuf.append(columnNamePattern);
                    queryBuf.append("'");
                    boolean fixUpOrdinalsRequired = false;
                    HashMap<String, Integer> ordinalFixUpMap = null;
                    if (!columnNamePattern.equals("%")) {
                        fixUpOrdinalsRequired = true;
                        StringBuffer fullColumnQueryBuf = new StringBuffer("SHOW ");
                        if (this.conn.getIO().versionMeetsMinimum(4, 1, 0)) {
                            fullColumnQueryBuf.append("FULL ");
                        }
                        fullColumnQueryBuf.append("COLUMNS FROM ");
                        fullColumnQueryBuf.append(this.quotedId);
                        fullColumnQueryBuf.append(tableNamePattern);
                        fullColumnQueryBuf.append(this.quotedId);
                        fullColumnQueryBuf.append(databasePart);
                        results = stmt.executeQuery(fullColumnQueryBuf.toString());
                        ordinalFixUpMap = new HashMap<String, Integer>();
                        int fullOrdinalPos = 1;
                        while (results.next()) {
                            String fullOrdColName = results.getString("Field");
                            ordinalFixUpMap.put(fullOrdColName, new Integer(fullOrdinalPos++));
                        }
                    }
                    results = stmt.executeQuery(queryBuf.toString());
                    int ordPos = 1;
                    while (results.next()) {
                        byte[][] rowVal = new byte[18][];
                        rowVal[0] = this.s2b(catalog);
                        rowVal[1] = null;
                        rowVal[2] = this.s2b(tableNamePattern);
                        rowVal[3] = results.getBytes("Field");
                        TypeDescriptor typeDesc = new TypeDescriptor(results.getString("Type"), results.getString("Null"));
                        rowVal[4] = Short.toString(typeDesc.dataType).getBytes();
                        rowVal[5] = this.s2b(typeDesc.typeName);
                        rowVal[6] = this.s2b(Integer.toString(typeDesc.columnSize));
                        rowVal[7] = this.s2b(Integer.toString(typeDesc.bufferLength));
                        rowVal[8] = this.s2b(Integer.toString(typeDesc.decimalDigits));
                        rowVal[9] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
                        rowVal[10] = this.s2b(Integer.toString(typeDesc.nullability));
                        try {
                            rowVal[11] = this.conn.getIO().versionMeetsMinimum(4, 1, 0) ? results.getBytes("Comment") : results.getBytes("Extra");
                        }
                        catch (Exception E) {
                            rowVal[11] = new byte[0];
                        }
                        rowVal[12] = results.getBytes("Default");
                        rowVal[13] = new byte[]{48};
                        rowVal[14] = new byte[]{48};
                        rowVal[15] = rowVal[6];
                        if (!fixUpOrdinalsRequired) {
                            rowVal[16] = Integer.toString(ordPos++).getBytes();
                        } else {
                            String origColName = results.getString("Field");
                            Integer realOrdinal = (Integer)ordinalFixUpMap.get(origColName);
                            if (realOrdinal != null) {
                                rowVal[16] = realOrdinal.toString().getBytes();
                            } else {
                                throw new SQLException("Can not find column in full column list to determine true ordinal position.", "S1000");
                            }
                        }
                        rowVal[17] = this.s2b(typeDesc.isNullable);
                        tuples.add(rowVal);
                    }
                    var24_33 = null;
                    if (results == null) break block46;
                }
                catch (Throwable throwable) {
                    var24_33 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                results = null;
            }
            if (stmt == null) continue;
            try {
                stmt.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            stmt = null;
            {
            }
        }
        java.sql.ResultSet results = this.buildResultSet(fields, tuples);
        return results;
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            Statement stmt;
            block23: {
                stmt = null;
                java.sql.ResultSet fkresults = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    if (this.conn.getIO().versionMeetsMinimum(3, 23, 50)) {
                        String db = this.database;
                        if (foreignCatalog != null && !foreignCatalog.equals("")) {
                            db = foreignCatalog;
                        }
                        fkresults = this.extractForeignKeyFromCreateTable(this.conn, this, db, null);
                    } else {
                        String databasePart = "";
                        if (foreignCatalog != null) {
                            if (!foreignCatalog.equals("")) {
                                databasePart = " FROM " + foreignCatalog;
                            }
                        } else {
                            databasePart = " FROM " + this.database;
                        }
                        fkresults = stmt.executeQuery("show table status " + databasePart);
                    }
                    String foreignTableWithCase = this.getTableNameWithCase(foreignTable);
                    String primaryTableWithCase = this.getTableNameWithCase(primaryTable);
                    ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
                    while (fkresults.next()) {
                        String dummy;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(SUPPORTS_FK) || (comment = fkresults.getString("Comment").trim()) == null) continue;
                        StringTokenizer commentTokens = new StringTokenizer(comment, ";", false);
                        if (commentTokens.hasMoreTokens()) {
                            dummy = commentTokens.nextToken();
                        }
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            int firstLeftParenIndex = keys.indexOf(40);
                            int firstRightParenIndex = keys.indexOf(41);
                            String referencingColumns = keys.substring(firstLeftParenIndex + 1, firstRightParenIndex);
                            StringTokenizer referencingColumnsTokenizer = new StringTokenizer(referencingColumns, ", ");
                            int secondLeftParenIndex = keys.indexOf(40, firstRightParenIndex + 1);
                            int secondRightParenIndex = keys.indexOf(41, firstRightParenIndex + 1);
                            String referencedColumns = keys.substring(secondLeftParenIndex + 1, secondRightParenIndex);
                            StringTokenizer referencedColumnsTokenizer = new StringTokenizer(referencedColumns, ", ");
                            int slashIndex = keys.indexOf(47);
                            String referencedTable = keys.substring(slashIndex + 1, secondLeftParenIndex);
                            int keySeq = 0;
                            while (referencingColumnsTokenizer.hasMoreTokens()) {
                                String referencingColumn = referencingColumnsTokenizer.nextToken();
                                byte[][] tuple = new byte[14][];
                                tuple[4] = foreignCatalog == null ? null : this.s2b(foreignCatalog);
                                tuple[5] = foreignSchema == null ? null : this.s2b(foreignSchema);
                                dummy = fkresults.getString("Name");
                                if (dummy.compareTo(foreignTableWithCase) != 0) continue;
                                tuple[6] = this.s2b(dummy);
                                tuple[7] = this.s2b(referencingColumn);
                                tuple[0] = primaryCatalog == null ? null : this.s2b(primaryCatalog);
                                byte[] byArray = tuple[1] = primarySchema == null ? null : this.s2b(primarySchema);
                                if (referencedTable.compareTo(primaryTableWithCase) != 0) continue;
                                tuple[2] = this.s2b(referencedTable);
                                tuple[3] = this.s2b(referencedColumnsTokenizer.nextToken());
                                tuple[8] = Integer.toString(keySeq).getBytes();
                                int[] actions = this.getForeignKeyActions(keys);
                                tuple[9] = Integer.toString(actions[1]).getBytes();
                                tuple[10] = Integer.toString(actions[0]).getBytes();
                                tuple[11] = null;
                                tuple[12] = null;
                                tuple[13] = Integer.toString(7).getBytes();
                                tuples.add(tuple);
                                ++keySeq;
                            }
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples);
                    Object var33_32 = null;
                    if (fkresults == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var33_33 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (Exception sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        fkresults = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (Exception sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                fkresults = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                stmt = null;
            }
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList());
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.getServerMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.getServerMinorVersion();
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.conn.getServerVersion();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            return 2;
        }
        return 0;
    }

    public int getDriverMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    public int getDriverMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    public String getDriverName() throws SQLException {
        return "MySQL-AB JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "mysql-connector-java-3.1.4-beta ( $Date: 2004/08/12 20:28:29 $, $Revision: 1.27.4.42 $ )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 255), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            Statement stmt;
            block21: {
                stmt = null;
                java.sql.ResultSet fkresults = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    if (this.conn.getIO().versionMeetsMinimum(3, 23, 50)) {
                        String db = this.database;
                        if (catalog != null && !catalog.equals("")) {
                            db = catalog;
                        }
                        fkresults = this.extractForeignKeyFromCreateTable(this.conn, this, db, null);
                    } else {
                        String databasePart = "";
                        if (catalog != null) {
                            if (!catalog.equals("")) {
                                databasePart = " FROM " + catalog;
                            }
                        } else {
                            databasePart = " FROM " + this.database;
                        }
                        fkresults = stmt.executeQuery("show table status " + databasePart);
                    }
                    String tableNameWithCase = this.getTableNameWithCase(table);
                    ArrayList tuples = new ArrayList();
                    while (fkresults.next()) {
                        StringTokenizer commentTokens;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(SUPPORTS_FK) || (comment = fkresults.getString("Comment").trim()) == null || !(commentTokens = new StringTokenizer(comment, ";", false)).hasMoreTokens()) continue;
                        commentTokens.nextToken();
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            this.getExportKeyResults(catalog, tableNameWithCase, keys, tuples, fkresults.getString("Name"));
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples);
                    Object var14_13 = null;
                    if (fkresults == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (SQLException sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        fkresults = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                fkresults = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    AssertionFailedException.shouldNotHappen(ex);
                }
                stmt = null;
            }
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList());
    }

    public String getExtraNameCharacters() throws SQLException {
        return "#@";
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn.supportsQuotedIdentifiers()) {
            if (!this.conn.useAnsiQuotedIdentifiers()) {
                return "`";
            }
            return "\"";
        }
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 255), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this.conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            java.sql.ResultSet resultSet;
            Statement stmt;
            block21: {
                stmt = null;
                java.sql.ResultSet fkresults = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    if (this.conn.getIO().versionMeetsMinimum(3, 23, 50)) {
                        String db = this.database;
                        if (catalog != null && !catalog.equals("")) {
                            db = catalog;
                        }
                        fkresults = this.extractForeignKeyFromCreateTable(this.conn, this, db, table);
                    } else {
                        String databasePart = "";
                        if (catalog != null) {
                            if (!catalog.equals("")) {
                                databasePart = " FROM " + catalog;
                            }
                        } else {
                            databasePart = " FROM " + this.database;
                        }
                        fkresults = stmt.executeQuery("show table status " + databasePart + " like '" + table + "'");
                    }
                    ArrayList tuples = new ArrayList();
                    while (fkresults.next()) {
                        StringTokenizer commentTokens;
                        String comment;
                        String tableType = fkresults.getString("Type");
                        if (tableType == null || !tableType.equalsIgnoreCase("innodb") && !tableType.equalsIgnoreCase(SUPPORTS_FK) || (comment = fkresults.getString("Comment").trim()) == null || !(commentTokens = new StringTokenizer(comment, ";", false)).hasMoreTokens()) continue;
                        commentTokens.nextToken();
                        while (commentTokens.hasMoreTokens()) {
                            String keys = commentTokens.nextToken();
                            this.getImportKeyResults(catalog, table, keys, tuples);
                        }
                    }
                    resultSet = this.buildResultSet(fields, tuples);
                    Object var13_12 = null;
                    if (fkresults == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    if (fkresults != null) {
                        try {
                            fkresults.close();
                        }
                        catch (SQLException sqlEx) {
                            AssertionFailedException.shouldNotHappen(sqlEx);
                        }
                        fkresults = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {
                            AssertionFailedException.shouldNotHappen(ex);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    fkresults.close();
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
                fkresults = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    AssertionFailedException.shouldNotHappen(ex);
                }
                stmt = null;
            }
            return resultSet;
        }
        return this.buildResultSet(fields, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        Exception ex22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block14: {
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            stmt = null;
            java.sql.ResultSet results = null;
            try {
                java.sql.ResultSet indexInfo;
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                StringBuffer queryBuf = new StringBuffer("SHOW INDEX FROM ");
                queryBuf.append(this.quotedId);
                queryBuf.append(table);
                queryBuf.append(this.quotedId);
                queryBuf.append(databasePart);
                results = stmt.executeQuery(queryBuf.toString());
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 4), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 4, 10), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
                ArrayList<byte[][]> rows = new ArrayList<byte[][]>();
                while (results.next()) {
                    byte[][] row = new byte[14][];
                    row[0] = catalog == null ? new byte[]{} : this.s2b(catalog);
                    row[1] = null;
                    row[2] = results.getBytes("Table");
                    row[3] = results.getInt("Non_unique") != 0 ? this.s2b("true") : this.s2b("false");
                    row[4] = new byte[0];
                    row[5] = results.getBytes("Key_name");
                    row[6] = Integer.toString(3).getBytes();
                    row[7] = results.getBytes("Seq_in_index");
                    row[8] = results.getBytes("Column_name");
                    row[9] = results.getBytes("Collation");
                    row[10] = results.getBytes("Cardinality");
                    row[11] = this.s2b("0");
                    row[12] = null;
                    rows.add(row);
                }
                resultSet = indexInfo = this.buildResultSet(fields, rows);
                Object var15_14 = null;
                if (results == null) break block14;
            }
            catch (Throwable throwable) {
                block17: {
                    Exception ex22;
                    Object var15_15 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt == null) break block17;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
        }
        return resultSet;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 256;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.getMaxBuf() - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Exception ex22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block16: {
            Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
            String dbSub = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    dbSub = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                dbSub = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (table == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            stmt = null;
            java.sql.ResultSet rs = null;
            try {
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                StringBuffer queryBuf = new StringBuffer("SHOW KEYS FROM ");
                queryBuf.append(this.quotedId);
                queryBuf.append(table);
                queryBuf.append(this.quotedId);
                queryBuf.append(dbSub);
                rs = stmt.executeQuery(queryBuf.toString());
                ArrayList tuples = new ArrayList();
                TreeMap<String, byte[][]> sortMap = new TreeMap<String, byte[][]>();
                while (rs.next()) {
                    String keyType = rs.getString("Key_name");
                    if (keyType == null || !keyType.equalsIgnoreCase("PRIMARY") && !keyType.equalsIgnoreCase("PRI")) continue;
                    byte[][] tuple = new byte[6][];
                    tuple[0] = catalog == null ? new byte[]{} : this.s2b(catalog);
                    tuple[1] = null;
                    tuple[2] = this.s2b(table);
                    String columnName = rs.getString("Column_name");
                    tuple[3] = this.s2b(columnName);
                    tuple[4] = this.s2b(rs.getString("Seq_in_index"));
                    tuple[5] = this.s2b(keyType);
                    sortMap.put(columnName, tuple);
                }
                Iterator sortedIterator = sortMap.values().iterator();
                while (sortedIterator.hasNext()) {
                    tuples.add(sortedIterator.next());
                }
                resultSet = this.buildResultSet(fields, tuples);
                Object var15_14 = null;
                if (rs == null) break block16;
            }
            catch (Throwable throwable) {
                block19: {
                    Exception ex22;
                    Object var15_15 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) break block19;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<String> proceduresToExtractList;
        Field[] fields;
        block22: {
            if (procedureNamePattern == null) {
                // empty if block
            }
            if (columnNamePattern == null) {
                // empty if block
            }
            fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
            proceduresToExtractList = new ArrayList<String>();
            if (this.supportsStoredProcedures()) {
                java.sql.ResultSet procedureNameRs;
                PreparedStatement procedureNameStmt;
                if (procedureNamePattern.indexOf("%") == -1 && procedureNamePattern.indexOf("?") == -1) {
                    proceduresToExtractList.add(procedureNamePattern);
                } else {
                    SQLException sqlEx22;
                    SQLException rethrowSqlEx;
                    block20: {
                        procedureNameStmt = null;
                        procedureNameRs = null;
                        procedureNameRs = this.getProcedures(catalog, schemaPattern, procedureNamePattern);
                        Collections.sort(proceduresToExtractList);
                        while (procedureNameRs.next()) {
                            proceduresToExtractList.add(procedureNameRs.getString(3));
                        }
                        Object var10_9 = null;
                        rethrowSqlEx = null;
                        if (procedureNameRs == null) break block20;
                        try {
                            procedureNameRs.close();
                        }
                        catch (SQLException sqlEx22) {
                            rethrowSqlEx = sqlEx22;
                        }
                    }
                    if (procedureNameStmt != null) {
                        try {
                            procedureNameStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            rethrowSqlEx = sqlEx22;
                        }
                    }
                    if (rethrowSqlEx != null) {
                        throw rethrowSqlEx;
                    }
                }
                break block22;
                catch (Throwable throwable) {
                    SQLException sqlEx22;
                    Object var10_10 = null;
                    SQLException rethrowSqlEx = null;
                    if (procedureNameRs != null) {
                        try {
                            procedureNameRs.close();
                        }
                        catch (SQLException sqlEx22) {
                            rethrowSqlEx = sqlEx22;
                        }
                    }
                    if (procedureNameStmt != null) {
                        try {
                            procedureNameStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            rethrowSqlEx = sqlEx22;
                        }
                    }
                    if (rethrowSqlEx != null) {
                        throw rethrowSqlEx;
                    }
                    throw throwable;
                }
            }
        }
        ArrayList resultRows = new ArrayList();
        Iterator iter = proceduresToExtractList.iterator();
        while (iter.hasNext()) {
            String procName = (String)iter.next();
            this.getCallStmtParameterTypes(procName, columnNamePattern, resultRows);
        }
        return this.buildResultSet(fields, resultRows);
    }

    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (procedureNamePattern == null || procedureNamePattern.length() == 0) {
            throw new SQLException("Procedure name pattern can not be NULL or empty.", "S1009");
        }
        Field[] fields = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "reserved1", 1, 0), new Field("", "reserved2", 1, 0), new Field("", "reserved3", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        ArrayList<byte[][]> procedureRows = new ArrayList<byte[][]>();
        if (this.supportsStoredProcedures()) {
            SQLException sqlEx32;
            SQLException rethrowSqlEx2;
            PreparedStatement proceduresStmt;
            block20: {
                proceduresStmt = null;
                java.sql.ResultSet proceduresRs = null;
                try {
                    proceduresStmt = this.conn.clientPrepareStatement("SELECT name FROM mysql.proc WHERE name like ? ORDER BY name");
                    int nameIndex = 1;
                    if (proceduresStmt.getMaxRows() != 0) {
                        proceduresStmt.setMaxRows(0);
                    }
                    proceduresStmt.setString(1, procedureNamePattern);
                    try {
                        proceduresRs = proceduresStmt.executeQuery();
                    }
                    catch (SQLException sqlEx2) {
                        proceduresStmt.close();
                        proceduresStmt = this.conn.clientPrepareStatement("SHOW PROCEDURE STATUS LIKE ?");
                        if (proceduresStmt.getMaxRows() != 0) {
                            proceduresStmt.setMaxRows(0);
                        }
                        proceduresStmt.setString(1, procedureNamePattern);
                        proceduresRs = proceduresStmt.executeQuery();
                        nameIndex = this.conn.getIO().versionMeetsMinimum(5, 0, 1) ? 2 : 1;
                    }
                    while (proceduresRs.next()) {
                        byte[][] rowData = new byte[][]{null, null, this.s2b(proceduresRs.getString(nameIndex)), null, null, null, null, this.s2b(Integer.toString(0))};
                        procedureRows.add(rowData);
                    }
                    Object var11_11 = null;
                    rethrowSqlEx2 = null;
                    if (proceduresRs == null) break block20;
                }
                catch (Throwable throwable) {
                    SQLException sqlEx32;
                    Object var11_12 = null;
                    SQLException rethrowSqlEx2 = null;
                    if (proceduresRs != null) {
                        try {
                            proceduresRs.close();
                        }
                        catch (SQLException sqlEx32) {
                            rethrowSqlEx2 = sqlEx32;
                        }
                    }
                    if (proceduresStmt != null) {
                        try {
                            proceduresStmt.close();
                        }
                        catch (SQLException sqlEx32) {
                            rethrowSqlEx2 = sqlEx32;
                        }
                    }
                    if (rethrowSqlEx2 != null) {
                        throw rethrowSqlEx2;
                    }
                    throw throwable;
                }
                try {
                    proceduresRs.close();
                }
                catch (SQLException sqlEx32) {
                    rethrowSqlEx2 = sqlEx32;
                }
            }
            if (proceduresStmt != null) {
                try {
                    proceduresStmt.close();
                }
                catch (SQLException sqlEx32) {
                    rethrowSqlEx2 = sqlEx32;
                }
            }
            if (rethrowSqlEx2 != null) {
                throw rethrowSqlEx2;
            }
        }
        return this.buildResultSet(fields, procedureRows);
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public int getSQLStateType() throws SQLException {
        if (this.conn.getIO().versionMeetsMinimum(4, 1, 0)) {
            return 2;
        }
        if (this.conn.getUseSqlStateCodes()) {
            return 2;
        }
        return 1;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        ArrayList tuples = new ArrayList();
        java.sql.ResultSet results = this.buildResultSet(fields, tuples);
        return results;
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getStringFunctions() throws SQLException {
        return "ASCII,BIN,BIT_LENGTH,CHAR,CHARACTER_LENGTH,CHAR_LENGTH,CONCAT,CONCAT_WS,CONV,ELT,EXPORT_SET,FIELD,FIND_IN_SET,HEX,INSERT,INSTR,LCASE,LEFT,LENGTH,LOAD_FILE,LOCATE,LOCATE,LOWER,LPAD,LTRIM,MAKE_SET,MATCH,MID,OCT,OCTET_LENGTH,ORD,POSITION,QUOTE,REPEAT,REPLACE,REVERSE,RIGHT,RPAD,RTRIM,SOUNDEX,SPACE,STRCMP,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public java.sql.ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TABLE_NAME", 1, 32), new Field("", "SUPERTABLE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public java.sql.ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TABLE_CAT", 1, 32), new Field("", "TABLE_SCHEM", 1, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "SUPERTYPE_CAT", 1, 32), new Field("", "SUPERTYPE_SCHEM", 1, 32), new Field("", "SUPERTYPE_NAME", 1, 32)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList<byte[][]> grantRows;
        Field[] fields;
        block25: {
            Exception ex32;
            Statement stmt;
            block22: {
                fields = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
                StringBuffer grantQuery = new StringBuffer("SELECT host,db,table_name,grantor,user,table_priv from mysql.tables_priv ");
                grantQuery.append(" WHERE ");
                if (catalog != null && catalog.length() != 0) {
                    grantQuery.append(" db='");
                    grantQuery.append(catalog);
                    grantQuery.append("' AND ");
                }
                grantQuery.append("table_name like '");
                grantQuery.append(tableNamePattern);
                grantQuery.append("'");
                java.sql.ResultSet results = null;
                grantRows = new ArrayList<byte[][]>();
                stmt = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    results = stmt.executeQuery(grantQuery.toString());
                    while (results.next()) {
                        String allPrivileges;
                        String host = results.getString(1);
                        String db = results.getString(2);
                        String table = results.getString(3);
                        String grantor = results.getString(4);
                        String user = results.getString(5);
                        if (user == null || user.length() == 0) {
                            user = "%";
                        }
                        StringBuffer fullUser = new StringBuffer(user);
                        if (host != null && this.conn.getUseHostsInPrivileges()) {
                            fullUser.append("@");
                            fullUser.append(host);
                        }
                        if ((allPrivileges = results.getString(6)) == null) continue;
                        allPrivileges = allPrivileges.toUpperCase();
                        StringTokenizer st = new StringTokenizer(allPrivileges, ",");
                        while (st.hasMoreTokens()) {
                            Exception ex22;
                            Object var21_20;
                            String privilege = st.nextToken().trim();
                            java.sql.ResultSet columnResults = null;
                            try {
                                columnResults = this.getColumns(catalog, schemaPattern, table, "%");
                                while (columnResults.next()) {
                                    byte[][] tuple = new byte[8][];
                                    tuple[0] = this.s2b(db);
                                    tuple[1] = null;
                                    tuple[2] = this.s2b(table);
                                    tuple[3] = (byte[])(grantor != null ? this.s2b(grantor) : null);
                                    tuple[4] = this.s2b(fullUser.toString());
                                    tuple[5] = this.s2b(privilege);
                                    tuple[6] = null;
                                    grantRows.add(tuple);
                                }
                                var21_20 = null;
                                if (columnResults == null) continue;
                            }
                            catch (Throwable throwable) {
                                var21_20 = null;
                                if (columnResults != null) {
                                    try {
                                        columnResults.close();
                                    }
                                    catch (Exception ex22) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                columnResults.close();
                            }
                            catch (Exception ex22) {}
                        }
                    }
                    Object var24_23 = null;
                    if (results == null) break block22;
                }
                catch (Throwable throwable) {
                    Exception ex32;
                    Object var24_24 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex32) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex32) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    results.close();
                }
                catch (Exception ex32) {
                    // empty catch block
                }
                results = null;
            }
            if (stmt == null) break block25;
            try {
                stmt.close();
            }
            catch (Exception ex32) {
                // empty catch block
            }
            stmt = null;
            {
            }
        }
        return this.buildResultSet(fields, grantRows);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        Field[] fields = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] tableTypeRow = new byte[][]{TABLE_AS_BYTES};
        tuples.add(tableTypeRow);
        if (this.conn.getIO().versionMeetsMinimum(5, 0, 1)) {
            byte[][] viewTypeRow = new byte[][]{VIEW_AS_BYTES};
            tuples.add(viewTypeRow);
        }
        byte[][] tempTypeRow = new byte[][]{this.s2b("LOCAL TEMPORARY")};
        tuples.add(tempTypeRow);
        return this.buildResultSet(fields, tuples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Exception ex22;
        java.sql.ResultSet resultSet;
        Statement stmt;
        block35: {
            String databasePart = "";
            if (catalog != null) {
                if (!catalog.equals("")) {
                    databasePart = " FROM " + this.quotedId + catalog + this.quotedId;
                }
            } else {
                databasePart = " FROM " + this.quotedId + this.database + this.quotedId;
            }
            if (tableNamePattern == null) {
                tableNamePattern = "%";
            }
            stmt = null;
            java.sql.ResultSet results = null;
            try {
                java.sql.ResultSet tables;
                stmt = this.conn.createStatement();
                stmt.setEscapeProcessing(false);
                results = stmt.executeQuery("SHOW TABLES " + databasePart + " LIKE '" + tableNamePattern + "'");
                Field[] fields = new Field[]{new Field("", "TABLE_CAT", 12, catalog == null ? 0 : catalog.length()), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
                ArrayList tuples = new ArrayList();
                boolean shouldReportTables = false;
                boolean shouldReportViews = false;
                if (types == null) {
                    shouldReportTables = true;
                    shouldReportViews = true;
                } else {
                    for (int i = 0; i < types.length; ++i) {
                        if ("TABLE".equalsIgnoreCase(types[i])) {
                            shouldReportTables = true;
                        }
                        if (!"VIEW".equalsIgnoreCase(types[i])) continue;
                        shouldReportViews = true;
                    }
                }
                int typeColumnIndex = 0;
                boolean hasTableTypes = false;
                if (shouldReportViews) {
                    try {
                        typeColumnIndex = results.findColumn("table_type");
                        hasTableTypes = true;
                    }
                    catch (SQLException sqlEx) {
                        try {
                            typeColumnIndex = results.findColumn("Type");
                            hasTableTypes = true;
                        }
                        catch (SQLException sqlEx2) {
                            hasTableTypes = false;
                        }
                    }
                }
                TreeMap<String, byte[][]> tablesOrderedByName = null;
                TreeMap<String, byte[][]> viewsOrderedByName = null;
                while (results.next()) {
                    byte[][] row = new byte[5][];
                    row[0] = catalog == null ? new byte[]{} : this.s2b(catalog);
                    row[1] = null;
                    row[2] = results.getBytes(1);
                    row[4] = new byte[0];
                    if (hasTableTypes) {
                        String tableType = results.getString(typeColumnIndex);
                        if (("table".equalsIgnoreCase(tableType) || "base table".equalsIgnoreCase(tableType)) && shouldReportTables) {
                            row[3] = TABLE_AS_BYTES;
                            if (tablesOrderedByName == null) {
                                tablesOrderedByName = new TreeMap();
                            }
                            tablesOrderedByName.put(results.getString(1), row);
                            continue;
                        }
                        if ("view".equalsIgnoreCase(tableType) && shouldReportViews) {
                            row[3] = VIEW_AS_BYTES;
                            if (viewsOrderedByName == null) {
                                viewsOrderedByName = new TreeMap<String, byte[][]>();
                            }
                            viewsOrderedByName.put(results.getString(1), row);
                            continue;
                        }
                        row[3] = TABLE_AS_BYTES;
                        if (tablesOrderedByName == null) {
                            tablesOrderedByName = new TreeMap();
                        }
                        tablesOrderedByName.put(results.getString(1), row);
                        continue;
                    }
                    row[3] = TABLE_AS_BYTES;
                    if (tablesOrderedByName == null) {
                        tablesOrderedByName = new TreeMap<String, byte[][]>();
                    }
                    tablesOrderedByName.put(results.getString(1), row);
                }
                if (tablesOrderedByName != null) {
                    Iterator tablesIter = tablesOrderedByName.values().iterator();
                    while (tablesIter.hasNext()) {
                        tuples.add(tablesIter.next());
                    }
                }
                if (viewsOrderedByName != null) {
                    Iterator viewsIter = viewsOrderedByName.values().iterator();
                    while (viewsIter.hasNext()) {
                        tuples.add(viewsIter.next());
                    }
                }
                resultSet = tables = this.buildResultSet(fields, tuples);
                Object var19_20 = null;
                if (results == null) break block35;
            }
            catch (Throwable throwable) {
                block38: {
                    Exception ex22;
                    Object var19_21 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        results = null;
                    }
                    if (stmt == null) break block38;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                }
                throw throwable;
            }
            try {
                results.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            results = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
        }
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        Object rowVal = null;
        ArrayList<byte[][]> tuples = new ArrayList<byte[][]>();
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIT");
        rowVal[1] = Integer.toString(-7).getBytes();
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BIT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BOOL");
        rowVal[1] = Integer.toString(-7).getBytes();
        rowVal[2] = this.s2b("1");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BOOL");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYINT");
        rowVal[1] = Integer.toString(-6).getBytes();
        rowVal[2] = this.s2b("3");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("TINYINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BIGINT");
        rowVal[1] = Integer.toString(-5).getBytes();
        rowVal[2] = this.s2b("19");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("BIGINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONG VARBINARY");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONG VARBINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("MEDIUMBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONGBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONGBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYBLOB");
        rowVal[1] = Integer.toString(-4).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TINYBLOB");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("VARBINARY");
        rowVal[1] = Integer.toString(-3).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("VARBINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("BINARY");
        rowVal[1] = Integer.toString(-2).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("true");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("BINARY");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONG VARCHAR");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONG VARCHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("16777215");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("MEDIUMTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("LONGTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = Integer.toString(Integer.MAX_VALUE).getBytes();
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("LONGTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TINYTEXT");
        rowVal[1] = Integer.toString(-1).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TINYTEXT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("CHAR");
        rowVal[1] = Integer.toString(1).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("CHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("NUMERIC");
        rowVal[1] = Integer.toString(2).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("NUMERIC");
        rowVal[13] = this.s2b("308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DECIMAL");
        rowVal[1] = Integer.toString(3).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M[,D])] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DECIMAL");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("INTEGER");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("INTEGER");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("INT");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("INT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("MEDIUMINT");
        rowVal[1] = Integer.toString(4).getBytes();
        rowVal[2] = this.s2b("7");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("MEDIUMINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("SMALLINT");
        rowVal[1] = Integer.toString(5).getBytes();
        rowVal[2] = this.s2b("5");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M)] [UNSIGNED] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("true");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("SMALLINT");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("FLOAT");
        rowVal[1] = Integer.toString(7).getBytes();
        rowVal[2] = this.s2b("10");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("FLOAT");
        rowVal[13] = this.s2b("-38");
        rowVal[14] = this.s2b("38");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DOUBLE");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DOUBLE");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DOUBLE PRECISION");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("DOUBLE PRECISION");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("REAL");
        rowVal[1] = Integer.toString(8).getBytes();
        rowVal[2] = this.s2b("17");
        rowVal[3] = this.s2b("");
        rowVal[4] = this.s2b("");
        rowVal[5] = this.s2b("[(M,D)] [ZEROFILL]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("true");
        rowVal[12] = this.s2b("REAL");
        rowVal[13] = this.s2b("-308");
        rowVal[14] = this.s2b("308");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("VARCHAR");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("255");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("(M)");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("VARCHAR");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("ENUM");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("65535");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("ENUM");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("SET");
        rowVal[1] = Integer.toString(12).getBytes();
        rowVal[2] = this.s2b("64");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("SET");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DATE");
        rowVal[1] = Integer.toString(91).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("DATE");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TIME");
        rowVal[1] = Integer.toString(92).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TIME");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("DATETIME");
        rowVal[1] = Integer.toString(93).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("DATETIME");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        rowVal = new byte[18][];
        rowVal[0] = this.s2b("TIMESTAMP");
        rowVal[1] = Integer.toString(93).getBytes();
        rowVal[2] = this.s2b("0");
        rowVal[3] = this.s2b("'");
        rowVal[4] = this.s2b("'");
        rowVal[5] = this.s2b("[(M)]");
        rowVal[6] = Integer.toString(1).getBytes();
        rowVal[7] = this.s2b("false");
        rowVal[8] = Integer.toString(3).getBytes();
        rowVal[9] = this.s2b("false");
        rowVal[10] = this.s2b("false");
        rowVal[11] = this.s2b("false");
        rowVal[12] = this.s2b("TIMESTAMP");
        rowVal[13] = this.s2b("0");
        rowVal[14] = this.s2b("0");
        rowVal[15] = this.s2b("0");
        rowVal[16] = this.s2b("0");
        rowVal[17] = this.s2b("10");
        tuples.add((byte[][])rowVal);
        return this.buildResultSet(fields, tuples);
    }

    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        Field[] fields = new Field[]{new Field("", "TYPE_CAT", 12, 32), new Field("", "TYPE_SCHEM", 12, 32), new Field("", "TYPE_NAME", 12, 32), new Field("", "CLASS_NAME", 12, 32), new Field("", "DATA_TYPE", 12, 32), new Field("", "REMARKS", 12, 32)};
        ArrayList tuples = new ArrayList();
        return this.buildResultSet(fields, tuples);
    }

    public String getURL() throws SQLException {
        return this.conn.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() throws SQLException {
        if (this.conn.getUseHostsInPrivileges()) {
            Exception ex22;
            String string;
            Statement stmt;
            block12: {
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    stmt = this.conn.createStatement();
                    stmt.setEscapeProcessing(false);
                    rs = stmt.executeQuery("SELECT USER()");
                    rs.next();
                    string = rs.getString(1);
                    Object var5_4 = null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var5_5 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        rs = null;
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex22) {
                            AssertionFailedException.shouldNotHappen(ex22);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex22) {
                    AssertionFailedException.shouldNotHappen(ex22);
                }
                stmt = null;
            }
            return string;
        }
        return this.conn.getUser();
    }

    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] fields = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return this.buildResultSet(fields, new ArrayList());
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public List extractForeignKeyForTable(ArrayList rows, java.sql.ResultSet rs, String catalog) throws SQLException {
        byte[][] row = new byte[3][];
        row[0] = rs.getBytes(1);
        row[1] = this.s2b(SUPPORTS_FK);
        String createTableString = rs.getString(2);
        StringTokenizer lineTokenizer = new StringTokenizer(createTableString, "\n");
        StringBuffer commentBuf = new StringBuffer("comment; ");
        boolean firstTime = true;
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken().trim();
            String constraintName = null;
            if (StringUtils.startsWithIgnoreCase(line, "CONSTRAINT")) {
                boolean usingBackTicks = true;
                int beginPos = line.indexOf("`");
                if (beginPos == -1) {
                    beginPos = line.indexOf("\"");
                    usingBackTicks = false;
                }
                if (beginPos != -1) {
                    int endPos = -1;
                    endPos = usingBackTicks ? line.indexOf("`", beginPos + 1) : line.indexOf("\"", beginPos + 1);
                    if (endPos != -1) {
                        constraintName = line.substring(beginPos + 1, endPos);
                        line = line.substring(endPos + 1, line.length()).trim();
                    }
                }
            }
            if (!line.startsWith("FOREIGN KEY")) continue;
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            int lineLength = line.length();
            StringBuffer lineBuf = new StringBuffer(lineLength);
            for (int i = 0; i < lineLength; ++i) {
                char c = line.charAt(i);
                if (c == '`') continue;
                lineBuf.append(c);
            }
            line = lineBuf.toString();
            StringTokenizer keyTokens = new StringTokenizer(line, "()", false);
            keyTokens.nextToken();
            String localColumnNamesString = keyTokens.nextToken();
            String referCatalogTableString = keyTokens.nextToken();
            StringTokenizer referSchemaTable = new StringTokenizer(referCatalogTableString.trim(), " .");
            String referColumnNamesString = keyTokens.nextToken();
            referSchemaTable.nextToken();
            int numTokensLeft = referSchemaTable.countTokens();
            String referCatalog = null;
            String referTable = null;
            if (numTokensLeft == 2) {
                referCatalog = referSchemaTable.nextToken();
                referTable = referSchemaTable.nextToken();
            } else {
                referTable = referSchemaTable.nextToken();
                referCatalog = catalog;
            }
            if (!firstTime) {
                commentBuf.append("; ");
            } else {
                firstTime = false;
            }
            if (constraintName != null) {
                commentBuf.append(constraintName);
            } else {
                commentBuf.append("not_available");
            }
            commentBuf.append("(");
            commentBuf.append(localColumnNamesString);
            commentBuf.append(") REFER ");
            commentBuf.append(referCatalog);
            commentBuf.append("/");
            commentBuf.append(referTable);
            commentBuf.append("(");
            commentBuf.append(referColumnNamesString);
            commentBuf.append(")");
            int lastParenIndex = line.lastIndexOf(")");
            if (lastParenIndex == line.length() - 1) continue;
            String cascadeOptions = line.substring(lastParenIndex + 1);
            commentBuf.append(" ");
            commentBuf.append(cascadeOptions);
        }
        row[2] = this.s2b(commentBuf.toString());
        rows.add(row);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet extractForeignKeyFromCreateTable(java.sql.Connection connToUse, java.sql.DatabaseMetaData metadata, String catalog, String tableName) throws SQLException {
        Field[] fields;
        ArrayList rows;
        Statement stmt;
        java.sql.ResultSet rs;
        block14: {
            ArrayList<String> tableList = new ArrayList<String>();
            rs = null;
            stmt = null;
            if (tableName != null) {
                tableList.add(tableName);
            } else {
                block13: {
                    try {
                        rs = metadata.getTables(catalog, "", "%", new String[]{"TABLE"});
                        while (rs.next()) {
                            tableList.add(rs.getString("TABLE_NAME"));
                        }
                        Object var9_8 = null;
                        if (rs == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (rs != null) {
                            rs.close();
                        }
                        rs = null;
                        throw throwable;
                    }
                    rs.close();
                }
                rs = null;
                {
                }
            }
            rows = new ArrayList();
            fields = new Field[]{new Field("", "Name", 1, Integer.MAX_VALUE), new Field("", "Type", 1, 255), new Field("", "Comment", 1, Integer.MAX_VALUE)};
            int numTables = tableList.size();
            stmt = connToUse.createStatement();
            stmt.setEscapeProcessing(false);
            try {
                for (int i = 0; i < numTables; ++i) {
                    String tableToExtract = (String)tableList.get(i);
                    String query = "SHOW CREATE TABLE " + "`" + catalog + "`.`" + tableToExtract + "`";
                    rs = stmt.executeQuery(query);
                    while (rs.next()) {
                        this.extractForeignKeyForTable(rows, rs, catalog);
                    }
                }
                Object var15_16 = null;
                if (rs == null) break block14;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (rs != null) {
                    rs.close();
                }
                rs = null;
                if (stmt != null) {
                    stmt.close();
                }
                stmt = null;
                throw throwable;
            }
            rs.close();
        }
        rs = null;
        if (stmt != null) {
            stmt.close();
        }
        stmt = null;
        return this.buildResultSet(fields, rows);
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return !this.conn.getEmulateLocators();
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 0, 2) && !this.conn.getIO().versionMeetsMinimum(4, 0, 11);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(3, 3, 22);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (toType) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (toType) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1004 && (concurrency == 1007 || concurrency == 1008);
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1004;
    }

    public boolean supportsSavepoints() throws SQLException {
        MysqlIO mysql = this.conn.getIO();
        return mysql.versionMeetsMinimum(4, 0, 14) || mysql.versionMeetsMinimum(4, 1, 1);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(5, 0, 0);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 1, 0);
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.conn.supportsIsolationLevel()) {
            switch (level) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return this.conn.supportsTransactions();
    }

    public boolean supportsUnion() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.conn.getIO().versionMeetsMinimum(4, 0, 0);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getCallStmtParameterTypes(String procName, String parameterNamePattern, List resultRows) throws SQLException {
        String parameterDef;
        byte[] procNameAsBytes;
        block53: {
            SQLException sqlEx22;
            SQLException sqlExRethrow;
            Object var16_10;
            PreparedStatement paramRetrievalPreparedStatement;
            java.sql.ResultSet paramRetrievalRs;
            Statement paramRetrievalStmt;
            block46: {
                block45: {
                    paramRetrievalStmt = null;
                    paramRetrievalRs = null;
                    procNameAsBytes = null;
                    try {
                        procNameAsBytes = procName.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException ueEx) {
                        procNameAsBytes = this.s2b(procName);
                    }
                    parameterDef = null;
                    paramRetrievalPreparedStatement = null;
                    paramRetrievalPreparedStatement = this.conn.clientPrepareStatement("SELECT param_list FROM mysql.proc WHERE name=?");
                    if (paramRetrievalPreparedStatement.getMaxRows() != 0) {
                        paramRetrievalPreparedStatement.setMaxRows(0);
                    }
                    paramRetrievalPreparedStatement.setString(1, procName);
                    paramRetrievalRs = paramRetrievalPreparedStatement.executeQuery();
                    if (!paramRetrievalRs.next()) break block45;
                    parameterDef = paramRetrievalRs.getString(1);
                }
                var16_10 = null;
                sqlExRethrow = null;
                if (paramRetrievalRs == null) break block46;
                try {
                    paramRetrievalRs.close();
                }
                catch (SQLException sqlEx22) {
                    sqlExRethrow = sqlEx22;
                }
                paramRetrievalRs = null;
            }
            if (paramRetrievalPreparedStatement != null) {
                try {
                    paramRetrievalPreparedStatement.close();
                }
                catch (SQLException sqlEx22) {
                    sqlExRethrow = sqlEx22;
                }
                paramRetrievalPreparedStatement = null;
            }
            if (paramRetrievalStmt != null) {
                try {
                    paramRetrievalStmt.close();
                }
                catch (SQLException sqlEx22) {
                    sqlExRethrow = sqlEx22;
                }
                paramRetrievalStmt = null;
            }
            if (sqlExRethrow != null) {
                throw sqlExRethrow;
            }
            break block53;
            {
                catch (SQLException sqlEx3) {
                    paramRetrievalStmt = this.conn.createStatement();
                    if (paramRetrievalStmt.getMaxRows() != 0) {
                        paramRetrievalStmt.setMaxRows(0);
                    }
                    if ((paramRetrievalRs = paramRetrievalStmt.executeQuery("SHOW CREATE PROCEDURE " + procName)).next()) {
                        String procedureDef = paramRetrievalRs.getString("Create Procedure");
                        int openParenIndex = procedureDef.indexOf(40);
                        String beforeBegin = null;
                        int beginIndex = StringUtils.indexOfIgnoreCase(procedureDef, "\nbegin");
                        beforeBegin = beginIndex != -1 ? procedureDef.substring(0, beginIndex) : procedureDef;
                        int endParenIndex = beforeBegin.lastIndexOf(41);
                        if (openParenIndex == -1 || endParenIndex == -1) {
                            throw new SQLException("Internal error when parsing callable statement metadata", "S1000");
                        }
                        parameterDef = procedureDef.substring(openParenIndex + 1, endParenIndex);
                    }
                    var16_10 = null;
                    sqlExRethrow = null;
                    if (paramRetrievalRs != null) {
                        try {
                            paramRetrievalRs.close();
                        }
                        catch (SQLException sqlEx22) {
                            sqlExRethrow = sqlEx22;
                        }
                        paramRetrievalRs = null;
                    }
                    if (paramRetrievalPreparedStatement != null) {
                        try {
                            paramRetrievalPreparedStatement.close();
                        }
                        catch (SQLException sqlEx22) {
                            sqlExRethrow = sqlEx22;
                        }
                        paramRetrievalPreparedStatement = null;
                    }
                    if (paramRetrievalStmt != null) {
                        try {
                            paramRetrievalStmt.close();
                        }
                        catch (SQLException sqlEx22) {
                            sqlExRethrow = sqlEx22;
                        }
                        paramRetrievalStmt = null;
                    }
                    if (sqlExRethrow != null) {
                        throw sqlExRethrow;
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqlEx22;
                Object var16_11 = null;
                sqlExRethrow = null;
                if (paramRetrievalRs != null) {
                    try {
                        paramRetrievalRs.close();
                    }
                    catch (SQLException sqlEx22) {
                        sqlExRethrow = sqlEx22;
                    }
                    paramRetrievalRs = null;
                }
                if (paramRetrievalPreparedStatement != null) {
                    try {
                        paramRetrievalPreparedStatement.close();
                    }
                    catch (SQLException sqlEx22) {
                        sqlExRethrow = sqlEx22;
                    }
                    paramRetrievalPreparedStatement = null;
                }
                if (paramRetrievalStmt != null) {
                    try {
                        paramRetrievalStmt.close();
                    }
                    catch (SQLException sqlEx22) {
                        sqlExRethrow = sqlEx22;
                    }
                    paramRetrievalStmt = null;
                }
                if (sqlExRethrow == null) throw throwable;
                throw sqlExRethrow;
            }
        }
        if (parameterDef == null) return;
        List parseList = StringUtils.split(parameterDef, ",", true);
        int parseListLen = parseList.size();
        for (int i = 0; i < parseListLen; ++i) {
            String declaration = (String)parseList.get(i);
            StringTokenizer declarationTok = new StringTokenizer(declaration, " \t");
            String paramName = null;
            boolean isOutParam = false;
            boolean isInParam = false;
            if (!declarationTok.hasMoreTokens()) throw new SQLException("Internal error when parsing callable statement metadata (unknown output from 'SHOW CREATE PROCEDURE')", "S1000");
            String possibleParamName = declarationTok.nextToken();
            if (possibleParamName.equalsIgnoreCase("OUT")) {
                isOutParam = true;
                if (!declarationTok.hasMoreTokens()) throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("INOUT")) {
                isOutParam = true;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                paramName = declarationTok.nextToken();
            } else if (possibleParamName.equalsIgnoreCase("IN")) {
                isOutParam = false;
                isInParam = true;
                if (!declarationTok.hasMoreTokens()) throw new SQLException("Internal error when parsing callable statement metadata (missing parameter name)", "S1000");
                paramName = declarationTok.nextToken();
            } else {
                isOutParam = false;
                isInParam = true;
                paramName = possibleParamName;
            }
            TypeDescriptor typeDesc = null;
            if (!declarationTok.hasMoreTokens()) throw new SQLException("Internal error when parsing callable statement metadata (missing parameter type)", "S1000");
            StringBuffer typeInfoBuf = new StringBuffer(declarationTok.nextToken());
            while (declarationTok.hasMoreTokens()) {
                typeInfoBuf.append(declarationTok.nextToken());
            }
            String typeInfo = typeInfoBuf.toString();
            typeDesc = new TypeDescriptor(typeInfo, null);
            int wildCompareRes = StringUtils.wildCompare(paramName, parameterNamePattern);
            if (wildCompareRes == -1) continue;
            byte[][] row = new byte[14][];
            row[0] = null;
            row[1] = null;
            row[2] = procNameAsBytes;
            row[3] = this.s2b(paramName);
            row[4] = isInParam && isOutParam ? this.s2b(String.valueOf(2)) : (isInParam ? this.s2b(String.valueOf(1)) : (isOutParam ? this.s2b(String.valueOf(4)) : this.s2b(String.valueOf(0))));
            row[5] = this.s2b(Short.toString(typeDesc.dataType));
            row[6] = this.s2b(typeDesc.typeName);
            row[7] = this.s2b(Integer.toString(typeDesc.columnSize));
            row[8] = this.s2b(Integer.toString(typeDesc.bufferLength));
            row[9] = this.s2b(Integer.toString(typeDesc.decimalDigits));
            row[10] = this.s2b(Integer.toString(typeDesc.numPrecRadix));
            switch (typeDesc.nullability) {
                case 0: {
                    row[11] = this.s2b(Integer.toString(0));
                    break;
                }
                case 1: {
                    row[11] = this.s2b(Integer.toString(1));
                    break;
                }
                case 2: {
                    row[11] = this.s2b(Integer.toString(2));
                    break;
                }
                default: {
                    throw new SQLException("Internal error while parsing callable statement metadata (unknown nullability value fount)", "S1000");
                }
            }
            row[12] = null;
            resultRows.add(row);
        }
    }

    private int getCascadeDeleteOption(String cascadeOptions) {
        int onDeletePos = cascadeOptions.indexOf("ON DELETE");
        if (onDeletePos != -1) {
            String deleteOptions = cascadeOptions.substring(onDeletePos, cascadeOptions.length());
            if (deleteOptions.startsWith("ON DELETE CASCADE")) {
                return 0;
            }
            if (deleteOptions.startsWith("ON DELETE SET NULL")) {
                return 2;
            }
            if (deleteOptions.startsWith("ON DELETE RESTRICT")) {
                return 1;
            }
            if (deleteOptions.startsWith("ON DELETE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    private int getCascadeUpdateOption(String cascadeOptions) {
        int onUpdatePos = cascadeOptions.indexOf("ON UPDATE");
        if (onUpdatePos != -1) {
            String updateOptions = cascadeOptions.substring(onUpdatePos, cascadeOptions.length());
            if (updateOptions.startsWith("ON UPDATE CASCADE")) {
                return 0;
            }
            if (updateOptions.startsWith("ON UPDATE SET NULL")) {
                return 2;
            }
            if (updateOptions.startsWith("ON UPDATE RESTRICT")) {
                return 1;
            }
            if (updateOptions.startsWith("ON UPDATE NO ACTION")) {
                return 3;
            }
        }
        return 3;
    }

    private void getExportKeyResults(String catalog, String exportingTable, String keysComment, List tuples, String fkTableName) throws SQLException {
        this.getResultsImpl(catalog, exportingTable, keysComment, tuples, fkTableName, true);
    }

    private int[] getForeignKeyActions(String commentString) {
        int[] actions = new int[]{3, 3};
        int lastParenIndex = commentString.lastIndexOf(")");
        if (lastParenIndex != commentString.length() - 1) {
            String cascadeOptions = commentString.substring(lastParenIndex + 1).trim().toUpperCase();
            actions[0] = this.getCascadeDeleteOption(cascadeOptions);
            actions[1] = this.getCascadeUpdateOption(cascadeOptions);
        }
        return actions;
    }

    private void getImportKeyResults(String catalog, String importingTable, String keysComment, List tuples) throws SQLException {
        this.getResultsImpl(catalog, importingTable, keysComment, tuples, null, false);
    }

    private void getResultsImpl(String catalog, String table, String keysComment, List tuples, String fkTableName, boolean isExport) throws SQLException {
        int firstLeftParenIndex = keysComment.indexOf(40);
        String constraintName = keysComment.substring(0, firstLeftParenIndex).trim();
        keysComment = keysComment.substring(firstLeftParenIndex, keysComment.length());
        StringTokenizer keyTokens = new StringTokenizer(keysComment.trim(), "()", false);
        String localColumnNamesString = keyTokens.nextToken();
        StringTokenizer localColumnNames = new StringTokenizer(localColumnNamesString, " ,");
        String referCatalogTableString = keyTokens.nextToken();
        StringTokenizer referSchemaTable = new StringTokenizer(referCatalogTableString, " /");
        String referColumnNamesString = keyTokens.nextToken();
        StringTokenizer referColumnNames = new StringTokenizer(referColumnNamesString, " ,");
        referSchemaTable.nextToken();
        String referCatalog = referSchemaTable.nextToken();
        String referTable = referSchemaTable.nextToken();
        if (isExport && !referTable.equals(table)) {
            return;
        }
        if (localColumnNames.countTokens() != referColumnNames.countTokens()) {
            throw new SQLException("Error parsing foriegn keys definition", "S1000");
        }
        int keySeqIndex = 1;
        while (localColumnNames.hasMoreTokens()) {
            byte[][] tuple = new byte[14][];
            String localColumnName = localColumnNames.nextToken();
            String referColumnName = referColumnNames.nextToken();
            tuple[4] = catalog == null ? new byte[]{} : this.s2b(catalog);
            tuple[5] = null;
            tuple[6] = this.s2b(isExport ? fkTableName : table);
            tuple[7] = this.s2b(localColumnName);
            tuple[0] = this.s2b(referCatalog);
            tuple[1] = null;
            tuple[2] = this.s2b(isExport ? table : referTable);
            tuple[3] = this.s2b(referColumnName);
            tuple[8] = this.s2b(Integer.toString(keySeqIndex++));
            int[] actions = this.getForeignKeyActions(keysComment);
            tuple[9] = this.s2b(Integer.toString(actions[1]));
            tuple[10] = this.s2b(Integer.toString(actions[0]));
            tuple[11] = this.s2b(constraintName);
            tuple[12] = null;
            tuple[13] = this.s2b(Integer.toString(7));
            tuples.add(tuple);
        }
    }

    private String getTableNameWithCase(String table) {
        String tableNameWithCase = this.conn.lowerCaseTableNames() ? table.toLowerCase() : table;
        return tableNameWithCase;
    }

    private java.sql.ResultSet buildResultSet(Field[] fields, ArrayList rows) throws SQLException {
        int fieldsLength = fields.length;
        for (int i = 0; i < fieldsLength; ++i) {
            fields[i].setConnection(this.conn);
        }
        return new ResultSet(this.conn.getCatalog(), fields, new RowDataStatic(rows), this.conn, null);
    }

    private byte[] s2b(String s) {
        if (this.conn != null && this.conn.getUseUnicode()) {
            try {
                String encoding = this.conn.getEncoding();
                if (encoding == null) {
                    return s.getBytes();
                }
                SingleByteCharsetConverter converter = this.conn.getCharsetConverter(encoding);
                if (converter != null) {
                    return converter.toBytes(s);
                }
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException E) {
                return s.getBytes();
            }
        }
        return s.getBytes();
    }

    class TypeDescriptor {
        String isNullable;
        String typeName;
        int bufferLength;
        int charOctetLength;
        int columnSize;
        int decimalDigits;
        int nullability;
        int numPrecRadix = 10;
        short dataType;

        TypeDescriptor(String typeInfo, String nullabilityInfo) throws SQLException {
            String mysqlType = "";
            String fullMysqlType = null;
            mysqlType = typeInfo.indexOf("(") != -1 ? typeInfo.substring(0, typeInfo.indexOf("(")) : typeInfo;
            int indexOfUnsignedInMysqlType = mysqlType.toLowerCase().indexOf("unsigned");
            if (indexOfUnsignedInMysqlType != -1) {
                mysqlType = mysqlType.substring(0, indexOfUnsignedInMysqlType - 1);
            }
            fullMysqlType = typeInfo.toLowerCase().indexOf("unsigned") != -1 ? mysqlType + " unsigned" : mysqlType;
            if (DatabaseMetaData.this.conn.getCapitalizeTypeNames()) {
                fullMysqlType = fullMysqlType.toUpperCase();
            }
            this.dataType = (short)MysqlDefs.mysqlToJavaType(mysqlType);
            this.typeName = fullMysqlType;
            if (typeInfo != null) {
                if (StringUtils.startsWithIgnoreCase(typeInfo, "enum") || StringUtils.startsWithIgnoreCase(typeInfo, "set")) {
                    String temp = typeInfo.substring(typeInfo.indexOf("("), typeInfo.lastIndexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(temp, ",");
                    int maxLength = 0;
                    while (tokenizer.hasMoreTokens()) {
                        maxLength = Math.max(maxLength, tokenizer.nextToken().length() - 2);
                    }
                    this.columnSize = maxLength;
                    this.decimalDigits = 0;
                } else if (typeInfo.indexOf(",") != -1) {
                    this.columnSize = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, typeInfo.indexOf(",")));
                    this.decimalDigits = Integer.parseInt(typeInfo.substring(typeInfo.indexOf(",") + 1, typeInfo.indexOf(")")));
                } else {
                    this.columnSize = 0;
                    if (typeInfo.indexOf("(") != -1) {
                        int endParenIndex = typeInfo.indexOf(")");
                        if (endParenIndex == -1) {
                            endParenIndex = typeInfo.length();
                        }
                        this.columnSize = Integer.parseInt(typeInfo.substring(typeInfo.indexOf("(") + 1, endParenIndex));
                    } else if (typeInfo.equalsIgnoreCase("tinyint")) {
                        this.columnSize = 1;
                    } else if (typeInfo.equalsIgnoreCase("smallint")) {
                        this.columnSize = 6;
                    } else if (typeInfo.equalsIgnoreCase("mediumint")) {
                        this.columnSize = 6;
                    } else if (typeInfo.equalsIgnoreCase("int")) {
                        this.columnSize = 11;
                    } else if (typeInfo.equalsIgnoreCase("integer")) {
                        this.columnSize = 11;
                    } else if (typeInfo.equalsIgnoreCase("bigint")) {
                        this.columnSize = 25;
                    } else if (typeInfo.equalsIgnoreCase("int24")) {
                        this.columnSize = 25;
                    } else if (typeInfo.equalsIgnoreCase("real")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("float")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("decimal")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("numeric")) {
                        this.columnSize = 12;
                    } else if (typeInfo.equalsIgnoreCase("double")) {
                        this.columnSize = 22;
                    } else if (typeInfo.equalsIgnoreCase("char")) {
                        this.columnSize = 1;
                    } else if (typeInfo.equalsIgnoreCase("varchar")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("date")) {
                        this.columnSize = 10;
                    } else if (typeInfo.equalsIgnoreCase("time")) {
                        this.columnSize = 8;
                    } else if (typeInfo.equalsIgnoreCase("timestamp")) {
                        this.columnSize = 19;
                    } else if (typeInfo.equalsIgnoreCase("datetime")) {
                        this.columnSize = 19;
                    } else if (typeInfo.equalsIgnoreCase("tinyblob")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("blob")) {
                        this.columnSize = 65535;
                    } else if (typeInfo.equalsIgnoreCase("mediumblob")) {
                        this.columnSize = 16277215;
                    } else if (typeInfo.equalsIgnoreCase("longblob")) {
                        this.columnSize = Integer.MAX_VALUE;
                    } else if (typeInfo.equalsIgnoreCase("tinytext")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("text")) {
                        this.columnSize = 65535;
                    } else if (typeInfo.equalsIgnoreCase("mediumtext")) {
                        this.columnSize = 16277215;
                    } else if (typeInfo.equalsIgnoreCase("longtext")) {
                        this.columnSize = Integer.MAX_VALUE;
                    } else if (typeInfo.equalsIgnoreCase("enum")) {
                        this.columnSize = 255;
                    } else if (typeInfo.equalsIgnoreCase("set")) {
                        this.columnSize = 255;
                    }
                    this.decimalDigits = 0;
                }
            } else {
                this.decimalDigits = 0;
                this.columnSize = 0;
            }
            this.bufferLength = MysqlIO.getMaxBuf();
            this.numPrecRadix = 10;
            if (nullabilityInfo != null) {
                if (nullabilityInfo.equals("YES")) {
                    this.nullability = 1;
                    this.isNullable = "YES";
                } else {
                    this.nullability = 0;
                    this.isNullable = "NO";
                }
            } else {
                this.nullability = 0;
                this.isNullable = "NO";
            }
        }
    }
}

