/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private static final int NOT_OUTPUT_PARAMETER_INDICATOR = Integer.MIN_VALUE;
    protected CallableStatementParamInfo paramInfo;
    private ResultSet outputParameterResults;
    private int[] parameterIndexToRsIndex;
    private boolean hasOutputParams = false;
    private static final String PARAMETER_NAMESPACE_PREFIX = "@com_mysql_jdbc_outparam_";

    public CallableStatement(Connection conn, String sql, String catalog) throws SQLException {
        super(conn, conn.nativeSQL(sql), catalog);
        this.determineParameterTypes();
    }

    public CallableStatement(Connection conn, CallableStatementParamInfo paramInfo) throws SQLException {
        super(conn, paramInfo.nativeSql, paramInfo.catalogInUse);
        this.paramInfo = paramInfo;
    }

    public CallableStatement(Connection conn, String catalog) throws SQLException {
        super(conn, catalog, null);
        this.determineParameterTypes();
    }

    public Array getArray(int i) throws SQLException {
        return this.getOutputParameters().getArray(this.mapOutputParameterIndexToRsIndex(i));
    }

    public Array getArray(String parameterName) throws SQLException {
        return this.getOutputParameters().getArray(this.fixParameterName(parameterName));
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.getNamedParamIndex(parameterName, false), x, length);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.getNamedParamIndex(parameterName, false), x);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getOutputParameters().getBigDecimal(this.mapOutputParameterIndexToRsIndex(parameterIndex), scale);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getBigDecimal(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getOutputParameters().getBigDecimal(this.fixParameterName(parameterName));
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.getNamedParamIndex(parameterName, false), x, length);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getBlob(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return this.getOutputParameters().getBlob(this.fixParameterName(parameterName));
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.getNamedParamIndex(parameterName, false), x);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getBoolean(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getOutputParameters().getBoolean(this.fixParameterName(parameterName));
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.getNamedParamIndex(parameterName, false), x);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getByte(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public byte getByte(String parameterName) throws SQLException {
        return this.getOutputParameters().getByte(this.fixParameterName(parameterName));
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.getNamedParamIndex(parameterName, false), x);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getOutputParameters().getBytes(this.fixParameterName(parameterName));
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getBytes(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.getNamedParamIndex(parameterName, false), reader, length);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getClob(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Clob getClob(String parameterName) throws SQLException {
        return this.getOutputParameters().getClob(this.fixParameterName(parameterName));
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.getNamedParamIndex(parameterName, false), x, cal);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.getNamedParamIndex(parameterName, false), x);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputParameters().getDate(this.mapOutputParameterIndexToRsIndex(parameterIndex), cal);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getDate(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputParameters().getDate(this.fixParameterName(parameterName), cal);
    }

    public Date getDate(String parameterName) throws SQLException {
        return this.getOutputParameters().getDate(this.fixParameterName(parameterName));
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.getNamedParamIndex(parameterName, false), x);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getDouble(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public double getDouble(String parameterName) throws SQLException {
        return this.getOutputParameters().getDouble(this.fixParameterName(parameterName));
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.getNamedParamIndex(parameterName, false), x);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getFloat(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public float getFloat(String parameterName) throws SQLException {
        return this.getOutputParameters().getFloat(this.fixParameterName(parameterName));
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.getNamedParamIndex(parameterName, false), x);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getInt(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public int getInt(String parameterName) throws SQLException {
        return this.getOutputParameters().getInt(this.fixParameterName(parameterName));
    }

    public void setLong(String parameterName, long x) throws SQLException {
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getLong(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public long getLong(String parameterName) throws SQLException {
        return this.getOutputParameters().getLong(this.fixParameterName(parameterName));
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.getNamedParamIndex(parameterName, false), x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.getNamedParamIndex(parameterName, false), x);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        return this.getOutputParameters().getObject(this.mapOutputParameterIndexToRsIndex(parameterIndex), map);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        CallableStatementParam paramDescriptor = this.checkIsOutputParam(parameterIndex);
        return this.getOutputParameters().getObjectStoredProc(this.mapOutputParameterIndexToRsIndex(parameterIndex), paramDescriptor.desiredJdbcType);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.getOutputParameters().getObject(this.fixParameterName(parameterName), map);
    }

    public Object getObject(String parameterName) throws SQLException {
        return this.getOutputParameters().getObject(this.fixParameterName(parameterName));
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getRef(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Ref getRef(String parameterName) throws SQLException {
        return this.getOutputParameters().getRef(this.fixParameterName(parameterName));
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.getNamedParamIndex(parameterName, false), x);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getShort(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public short getShort(String parameterName) throws SQLException {
        return this.getOutputParameters().getShort(this.fixParameterName(parameterName));
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.getNamedParamIndex(parameterName, false), x);
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getString(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public String getString(String parameterName) throws SQLException {
        return this.getOutputParameters().getString(this.fixParameterName(parameterName));
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.getNamedParamIndex(parameterName, false), x, cal);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.getNamedParamIndex(parameterName, false), x);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputParameters().getTime(this.mapOutputParameterIndexToRsIndex(parameterIndex), cal);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getTime(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputParameters().getTime(this.fixParameterName(parameterName), cal);
    }

    public Time getTime(String parameterName) throws SQLException {
        return this.getOutputParameters().getTime(this.fixParameterName(parameterName));
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.getNamedParamIndex(parameterName, false), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.getNamedParamIndex(parameterName, false), x);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getOutputParameters().getTimestamp(this.mapOutputParameterIndexToRsIndex(parameterIndex), cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getTimestamp(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getOutputParameters().getTimestamp(this.fixParameterName(parameterName), cal);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getOutputParameters().getTimestamp(this.fixParameterName(parameterName));
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.getNamedParamIndex(parameterName, false), val);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return this.getOutputParameters().getURL(this.mapOutputParameterIndexToRsIndex(parameterIndex));
    }

    public URL getURL(String parameterName) throws SQLException {
        return this.getOutputParameters().getURL(this.fixParameterName(parameterName));
    }

    public void addBatch() throws SQLException {
        this.setOutParams();
        super.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean returnVal = false;
        this.checkClosed();
        this.checkStreamability();
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.setInOutParamsOnServer();
            this.setOutParams();
            returnVal = super.execute();
            this.retrieveOutParams();
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.checkStreamability();
        java.sql.ResultSet execResults = null;
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.setInOutParamsOnServer();
            this.setOutParams();
            execResults = super.executeQuery();
            this.retrieveOutParams();
        }
        return execResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate() throws SQLException {
        int returnVal = -1;
        this.checkClosed();
        this.checkStreamability();
        Object object = this.connection.getMutex();
        synchronized (object) {
            this.setInOutParamsOnServer();
            this.setOutParams();
            returnVal = super.executeUpdate();
            this.retrieveOutParams();
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInOutParamsOnServer() throws SQLException {
        if (this.paramInfo.numParameters > 0) {
            int parameterIndex = 0;
            Iterator paramIter = this.paramInfo.iterator();
            while (paramIter.hasNext()) {
                CallableStatementParam inParamInfo = (CallableStatementParam)paramIter.next();
                if (!inParamInfo.isOut || !inParamInfo.isIn) continue;
                String inOutParameterName = CallableStatement.mangleParameterName(inParamInfo.paramName);
                StringBuffer queryBuf = new StringBuffer(4 + inOutParameterName.length() + 1 + 1);
                queryBuf.append("SET ");
                queryBuf.append(inOutParameterName);
                queryBuf.append("=?");
                PreparedStatement setPstmt = null;
                try {
                    setPstmt = this.connection.clientPrepareStatement(queryBuf.toString());
                    byte[] parameterAsBytes = this.getBytesRepresentation(parameterIndex);
                    if (parameterAsBytes != null) {
                        setPstmt.setBytes(1, parameterAsBytes);
                    } else {
                        setPstmt.setNull(1, 0);
                    }
                    setPstmt.executeUpdate();
                }
                finally {
                    if (setPstmt == null) continue;
                    setPstmt.close();
                }
            }
            ++parameterIndex;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIsOutputParam(parameterIndex);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        CallableStatementParam paramDescriptor = this.checkIsOutputParam(parameterIndex);
        paramDescriptor.desiredJdbcType = sqlType;
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.getNamedParamIndex(parameterName, true), sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.getNamedParamIndex(parameterName, true), sqlType, typeName);
    }

    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.getNamedParamIndex(parameterName, true), sqlType);
    }

    public boolean wasNull() throws SQLException {
        return this.getOutputParameters().wasNull();
    }

    private int getNamedParamIndex(String paramName, boolean forOut) throws SQLException {
        if (paramName == null || paramName.length() == 0) {
            throw new SQLException(Messages.getString("CallableStatement.2"), "S1009");
        }
        CallableStatementParam namedParamInfo = this.paramInfo.getParameter(paramName);
        if (this.paramInfo == null) {
            throw new SQLException(Messages.getString("CallableStatement.3") + paramName + Messages.getString("CallableStatement.4"), "S1009");
        }
        if (forOut && !namedParamInfo.isOut) {
            throw new SQLException(Messages.getString("CallableStatement.5") + paramName + Messages.getString("CallableStatement.6"), "S1009");
        }
        return namedParamInfo.index + 1;
    }

    private void setOutParams() throws SQLException {
        if (this.paramInfo.numParameters > 0) {
            Iterator paramIter = this.paramInfo.iterator();
            while (paramIter.hasNext()) {
                CallableStatementParam outParamInfo = (CallableStatementParam)paramIter.next();
                if (!outParamInfo.isOut) continue;
                String outParameterName = CallableStatement.mangleParameterName(outParamInfo.paramName);
                this.setBytesNoEscapeNoQuotes(outParamInfo.index + 1, StringUtils.getBytes(outParameterName, this.charConverter, this.charEncoding, this.connection.getServerCharacterEncoding(), this.connection.parserKnowsUnicode()));
            }
        }
    }

    private ResultSet getOutputParameters() throws SQLException {
        if (this.outputParameterResults == null) {
            if (this.paramInfo.numberOfParameters() == 0) {
                throw new SQLException(Messages.getString("CallableStatement.7"), "S1009");
            }
            throw new SQLException(Messages.getString("CallableStatement.8"), "S1000");
        }
        return this.outputParameterResults;
    }

    private CallableStatementParam checkIsOutputParam(int paramIndex) throws SQLException {
        this.checkParameterIndexBounds(paramIndex);
        int localParamIndex = paramIndex - 1;
        CallableStatementParam paramDescriptor = this.paramInfo.getParameter(localParamIndex);
        if (!paramDescriptor.isOut) {
            throw new SQLException(Messages.getString("CallableStatement.9") + paramIndex + Messages.getString("CallableStatement.10"), "S1009");
        }
        this.hasOutputParams = true;
        return paramDescriptor;
    }

    private void checkParameterIndexBounds(int paramIndex) throws SQLException {
        int localParamIndex = paramIndex - 1;
        if (paramIndex < 0 || localParamIndex >= this.paramInfo.numberOfParameters()) {
            throw new SQLException(Messages.getString("CallableStatement.11") + paramIndex + Messages.getString("CallableStatement.12") + this.paramInfo.numberOfParameters() + Messages.getString("CallableStatement.13"), "S1009");
        }
    }

    private void checkStreamability() throws SQLException {
        if (this.hasOutputParams && this.createStreamingResultSet()) {
            throw new SQLException(Messages.getString("CallableStatement.14"), "S1C00");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineParameterTypes() throws SQLException {
        SQLException sqlExRethrow2;
        block8: {
            java.sql.ResultSet paramTypesRs = null;
            try {
                String procName = this.extractProcedureName();
                DatabaseMetaData dbmd = this.connection.getMetaData();
                paramTypesRs = dbmd.getProcedureColumns(null, null, procName, "%");
                this.paramInfo = new CallableStatementParamInfo(paramTypesRs);
                Object var5_4 = null;
                sqlExRethrow2 = null;
                if (paramTypesRs == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                SQLException sqlExRethrow2 = null;
                if (paramTypesRs != null) {
                    try {
                        paramTypesRs.close();
                    }
                    catch (SQLException sqlEx) {
                        sqlExRethrow2 = sqlEx;
                    }
                    paramTypesRs = null;
                }
                if (sqlExRethrow2 != null) {
                    throw sqlExRethrow2;
                }
                throw throwable;
            }
            try {
                paramTypesRs.close();
            }
            catch (SQLException sqlEx) {
                sqlExRethrow2 = sqlEx;
            }
            paramTypesRs = null;
        }
        if (sqlExRethrow2 != null) {
            throw sqlExRethrow2;
        }
    }

    private String extractProcedureName() throws SQLException {
        int endCallIndex = this.originalSql.toUpperCase().indexOf("CALL");
        if (endCallIndex != -1) {
            char c;
            StringBuffer nameBuf = new StringBuffer();
            String trimmedStatement = this.originalSql.substring(endCallIndex + 4).trim();
            int statementLength = trimmedStatement.length();
            for (int i = 0; i < statementLength && !Character.isWhitespace(c = trimmedStatement.charAt(i)) && c != '(' && c != '?'; ++i) {
                nameBuf.append(c);
            }
            return nameBuf.toString();
        }
        throw new SQLException(Messages.getString("CallableStatement.1"), "S1000");
    }

    private String fixParameterName(String paramNameIn) throws SQLException {
        if (paramNameIn == null || paramNameIn.length() == 0) {
            throw new SQLException(Messages.getString("CallableStatement.0") + paramNameIn == null ? Messages.getString("CallableStatement.15") : Messages.getString("CallableStatement.16"), "S1009");
        }
        return CallableStatement.mangleParameterName(paramNameIn);
    }

    private int mapOutputParameterIndexToRsIndex(int paramIndex) throws SQLException {
        this.checkParameterIndexBounds(paramIndex);
        int localParamIndex = paramIndex - 1;
        int rsIndex = this.parameterIndexToRsIndex[localParamIndex];
        if (rsIndex == Integer.MIN_VALUE) {
            throw new SQLException(Messages.getString("CallableStatement.21") + paramIndex + Messages.getString("CallableStatement.22"), "S1009");
        }
        return rsIndex + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveOutParams() throws SQLException {
        int numParameters = this.paramInfo.numberOfParameters();
        this.parameterIndexToRsIndex = new int[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            this.parameterIndexToRsIndex[i] = Integer.MIN_VALUE;
        }
        int localParamIndex = 0;
        if (numParameters > 0) {
            StringBuffer outParameterQuery = new StringBuffer("SELECT ");
            boolean firstParam = true;
            boolean hadOutputParams = false;
            Iterator paramIter = this.paramInfo.iterator();
            while (paramIter.hasNext()) {
                CallableStatementParam retrParamInfo = (CallableStatementParam)paramIter.next();
                if (!retrParamInfo.isOut) continue;
                hadOutputParams = true;
                this.parameterIndexToRsIndex[retrParamInfo.index] = localParamIndex++;
                String outParameterName = CallableStatement.mangleParameterName(retrParamInfo.paramName);
                if (!firstParam) {
                    outParameterQuery.append(",");
                } else {
                    firstParam = false;
                }
                if (!outParameterName.startsWith("@")) {
                    outParameterQuery.append('@');
                }
                outParameterQuery.append(outParameterName);
            }
            if (hadOutputParams) {
                Statement outParameterStmt = null;
                java.sql.ResultSet outParamRs = null;
                try {
                    outParameterStmt = this.connection.createStatement();
                    outParamRs = outParameterStmt.executeQuery(outParameterQuery.toString());
                    this.outputParameterResults = ((ResultSet)outParamRs).copy();
                    if (this.outputParameterResults.next()) return;
                    this.outputParameterResults.close();
                    this.outputParameterResults = null;
                    return;
                }
                finally {
                    if (outParameterStmt != null) {
                        outParameterStmt.close();
                    }
                }
            } else {
                this.outputParameterResults = null;
            }
            return;
        } else {
            this.outputParameterResults = null;
        }
    }

    private static String mangleParameterName(String origParameterName) {
        if (origParameterName == null) {
            return null;
        }
        int offset = 0;
        if (origParameterName.length() > 0 && origParameterName.charAt(0) == '@') {
            offset = 1;
        }
        StringBuffer paramNameBuf = new StringBuffer(PARAMETER_NAMESPACE_PREFIX.length() + origParameterName.length());
        paramNameBuf.append(PARAMETER_NAMESPACE_PREFIX);
        paramNameBuf.append(origParameterName.substring(offset));
        return paramNameBuf.toString();
    }

    class CallableStatementParamInfo {
        List parameterList;
        Map parameterMap;
        String catalogInUse;
        String nativeSql;
        int numParameters;

        CallableStatementParamInfo(java.sql.ResultSet paramTypesRs) throws SQLException {
            boolean hadRows = paramTypesRs.last();
            this.nativeSql = CallableStatement.this.originalSql;
            this.catalogInUse = CallableStatement.this.currentCatalog;
            if (hadRows) {
                this.numParameters = paramTypesRs.getRow();
                this.parameterList = new ArrayList(this.numParameters);
                this.parameterMap = new HashMap(this.numParameters);
                paramTypesRs.beforeFirst();
                this.addParametersFromDBMD(paramTypesRs);
            } else {
                this.numParameters = 0;
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        CallableStatementParam getParameter(String name) {
            return (CallableStatementParam)this.parameterMap.get(name);
        }

        CallableStatementParam getParameter(int index) {
            return (CallableStatementParam)this.parameterList.get(index);
        }

        Iterator iterator() {
            return this.parameterList.iterator();
        }

        int numberOfParameters() {
            return this.numParameters;
        }

        private void addParametersFromDBMD(java.sql.ResultSet paramTypesRs) throws SQLException {
            int i = 0;
            while (paramTypesRs.next()) {
                String paramName = paramTypesRs.getString(4);
                int inOutModifier = paramTypesRs.getInt(5);
                boolean isOutParameter = false;
                boolean isInParameter = false;
                if (inOutModifier == 2) {
                    isOutParameter = true;
                    isInParameter = true;
                } else if (inOutModifier == 1) {
                    isOutParameter = false;
                    isInParameter = true;
                } else if (inOutModifier == 4) {
                    isOutParameter = true;
                    isInParameter = false;
                }
                CallableStatementParam paramInfoToAdd = new CallableStatementParam(paramName, i++, isInParameter, isOutParameter);
                this.parameterList.add(paramInfoToAdd);
                this.parameterMap.put(paramName, paramInfoToAdd);
            }
        }
    }

    class CallableStatementParam {
        String paramName;
        boolean isIn;
        boolean isOut;
        int desiredJdbcType;
        int index;

        CallableStatementParam(String name, int idx, boolean in, boolean out) {
            this.paramName = name;
            this.isIn = in;
            this.isOut = out;
            this.index = idx;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

