// $Id: MSXBunsetsu.hh,v 1.11 2004/07/19 20:58:27 m9710797 Exp $

#ifndef __MSXBUNSETSU_HH__
#define __MSXBUNSETSU_HH__

#include "MSXDevice.hh"
#include "Rom.hh"

namespace openmsx {

class MSXBunsetsu : public MSXDevice
{
public:
	MSXBunsetsu(const XMLElement& config, const EmuTime& time);
	virtual ~MSXBunsetsu();
	
	virtual void reset(const EmuTime& time);
	
	virtual byte readMem(word address, const EmuTime& time);
	virtual void writeMem(word address, byte value, const EmuTime& time);  
	virtual const byte* getReadCacheLine(word start) const;
	virtual byte* getWriteCacheLine(word start) const;

private:
	Rom bunsetsuRom;
	Rom jisyoRom;
	int jisyoAddress;
};

} // namespace openmsx

#endif
