/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *       MOSIX $Id: msxctl.c,v 1.12 2001/04/12 16:53:00 amnons Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt, Amnon Shiloh
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */

#include "mos.h"

int
msxctl(msx_cmd_t cmd, int arg, void *resp, int len)
{
	struct mosixnet config[MAX_MOSNET_ENTS];
	struct decay_params *dec;
	struct process_info *pinfo;
	int val;
	int ofast, oslow, ointerval;
		
	switch(cmd)
	{
	case D_STAY: 
		return(msx_replace("/proc/mosix/admin/stay", 1));
	case D_NOSTAY: 
		return(msx_replace("/proc/mosix/admin/stay", 0));
	case D_LSTAY: 
		return(msx_replace("/proc/mosix/admin/lstay", 1));
	case D_NOLSTAY: 
		return(msx_replace("/proc/mosix/admin/lstay", 0));
	case D_BLOCK: 
		return(msx_replace("/proc/mosix/admin/block", 1));
	case D_NOBLOCK: 
		return(msx_replace("/proc/mosix/admin/block", 0));
	case D_EXPEL: 
		return(msx_write("/proc/mosix/admin/expel", 1));
	case D_BRING: 
		return(msx_write("/proc/mosix/admin/bring", 1));
	case D_QUIET: 
		return(msx_replace("/proc/mosix/admin/quiet", 1));
	case D_NOQUIET: 
		return(msx_replace("/proc/mosix/admin/quiet", 0));
	case D_MFS:
		return(msx_replace("/proc/mosix/admin/nomfs", 0));
	case D_NOMFS:
		return(msx_replace("/proc/mosix/admin/nomfs", 1));
	case D_GETSSPEED: 
		return(msx_read("/proc/mosix/admin/sspeed"));
	case D_SETSSPEED: 
		return(msx_write("/proc/mosix/admin/sspeed", arg));
	case D_GETSPEED: 
		return(msx_readnode(arg, "speed"));
	case D_SETSPEED: 
		return(msx_write("/proc/mosix/admin/speed", arg));
	case D_GETLOAD:	
		return(msx_readnode(arg, "load"));
	case D_GETMEM:
		if((*((int *)resp) = msx_readnode(arg, "tmem")) == -1)
			return(-1);
		return(msx_readnode(arg, "mem"));
	case D_GETRMEM: 
		if((*((int *)resp) = msx_readnode(arg, "tmem")) == -1)
			return(-1);
		return(msx_readnode(arg, "rmem"));
	case D_GETSTAT: 
		return(msx_readnode(arg, "status"));
	case D_GETUTIL: 
		return(msx_readnode(arg, "util"));
	case D_GETPE:
		return(msx_read("/proc/mosix/admin/mospe"));
	case D_GETCPUS:
		return(msx_readnode(arg, "cpus"));
	case D_MOSIX_TO_IP:
	{
		int i;
		int total;

		total = msx_readdata("/proc/mosix/admin/config", config,
				MAX_MOSNET_ENTS, sizeof(struct mosixnet));
		if(total <= 0)
			return(-1);
		for(i = 0 ; i < total && (arg < config[i].base ||
			arg > config[i].base + config[i].cnt - 1) ; i++)
			;
		if (i < total)
		{
			struct in_addr in = (*((struct sockaddr_in *)
						&(config[i].saddr))).sin_addr;
			in.s_addr = ntohl(in.s_addr);
			in.s_addr += arg - config[i].base;
			in.s_addr = htonl(in.s_addr);
			strcpy(resp, inet_ntoa(in));
		}
		else
		{
			errno = ENOENT;
			return -1;
		}
		return 0;
	}
	case D_IP_TO_MOSIX: 
		if (arg == 0)
			return(msx_read("/proc/mosix/admin/mospe"));
		{
			struct in_addr in;
			int total;
			int i;
			
			total = msx_readdata("/proc/mosix/admin/config", config,
						MAX_MOSNET_ENTS,
						sizeof(struct mosixnet));
			if(total <= 0)
				return(-1);
			for(i = 0 ; i < total ; i++)
			if(config[i].cnt)
			{
				in = (*((struct sockaddr_in *)
						&(config[i].saddr))).sin_addr;
				in.s_addr = ntohl(in.s_addr);
				if((unsigned)arg >= in.s_addr && (unsigned)arg <
						in.s_addr + config[i].cnt)
					return(config[i].base +
						((unsigned)arg - in.s_addr));
					
			}
			errno = ENOENT;
			return -1;
		}
	case D_GETNTUNE:
		return(msx_count_ints("/proc/mosix/admin/overheads"));
	case D_GETTUNE:
		return(msx_fill_ints("/proc/mosix/admin/overheads", (int *)resp,
									 len));
	case D_SETDECAY:
		errno = EINVAL;
		dec = (struct decay_params*)arg;
		if(dec->interval < 1 || dec->interval > 65535 ||
			dec->fast < 0 || dec->slow < dec->fast ||
			dec->slow > DECAY_QUOTIENT)
			return(-1);
		if(!msx_readval("/proc/mosix/admin/slowdecay", &oslow) ||
			!msx_readval("/proc/mosix/admin/fastdecay", &ofast) ||
			!msx_readval("/proc/mosix/admin/decayinterval",
				&ointerval))
			return(-1);
		if(!msx_write("/proc/mosix/admin/decayinterval", dec->interval))
			return(-1);
		if(dec->slow < ofast)
		{
			if(!msx_write("/proc/mosix/admin/fastdecay", dec->fast))
			{
				restinterval:
				val = errno;
				msx_write("/proc/mosix/admin/decayinterval",
								dec->interval);
				errno = val;
				return(-1);
			}
			if(!msx_write("/proc/mosix/admin/slowdecay", dec->slow))
			{
				val = errno;
				msx_write("/proc/mosix/admin/fastdecay", ofast);
				errno = val;
				goto restinterval;
				return(-1);
			}
		}
		else
		{
			if(!msx_write("/proc/mosix/admin/slowdecay", dec->slow))
				goto restinterval;
			if(!msx_write("/proc/mosix/admin/fastdecay", dec->fast))
			{
				val = errno;
				msx_write("/proc/mosix/admin/slowdecay", oslow);
				errno = val;
				goto restinterval;
			}
		}
		return 0;
	case D_GETDECAY:
		dec = (struct decay_params*)resp;
		if ((dec->interval =
			msx_read("/proc/mosix/admin/decayinterval")) == -1 ||
			(dec->slow =
			msx_read("/proc/mosix/admin/slowdecay")) == -1 ||
			(dec->fast =
				msx_read("/proc/mosix/admin/fastdecay")) == -1)
			return -1;
		return 0;
	case D_SETWHERETO:
		pinfo = (struct process_info*)arg;
		return(msx_writeproc(pinfo->pid, "goto", pinfo->where));
	default:
		return(-1);
	}
}

int
msx_lock(void)
{
	return(msx_write("/proc/self/lock", 1));
}

int
msx_unlock(void)
{
	return(msx_write("/proc/self/lock", 0));
}

int
msx_get_own(int *decay, int *time)
{
	return(msx_readval2("/proc/mosix/decay/own", decay, time));
}

int
msx_get_decayinterval(void)
{
	return(msx_read("/proc/mosix/admin/decayinterval"));
}

int
msx_get_fast(void)
{
	return(msx_read("/proc/mosix/decay/fast"));
}

int
msx_get_slow(void)
{
	return(msx_read("/proc/mosix/decay/slow"));
}

int
msx_get_cpujob(void)
{
	return(msx_read("/proc/mosix/decay/cpujob"));
}

int
msx_get_iojob(void)
{
	return(msx_read("/proc/mosix/decay/iojob"));
}

int
msx_get_slowdecay(void)
{
	return(msx_read("/proc/mosix/admin/slowdecay"));
}

int
msx_get_fastdecay(void)
{
	return(msx_read("/proc/mosix/admin/fastdecay"));
}

int
msx_migrate(int where)
{
	return(msx_write("/proc/self/migrate", where));
}
int
msx_where_is(pid_t pid)
{
	return(msx_readproc(pid, "where"));
}

int
msx_is_lock(pid_t pid)
{
	return(msx_readproc(pid, "lock"));
}

int
msx_send(pid_t pid, int node)
{
	return(msx_writeproc(pid, "goto", node));
}

int
msx_get_nmigs(pid_t pid)
{
	return(msx_readproc(pid, "nmigs"));
}

int
msx_where_am_i(void)
{
	return(msx_read("/proc/self/where"));
}

int
msx_self_is_lock(void)
{
	return(msx_read("/proc/self/lock"));
}

int
msx_self_get_nmigs(void)
{
	return(msx_read("/proc/self/nmigs"));
}

int
msx_send_back_home(pid_t pid)
{
	return(msx_writeproc(pid, "goto", D_GOBACKHOME));
}

int
msx_go_back_home()
{
	return(msx_write("/proc/self/migrate", D_GOBACKHOME));
}
