/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */
#ifndef _MOS_REQUEST_H
#define _MOS_REQUEST_H
#ifdef CONFIG_MOSIX

struct prequest
{
	struct prequest *rnext;		/* next in request chain */
	struct prequest *cnext;		/* caller chain */
	volatile char rflags;		/* coordination flags - see below */
	char command;			/* ... */
	int param;			/* optional parameter */
	int param2;			/* optional parameter */
	caddr_t ereply;		 	/* extended reply address */
	int len;			/* optional extended reply length */
	long reply;			/* reply, if only one longword */
	wait_queue_head_t waitq;	/* who is waiting for the reply */
};

/* flags: */

#define PR_WAITING	1       /* caller still waiting for the request */
#define PR_DONE	 	2	/* request complete */
#define PR_ERROR	4	/* request failed, reply contains errno */

/* commands: */

enum
{
PR_PROCFS_TASK_MEM = 1,
PR_PROCFS_GET_ENV,
PR_PROCFS_GET_ARG,
PR_PROCFS_GET_STAT_PARTS,
PR_PROCFS_GET_STATM,
PR_PROCFS_MAP_INFO,
PR_PROCFS_MEM_READ,
PR_PROCFS_MEM_WRITE,
PR_PROCFS_UPDATE_TIMES,
PR_PROCFS_GET_EXE,
PR_PTRACE_GET_STACK_LONG,
PR_PTRACE_PUT_STACK_LONG,
PR_PTRACE_GETREGS,
PR_PTRACE_SETREGS,
PR_PTRACE_PEEKUSER,
PR_PTRACE_POKEUSER,
PR_PTRACE_CONT,
PR_PTRACE_SINGLE_STEP,
PR_PTRACE_GETFPREGS,
PR_PTRACE_SETFPREGS,
PR_PTRACE_GETFPXREGS,
PR_PTRACE_SETFPXREGS,
PR_PTRACE_NOT_TRACED,
#ifdef CONFIG_MOSIX_DFSA
PR_DFSA_SYNCHRONIZE,
#endif /* CONFIG_MOSIX_DFSA */
};

#define	SHOULD_ASK_PROCESS(p)	(p && (p->mosix.dflags & DDEPUTY) && (p != current || !(p->mosix.dflags & DINSCHED)))

extern int request_process_arg2(struct task_struct *, void *, int, int, int);
#define request_process(_t, _b, _c, _a) request_process_arg2(_t, _b, _c, _a, 0)
extern char *request_process_to_buf_arg(struct task_struct *, char *, int, int);
#define request_process_to_buf(_p,_b,_c) request_process_to_buf_arg(_p,_b,_c,0)

extern char *fill_common_ps_info(int *);
extern int pick_ps(struct task_struct *, struct prequest *);
extern void store_common_ps_info(void);
extern void stop_storing_common_ps_info(void);
extern void process_requests(void);
extern void discard_requests(void);
extern void process_only_easy_requests(void);

struct proc_remote_stat_parts
{
	unsigned long vsize, eip, esp;
	long priority;
	unsigned long rss, start_code, end_code, start_stack;
	long processor;
};

/* routines in other parts of the kernel that are called by MOSIX: */

extern int proc_pid_environ(struct task_struct *, char *);
extern int proc_pid_cmdline(struct task_struct *, char *);
extern char *task_mem(struct mm_struct *, char *);
extern void proc_get_stat_parts(struct task_struct *, struct mm_struct *, struct proc_remote_stat_parts *);
extern int proc_pid_statm(struct task_struct *, char *);
struct vmamaps;
extern int proc_list_maps(struct vmamaps *, int);
extern void ref_mapped_files(struct vmamaps *, int);
extern int get_stack_long(struct task_struct *, int);
extern int put_stack_long(struct task_struct *, int, unsigned long);
extern void ptrace_putregs(unsigned long *);
extern void ptrace_getregs(unsigned long *);
extern unsigned long ptrace_peekuser(long);
extern void ptrace_pokeuser(long, long);
extern void ptrace_cont(int);
extern void ptrace_single_step(void);
struct user_i387_struct;
extern void ptrace_getfpregs(struct user_i387_struct *);
extern void ptrace_setfpregs(struct user_i387_struct *);
struct user_fxsr_struct;
extern void ptrace_getfpxregs(struct user_fxsr_struct *);
extern void ptrace_setfpxregs(struct user_fxsr_struct *);
extern struct file *first_executable(void); 

#endif /* CONFIG_MOSIX */
#endif
