;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

; Dumplisp.lisp

(in-package :ccl)

(defvar *save-exit-functions* nil 
  "List of (0-arg)functions to call before saving memory image")

(defvar *restore-lisp-functions* nil
  "List of (0-arg)functions to call after restoring saved image")


(declaim (special *lisp-system-pointer-functions*)) ; defined in l1-init.

(defun kill-lisp-pointers ()
  (setq * nil ** nil *** nil + nil ++ nil +++ nil - nil
        / nil // nil /// nil
        *open-file-streams* nil
         @ nil)
  (setq *eval-queue* nil)
  
  (if (boundp '*window-object-hash*)
    (clrhash (symbol-value '*window-object-hash*)))
  (setq *selected-window* nil)
  (setf (*%saved-method-var%*) nil)
  (setq *%periodic-tasks%* nil)
  (setq *event-dispatch-task* nil)
  (setq *module-file-alist* nil)        ; nuke paths to lisp 
  )


; this needs work for the new world order
(defun save-application (filename
                         &rest rest
                         &key init-file toplevel-function
                         error-handler application-class excise-compiler
                           clear-clos-caches )
  (declare (ignore init-file toplevel-function  excise-compiler error-handler application-class
                   resources clear-clos-caches ))
  (apply #'process-interrupt
                *initial-process*
                #'%save-application-internal
                filename
                rest))

(defun %save-application-internal (filename &key
                                            (init-file nil init-file-p)
                                            toplevel-function  ;????                                             
                                            error-handler ; meaningless unless application-class or *application* not lisp-development..
                                            application-class
                                            excise-compiler                                            
                                            (clear-clos-caches t))  
  (when (and application-class (neq  (class-of *application*)
                                     (if (symbolp application-class)
                                       (find-class application-class)
                                       application-class)))
    (setq *application* (make-instance application-class)))
  (when (not toplevel-function)
    (setq toplevel-function 
          #'(lambda ()
              (toplevel-function *application* 
                                 (if init-file-p
                                   init-file
                                   (application-init-file *application*))))))
  (when error-handler
    (make-application-error-handler *application* error-handler))
  
  (prepare-to-quit)
  (if clear-clos-caches (clear-clos-caches))
  (if excise-compiler (excise-compiler))
  (save-image (let ((fd (open-dumplisp-file filename)))
                #'(lambda () (%save-application fd )))
              ;This is a bit bogus.  Specifying an init-file arg means requesting
              ;the usual lisp startup actions (load init file, print greeting and
              ;run *lisp-startup-functions*).  Really should have some more
              ;explicit arguments for specifying this stuff.
              toplevel-function))

(defun save-image (save-function toplevel-function)
  (let ((toplevel (%set-toplevel)))
      (%set-toplevel #'(lambda ()
                         (setq *interrupt-level* -1)
                         (%set-toplevel toplevel)       ; in case *save-exit-functions* error
                         (dolist (f *save-exit-functions*)
                           (funcall f))
                         (kill-lisp-pointers)
                         (%set-toplevel
                          #'(lambda ()
                              (%set-toplevel toplevel-function)
                              (restore-lisp-pointers)))   ; do startup stuff
                         (funcall save-function)))
      (toplevel)))

(defun open-dumplisp-file (filename)
  (when (probe-file filename)
    (delete-file filename))
  (setq filename (create-file filename :if-exists :error))
  (fd-open filename (logior #o01 #o01000 #o0100)))

(defun excise-compiler ()
   (if *nx1-alphatizers* (clrhash *nx1-alphatizers*))
   (%init-misc 0 *ppc2-specials*)
   (setq *compile-definitions* nil)
   (flet ((remove-startup-function (name)
            (setq *lisp-system-pointer-functions*
                  (delete name *lisp-system-pointer-functions*
                          :key #'function-name))))
     (dolist (f '(*ppc-operand-vector-freelist*
                  *ppc-lap-instruction-freelist*
                  *ppc-lap-label-freelist*
                  *vinsn-varparts*
                  *vinsn-label-freelist*
                  *vinsn-freelist*))
       (remove-startup-function f)))
   (ff-call (%kernel-import arch::kernel-import-excise-library)
                :unsigned-fullword 2    ; magic number
                :void))

        


(defun %save-application (fd)
  (let* ((err (%%save-application fd)))
    (unless (eql err 0)
      (%err-disp err))))
  

#+ppc-target
(defppclapfunction %%save-application ((fd arg_z))
  (uuo_xalloc rzero rnil fd)
  (blr))
#+sparc-target
(defsparclapfunction %%save-application ((fd %arg_z))
  (retl)
  (uuo_xalloc %rzero %rnil fd))
   

(defun restore-lisp-pointers ()
  (restore-pascal-functions)
  (refresh-external-entrypoints)
  (dolist (f (reverse *lisp-system-pointer-functions*))
    (funcall f))
  (setq *foreground* t)                 ; Necessary if you save a world under MultiFinder and run it in UniFinder.
  (let ((restore-lisp-fns *restore-lisp-functions*)
        (user-pointer-fns *lisp-user-pointer-functions*)
        (lisp-startup-fns *lisp-startup-functions*))
    (unwind-protect
      (with-simple-restart (abort "Abort (possibly crucial) startup functions.")
        (let ((call-with-restart
               #'(lambda (f)
                   (with-simple-restart 
                     (continue "Skip (possibly crucial) startup function ~s."
                               (if (symbolp f) f (function-name f)))
                     (funcall f)))))
          (dolist (f restore-lisp-fns) (funcall call-with-restart f))
          (dolist (f (reverse user-pointer-fns)) (funcall call-with-restart f))
          (dolist (f (reverse lisp-startup-fns)) (funcall call-with-restart f))))
      (setq *interrupt-level* 0)))
  nil)


(defun  restore-pascal-functions ()
  (when (simple-vector-p %pascal-functions%)
    (dotimes (i (length %pascal-functions%))
      (let ((pfe (%svref %pascal-functions% i)))
        (when (vectorp pfe)
          (let ((trampoline (make-callback-trampoline i))
                (name (pfe.sym pfe)))
            (setf (pfe.routine-descriptor pfe) trampoline)
            (when name
              (set name trampoline))))))))

