;;;-*-Mode: LISP; Package: ccl -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

; l1-ppc-stack-groups.lisp
; low-level support for PPC stack groups and stack-backtrace printing

(in-package :ccl)









(defppclapfunction %get-kernel-global-from-offset ((offset arg_z))
  (check-nargs 1)
  (unbox-fixnum imm0 offset)
  (lwzx arg_z imm0 rnil)
  (blr))

(defppclapfunction %set-kernel-global-from-offset ((offset arg_y) (new-value arg_z))
  (check-nargs 2)
  (unbox-fixnum imm0 offset)
  (stwx new-value imm0 rnil)
  (blr))

(defppclapfunction %get-kernel-global-ptr-from-offset ((offset arg_y)
						       (ptr arg_z))
  (check-nargs 2)
  (unbox-fixnum imm0 offset)
  (lwzx imm0 rnil imm0)
  (stw imm0 arch::macptr.address ptr)
  (blr))




(defppclapfunction %stack-group-trampoline ((arg arg_z))
  (check-nargs 1)
  (mr arg_y nfn)
  (set-nargs 2)
  (lwz temp0 2 nfn)
  (ba .SPfuncall))





(defppclapfunction %fixnum-ref ((fixnum arg_y) #| &optional |# (offset arg_z))
  (cmpi cr0 nargs '1)
  (check-nargs 1 2)
  (bne cr0 @2-args)
  (mr fixnum offset)
  (li offset 0)
  @2-args
  (unbox-fixnum imm0 offset)
  (lwzx arg_z imm0 fixnum)
  (blr))

(defppclapfunction %fixnum-set ((fixnum arg_x) (offset arg_y) #| &optional |# (new-value arg_z))
  (cmpi cr0 nargs '2)
  (check-nargs 2 3)
  (bne cr0 @3-args)
  (mr fixnum offset)
  (li offset 0)
  @3-args
  (unbox-fixnum imm0 offset)
  (stwx new-value imm0 fixnum)
  (mr arg_z new-value)
  (blr))

; Sure would be nice to have &optional in defppclapfunction arglists
(let ((bits (lfun-bits #'(lambda (x &optional y) (declare (ignore x y))))))
  (lfun-bits #'%fixnum-ref
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-ref)))))

(let ((bits (lfun-bits #'(lambda (x y &optional z) (declare (ignore x y z))))))
  (lfun-bits #'%fixnum-set
             (dpb (ldb $lfbits-numreq bits)
                  $lfbits-numreq
                  (dpb (ldb $lfbits-numopt bits)
                       $lfbits-numopt
                       (lfun-bits #'%fixnum-set)))))




; This version is in LAP so that it won't vpush anything
(defppclapfunction %db-link-chain-in-current-sg-area ((area arg_z))
  (check-nargs 1)
  (let ((db imm0)
        (high imm1)
        (low imm2))
    (lwz high arch::area.high area)
    (lwz low arch::area.low area)
    (ref-global db db-link)
    (cmpwi cr0 db 0)
    (b @test)
    @loop
    (cmplw cr1 db low)
    (cmplw cr2 db high)
    (lwz db 0 db)
    (cmpwi cr0 db 0)
    (blt cr1 @test)
    (bge cr2 @test)
    (la arg_z arch::t-offset rnil)
    (blr)
    @test
    (bne cr0 @loop)
    (mr arg_z rnil)
    (blr)))



; The UPP for callback to #'threadEntry below
(defvar threadEntry)

; The callback-transition-vector for the threadEntry UPP
; #_NewThread takes a transition vector, not a UPP
; Initialized by (def-ccl-pointers *initial-stack-group* ...) below.
(defvar *stack-group-startup-function*)

; Here's the function that starts up a stack group.
; It never returns. Instead, we kill the thread.
; Expects *next-stack-group* to contain the stack group being started.
; If you redefine this, remember to reevaluate the define-ppc-pascal-function
; form below.
(defppclapfunction threadEntry ((arg-ptr arg_z))
  (let ((sg arg_y)
        (temp arg_x))
    (set-global rzero catch-top)
    (set-global rzero db-link)
    (set-global rzero xframe)
    (lwz temp '*next-stack-group* nfn)
    (lwz sg arch::symbol.vcell temp)
    (stw rnil arch::symbol.vcell temp)
    (lwz temp '*current-stack-group* nfn)
    (la loc-g arch::symbol.vcell temp)
    (push loc-g memo)
    (stw sg 0 loc-g)
    (svref temp sg.cs-area sg)
    (set-global temp current-cs)
    (svref temp sg.vs-area sg)
    (set-global temp current-vs)
    (lwz vsp arch::area.high temp)
    (svref temp sg.ts-area sg)
    (set-global temp current-ts)
    (lwz tsp arch::area.high temp)
    ; Ensure that the stack pointer is tagged as a fixnum
    ; push a stack frame in the process.
    (mr imm0 sp)
    (rlwinm imm0 imm0 0 0 29)          ; fixnum tag it
    (subi imm0 imm0 16)
    (sub imm0 imm0 sp)
    (stwux sp sp imm0)
    (stw fn ppc::lisp-frame.savefn sp)
    (mflr loc-pc)
    (stw loc-pc ppc::lisp-frame.savelr sp)
    (stw vsp ppc::lisp-frame.savevsp sp)
    (mr fn nfn)
    (li imm0 #xd0)                      ; Overflow, invalid, divide-by-zero enabled.
    (stwu tsp -16 tsp)
    (stw tsp 4 tsp)
    (stw imm0 12 tsp)
    (lfd fp0 8 tsp)
    (lwz tsp 0 tsp)
    (mtfsf #xff fp0)
    (zero-fp-reg fp0)
    ; (%run-stack-group-function sg sp)
    (mr arg_z sp)
    (set-nargs 2)
    (lwz temp0 '%run-stack-group-function fn)
    (bla .SPfuncall)
    (lwz temp0 'error fn)
    (lwz arg_z '"%run-stack-group-function returned!" fn)
    (bla .SPfuncall)))
    
; This does (set 'threadEntry UPP)
(define-callback-function #'threadEntry)


; This code is called when we reenter the Lisp after a control stack overflow.
; We are operating on a new thread, and the kernel has initialized the
; saved registers.
; We need to install the new cs_area and initialize its contents,
; then set up an unwind-protect to handle returning to the other thread.
; Then we can enable interrupts and continue execution at the point
; where stack overflow exception occurred.


; This is just like the commented out code above except
; it doesn't leave anything on the VSP stack during the call to
; %cs-overflow-callback.
; This is in LAP so it doesn't VPUSH anything.
; VPUSHing might cause a value stack overflow.
(defppclapfunction cs-overflow-callback ((arg-macptr arg_z))
  (check-nargs 1)
  (lwz fname '%cs-overflow-callback nfn)
  (set-nargs 0)
  (ba .SPjmpsym))

(define-callback-function #'cs-overflow-callback nil nil)

(defparameter *debug-cs-overflow-code* nil)

(defvar *cs-overflow-vsp* 0)
(declaim (type fixnum *cs-overflow-vsp*))

; Copy the preceding frame's savevsp to this one
(defppclapfunction %fix-savevsp ()
  (let ((temp imm0))
    (lwz temp 0 sp)
    (lwz temp ppc::lisp-frame.savevsp temp)
    (stw temp ppc::lisp-frame.savevsp sp)
    (blr)))

; Same as %fix-savevsp, but fixes the top 2 frames
; It's important that this doesn't check or change nargs.
(defppclapfunction %fix-savevsp-2 ()
  (let ((temp imm0)
        (temp-2 imm1))
    (lwz temp 0 sp)
    (lwz temp-2 0 temp)
    (lwz temp-2 ppc::lisp-frame.savevsp temp-2)
    (stw temp-2 ppc::lisp-frame.savevsp temp)
    (stw temp-2 ppc::lisp-frame.savevsp sp)
    (blr)))

; This is split out of the body of cs-overflow-callback
; so that the unwind-protect below will be sure to throw multiple values.
; This code computes (%current-xp) more than once to avoid any variable bindings:
; the vsp stack pointer at entry to this function needs to be
; the same as its value at the call to %restart-user-code-after-cs-overflow.
(defun %cs-overflow-callback ()
  (declare (optimize (debug 3)))                ; no saved register usage.
  (locally (declare (optimize (debug 0)))       ; but still do fixnum optimizations
    (setq *cs-overflow-vsp* (%current-vsp))
    (let* ((old-cs-area (%get-kernel-global 'current-cs))
           (cs-area (%fixnum-ref old-cs-area arch::area.younger))
           (sg *current-stack-group*))
      (%set-kernel-global 'current-cs cs-area)
      (setf (sg.cs-area sg) cs-area
            (sg.threadID sg) (gc-area.threadid cs-area))
      ; Initialize the cs-area.
      ; Add 8 to the frame pointer so that none of the frames appear to be off the bottom of the stack
      (initialize-sg-cs-area sg (+ (%current-frame-ptr) 8))
      (setf (gc-area.return-sp cs-area) (%current-frame-ptr)))
    (let* ((sp (with-area-macptr (xp (%current-xp)) (xp-gpr-lisp xp ppc::sp)))
           (vsp (%fixnum-ref sp ppc::lisp-frame.savevsp)))
      (setf (%fixnum-ref (%current-frame-ptr) ppc::lisp-frame.savevsp) vsp))
    (%set-current-vsp *cs-overflow-vsp*)          ; in case VSP overflowed
    (unwind-protect
      (progn
        ; It's important that nothing gets pushed on the VSP stack here
        ; until after the (%current-vsp) call for the first arg to %restart-user-code-after-cs-overflow
        (%fix-savevsp)
        ; Reenable stack overflow errors
        (bitclrf $gc-allow-stack-overflows-bit (the fixnum *gc-event-status-bits*))
        ; Restore *interrupt-level* to its value before the callback
        ; cs_stack_switch_startup in "ccl:pmcl;lisp-exceptions.c" decrements it by 2.
        (setq *interrupt-level* (%i+ *interrupt-level* 2))
        ; And reenter the user code
        (when *debug-cs-overflow-code*
          (dbg "Restarting after cs overflow"))
        (multiple-value-prog1
          ; vsp here must be the same as at function entry
          (%restart-user-code-after-cs-overflow
           (%current-vsp)
           (%current-xp)
           (%count-cs-overflow-stack-frames-to-copy (%current-xp)))
          (setf (gc-area.return-sp (%get-kernel-global 'current-cs)) 0)))
      (let* ((cs-area (%get-kernel-global 'current-cs))
             (old-cs-area (%fixnum-ref cs-area arch::area.older))
             (old-threadID (gc-area.threadid old-cs-area))
             (sg *current-stack-group*))
        ; From here out needs to be uninterruptable.
        (decf *interrupt-level* 2)
        (setf (sg.cs-area sg) old-cs-area
              (sg.threadID sg) old-threadID))
      ; VSP here must be the same as it was when the unwind-protect cleanup form was entered.
      (%copy-throw-context-to-exception-frame
       (%current-xp)
       (gc-area.return-sp (%get-kernel-global 'current-cs))))))



(defun %count-cs-overflow-stack-frames-to-copy (xp-fixnum)
  (with-macptrs (xp)
    (%setf-macptr-to-object xp xp-fixnum)
    (let ((sp (xp-gpr-lisp xp ppc::sp))
          (count 0)
          (sg *current-stack-group*))
      (loop
        (unless (%lexpr-entry-frame-p sp) (return))
        (unless (lisp-frame-p sp sg) (return))
        (incf count)
        (setq sp (%%frame-backlink sp)))
      count)))

(defun %lexpr-entry-frame-p (sp-ptr)
  (let ((savelr (%fixnum-ref sp-ptr ppc::lisp-frame.savelr))
        (lexpr-return (%get-kernel-global 'lexpr-return))
        (lexpr-return1v (%get-kernel-global 'lexpr-return1v))
        (ret1valn (%get-kernel-global 'ret1valaddr)))
    (or (eq savelr lexpr-return1v)
        (eq savelr lexpr-return)
        (and (eq savelr ret1valn)
             (eq (%fixnum-ref (%fixnum-ref sp-ptr ppc::lisp-frame.backlink)
                              ppc::lisp-frame.savelr)
                 lexpr-return)))))

(eval-when (:compile-toplevel :execute)
  (assert (eql ppc::lisp-frame.size 16)))



(defun %handle-sp-stack-overflow (xp-fixnum)
  (with-area-macptr (xp xp-fixnum)
    (handle-stack-overflow xp (xp-gpr-lisp xp ppc::fn) ppc::sp)))


(defppclapfunction %restart-user-code-after-cs-overflow ((current-vsp arg_x) (xp arg_y) (frame-count arg_z))
  (check-nargs 3)
  (mflr loc-pc)
  (bla .spsavecontextvsp)
  (call-symbol %fix-savevsp-2)
  (stwu tsp -8 tsp)                     ; push a dummy TSP frame in case user code wants to pop one
  (stw tsp 4 tsp)                       ; "raw" block
  (load-constant temp0  %%restart-user-code-after-cs-overflow)
  (bla .SPmvpass)
  ; Fix up TSP, if user code popped a frame
  (let ((temp imm0))
    (lwz temp 4 tsp)
    (cmpwi temp 0)
    (bne @no-user-pop)
    ; User code popped a TSP frame. Need to splice out the frame below the top one.
    ; That frame is guaranteed to be a lisp frame, so we don't need to clear its contents
    (lwz temp 0 tsp)
    (lwz temp 0 temp)
    (stw temp 0 tsp)
    (b @done)
    @no-user-pop
    ; The user code didn't pop the tsp frame we pushed, so pop it ourself
    (lwz tsp 0 tsp)
    @done
    (ba .spnvalret)))



(defppclapfunction %%restart-user-code-after-cs-overflow ((current-vsp arg_x) (xp arg_y) (frame-count arg_z))
  (let ((temp imm0)
        (sp-bytes imm1)
        (sp-ptr imm2)
        (temp-2 imm3)
        (temp-3 temp0)
        (ri nargs))                    ; must be nargs since nargs is overwritten last below
    (check-nargs 3)
    (mr vsp current-vsp)
    (mflr loc-pc)
    (bla .spsavecontextvsp)
    (call-symbol %fix-savevsp-2)
    ; Copy frame-count frames onto the current stack.
    (lwi temp #.(ash ppc::lisp-frame.size (- arch::fixnum-shift)))
    (mullw. sp-bytes frame-count temp)
    (linux-xp-regs ri xp)
    (get-linux-regs-reg temp ri ppc::vsp)
    (cmpw cr1 temp vsp)
    (beq cr1 @ok)
    (mr arg_y temp)
    (mr arg_z vsp)
    (set-nargs 2)
    (call-symbol vsp-mismatch-error)
    @ok
    (get-linux-regs-reg sp-ptr ri ppc::sp)
    (add sp-ptr sp-bytes sp-ptr)
    (beq @nostack)
    (set-linux-regs-reg sp-ptr ri ppc::sp)
    (lwz temp ppc::lisp-frame.savevsp sp-ptr)
    (mr temp-2 sp)
    ; Update the savevsp entries in the stack frames between here and the stack overflow frame
    @copy-savevsp-loop
    (stw temp ppc::lisp-frame.savevsp temp-2)
    (la temp-3 ppc::lisp-frame.size temp-2)
    (lwz temp-2 0 temp-2)
    (cmpw temp-2 temp-3)
    (beq @copy-savevsp-loop)
    ; Copy the lexpr-entry frames from the old stack area
    @copy-sp-loop
    (stwu sp (- ppc::lisp-frame.size) sp)
    (la sp-ptr (- ppc::lisp-frame.size) sp-ptr)
    (lwz temp 4 sp-ptr)
    (stw temp 4 sp)
    (addi frame-count frame-count '-1)
    (lwz temp 8 sp-ptr)
    (stw temp 8 sp)
    (cmpwi frame-count 0)
    (lwz temp 12 sp-ptr)
    (stw temp 12 sp)
    (bne @copy-sp-loop)
    (lwz temp-2 0 sp)
    @splice-out-frames-loop
    (mr temp temp-2)
    (lwz temp-2 0 temp)
    (cmpw temp-2 sp-ptr)
    (bne @splice-out-frames-loop)
    (get-linux-regs-reg sp-ptr ri ppc::sp)
    (stw sp-ptr 0 temp)
    @nostack
    ; Possibly signal an error
    (vpush xp)
    (mr arg_z xp)
    (set-nargs 1)
    (call-symbol %handle-sp-stack-overflow)
    (vpop xp)
    (linux-xp-regs ri xp)
    ; Restore arg_N, tempN, immN, fn, lr, pc->ctr, cr, xer
    (get-linux-regs-reg vsp ri ppc::vsp)
    (get-linux-regs-reg arg_x ri ppc::arg_x)
    (get-linux-regs-reg arg_y ri ppc::arg_y)
    (get-linux-regs-reg arg_z ri ppc::arg_z)
    (get-linux-regs-reg temp0 ri ppc::temp0)
    (get-linux-regs-reg temp1 ri ppc::temp1)
    (get-linux-regs-reg temp2 ri ppc::temp2)
    (get-linux-regs-reg temp3 ri ppc::temp3)
    (get-linux-regs-reg fn ri ppc::fn)
    ;; Load FPU state from xp.
    (ref-global imm0 arch::kernel-imports)
    (lwz imm0 arch::kernel-import-restore-fp-context imm0)
    (mtctr imm0)
    (la imm0 (ash xp-fpr0 2) ri)
    (bctrl)
    ;; Load Altivec state from xp (stored in regs[#$PT_MQ]).
    (ref-global imm0 arch::kernel-imports)
    (lwz imm0 arch::kernel-import-get-altivec-registers imm0)
    (mtctr imm0)
    (lwz imm0 (ash xp-mq 2) ri)
    (bctrl)
    ;; I don't think we really need to restore the CR or XER here, but it can't hurt.
    (get-linux-regs-lr loc-pc ri)
    (mtlr loc-pc)
    (get-linux-regs-pc loc-pc ri)
    (addi loc-pc loc-pc 4)                  ; skip the trap instruction that detected the original stack overflow
    (mtctr loc-pc)
    (get-linux-regs-reg loc-pc ri ppc::loc-pc)
    (get-linux-regs-cr temp ri)
    (mtcrf #xff temp)
    (get-linux-regs-xer temp ri)
    (mtxer temp)
    (get-linux-regs-reg imm0 ri ppc::imm0)
    (get-linux-regs-reg imm1 ri ppc::imm1)
    (get-linux-regs-reg imm2 ri ppc::imm2)
    (get-linux-regs-reg imm3 ri ppc::imm3)
    (get-linux-regs-reg imm4 ri ppc::imm4)
    (get-linux-regs-reg nargs ri ppc::nargs)
    (bctr)))

    
;;; This is called from the unwind-protect cleanup form in %cs-overflow-callback.
;;; The control stack at that point contains two frames of interest:
;;;
;;;  1) Return to nthrowvalues or nthrow1value subprim.
;;;  2) Return to end of unwind-protect body in %cs-overflow-callback
;;;       or
;;;     Return to .spTHROW subprim if return-sp is non-zero
;;;
;;; We move frame 1 into the exception frame,
;;; Copy the rest of the relevant machine state into the exceptions frame,
;;; Then return no values to frame 2.
;;; If the return-sp param is non-zero, then we copy frame 2 to the top
;;; stack frame on the other stack group and then return to the frame in return-sp.
;;; %cs-overflow-callback will return normally to the kernel code,
;;; which will switch to the other thread and return from the exception.
;;; This will continue the throw that we aborted here.
;;; Clever, huh?

#-cross-compiling
(defppclapfunction %copy-throw-context-to-exception-frame ((xp arg_y) (return-sp arg_z))
  (let ((ms imm0)
        (temp imm1)
        (other-sp imm2)
        (temp-2 imm3)
	(ri imm4))
    (check-nargs 2)
    (linux-xp-regs ri xp)
    ; I don't think it's necessary move the save registers, but it can't hurt.
    (set-linux-regs-reg save0 ri ppc::save0)
    (set-linux-regs-reg save1 ri ppc::save1)
    (set-linux-regs-reg save2 ri ppc::save2)
    (set-linux-regs-reg save3 ri ppc::save3)
    (set-linux-regs-reg save4 ri ppc::save4)
    (set-linux-regs-reg save5 ri ppc::save5)
    (set-linux-regs-reg save6 ri ppc::save6)
    (set-linux-regs-reg save7 ri ppc::save7)
    ;; Save FPU state to xp.
    (ref-global imm0 arch::kernel-imports)
    (lwz imm0 arch::kernel-import-save-fp-context imm0)
    (mtctr imm0)
    (la imm0 (ash xp-fpr0 2) ri)
    (bctrl)
    ;; Save Altivec state to xp (stored in regs[#$PT_MQ]).
    (ref-global imm0 arch::kernel-imports)
    (lwz imm0 arch::kernel-import-put-altivec-registers imm0)
    (mtctr imm0)
    (lwz imm0 (ash xp-mq 2) ri)
    (bctrl)
    (set-linux-regs-reg freeptr ri ppc::freeptr)
    (set-linux-regs-reg initptr ri ppc::initptr)
    (set-linux-regs-reg memo ri ppc::memo)
    (set-linux-regs-reg tsp ri ppc::tsp)
    (set-linux-regs-reg vsp ri ppc::vsp)
    (set-linux-regs-reg 0 ri ppc::nargs)
    ; Set return address and fn in exception frame from frame 1
    (lwz temp ppc::lisp-frame.savelr sp)
    (set-linux-regs-lr temp ri)
    (lwz temp
         '#.#'(lambda (&lap 0)
                ; this is lap so that it won't check for stack overflow
                ; It's only here to provide a debugger hook so that I can
                ; inspect the machine state right when the old thread restarts.
                ; This code is basically equivalent to: (when *debug-cs-overflow-code* (dbg "..."))
                (ppc-lap-function nil ()
                 (vpush arg_z)
                 (lwz arg_z '*debug-cs-overflow-code* nfn)
                 (lwz arg_z arch::symbol.vcell arg_z)
                 (cmpw arg_z rnil)
                 (beq @ret)
                 (lwz arg_z '"Reentering old thread after CS overflow" nfn)
                 (dbg t)
                 @ret
                 (vpop arg_z)
                 (lwz vsp ppc::lisp-frame.savevsp sp)
                 (blr)))
         nfn)
    (set-linux-regs-reg temp ri ppc::nfn)
    (svref temp 0 temp)
    (la temp (- arch::misc-data-offset 4) temp)
    (set-linux-regs-pc temp ri)
    (lwz temp ppc::lisp-frame.savefn sp)        ; I think this is guaranteed to be 0, but be safe
    (set-linux-regs-reg temp ri ppc::fn)
    (cmpwi return-sp 0)
    (la sp ppc::lisp-frame.size sp)
    (get-linux-regs-reg other-sp ri ppc::sp)
    (bne @throw)
    ; Regular return. May need to insert a ret1valn frame to
    ; convert the multiple values from the throw to a single value.
    (lwz temp ppc::lisp-frame.savelr other-sp)
    (ref-global temp-2 ret1valaddr)
    (cmpw temp temp-2)
    (beq @mv)
    ; Single value return expected, so push a frame to change the multiple values to a single value
    (lwz temp ppc::lisp-frame.savevsp other-sp)
    (stwu other-sp (- ppc::lisp-frame.size) other-sp)
    (stw temp ppc::lisp-frame.savevsp other-sp)
    (lwz temp-2 '#.#'(lambda (&lap 0)
                       (ppc-lap-function nil ()
                         (cmpwi nargs 0)
                         (mr arg_z rnil)
                         (add vsp vsp nargs)
                         (beq @ret)
                         (lwz arg_z -4 vsp)
                         @ret
                         (ba .SPpopj)))
         nfn)
    (stw temp-2 ppc::lisp-frame.savefn other-sp)
    (svref temp-2 0 temp-2)
    (stw temp-2 ppc::lisp-frame.savelr other-sp)
    (set-linux-regs-reg other-sp ri ppc::sp)
    (b @return)
    @mv
    ; Multiple value return expected. Pop the ret1valn frame.
    (lwz other-sp 0 other-sp)
    (set-linux-regs-reg other-sp ri ppc::sp)
    (b @return)
    @throw
    (lwz temp ppc::lisp-frame.savefn sp)
    (stw temp ppc::lisp-frame.savefn other-sp)
    (lwz temp ppc::lisp-frame.savelr sp)
    (stw temp ppc::lisp-frame.savelr other-sp)
    (mr sp return-sp)
    @return
    ; Return to frame 2
    (restore-full-lisp-context temp)    ; dont' restore VSP
    (mr arg_z rnil)
    (li nargs 0)                        ; 0 values for return from %cs-overflow-callback
    (blr)))














; This is called just before exiting lisp context to be sure that
; there is enough space on the VSP stack for ppc-ff-call (ffcalladdress) to
; vpush_saveregs.
(defppclapfunction %ensure-vsp-stack-space ()
  (vpush rzero)   ; 1
  (vpush rzero)   ; 2
  (vpush rzero)   ; 3
  (vpush rzero)   ; 4
  (vpush rzero)   ; 5
  (vpush rzero)   ; 6
  (vpush rzero)   ; 7
  (vpush rzero)   ; 8
  (la vsp 32 vsp)
  (blr))

; Reverse special bindings, but don't mess with *interrupt-level*
; A special binding is [link, symbol, value]
(defppclapfunction %reverse-special-bindings ((set-db-link-p arg_z))
  (let ((last-db imm0)
        (db imm1)
        (sym imm2)
        (next-db imm2)
        (value imm3)
        (sym-value imm4)
        (*interrupt-level*-sym temp0)
        (top-catch arg_y))
    (cmp cr1 set-db-link-p rnil)
    (lwz *interrupt-level*-sym '*interrupt-level* nfn)
    (la top-catch (+ 8 arch::fulltag-misc) tsp)
    (bne cr1 @dont-zero)
    (set-global rzero db-link)          ; Prevent interrupt from modifying wrong binding
  @dont-zero
    (svref db arch::catch-frame.db-link-cell top-catch)
    (li last-db 0)
    (b @test)

  @loop
    (lwz sym 4 db)
    (cmp cr0 sym *interrupt-level*-sym)
    (beq @skip)
    (lwz value 8 db)
    (lwz sym-value arch::symbol.vcell sym)
    (svset value arch::symbol.vcell-cell sym)
    (stw sym-value 8 db)
  @skip
    (lwz next-db 0 db)
    (stw last-db 0 db)
    (mr last-db db)
    (mr db next-db)
  @test
    (cmpwi cr0 db 0)
    (bne cr0 @loop)
  
    (svset last-db arch::catch-frame.db-link-cell top-catch t)
    (beq cr1 @return)
    (set-global last-db db-link))
  @return
  (blr))

; Save the global state in a stack group
; %normalize-areas has already done most of the work.
(defppclapfunction %save-stack-group-context ((sg arg_z))
  (let ((address imm0)
        (data imm1))

    ; Update active pointer for vsp area to include the 8 words pushed by .SPffcall
    (ref-global address current-vs)
    (la data (- (* 4 8)) vsp)           ; .SPffcall pushes the 8 saved registers on the VSP
    (stw data arch::area.active address)

    (ref-global data cs-overflow-limit)
    (svset data sg.cs-overflow-limit sg t)
    ; Prevent stack overflow when we reenter this code (may not be necessary)
    (set-global rzero cs-overflow-limit))
  (blr))

; Initialize the global vars from a stack group.
; This is the first thing that happens when a stack group switches in.
; Assumes that a catch frame is on the top of the tsp.
; The vsp has already been restored by .SPffcall
(defppclapfunction %restore-stack-group-context ((sg arg_z))
  (let ((temp imm0))
    (svref temp sg.cs-area sg)
    (set-global temp current-cs)
    (svref temp sg.vs-area sg)
    (set-global temp current-vs)
    (svref temp sg.ts-area sg)
    (set-global temp current-ts)
    (lwz tsp arch::area.active temp)
    (svref temp sg.cs-overflow-limit sg)
    (set-global temp cs-overflow-limit)
    (la temp (+ 8 arch::fulltag-misc) tsp)
    (set-global temp catch-top))
  (blr))














;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;




(defppclapfunction %current-frame-ptr ()
  (check-nargs 0)
  (mr arg_z sp)
  (blr))

(defppclapfunction %current-vsp ()
  (check-nargs 0)
  (mr arg_z vsp)
  (blr))

(defppclapfunction %set-current-vsp ((new-vsp arg_z))
  (check-nargs 1)
  (mr vsp new-vsp)
  (blr))

(defppclapfunction %current-tsp ()
  (check-nargs 0)
  (mr arg_z tsp)
  (blr))

(defppclapfunction %set-current-tsp ((new-tsp arg_z))
  (check-nargs 1)
  (mr tsp new-tsp)
  (blr))

; This assumes that bit 0 being set in a back pointer can be ignored.
; I believe the system uses that to denote a mode change from
; PPC to/from 68K.
; It also assumes that if bit 1 is set we're at the bottom of the stack;
; it returns 0 in that case.
(defun %frame-backlink (p &optional (sg *current-stack-group*))
  (cond ((fake-stack-frame-p p)
         (%fake-stack-frame.next-sp p))
        ((fixnump p)
         (let ((backlink (%%frame-backlink p))
               (fake-frame (symbol-value-in-stack-group '*fake-stack-frames* sg)))
           (loop
             (when (null fake-frame) (return backlink))
             (when (eq backlink (%fake-stack-frame.sp fake-frame))
               (return fake-frame))
             (setq fake-frame (%fake-stack-frame.link fake-frame)))))
        (t (error "~s is not a valid stack frame" p))))

(defppclapfunction %%frame-backlink ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.backlink arg_z)
  (rlwinm imm0 arg_z 30 0 0)            ; Bit 1 -> sign bit
  (srawi imm0 imm0 31)                  ; copy sign bit to rest of word
  (andc arg_z arg_z imm0)               ; arg_z = 0 if bit 1 was set
  (rlwinm arg_z arg_z 0 0 29)           ; clear low two bits
  (blr))



(defppclapfunction %%frame-savefn ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.savefn arg_z)
  (blr))

(defppclapfunction %frame-savelr ((p arg_z))
  (check-nargs 1)
  (lwz arg_z ppc::lisp-frame.savelr arg_z)
  (blr))



(defppclapfunction %%frame-savevsp ((p arg_z))
  (check-nargs 1)
  (lwz imm0 ppc::lisp-frame.savevsp arg_z)
  (rlwinm imm0 imm0 0 0 30)             ; clear lsb
  (mr arg_z imm0)
  (blr))



(eval-when (:compile-toplevel :execute)
  (assert (eql arch::t-offset #x11)))

(defppclapfunction %uvector-data-fixnum ((uv arg_z))
  (check-nargs 1)
  (trap-unless-fulltag= arg_z arch::fulltag-misc)
  (la arg_z arch::misc-data-offset arg_z)
  (blr))



(defun lisp-frame-p (p stack-group)
  (or (fake-stack-frame-p p)
      (locally (declare (fixnum p))
        (let ((next-frame (%frame-backlink p stack-group)))
          (when (fake-stack-frame-p next-frame)
            (setq next-frame (%fake-stack-frame.sp next-frame)))
          (locally (declare (fixnum next-frame))
            (if (bottom-of-stack-p next-frame stack-group)
              (values nil t)
              (and
               (eql (ash ppc::lisp-frame.size (- arch::fixnum-shift))
                    (the fixnum (- next-frame p)))
               ;; EABI C functions keep their saved LRs where we save FN or 0
               ;; The saved LR of such a function would be fixnum-tagged and never 0.
               (let* ((fn (%fixnum-ref p ppc::lisp-frame.savefn)))
                 (or (eql fn 0) (typep fn 'function))))))))))

(defppclapfunction %catch-top ((stack-group arg_z))
  (check-nargs 1)
  (lwz temp0 '*current-stack-group* nfn)
  (lwz temp0 arch::symbol.vcell temp0)
  (cmp cr0 stack-group temp0)
  (bne cr0 @not-current)

  ; stack-group = *current-stack-group*
  (ref-global arg_z catch-top)
  (cmpwi cr0 arg_z 0)
  (bne @ret)
  (mr arg_z rnil)
 @ret
  (blr)

@not-current
  (svref imm0 sg.ts-area stack-group)
  (lwz imm0 arch::area.active imm0)
  (la arg_z (+ 8 arch::fulltag-misc) imm0)
  (blr))









; Same as %address-of, but doesn't cons any bignums
; It also left shift fixnums just like everything else.
(defppclapfunction %fixnum-address-of ((x arg_z))
  (check-nargs 1)
  (box-fixnum arg_z x)
  (blr))

(defppclapfunction %get-freeptr ()
  (check-nargs 0)
  (mr arg_z freeptr)
  (blr))

  





