# application-vcc3client.tcl --
#
#       Creates a Vcc3Client and gives it a frame to display in
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import Application Vcc3Client

Class Vcc3ClientApplication -superclass Application

Vcc3ClientApplication instproc showUsage {} {
   puts stdout "usage:  vcc3client \[-port <port>\] \[-host <host>\]"
}

Vcc3ClientApplication instproc getFlags {argv} {
    $self instvar hostname_ port_ labeltxt_

    # defaults
    set hostname_ "garfield.cs.berkeley.edu"
    set port_ 6905

    set state flag
    foreach arg $argv {
	switch -exact -- $state {
	    flag {
		switch -exact -- $arg {
		    -port {
			set state "port"
		    }
		    -host {
			set state "host"
		    }
		    -label {
			set state "label"
		    }
		    -help {
			$self showUsage
			exit
		    }
		    default {
			$self showUsage
			exit
		    }
		}
	    }
	    port {
		set port_ $arg
		set state "flag"
	    }
	    host {
		set hostname_ $arg
		set state "flag"
	    }
	    label {
		set labeltxt_ $arg
		set state "flag"
	    }
	}
    }
}

Vcc3ClientApplication instproc init {argv} {
    $self next "vcc3Client"
    $self instvar client_ hostname_ port_ labeltxt_
    set labeltxt_ ""
    $self getFlags $argv

    $self initUI

    set client_ [new Vcc3Client "" $hostname_ $port_]
}

Vcc3ClientApplication instproc initUI {} {
    $self instvar client_ hostname_ port_ labeltxt_

    wm title . "Vcc3Client: $hostname_"
#    wm minsize . 200 100

    frame .clientFrame -relief ridge -borderwidth 5
    pack .clientFrame -side top

    # make exit button
    label .l -text $labeltxt_
    button .exit -text "Exit" -command exit
    pack .l .exit -side bottom
}

