# matrix.tcl --
#
#       Allows raw setting of video matrix connections in 405.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_app

Import enable

import Application DpClient

Class MatrixApp -superclass Application

MatrixApp instproc init {argv} {
    $self instvar amx_

    $self next $argv
    $self initUI
#    $self initAmx garfield.cs.berkeley.edu 6905
    $self initAmx htsr.bmrc.berkeley.edu 6901
}

#
# GUI stuff
#

MatrixApp instproc initUI {} {
    $self instvar in1Text_ in2Text_ out1Text_ out2Text_ in1_ in2_ out1_ out2_

    wm title . "MatrixTest"
    wm minsize . 150 0

    frame .entry
    pack .entry -side top -pady 10

    label .entry.in1Label  -text "In1"
    pack .entry.in1Label -side left
    set in1Text_ [text .entry.in1Text -width 4 -height 1]
    pack .entry.in1Text -side left
    $in1Text_ insert 0.0 "1"

    label .entry.out1Label  -text "Out1"
    pack .entry.out1Label -side left
    set out1Text_ [text .entry.out1Text -width 4 -height 1]
    pack .entry.out1Text -side left
    $out1Text_ insert 0.0 "2"

    label .entry.in2Label  -text "In2"
    pack .entry.in2Label -side left
    set in2Text_ [text .entry.in2Text -width 4 -height 1]
    pack .entry.in2Text -side left
    $in2Text_ insert 0.0 "1"

    label .entry.out2Label  -text "Out2"
    pack .entry.out2Label -side left
    set out2Text_ [text .entry.out2Text -width 4 -height 1]
    pack .entry.out2Text -side left
    $out2Text_ insert 0.0 "7"


    frame .but
    pack .but -side top -pady 10

    button .but.send -text "Switch" -command "$self doSwitch"
    pack .but.send -side left
    button .but.status -text "Status" -command "$self getStatus"
    pack .but.status -side left

    button .but.test1 -text "Test 1" -command "$self doTest1"
    pack .but.test1 -side left

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

MatrixApp instproc initAmx { {hostname htsr.bmrc.berkeley.edu} {port 6901}} {
    $self instvar amx_

    if {[catch {new DpClient $hostname $port} amx_]} {
        puts stderr "Fatal error:  could not connext to AMX server"
	exit
    }
}

MatrixApp instproc exitApp {} {
    $self instvar amx_

    $amx_ closeRPC
    exit
}

MatrixApp public doSwitch {} {
    $self instvar amx_ in1_ in2_ out1_ out2_

    $self get_values

    puts stdout "in1=$in1_ in2=$in2_ out1=$out1_ out2=$out2_"

    # 4 means send string, 2 means send it to the matrix
    $amx_ do matrix_rawSwitchVideoStream 1 $in1_ $out1_
    $amx_ do matrix_rawSwitchVideoStream 2 $in2_ $out2_
}

MatrixApp public doTest1 {} {
    $self instvar amx_

    set output "htsr"
    set result [$amx_ do matrix_getInputSource $output]
    puts stdout "matrix_getInputSource $output returns $result"

    set output "htsr2"
    set result [$amx_ do matrix_getInputSource $output]
    puts stdout "matrix_getInputSource $output returns $result"

    set output "realNetworks"
    set result [$amx_ do matrix_getInputSource $output]
    puts stdout "matrix_getInputSource $output returns $result"

    set output "projector"
    set result [$amx_ do matrix_getInputSource $output]
    puts stdout "matrix_getInputSource $output returns $result"

        set output "projectorRGB"
    set result [$amx_ do matrix_getInputSource $output]
    puts stdout "matrix_getInputSource $output returns $result"

    puts stdout ""
}

MatrixApp public getStatus {} {
    $self instvar amx_

    set input 7
    set output 3
    set level 2

    puts stdout "getting status"

    for {set x 0} {$x < 1} {incr x 1} {
	set result [$amx_ do matrix_getStatus $level input $input]
	puts stdout "matrix_getStatus level $level input $input returns $result"
	set result [$amx_ do matrix_getStatus $level output $output]
	puts stdout "matrix_getStatus level $level output $output returns $result"
    }

    set level 2
    set input 1
    set output 7


    for {set x 0} {$x < 1} {incr x 1} {
	set result [$amx_ do matrix_getStatus $level input $input]
	puts stdout "matrix_getStatus level $level input $input returns $result"
	set result [$amx_ do matrix_getStatus $level output $output]
	puts stdout "matrix_getStatus level $level output $output returns $result"
    }
}

MatrixApp private get_values {} {
    $self instvar in1Text_ in2Text_ out1Text_ out2Text_ in1_ in2_ out1_ out2_

    set in1_ 1
    set in2_ 1
    set out1_ 1
    set out2_ 1

    set temp_str [$in1Text_ get 1.0 1.end]
    scan $temp_str "%d" in1_
    set temp_str [$in2Text_ get 1.0 1.end]
    scan $temp_str "%d" in2_
    set temp_str [$out1Text_ get 1.0 1.end]
    scan $temp_str "%d" out1_
    set temp_str [$out2Text_ get 1.0 1.end]
    scan $temp_str "%d" out2_
}


#
# driver engine
#

set g_app [new MatrixApp $argv]

# next line is very important!!!
vwait forever

