# getcampos.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_outfile g_infile g_prevMode g_areas

proc init {} {
    global g_areas

    set g_areas(left,start) -800
    set g_areas(left,end) -400
    set g_areas(center,start) -399
    set g_areas(center,end) -100
    set g_areas(right,start) -99
    set g_areas(right,end) 800
}

proc makeOutfile {} {
    global g_infile

    if {[catch {open $g_infile r} infile]} {
        puts stdout "Cannot open file $g_infile for reading"
        return 0
    }

    # at this point, infile is open

    # always assume starting with speaker
    while {[gets $infile line] >= 0} {
	set sLine [split $line " "]
	set index [lindex $sLine 0]
	set xPos [lindex $sLine 1]
	set yPos [lindex $sLine 2]
	processEntry $index $xPos $yPos
    }

    close $infile
}

# we ignore the yPos for now
proc processEntry {index xPos yPos} {
    global g_areas g_point g_endPoint

    set check [list "left" "center" "right"]
    if {($index > $g_point) && ($index < $g_endPoint)} {
	# it's in the time interval of interest, categorize it
	foreach chk $check {
	    if {($xPos > $g_areas($chk,start)) && ($xPos < $g_areas($chk,end))} {
		puts stdout "$index $chk"
	    }
	}
    }
}

# main program

if {[llength $argv] != 3} {
    puts stdout "Usage: getcampos <log.camera file> <point> <range>"
    puts stdout "length is [llength $argv]"
    exit
}
set g_infile [lindex $argv 0]
set g_point [lindex $argv 1]
set g_range [lindex $argv 2]
set g_endPoint [expr $g_point + $g_range]

init

makeOutfile

