# rtpgw_ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1995-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rtpgw_ui/rtpgw_ui.tcl,v 1.5 2002/02/03 04:29:22 lim Exp $ (UC Berkeley)


#
# We want these resources to override user defaults
# (the option command's "userDefault" priority is 60)
# We do this for a consistent user inteface "look".
# Too often, people define *background and *foreground
# in their X resources, which gives bad results with tk.
#
option add *background gray80 61
option add *foreground black 61
option add *activeBackground gray95 61
option add *selectBackground gray95 61
option add *Scale.sliderForeground gray66 61
option add *Scale.activeForeground gray80 61
#option add *Scale.background gray70 61
option add *Scrollbar.foreground gray80 61
option add *Scrollbar.activeForeground gray70 61
option add *disabledForeground gray70

option add RtpgwUI.foundry adobe startupFile

proc mapf { f } {
    if { ! [havefont $f] } {
	set i [string first 75 $f]
	set f [string range $f 0 [expr $i - 1]]*-*-*-*-*-*
    }
        return $f
}

set ff [option get . foundry RtpgwUI]
set helv10 [mapf "-$ff-helvetica-medium-r-normal--*-100-75-75-*-*-*-*"]
set helv10b [mapf "-$ff-helvetica-bold-r-normal--*-100-75-75-*-*-*-*"]
set helv10o [mapf "-$ff-helvetica-bold-o-normal--*-100-75-75-*-*-*-*"]
set helv12 [mapf "-$ff-helvetica-medium-r-normal--*-120-75-75-*-*-*-*"]
set helv12b [mapf "-$ff-helvetica-bold-r-normal--*-120-75-75-*-*-*-*"]
set helv14 [mapf "-$ff-helvetica-medium-r-normal--*-140-75-75-*-*-*-*"]
set helv14b [mapf "-$ff-helvetica-bold-r-normal--*-140-75-75-*-*-*-*"]
set times14 [mapf  "-$ff-times-medium-r-normal--*-140-75-75-*-*-*-*"]

option add *Font $helv12b startupFile
option add RtpgwUI.disablefont $helv10o
option add RtpgwUI.smallfont $helv10b
option add RtpgwUI.medfont $helv12b  startupFile
option add RtpgwUI.helpFont $times14 startupFile
option add RtpgwUI.entryFont $helv10 startupFile
option add RtpgwUI.suppressUserName true startupFile

set V(active_list) {}
set V(encoders) {}
set cbAppName "rtpgwUI"

proc smallfont { } {
     return [option get . smallfont RtpgwUI]
}

proc mediumfont { } {
    return [option get . medfont RtpgwUI]
}

proc disfont { } {
    return [option get . disablefont RtpgwUI]
}

proc build.bar w {
	global title V
	frame $w.bar -relief ridge -borderwidth 2
	label $w.bar.title -text "RtpgwUI v[version]: $V(media_type)" \
		-font [smallfont] -relief flat -justify left
	button $w.bar.menu -text Menu -relief raised \
		-font [smallfont] -highlightthickness 0 \
	    	-command "toggle_window .menu" -width 2
	button $w.bar.engine -text Engine -relief raised \
		-font [smallfont] -highlightthickness 0 \
	    	-command "toggle_window .engine" -width 3
	button $w.bar.help -text Help -relief raised \
		-font [smallfont] -highlightthickness 0 \
		-command "toggle_window .help" -width 1
	button $w.bar.quit -text Quit -relief raised \
		-font [smallfont] -highlightthickness 0 \
	    	-command "adios" -width 2
	pack $w.bar.title -side left -fill both -expand 1
	pack $w.bar.menu $w.bar.engine $w.bar.help $w.bar.quit -side left
}

proc kill_engine {} {
	global V
    	if { [info exists V(rtpgw_engine)] } then {
		set p $V(rtpgw_engine)
		if { $p != "" } then {
			set t [lindex [split $p /] 1]
			kill $t
		    	set V(engine_status) "Disconnected - No Engine."
		    	set V(rtpgw_engine) ""
		    	engine_pid -1
			cleanUp
		}
	}
}

proc build.engine {} {
	set w .engine
	toplevel $w
	wm title $w "rtpgw engine"
	wm withdraw $w
	bind $w <Enter> "focus $w"
	set f [smallfont]
	set med [mediumfont]

	global V
	set sys [frame $w.sys -relief sunken -borderwidth 1]
	label $sys.t -text "Engine" -width 26

	frame $sys.status
	label $sys.status.title -text "Status:" -font $f
	label $sys.status.l -textvariable V(engine_status) \
		-font $f

	pack $sys.status.title $sys.status.l -side left -anchor w

	frame $sys.confbus
	label $sys.confbus.l -font $f \
		-text "Conference Bus Channel: $V(cb_channel)"

	pack $sys.confbus.l -side left
	pack $sys.t -side top
	pack $sys.status $sys.confbus -side top -anchor w

	set ek [frame $sys.execkill]

	button $ek.exec -text Exec -relief raised \
		-font [smallfont] -highlightthickness 0 -width 1 \
		-command "execkill $ek exec"
	button $ek.kill -text Kill -relief raised \
		-font [smallfont] -highlightthickness 0 -width 1 \
		-command "execkill $ek kill"

	set V(pathnames,execbutton) $ek.exec
	set V(pathnames,killbutton) $ek.kill

	if { $V(rtpgw_engine) == "" } then {
		$ek.kill configure -state disabled
	} else {
		$ek.exec configure -state disabled
	}

	pack $ek.exec $ek.kill -side left -expand 1
	pack $ek -side top -fill x -pady 2

	frame $w.buttons
	button $w.buttons.dismiss -text "Dismiss" -command "toggle_window $w"
	pack $w.buttons.dismiss -side top
	pack $sys $w.buttons -ipady 3 -padx 5 -pady 5 -anchor n


}

proc build.menu {} {
	set w .menu
	toplevel $w
	wm title $w "rtpgw menu"
	wm withdraw $w
	bind $w <Enter> "focus $w"
	set f [smallfont]
	set med [mediumfont]

	set b [frame $w.body -relief ridge -borderwidth 2]

	frame $b.info -relief sunken -borderwidth 1

	global V

    	label $b.info.title -text "Sessions"
	set A [frame $b.info.a -relief groove -borderwidth 2]
    	build.session $A A
	set B [frame $b.info.b -relief groove -borderwidth 2]
    	if { $V(B,nettype) == "ipad" } {
		build.ipadsession $B B
	} else {
		build.session $B B
	}
	pack $b.info.title -side top -expand 1 -fill x
	pack $A $B -side top -anchor w -expand 1 -padx 4 -fill x -ipadx 2

	frame $b.buttons
	button $b.buttons.dismiss -text "Dismiss" -command "toggle_window $w"
	pack $b.buttons.dismiss -side left

	pack $b.info -side top -pady 5 -padx 4 -ipady 4 -expand 1 -fill x
	pack $b.buttons -side top -pady 5 -padx 4

	pack $b -side top
}

proc build.session { w name } {
	global V
	set f [smallfont]

	frame $w.addr
	frame $w.bw

	set spec [split $V($name,hostspec) :]

	set c 0
	frame $w.addr.l
	foreach s $spec {
		set V(pathnames,hostspecs,$s) $w.addr.l.h$c
		set s [split $s /]
		set addr [lindex $s 0]
		set port [lindex $s 1]
		set ttl [lindex $s 2]
		label $w.addr.l.h$c -font $f \
		    -text "$name: addr: $addr port: $port ttl: $ttl"
		pack $w.addr.l.h$c -side top -anchor w
		incr c
	}

	frame $w.addr.glue
	checkbutton $w.addr.cb -text "Rate Control" \
		-variable V($name,RC) -font $f -highlightthickness 0 \
		-command "set_RC $name"
	pack $w.addr.l -side left -anchor w
	pack $w.addr.glue -side left -expand 1 -fill x -anchor w
	pack $w.addr.cb -side right


	mkTotBWScale $w.bw $name
	mk.key $w $name
	pack $w.addr $w.bw $w.key -side top -expand 1 -fill x

	set btns [frame $w.buttons]
	set V(pathnames,buttons,$name) $btns
	frame $btns.enc -relief raised -borderwidth 2
	set V(pathnames,encoders,$name) \
		[menubutton $btns.enc.mb -menu $btns.enc.mb.m \
			-text "Format..." -font $f]
	mkEncoders $name $btns.enc.mb.m
	pack $btns.enc.mb

	frame $btns.glue
	pack $btns.enc -side left -anchor w
	checkbutton $btns.switching -text "Switching" -font $f \
		-variable V($name,switching) -highlightthickness 0 \
		-onvalue "on" -offvalue "off"
	checkbutton $btns.color -text "Color" -variable V($name,color) \
		-font $f -highlightthickness 0 -command "set_color $name"
	pack $btns.glue -side left -expand 1 -fill x -anchor w
	pack $btns.color $btns.switching -side right -padx 4
	pack $btns -side top -expand 1 -fill x -padx 4 -pady 4
	if { $V($name,RC) == 0 || $V(rtpgw_engine) == ""} then {
		$btns.enc.mb configure -state disabled
		$btns.switching configure -state disabled
		$btns.color configure -state disabled
	}
	if { $V(media_type) != "video" } {
		$btns.color configure -state disabled
	}
}

proc build.ipadsession { w name } {
	global V
	set f [smallfont]

	frame $w.addr
	frame $w.bw

	label $w.addr.l -font $f \
		-text "$name: Infopad Session - Pad ID: $V(padid)"
	frame $w.addr.glue
	checkbutton $w.addr.cb -text "Rate Control" \
		-variable V($name,RC) -font $f -highlightthickness 1 \
		-command "set_RC $name"
	pack $w.addr.l -side left -anchor w
	pack $w.addr.glue -side left -expand 1 -fill x -anchor w
	pack $w.addr.cb -side right

	mkTotBWScale $w.bw $name
	pack $w.addr $w.bw -side top -expand 1 -fill x

	frame $w.enc -relief raised -borderwidth 2
	set V(pathnames,encoders,$name) \
		[menubutton $w.enc.mb -menu $w.enc.mb.m -text "Format..." \
		 -font $f]
	mkEncoders $name $w.enc.mb.m
	pack $w.enc -side top -anchor w -pady 4 -padx 4
	pack $w.enc.mb -side top
	if { $V($name,RC) == 0 || $V(rtpgw_engine) == ""} then {
		$w.enc.mb configure -state disabled
	}
}

proc build.ipadsession {w name} {
    puts "rtpgw_ui: not configured for InfoPad!"
    adios
}

proc mkTotBWScale { w name } {
	global V

	set V($name,totbwtext) "0 bps"
	set f [smallfont]

	set V(pathnames,bwscale,$name) $w

	frame $w.title
	label $w.title.l -text "Total Session Bandwidth: " -font $f
	label $w.title.bwtext -width 10 \
		-textvariable V($name,totbwtext) -font $f
	pack $w.title.l $w.title.bwtext -side left -expand 1 -fill x
	set n [format "%s%s%s" session $name totbwScaleStep]
	set step [option get . $n RtpgwUI]
	set totbw $V($name,maxscale)
	if { $step == "log" } then {
		set scaleto [expr log10($totbw)/log10(2)]
		scale $w.scale -from 0.01 -to $scaleto -showvalue 0  \
			-resolution 0.01 -orient horizontal -length 9c \
		        -highlightthickness 0 -command "setbw $name" -width 10
		$w.scale set [expr log10($V($name,totbw))/log10(2)]
	} else {
		scale $w.scale -from 0 -to $totbw -showvalue 0 \
			-orient horizontal -length 9c -command "setbw $name"\
		        -highlightthickness 0 -resolution 1000 -width 10
	    	$w.scale set $V($name,totbw)
	}

	if { $V($name,RC) == 0 } then {
		$w.scale configure -state disabled
		set f [option get . disabledForeground RtpgwUI]
		$w.title.l configure -foreground $f
		$w.title.bwtext configure -foreground $f
	}

	pack $w.title $w.scale -side top
}

proc set_color { name } {
	global V
	cb_send "cb_video_set $name color $V($name,color)"
}

proc set_RC { name } {
	global V srcinfo

	set rc $V($name,RC)
	if { $rc == 0 } {
		set f [option get . disabledForeground RtpgwUI]
		set state disabled
	} else {
		set f [option get . foreground RtpgwUI]
		set state normal
	}

	if { [info exists V(pathnames,bwscale,$name)] } then  {
		set w $V(pathnames,bwscale,$name)
		set b $V(pathnames,buttons,$name)
		$w.scale configure -state $state
		$w.title.l configure -foreground $f
		$w.title.bwtext configure -foreground $f
		$b.enc.mb configure -state $state
		$b.switching configure -state $state
		$b.color configure -state $state

	    	if { $V(media_type) != "video" } {
		    $b.color configure -state disabled
		}
	}
	foreach s $V(active_list) {
		if { $srcinfo($s,osess) != $name } then {
			continue
		}
		if { $rc == 0} then {
			srcBWstate $s alldisabled
		} else {
			if { $srcinfo($s,tname) == "pass-thru" } then {
				srcBWstate $s disabled
			} else {
				srcBWstate $s normal
			}
		}
	}
	cb_send "cb_set $name RC $V($name,RC)"
}

proc srcBWstate { src state } {
	global V srcinfo

	if { [info exists V(pathnames,scale,$src)] == 0 } then {
		return
	}

	if { $state == "alldisabled" } then {
		set f0 [option get . disabledForeground RtpgwUI]
		set f1 [option get . disabledForeground RtpgwUI]
		set s "disabled"
	} elseif { $state == "disabled" } {
		set f0 [option get . foreground RtpgwUI]
		set f1 [option get . disabledForeground RtpgwUI]
		set s "normal"
	} else {
		set f0 [option get . foreground RtpgwUI]
		set f1 [option get . foreground RtpgwUI]
		set s "normal"
	}

	set p $V(pathnames,scale,$src)
	$p.scale configure -state $s
	$p.info.val configure -foreground $f0
	$p.info.name configure -foreground $f0
	$p.info.maxbpsval configure -foreground $f0

	set p $V(grid).$src
	$p.l.rates.ifps configure -foreground $f1
	$p.l.rates.ofps configure -foreground $f1
}

proc execkill { w sel } {
	if { $sel == "exec" } then {
		if { [execRTPGW] > 0 } then {
			$w.exec configure -state disabled
			$w.kill configure -state normal
		}
	} else {
		kill_engine
		$w.kill configure -state disabled
		$w.exec configure -state normal
	}
}

proc mkEncoders { name m } {
	global V

	set f [smallfont]

	if { [winfo exists $m] } then {
		destroy $m
	}
	menu $m -tearoff 0
	# Create new encoders
	foreach e $V(encoders) {
		$m add radiobutton -label "$e" -font $f -value "$e" \
			-variable V($name,enc) \
			-command "set_encoder $name"
	}
}

proc set_encoder {name} {
	global V
	if { $V(rtpgw_engine) != "" } then {
		cb_send "cb_set $name ofmt \"$V($name,enc)\""
	}
}

proc setbw { name b } {
	global V
	set n [format "%s%s%s" session $name scaleStep]
	if { [option get . $n RtpgwUI] == "log" } then {
	    	set V($name,totbw) [expr int(pow(2,$b)+0.5)]
	} else {
		set V($name,totbw) $b
	}

	set V($name,totbwtext) [format_bps $b]
	global srcinfo
	foreach s $V(active_list) {
		if { $srcinfo($s,osess) != $name } then {
			continue
		}
		set t [expr $V($name,totbw)*$srcinfo($s,perbw)/100.+0.5]
		setmaxbps $s [expr int($t)]
	}
}


proc toggle_window w {
	if { ![winfo exists $w] } { build$w }
	global created$w
	if { ! [info exists created$w] } {
		set created$w 1
		wm transient $w .
		update idletasks
		set x [winfo rootx .]
		set y [winfo rooty .]
		incr y [winfo height .]
		incr y -[winfo reqheight $w]
		incr y -20
 		# adjust for virtual desktops
		incr x [winfo vrootx .]
		incr y [winfo vrooty .]
		if { $y < 0 } { set y 0 }
		if { $x < 0 } {
			set x 0
		} else {
			set right [expr [winfo screenwidth .] - \
					[winfo reqwidth $w]]
			if { $x > $right } {
				set x $right
			}
		}
		wm geometry $w +$x+$y
		wm deiconify $w
	} elseif { [winfo ismapped $w] } {
		wm withdraw $w
	} else {
		wm deiconify $w
	}
}

#
# Build the user-interface.
#
proc build.tk {} {
	global prefix V

    	set V(media_type) [option get . mediaType RtpgwUI]

	if {$V(media_type) != "audio" && $V(media_type) != "video"} {
		puts "rtpgw_ui: media type must be 'audio' or 'video'"
		exit 1
	}

    	set t "RTP Gateway: $V(media_type)"
	set prefix [option get . iconPrefix RtpgwUI]
	wm iconname . $prefix$t
	wm title . $t

	#
	# emulate implicit keyboard focus
	#
	bind . <Enter> { focus %W }
	bind . <q> { adios }
	bind . <Control-c> { adios }
	bind . <Control-d> { adios }

#	foreach i { 1 2 3 4 } {
#		bind . <Key-$i> "redecorate $i"
#	}

	frame .top
	build.bar .top
	pack .top.bar -fill x -side bottom
	pack .top -expand 1 -fill both

        label .top.label -text "Waiting for $V(media_type)..."
	pack .top.label -before .top.bar -anchor c -expand 1

	#
	# Withdraw window so that user-placement is deferred
	# until after initial geometry is computed
	#
	wm withdraw .
	wm geometry . 375x250
	update idletasks
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	#FIXME
	if { $minwidth < 200 || $minheight < 100 } {
		set minwidth 200
		set minheight 100
	}
	wm minsize . $minwidth $minheight
	wm deiconify .


	global curcol currow nrow
	set curcol 0
	set currow 0
	set nrow [option get . tile RtpgwUI]

	set V(A,hostspec) [hostspec [option get . sessionAspec RtpgwUI] \
		[option get . sessionAdefaultTTL RtpgwUI]]
	set V(B,nettype) [option get . sessionBnetworkType RtpgwUI]

	if {$V(B,nettype) == "ip" } then {
		set V(B,hostspec) [hostspec [option get . sessionBspec RtpgwUI]\
			[option get . sessionAdefaultTTL RtpgwUI]]
	}
	if {$V(B,nettype) == "ipad"} then {
		set V(padid) [option get . padID RtpgwUI]
	}

	init_resources A
	init_resources B

	set s [option get . sessionKeyString RtpgwUI]
	if { $s != "" } {
		set s [split $s :]
		set V(A,key) [lindex $s 0]
		set V(B,key) [lindex $s 1]
		set V(A,encrypt) [expr 1-[isempty $V(A,key)]]
		set V(B,encrypt) [expr 1-[isempty $V(B,key)]]
	} else {
		set V(A,key) ""
		set V(B,key) ""
		set V(A,encrypt) 0
		set V(B,encrypt) 0
	}


	set V(updateInterval) [option get . updateInterval RtpgwUI]

	initConferenceBus

	set V(rtpgw_engine) ""
	set V(engine_status) "Disconnected - No Engine."
    	if { [option get . standalone RtpgwUI] == "no" } then {
		engine_pid [execRTPGW]
	}

	set livestate(alive) 0
	checkalive
}

proc isempty { s } {
	if { $s == "" } {
		return 1
	} else {
		return 0
	}
}

proc sresource { sname resource } {
	return [option get . session$sname$resource RtpgwUI]
}

proc init_resources { sname } {
	global V

	set rname session$sname

	set V($sname,totbw) [sresource $sname totalOutputBW]
	set V($sname,maxscale) [sresource $sname maxBWScale]
	set V($sname,speakerBW) [sresource $sname speakerBWpercent]

	if { $V($sname,speakerBW) > 100 || $V($sname,speakerBW) < 0 } then {
		puts "rtpgw_ui: bad $sname session switching bandwidth - using default value 100"
		set V($sname,speakerBW) 100
	}

	# Threshold
	if {$V($sname,totbw) > $V($sname,maxscale)} then {
		set V($sname,totbw) $V($sname,maxscale)
	}

	if { [sresource $sname rateControl] == "on" } then {
		set V($sname,RC) 1
	} else {
		set V($sname,RC) 0
	}

	set V($sname,switching) [sresource $sname switching]
	set V($sname,color)	[sresource $sname color]
}

proc execRTPGW {} {
	global V

	# -x flag override
	set engine [option get . engine RtpgwUI]
	if { $engine == "" } {
		set opt	$V(media_type)Engine
	    	set engine [option get . $opt RtpgwUI]
	}
    	set gain [option get . filterGain RtpgwUI]
	set proto [option get . proto RtpgwUI]
        if { [catch "exec $engine -A $proto -I $V(cb_channel) -g $gain &" p] == 1 } {
	       	puts "rtpgw_ui: couldn't exec $engine."
		adios
	} else {
		return $p
	}
}

# We are always sending to the engine, so we may as well encapsulate this.
proc cb_send { msg } {
	global V
	cbSend $V(rtpgw_engine) $msg
}

proc initEngine {} {
	global V

    	cb_send "cb_init"
	cb_send "cb_set A addr $V(A,hostspec)"

	switch $V(B,nettype) {
	ip {
		cb_send "cb_set B addr $V(B,hostspec)"
	 }
	ipad {
		cb_send "cb_set B padid $V(padid)"
	 }
	}

	if $V(A,encrypt) then {
		crypt_set A $V(A,key)
	}

	if $V(B,encrypt) then {
		crypt_set B $V(B,key)
	}

	cb_send "cb_set A RC $V(A,RC)"
	cb_send "cb_set B RC $V(B,RC)"

	if { $V(media_type) == "video" } {
		cb_send "cb_video_set A color $V(A,color)"
		cb_send "cb_video_set B color $V(B,color)"
	}

	cb_send "cb_get encoders"
}

proc bump { } {
	global curcol currow nrow
	incr currow
	if { $currow == $nrow } {
		set currow 0
		incr curcol
	}
}

proc activate { srcspec src name addr osess info transcoder } {
    	global V currow curcol
	# FIXME Is this our engine?
	if { $V(rtpgw_engine) != $srcspec } then {
		return
	}
    	if { [llength $V(active_list)] == 0 } then {
		pack forget .top.label

	        set V(grid) .top.grid
		set g [frame $V(grid)]
	    	pack $g -fill both -anchor n
	}
	lappend V(active_list) $src

	set w [frame $V(grid).$src]
	build.src $w $src $name $addr $osess $info $transcoder

	if { $transcoder == "pass-thru" } then {
		if {$V($osess,RC) == 0} then {
			srcBWstate $src alldisabled
		} else {
			srcBWstate $src disabled
		}
	}

	grid $w -row $currow -column $curcol -sticky we
	grid columnconfigure $w $curcol -weight 1
	bump

}

proc deactivate { srcspec src }  {
    	global V
	if { $V(rtpgw_engine) != $srcspec } then {
		return
	}
	set i [lsearch $V(active_list) $src]

	# Could have been called has a result of a global init by the engine
	if { $i == -1 } then {
		return
	}

	set V(active_list) [lreplace $V(active_list) $i $i]

	set w $V(grid).$src
	if [winfo exists $w] {
		grid forget $w
		destroy $w
	}
	if { [llength $V(active_list)] == 0 } then {
		pack forget $V(grid)
		destroy $V(grid)
		pack .top.label -before .top.bar -anchor c -expand 1
	}
}

proc initConferenceBus {} {
	set channel [option get . confBusChannel RtpgwUI]
	if { $channel != 0 } {
		global V confbus
		set confbus [new confbus $channel]
		$confbus handler confbusHandler
		set V(cb_channel) $channel
		init_callbacks
	}
}

proc init_callbacks {} {
	cb_callback srcupdate {srcupdate}
	cb_callback activate {activate}
	cb_callback deactivate {deactivate}
	cb_callback encoders {encoders}
	cb_callback alive {alive}
	cb_callback loopdetect {loopdetect}
	cb_callback dead {dead}
}

proc cb_callback { proc methods } {
	global cb_dispatch
	foreach i $methods {
		set cb_dispatch($i) $proc
	}
}

proc encoders { srcspec e }  {
	global V
	if { $V(rtpgw_engine) != $srcspec } then {
		return
	}
	set V(encoders) $e


	set d [option get . sessionAdefaultFormat RtpgwUI]
	# If default format is not in the encoder list, select the first one.
	if { [lsearch $e $d] == -1 } then {
		set d [lindex $e 0]
	}
	set V(A,enc) $d
    	set_encoder A

	set d [option get . sessionBdefaultFormat RtpgwUI]
	# If default format is not in the encoder list, select the first one.
	if { [lsearch $e $d] == -1 } then {
		set d [lindex $e 0]
	}
	set V(B,enc) $d
    	set_encoder B

	if { [info exists V(pathnames,encoders,A)] } then {
		mkEncoders A $V(pathnames,encoders,A).m
		mkEncoders B $V(pathnames,encoders,B).m
		if { $V(A,RC) == 1 } then {
			$V(pathnames,encoders,A) configure -state normal
		}
		if { $V(B,RC) == 1 } then {
			$V(pathnames,encoders,B) configure -state normal
		}
	}

}

proc srcupdate { srcspec src name osess info tname maxbps rates } {
	global V
	if { $V(rtpgw_engine) != $srcspec} then {
		return
	}
	set i [lsearch $V(active_list) $src]
	if { $i == -1 } then {
		return
	}
	global srcinfo
	set srcinfo($src,name) $name
	set srcinfo($src,osess) $osess
	set srcinfo($src,info) $info

	if { $tname != $srcinfo($src,tname) } then {
		set srcinfo($src,tname) $tname
		if {$tname == "pass-thru" } then {
			if {$V($osess,RC) == 0} then {
				srcBWstate $src alldisabled
			} else {
				srcBWstate $src disabled
			}
		} else {
			srcBWstate $src normal
		}
	}

	set srcinfo($src,ifps) [lindex $rates 0]
	set srcinfo($src,ibps) [lindex $rates 1]
	set srcinfo($src,ofps) [lindex $rates 2]
	set srcinfo($src,obps) [lindex $rates 3]
}

proc setmaxbps { src val } {
	global srcinfo
	set srcinfo($src,maxbps) $val
	set val [format_bps $val]
	set srcinfo($src,maxbpstext) $val
}

proc format_bps b {
	set bps $b

	if { $bps < 1 } {
		set bps "0 bps"
	} elseif { $bps < 1000 } {
		set bps [format "%3.0f bps" $bps]
	} elseif { $bps < 1000000 } {
		set bps [format "%3.0f kb/s" [expr $bps / 1000.]]
	} else {
		set bps [format "%.1f Mb/s" [expr $bps / 1000000.]]
	}

	return $bps
}

proc update_state {} {
	global V srcinfo

	if { $V(rtpgw_engine) == "" } then {
		return;
	}

	foreach s $V(active_list) {
		cb_send "cb_srcset $s maxbps $srcinfo($s,maxbps)"
		cb_send "srcupdate $s"
	}

	after $V(updateInterval) update_state
	update idletasks
}

proc mkSrcFrame w {
	frame $w -relief ridge -borderwidth 2
}

proc build.src { w src name addr osess info tname } {
	global V

	set f [smallfont]
    	global srcinfo
	set srcinfo($src,name) $name
	set srcinfo($src,osess) $osess
	set srcinfo($src,info) $info
	set srcinfo($src,tname) $tname
	set srcinfo($src,addr) $addr

	# for compatibility with mono-mode
	mkSrcFrame $w.l
	frame $w.l.name
	frame $w.l.info
	frame $w.l.rates

	mkSrcFrame $w.r
	frame $w.r.slider

	global srcinfo
	label $w.l.name.srcspec -textvariable srcinfo($src,name) -font $f
	label $w.l.name.osess -text "($srcinfo($src,osess))" -font $f
	pack  $w.l.name.osess -side left
	pack $w.l.name.srcspec -expand 1 -fill x -side left
	pack $w.l.name -side top

	label $w.l.info.srcspec -textvariable srcinfo($src,info) -font $f
	label $w.l.info.tname -textvariable srcinfo($src,tname) -font $f
	pack $w.l.info.srcspec $w.l.info.tname -side left -expand 1
	pack $w.l.info -side top -fill x

	set srcinfo($src,ifps) "0 f/s"
	set srcinfo($src,ibps) "0 bps"
	set srcinfo($src,ofps) "0 f/s"
	set srcinfo($src,obps) "0 bps"

	label $w.l.rates.ifps -textvariable srcinfo($src,ifps) -font $f \
		-width 8 -height 1
	label $w.l.rates.ibps -textvariable srcinfo($src,ibps) -font $f \
		-width 8 -height 1
	label $w.l.rates.arrow -text "  -->" -font $f -width 5 -height 1
	label $w.l.rates.ofps -textvariable srcinfo($src,ofps) -font $f \
		-width 8 -height 1
	label $w.l.rates.obps -textvariable srcinfo($src,obps) -font $f \
		-width 8 -height 1

	pack $w.l.rates.ifps $w.l.rates.ibps $w.l.rates.arrow $w.l.rates.ofps \
		$w.l.rates.obps -side left
	pack $w.l.name -side top -fill both -expand 1
	pack $w.l.info -side top
	pack $w.l.rates -side top -fill both -expand 1

    	set srcinfo($src,maxbps) "0"
    	set srcinfo($src,maxbpstext) "(0 bps)"
	set srcinfo($src,perbw) 0

	mkSrcBWController $w.r $src

	pack $w.l -side left
	pack $w.r -side left -fill both -expand 1
}

proc mkSrcBWController { w src } {
	global V
	set f [smallfont]

	set V(pathnames,scale,$src) $w
	scale $w.scale -orient horizontal -from 0.0 -to 100.0 \
			-showvalue 0 -font $f -width 10 -resolution 0.1 \
			-command "setsrcbw $src" -highlightthickness 0
	frame $w.info
	label $w.info.name -text "%bw" -font $f -width 3
	label $w.info.val -textvariable srcinfo($src,perbw) -font $f -width 4
	label $w.info.maxbpsval -font $f -width 8 \
		-textvariable srcinfo($src,maxbpstext)
	pack $w.info.val $w.info.name $w.info.maxbpsval -side left -expand 1 -fill x
	pack $w.scale $w.info -side bottom -expand 1
}

proc setsrcbw {cursrc newper} {
	global V srcinfo

	set sum 0
	set osess $srcinfo($cursrc,osess)
	foreach s $V(active_list) {
		if { $srcinfo($s,osess) == $osess && $s != $cursrc } then {
		    set sum [expr $sum+$srcinfo($s,perbw)]
		}
	}

	# Are we asking for more than we have?
	if { [expr $sum+$newper] > 100 } then {
		$V(pathnames,scale,$cursrc).scale set \
			$srcinfo($cursrc,perbw)
		return
	}

	set srcinfo($cursrc,perbw) $newper

	set newbw [expr $newper/100.*$V($osess,totbw)]
	set newbw [expr int($newbw+0.5)]
	setmaxbps $cursrc $newbw
}

proc alive srcspec {
	global livestate V

	if { $V(rtpgw_engine) != "" && \
	     $srcspec != $V(rtpgw_engine) } then {
		return
	}

	# Initialization
	if { $V(rtpgw_engine) == "" } then {
		set t [lindex [split $srcspec /] 1]
		engine_pid $t

		set V(rtpgw_engine) $srcspec
		if { [info exists V(pathnames,execbutton)] } then {
			$V(pathnames,execbutton) configure -state disabled
			$V(pathnames,killbutton) configure -state normal
		}

		if { [info exists V(pathnames,encoders,A)] } then {
			if { $V(A,RC) == 1 } then {
				$V(pathnames,encoders,A) configure \
					-state normal
			}
			if { $V(B,RC) == 1 } then {
				$V(pathnames,encoders,B) configure \
					-state normal
			}
		}
		initEngine
		update_state
	}

	set V(engine_status) "Connected to $srcspec."
	set livestate(alive) 1
}

proc checkalive {} {
	global livestate V

# Not yet ready for prime time...
#	if { $V(rtpgw_engine) != "" && $livestate(alive) == 0 } then {
#		set V(engine_status) "Disconnected - No Engine."
#           	set V(rtpgw_engine)  ""
#		engine_pid -1
#		cleanUp
#	}

	set livestate(alive) 0
	after 20000 checkalive
	update idletasks
}

proc dead srcspec {
	global V

	if { $srcspec == $V(rtpgw_engine) } then {
		set V(engine_status) "Disconnected - No Engine."
		set V(rtpgw_engine) ""
		engine_pid -1
		cleanUp
	}
}

proc cleanUp {} {
	global V

	set al $V(active_list)
	foreach s $al {
		deactivate $V(rtpgw_engine) $s
	}
	set encoders {}
	if { [info exists V(pathnames,execbutton)] } then {
		# We have created the config window
		$V(pathnames,execbutton) configure -state normal
		$V(pathnames,killbutton) configure -state disabled
	}
	if { [info exists V(pathnames,encoders,A)] } then {
		$V(pathnames,encoders,A) configure -state disabled
		$V(pathnames,encoders,B) configure -state disabled
	}
}

proc loopdetect {srcspec hlist} {
	global V
	if { $V(rtpgw_engine) != $srcspec } then {
		return
	}
	puts "rtpgw_ui: Detected gateway routing loop:"
	set i 0
	foreach h $hlist {
		incr i
		if { $i != [llength $hlist]} {
			puts "    $h ->"
		} else {

			puts "    $h"
		}
	}
	adios
}

proc src_switch addr {
	global V srcinfo
	foreach s $V(active_list) {
		if { $srcinfo($s,addr) == $addr } then {
			break
		}
	}

	set osess $srcinfo($s,osess)
	# If not a rate controlled session or switching turned off for the
	# session - do nothing.
	if { $V($osess,RC) == 0 || $V($osess,switching) == "off" } {
		return
	}

	# Otherwise, allocate appropriate bandwidth to the speaker source,
	# count silent sources and divide up bandwidth.
	set nsilent 0
	set silentsrcs {}
	foreach osrc $V(active_list) {
		if { $srcinfo($osrc,osess) != $osess || $osrc == $s } then {
			continue
		}
		# So we don't try and allocate over 100%
		$V(pathnames,scale,$osrc).scale set 0

		lappend silentsrcs $osrc
		incr nsilent
	}

	$V(pathnames,scale,$s).scale set $V($osess,speakerBW)
	cb_send "cb_srcset $s maxbps $srcinfo($s,maxbps)"

	# FIXME
        # To avoid rounding problems, we allocate in two passes.  First we
	# allocate the bandwidth - 0.1 and then we increment each source's bw
	# by 0.1. Can we do this better?
	if { $nsilent > 0 } then {
		set silentbw [expr (100.-$V($osess,speakerBW))/$nsilent]
		# Optimize the common case
		if { $silentbw != 0 } then {
			foreach src $silentsrcs {
				$V(pathnames,scale,$src).scale set \
					[expr $silentbw-0.1]
			}
		}
		foreach src $silentsrcs {
			$V(pathnames,scale,$src).scale set $silentbw
			cb_send "cb_srcset $osrc maxbps $srcinfo($osrc,maxbps)"
		}
	}
	update idletasks
}

proc hostspec { spec defttl } {
	set spec [split $spec :]
	set ret ""
	foreach d $spec {
		set dst [split $d /]
		set n [llength $dst]
		if { $n < 2 } {
			puts "must specify both address and port in the form addr/port"
			exit 1
		} else {
			set addr [lindex $dst 0]
			set port [lindex $dst 1]
			if { ![string match \[0-9\]* $port] || \
			     $port >= 65536 } {
				puts "illegal port '$port'"
				exit 1
			}
			if { $n >= 3 } {
				set ttl [lindex $dst 2]
				if { $n > 3 } {
					puts "bad address specification"
				}
			} else {
				set ttl $defttl
			}
			if { $ttl < 0 || $ttl > 255 } {
				puts "invalid ttl ($ttl)"
				exit 1
			}
			set port [expr $port &~ 1]
			set ret [format "%s:%s" $ret $addr/$port/$ttl]
		}
	}

	# Drop first colon
	return [string range $ret 1 end]
}

